/* cawbird.h generated by valac 0.38.7, the Vala compiler, do not modify */


#ifndef __CAWBIRD_H__
#define __CAWBIRD_H__

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "CbSnippetManager.h"
#include <stdlib.h>
#include <string.h>
#include "CbBundle.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <cairo.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include <json-glib/json-glib.h>
#include "CbMessageReceiver.h"
#include <float.h>
#include <math.h>
#include "CbTextTransform.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include "CbMedia.h"
#include "CbTypes.h"
#include "CbTwitterItem.h"
#include <sqlite3.h>

G_BEGIN_DECLS


#define TYPE_CAWBIRD (cawbird_get_type ())
#define CAWBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAWBIRD, Cawbird))
#define CAWBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAWBIRD, CawbirdClass))
#define IS_CAWBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAWBIRD))
#define IS_CAWBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAWBIRD))
#define CAWBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAWBIRD, CawbirdClass))

typedef struct _Cawbird Cawbird;
typedef struct _CawbirdClass CawbirdClass;
typedef struct _CawbirdPrivate CawbirdPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;
typedef struct _MainWidgetPrivate MainWidgetPrivate;
typedef struct _AccountPrivate AccountPrivate;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;
typedef struct _HomeTimelinePrivate HomeTimelinePrivate;

#define TYPE_MEDIA_VISIBILITY (media_visibility_get_type ())

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef struct _SettingsPrivate SettingsPrivate;
typedef struct _NotificationManagerPrivate NotificationManagerPrivate;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
typedef struct _TwitterPrivate TwitterPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_DM_MANAGER (dm_manager_get_type ())
#define DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_MANAGER, DMManager))
#define DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_MANAGER, DMManagerClass))
#define IS_DM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_MANAGER))
#define IS_DM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_MANAGER))
#define DM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_MANAGER, DMManagerClass))

typedef struct _DMManager DMManager;
typedef struct _DMManagerClass DMManagerClass;
typedef struct _DMManagerPrivate DMManagerPrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;
typedef struct _TextButtonPrivate TextButtonPrivate;
typedef struct _BadgeRadioButtonPrivate BadgeRadioButtonPrivate;

#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
typedef struct _ReplyIndicatorPrivate ReplyIndicatorPrivate;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;
typedef struct _AvatarWidgetPrivate AvatarWidgetPrivate;

#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;
typedef struct _AvatarBannerWidgetPrivate AvatarBannerWidgetPrivate;

#define TYPE_LAZY_MENU_BUTTON (lazy_menu_button_get_type ())
#define LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButton))
#define LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))
#define IS_LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAZY_MENU_BUTTON))
#define IS_LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAZY_MENU_BUTTON))
#define LAZY_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))

typedef struct _LazyMenuButton LazyMenuButton;
typedef struct _LazyMenuButtonClass LazyMenuButtonClass;
typedef struct _LazyMenuButtonPrivate LazyMenuButtonPrivate;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;
typedef struct _ListListEntryPrivate ListListEntryPrivate;

#define BENCHMARK_TYPE_BENCH (benchmark_bench_get_type ())
#define BENCHMARK_BENCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BENCHMARK_TYPE_BENCH, BenchmarkBench))
#define BENCHMARK_BENCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BENCHMARK_TYPE_BENCH, BenchmarkBenchClass))
#define BENCHMARK_IS_BENCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BENCHMARK_TYPE_BENCH))
#define BENCHMARK_IS_BENCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BENCHMARK_TYPE_BENCH))
#define BENCHMARK_BENCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BENCHMARK_TYPE_BENCH, BenchmarkBenchClass))

typedef struct _BenchmarkBench BenchmarkBench;
typedef struct _BenchmarkBenchClass BenchmarkBenchClass;
typedef struct _BenchmarkBenchPrivate BenchmarkBenchPrivate;

#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
typedef struct _AccountDialogPrivate AccountDialogPrivate;
typedef struct _SqlDatabasePrivate SqlDatabasePrivate;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _SqlInsertStatementPrivate SqlInsertStatementPrivate;
typedef struct _SqlUpdateStatementPrivate SqlUpdateStatementPrivate;
typedef struct _SqlSelectStatementPrivate SqlSelectStatementPrivate;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _CollectPrivate CollectPrivate;

#define TYPE_DM_THREAD (dm_thread_get_type ())
#define DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD, DMThread))
#define DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD, DMThreadClass))
#define IS_DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD))
#define IS_DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD))
#define DM_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD, DMThreadClass))

typedef struct _DMThread DMThread;
typedef struct _DMThreadClass DMThreadClass;
typedef struct _DMThreadPrivate DMThreadPrivate;

#define TYPE_DM_THREADS_MODEL (dm_threads_model_get_type ())
#define DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModel))
#define DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))
#define IS_DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_MODEL))
#define IS_DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_MODEL))
#define DM_THREADS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))

typedef struct _DMThreadsModel DMThreadsModel;
typedef struct _DMThreadsModelClass DMThreadsModelClass;
typedef struct _DMThreadsModelPrivate DMThreadsModelPrivate;

struct _Cawbird {
	GtkApplication parent_instance;
	CawbirdPrivate * priv;
};

struct _CawbirdClass {
	GtkApplicationClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _MainWidget {
	GtkBox parent_instance;
	MainWidgetPrivate * priv;
};

struct _MainWidgetClass {
	GtkBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, CbBundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _HomeTimeline {
	DefaultTimeline parent_instance;
	HomeTimelinePrivate * priv;
};

struct _HomeTimelineClass {
	DefaultTimelineClass parent_class;
};

typedef enum  {
	MEDIA_VISIBILITY_SHOW = 1,
	MEDIA_VISIBILITY_HIDE = 2,
	MEDIA_VISIBILITY_HIDE_IN_TIMELINES = 3
} MediaVisibility;

struct _Settings {
	GObject parent_instance;
	SettingsPrivate * priv;
};

struct _SettingsClass {
	GObjectClass parent_class;
};

struct _NotificationManager {
	GObject parent_instance;
	NotificationManagerPrivate * priv;
};

struct _NotificationManagerClass {
	GObjectClass parent_class;
};

struct _Twitter {
	GObject parent_instance;
	TwitterPrivate * priv;
};

struct _TwitterClass {
	GObjectClass parent_class;
};

struct _DMManager {
	GObject parent_instance;
	DMManagerPrivate * priv;
};

struct _DMManagerClass {
	GObjectClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _TextButton {
	GtkButton parent_instance;
	TextButtonPrivate * priv;
};

struct _TextButtonClass {
	GtkButtonClass parent_class;
};

struct _BadgeRadioButton {
	GtkRadioButton parent_instance;
	BadgeRadioButtonPrivate * priv;
};

struct _BadgeRadioButtonClass {
	GtkRadioButtonClass parent_class;
};

struct _ReplyIndicator {
	GtkWidget parent_instance;
	ReplyIndicatorPrivate * priv;
};

struct _ReplyIndicatorClass {
	GtkWidgetClass parent_class;
};

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	gboolean restrict_height;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

struct _AvatarWidget {
	GtkWidget parent_instance;
	AvatarWidgetPrivate * priv;
};

struct _AvatarWidgetClass {
	GtkWidgetClass parent_class;
};

struct _AvatarBannerWidget {
	GtkContainer parent_instance;
	AvatarBannerWidgetPrivate * priv;
};

struct _AvatarBannerWidgetClass {
	GtkContainerClass parent_class;
};

struct _LazyMenuButton {
	GtkToggleButton parent_instance;
	LazyMenuButtonPrivate * priv;
};

struct _LazyMenuButtonClass {
	GtkToggleButtonClass parent_class;
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _ListListEntry {
	GtkListBoxRow parent_instance;
	ListListEntryPrivate * priv;
	gint64 id;
	gboolean user_list;
	gchar* creator_screen_name;
	gint n_subscribers;
	gint n_members;
	gint64 created_at;
	gchar* mode;
};

struct _ListListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _BenchmarkBench {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BenchmarkBenchPrivate * priv;
	gchar* name;
	GDateTime* first;
};

struct _BenchmarkBenchClass {
	GTypeClass parent_class;
	void (*finalize) (BenchmarkBench *self);
};

struct _AccountDialog {
	GtkWindow parent_instance;
	AccountDialogPrivate * priv;
};

struct _AccountDialogClass {
	GtkWindowClass parent_class;
};

struct _SqlDatabase {
	GObject parent_instance;
	SqlDatabasePrivate * priv;
};

struct _SqlDatabaseClass {
	GObjectClass parent_class;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _SqlInsertStatement {
	GObject parent_instance;
	SqlInsertStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlInsertStatementClass {
	GObjectClass parent_class;
};

struct _SqlUpdateStatement {
	GObject parent_instance;
	SqlUpdateStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlUpdateStatementClass {
	GObjectClass parent_class;
};

struct _SqlSelectStatement {
	GObject parent_instance;
	SqlSelectStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlSelectStatementClass {
	GObjectClass parent_class;
};

struct _Collect {
	GObject parent_instance;
	CollectPrivate * priv;
};

struct _CollectClass {
	GObjectClass parent_class;
};

struct _DMThread {
	GObject parent_instance;
	DMThreadPrivate * priv;
	CbUserIdentity user;
	gint64 last_message_id;
	gchar* last_message;
	gint unread_count;
	gchar* notification_id;
	cairo_surface_t* avatar_surface;
};

struct _DMThreadClass {
	GObjectClass parent_class;
};

struct _DMThreadsModel {
	GObject parent_instance;
	DMThreadsModelPrivate * priv;
};

struct _DMThreadsModelClass {
	GObjectClass parent_class;
};


GType cawbird_get_type (void) G_GNUC_CONST;
GType sql_database_get_type (void) G_GNUC_CONST;
extern SqlDatabase* cawbird_db;
extern CbSnippetManager* cawbird_snippet_manager;
Cawbird* cawbird_new (void);
Cawbird* cawbird_construct (GType object_type);
gboolean cawbird_add_window_for_screen_name (Cawbird* self, const gchar* screen_name);
GType account_get_type (void) G_GNUC_CONST;
void cawbird_add_window_for_account (Cawbird* self, Account* account);
GType main_window_get_type (void) G_GNUC_CONST;
gboolean cawbird_is_window_open_for_screen_name (Cawbird* self, const gchar* screen_name, MainWindow* * window);
gboolean cawbird_is_window_open_for_user_id (Cawbird* self, gint64 user_id, MainWindow* * window);
void cawbird_start_account (Cawbird* self, Account* acc);
void cawbird_stop_account (Cawbird* self, Account* acc);
GType main_widget_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
void main_window_change_account (MainWindow* self, Account* account);
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
void main_window_save_geometry (MainWindow* self);
void main_window_rerun_filters (MainWindow* self);
void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type);
void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id);
void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id);
gint main_window_get_cur_page_id (MainWindow* self);
MainWidget* main_widget_new (Account* account, MainWindow* parent, Cawbird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Cawbird* app);
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
void main_widget_remove_current_page (MainWidget* self);
IPage* main_widget_get_page (MainWidget* self, gint page_id);
void main_widget_stop (MainWidget* self);
gint main_widget_get_cur_page_id (MainWidget* self);
GType notification_manager_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DUMMY "screen_name"
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
void account_init_database (Account* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_uninit (Account* self);
void account_load_avatar (Account* self);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_init_information_finish (Account* self, GAsyncResult* _res_);
void account_save_info (Account* self);
void account_add_filter (Account* self, CbFilter* f);
gboolean account_filter_matches (Account* self, CbTweet* t);
void account_set_friends (Account* self, JsonArray* friends_array);
gboolean account_follows_id (Account* self, gint64 user_id);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
void account_set_muted (Account* self, JsonArray* muted_array);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
void account_set_blocked (Account* self, JsonArray* blocked_array);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
void account_set_disabled_rts (Account* self, JsonArray* disabled_rts_array);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
gboolean account_is_blocked (Account* self, gint64 user_id);
gboolean account_is_muted (Account* self, gint64 user_id);
Account* account_get_nth (guint index);
guint account_get_n (void);
void account_add_account (Account* acc);
void account_remove_account (const gchar* screen_name);
Account* account_query_account (const gchar* screen_name);
Account* account_query_account_by_id (gint64 id);
cairo_surface_t* account_get_avatar_small (Account* self);
void account_set_avatar_small (Account* self, cairo_surface_t* value);
cairo_surface_t* account_get_avatar (Account* self);
void account_set_avatar (Account* self, cairo_surface_t* value);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void ipage_on_join (IPage* self, gint page_id, CbBundle* args);
void ipage_on_leave (IPage* self);
void ipage_create_radio_button (IPage* self, GtkRadioButton* group);
GtkRadioButton* ipage_get_radio_button (IPage* self);
gchar* ipage_get_title (IPage* self);
gboolean ipage_handles_double_open (IPage* self);
void ipage_double_open (IPage* self);
gint ipage_get_id (IPage* self);
void ipage_set_id (IPage* self, gint value);
void ipage_set_window (IPage* self, MainWindow* value);
#define DEFAULT_TIMELINE_REST 25
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
void default_timeline_on_join (DefaultTimeline* self, gint page_id, CbBundle* args);
void default_timeline_on_leave (DefaultTimeline* self);
void default_timeline_load_newest (DefaultTimeline* self);
void default_timeline_load_older (DefaultTimeline* self);
gchar* default_timeline_get_title (DefaultTimeline* self);
void default_timeline_create_radio_button (DefaultTimeline* self, GtkRadioButton* group);
void default_timeline_handle_scrolled_to_start (DefaultTimeline* self);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
void default_timeline_mark_seen (DefaultTimeline* self, gint64 id);
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
void default_timeline_load_newest_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void default_timeline_load_newest_internal_finish (DefaultTimeline* self, GAsyncResult* _res_);
void default_timeline_load_older_internal (DefaultTimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void default_timeline_load_older_internal_finish (DefaultTimeline* self, GAsyncResult* _res_);
void default_timeline_mark_seen_on_scroll (DefaultTimeline* self, gdouble value);
void default_timeline_rerun_filters (DefaultTimeline* self);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
const gchar* default_timeline_get_function (DefaultTimeline* self);
GType media_visibility_get_type (void) G_GNUC_CONST;
GType settings_get_type (void) G_GNUC_CONST;
void settings_init (void);
GSettings* settings_get (void);
gint settings_get_tweet_stack_count (void);
gboolean settings_use_dark_theme (void);
gboolean settings_notify_new_mentions (void);
gboolean settings_notify_new_dms (void);
gboolean settings_auto_scroll_on_new_tweets (void);
gchar* settings_get_accel (const gchar* accel_name);
gdouble settings_max_media_size (void);
void settings_toggle_topbar_visible (void);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
void settings_add_text_transform_flag (CbTransformFlags flag);
void settings_remove_text_transform_flag (CbTransformFlags flag);
CbTransformFlags settings_get_text_transform_flags (void);
gboolean settings_hide_nsfw_content (void);
MediaVisibility settings_get_media_visiblity (void);
Settings* settings_new (void);
Settings* settings_construct (GType object_type);
NotificationManager* notification_manager_new (Account* account);
NotificationManager* notification_manager_construct (GType object_type, Account* account);
void notification_manager_withdraw (NotificationManager* self, const gchar* id);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
gchar* notification_manager_send_dm (NotificationManager* self, gint64 sender_id, const gchar* existing_id, const gchar* summary, const gchar* text);
GType twitter_get_type (void) G_GNUC_CONST;
extern cairo_surface_t* twitter_no_avatar;
extern GdkPixbuf* twitter_no_banner;
#define TWITTER_MAX_BYTES_PER_IMAGE ((1024 * 1024) * 3)
#define TWITTER_short_url_length 23
#define TWITTER_max_media_per_upload 4
Twitter* twitter_get (void);
void twitter_init (Twitter* self);
void twitter_ref_avatar (Twitter* self, cairo_surface_t* surface);
void twitter_unref_avatar (Twitter* self, cairo_surface_t* surface);
gboolean twitter_has_avatar (Twitter* self, gint64 user_id);
cairo_surface_t* twitter_get_cached_avatar (Twitter* self, gint64 user_id);
void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_);
GType avatar_widget_get_type (void) G_GNUC_CONST;
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
GType dm_manager_get_type (void) G_GNUC_CONST;
DMManager* dm_manager_new_for_account (Account* account);
DMManager* dm_manager_construct_for_account (GType object_type, Account* account);
void dm_manager_load_cached_threads (DMManager* self);
GListModel* dm_manager_get_threads_model (DMManager* self);
gboolean dm_manager_has_thread (DMManager* self, gint64 user_id);
gint dm_manager_reset_unread_count (DMManager* self, gint64 user_id);
gchar* dm_manager_reset_notification_id (DMManager* self, gint64 user_id);
void dm_manager_load_newest_dms (DMManager* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_manager_load_newest_dms_finish (DMManager* self, GAsyncResult* _res_);
void dm_manager_insert_message (DMManager* self, JsonObject* dm_obj);
DMManager* dm_manager_new (void);
DMManager* dm_manager_construct (GType object_type);
gboolean dm_manager_get_empty (DMManager* self);
TweetListBox* tweet_list_box_new (void);
TweetListBox* tweet_list_box_construct (GType object_type);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_list_box_set_unempty (TweetListBox* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
GtkStack* tweet_list_box_get_placeholder (TweetListBox* self);
void tweet_list_box_set_placeholder_text (TweetListBox* self, const gchar* text);
void tweet_list_box_reset_placeholder_text (TweetListBox* self);
void tweet_list_box_remove_all (TweetListBox* self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_box_get_action_entry (TweetListBox* self);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
void scroll_widget_scroll_up_next (ScrollWidget* self, gboolean animate, gboolean force_start);
void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
gdouble scroll_widget_get_end_diff (ScrollWidget* self);
void scroll_widget_set_end_diff (ScrollWidget* self, gdouble value);
gboolean scroll_widget_get_scrolled_down (ScrollWidget* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
GType text_button_get_type (void) G_GNUC_CONST;
TextButton* text_button_new (void);
TextButton* text_button_construct (GType object_type);
void text_button_set_markup (TextButton* self, const gchar* text);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
gboolean badge_radio_button_get_show_badge (BadgeRadioButton* self);
void badge_radio_button_set_show_badge (BadgeRadioButton* self, gboolean value);
GType reply_indicator_get_type (void) G_GNUC_CONST;
ReplyIndicator* reply_indicator_new (void);
ReplyIndicator* reply_indicator_construct (GType object_type);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
GType multi_media_widget_get_type (void) G_GNUC_CONST;
#define MULTI_MEDIA_WIDGET_MAX_HEIGHT 180
void multi_media_widget_set_all_media (MultiMediaWidget* self, CbMedia** medias, int medias_length1);
void multi_media_widget_set_media (MultiMediaWidget* self, gint index, CbMedia* media);
MultiMediaWidget* multi_media_widget_new (void);
MultiMediaWidget* multi_media_widget_construct (GType object_type);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
gboolean avatar_widget_get_make_round (AvatarWidget* self);
void avatar_widget_set_make_round (AvatarWidget* self, gboolean value);
gboolean avatar_widget_get_verified (AvatarWidget* self);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
gboolean avatar_widget_get_overlap (AvatarWidget* self);
void avatar_widget_set_overlap (AvatarWidget* self, gboolean value);
gint avatar_widget_get_size (AvatarWidget* self);
void avatar_widget_set_size (AvatarWidget* self, gint value);
cairo_surface_t* avatar_widget_get_surface (AvatarWidget* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar);
void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner);
AvatarBannerWidget* avatar_banner_widget_new (void);
AvatarBannerWidget* avatar_banner_widget_construct (GType object_type);
GType lazy_menu_button_get_type (void) G_GNUC_CONST;
LazyMenuButton* lazy_menu_button_new (void);
LazyMenuButton* lazy_menu_button_construct (GType object_type);
GMenu* lazy_menu_button_get_menu_model (LazyMenuButton* self);
void lazy_menu_button_set_menu_model (LazyMenuButton* self, GMenu* value);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index, gdouble px, gdouble py);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
const gchar* __class_name (GObject* o);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
void utils_load_custom_icons (void);
void utils_load_custom_css (void);
void utils_init_soup_session (void);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
CbFilter* utils_create_persistent_filter (const gchar* content, Account* account);
gchar* utils_get_media_display_name (CbMedia* media);
void utils_download_file (const gchar* url, GOutputStream* out_stream, GAsyncReadyCallback _callback_, gpointer _user_data_);
void utils_download_file_finish (GAsyncResult* _res_);
void dirs_create_dirs (void);
gchar* dirs_config (const gchar* path);
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void tweet_list_entry_set_avatar (TweetListEntry* self, cairo_surface_t* surface);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
void tweet_list_entry_fade_in (TweetListEntry* self);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
GType list_list_entry_get_type (void) G_GNUC_CONST;
gint list_list_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
ListListEntry* list_list_entry_new (void);
ListListEntry* list_list_entry_construct (GType object_type);
const gchar* list_list_entry_get_name (ListListEntry* self);
void list_list_entry_set_name (ListListEntry* self, const gchar* value);
const gchar* list_list_entry_get_description (ListListEntry* self);
void list_list_entry_set_description (ListListEntry* self, const gchar* value);
gpointer benchmark_bench_ref (gpointer instance);
void benchmark_bench_unref (gpointer instance);
GParamSpec* benchmark_param_spec_bench (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void benchmark_value_set_bench (GValue* value, gpointer v_object);
void benchmark_value_take_bench (GValue* value, gpointer v_object);
gpointer benchmark_value_get_bench (const GValue* value);
GType benchmark_bench_get_type (void) G_GNUC_CONST;
void benchmark_bench_stop (BenchmarkBench* self);
BenchmarkBench* benchmark_bench_new (void);
BenchmarkBench* benchmark_bench_construct (GType object_type);
BenchmarkBench* benchmark_start (const gchar* name);
GType account_dialog_get_type (void) G_GNUC_CONST;
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
#define SQL_CAWBIRD_SQL_VERSION 2
#define SQL_CAWBIRD_INIT_FILE "/uk/co/ibboard/cawbird/sql/init/Create.%d.sql"
#define SQL_ACCOUNTS_SQL_VERSION 3
#define SQL_ACCOUNTS_INIT_FILE "/uk/co/ibboard/cawbird/sql/accounts/Create.%d.sql"
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
void sql_database_begin_transaction (SqlDatabase* self);
void sql_database_end_transaction (SqlDatabase* self);
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
SqlInsertStatement* sql_insert_statement_new (const gchar* table_name, gboolean replace);
SqlInsertStatement* sql_insert_statement_construct (GType object_type, const gchar* table_name, gboolean replace);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
SqlInsertStatement* sql_insert_statement_vali (SqlInsertStatement* self, const gchar* col_name, gint col_value);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_valb (SqlInsertStatement* self, const gchar* col_name, gboolean col_value);
SqlUpdateStatement* sql_update_statement_new (const gchar* table_name);
SqlUpdateStatement* sql_update_statement_construct (GType object_type, const gchar* table_name);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
SqlUpdateStatement* sql_update_statement_where (SqlUpdateStatement* self, const gchar* where);
SqlUpdateStatement* sql_update_statement_where_eq (SqlUpdateStatement* self, const gchar* col, const gchar* value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_vali (SqlUpdateStatement* self, const gchar* col_name, gint col_value);
SqlUpdateStatement* sql_update_statement_vali64 (SqlUpdateStatement* self, const gchar* col_name, gint64 col_value);
SqlUpdateStatement* sql_update_statement_valb (SqlUpdateStatement* self, const gchar* col_name, gboolean col_value);
SqlSelectStatement* sql_select_statement_new (const gchar* table_name);
SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_where_prefix (SqlSelectStatement* self, const gchar* field, const gchar* prefix);
SqlSelectStatement* sql_select_statement_where_prefix2 (SqlSelectStatement* self, const gchar* field, const gchar* prefix);
SqlSelectStatement* sql_select_statement_or (SqlSelectStatement* self);
SqlSelectStatement* sql_select_statement_nocase (SqlSelectStatement* self);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
gchar* sql_select_statement_once_string (SqlSelectStatement* self);
GType collect_get_type (void) G_GNUC_CONST;
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
void collect_emit (Collect* self, GError* _error_);
gboolean collect_get_done (Collect* self);
GType dm_thread_get_type (void) G_GNUC_CONST;
void dm_thread_load_avatar (DMThread* self, Account* account, gint scale_factor, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_thread_load_avatar_finish (DMThread* self, GAsyncResult* _res_);
DMThread* dm_thread_new (void);
DMThread* dm_thread_construct (GType object_type);
GType dm_threads_model_get_type (void) G_GNUC_CONST;
void dm_threads_model_add (DMThreadsModel* self, DMThread* thread);
void dm_threads_model_update_last_message (DMThreadsModel* self, gint64 sender_id, gint64 message_id, const gchar* message_text);
gboolean dm_threads_model_has_thread (DMThreadsModel* self, gint64 user_id);
gint dm_threads_model_reset_unread_count (DMThreadsModel* self, gint64 user_id);
gchar* dm_threads_model_reset_notification_id (DMThreadsModel* self, gint64 user_id);
void dm_threads_model_increase_unread_count (DMThreadsModel* self, gint64 user_id, gint amount);
DMThread* dm_threads_model_get_thread (DMThreadsModel* self, gint64 user_id);
DMThreadsModel* dm_threads_model_new (void);
DMThreadsModel* dm_threads_model_construct (GType object_type);


G_END_DECLS

#endif
