/*$
 Copyright (C) 2013-2019 Azel.

 This file is part of AzPainter.

 AzPainter is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 AzPainter is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
$*/

#ifndef MLIB_NANOTIME_H
#define MLIB_NANOTIME_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _mNanoTime
{
	int64_t sec;
	int32_t nsec;
}mNanoTime;

void mNanoTimeGet(mNanoTime *nt);
void mNanoTimeAdd(mNanoTime *nt,uint64_t nsec);
void mNanoTimeAddMilliSec(mNanoTime *nt,int msec);
int mNanoTimeCompare(mNanoTime *nt1,mNanoTime *nt2);
mBool mNanoTimeSub(mNanoTime *dst,mNanoTime *nt1,mNanoTime *nt2);

#ifdef __cplusplus
}
#endif

#endif
