'use babel';

var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x6, _x7, _x8) { var _again = true; _function: while (_again) { var object = _x6, property = _x7, receiver = _x8; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x6 = parent; _x7 = property; _x8 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _ = require('underscore-plus');
var url = require('url');
var path = require('path');

var _require = require('event-kit');

var Emitter = _require.Emitter;
var Disposable = _require.Disposable;
var CompositeDisposable = _require.CompositeDisposable;

var fs = require('fs-plus');

var _require2 = require('pathwatcher');

var Directory = _require2.Directory;

var Grim = require('grim');
var DefaultDirectorySearcher = require('./default-directory-searcher');
var Dock = require('./dock');
var Model = require('./model');
var StateStore = require('./state-store');
var TextEditor = require('./text-editor');
var Panel = require('./panel');
var PanelContainer = require('./panel-container');
var Task = require('./task');
var WorkspaceCenter = require('./workspace-center');
var WorkspaceElement = require('./workspace-element');

var STOPPED_CHANGING_ACTIVE_PANE_ITEM_DELAY = 100;
var ALL_LOCATIONS = ['center', 'left', 'right', 'bottom'];

// Essential: Represents the state of the user interface for the entire window.
// An instance of this class is available via the `atom.workspace` global.
//
// Interact with this object to open files, be notified of current and future
// editors, and manipulate panes. To add panels, use {Workspace::addTopPanel}
// and friends.
//
// ## Workspace Items
//
// The term "item" refers to anything that can be displayed
// in a pane within the workspace, either in the {WorkspaceCenter} or in one
// of the three {Dock}s. The workspace expects items to conform to the
// following interface:
//
// ### Required Methods
//
// #### `getTitle()`
//
// Returns a {String} containing the title of the item to display on its
// associated tab.
//
// ### Optional Methods
//
// #### `getElement()`
//
// If your item already *is* a DOM element, you do not need to implement this
// method. Otherwise it should return the element you want to display to
// represent this item.
//
// #### `destroy()`
//
// Destroys the item. This will be called when the item is removed from its
// parent pane.
//
// #### `onDidDestroy(callback)`
//
// Called by the workspace so it can be notified when the item is destroyed.
// Must return a {Disposable}.
//
// #### `serialize()`
//
// Serialize the state of the item. Must return an object that can be passed to
// `JSON.stringify`. The state should include a field called `deserializer`,
// which names a deserializer declared in your `package.json`. This method is
// invoked on items when serializing the workspace so they can be restored to
// the same location later.
//
// #### `getURI()`
//
// Returns the URI associated with the item.
//
// #### `getLongTitle()`
//
// Returns a {String} containing a longer version of the title to display in
// places like the window title or on tabs their short titles are ambiguous.
//
// #### `onDidChangeTitle`
//
// Called by the workspace so it can be notified when the item's title changes.
// Must return a {Disposable}.
//
// #### `getIconName()`
//
// Return a {String} with the name of an icon. If this method is defined and
// returns a string, the item's tab element will be rendered with the `icon` and
// `icon-${iconName}` CSS classes.
//
// ### `onDidChangeIcon(callback)`
//
// Called by the workspace so it can be notified when the item's icon changes.
// Must return a {Disposable}.
//
// #### `getDefaultLocation()`
//
// Tells the workspace where your item should be opened in absence of a user
// override. Items can appear in the center or in a dock on the left, right, or
// bottom of the workspace.
//
// Returns a {String} with one of the following values: `'center'`, `'left'`,
// `'right'`, `'bottom'`. If this method is not defined, `'center'` is the
// default.
//
// #### `getAllowedLocations()`
//
// Tells the workspace where this item can be moved. Returns an {Array} of one
// or more of the following values: `'center'`, `'left'`, `'right'`, or
// `'bottom'`.
//
// #### `isPermanentDockItem()`
//
// Tells the workspace whether or not this item can be closed by the user by
// clicking an `x` on its tab. Use of this feature is discouraged unless there's
// a very good reason not to allow users to close your item. Items can be made
// permanent *only* when they are contained in docks. Center pane items can
// always be removed. Note that it is currently still possible to close dock
// items via the `Close Pane` option in the context menu and via Atom APIs, so
// you should still be prepared to handle your dock items being destroyed by the
// user even if you implement this method.
//
// #### `save()`
//
// Saves the item.
//
// #### `saveAs(path)`
//
// Saves the item to the specified path.
//
// #### `getPath()`
//
// Returns the local path associated with this item. This is only used to set
// the initial location of the "save as" dialog.
//
// #### `isModified()`
//
// Returns whether or not the item is modified to reflect modification in the
// UI.
//
// #### `onDidChangeModified()`
//
// Called by the workspace so it can be notified when item's modified status
// changes. Must return a {Disposable}.
//
// #### `copy()`
//
// Create a copy of the item. If defined, the workspace will call this method to
// duplicate the item when splitting panes via certain split commands.
//
// #### `getPreferredHeight()`
//
// If this item is displayed in the bottom {Dock}, called by the workspace when
// initially displaying the dock to set its height. Once the dock has been
// resized by the user, their height will override this value.
//
// Returns a {Number}.
//
// #### `getPreferredWidth()`
//
// If this item is displayed in the left or right {Dock}, called by the
// workspace when initially displaying the dock to set its width. Once the dock
// has been resized by the user, their width will override this value.
//
// Returns a {Number}.
//
// #### `onDidTerminatePendingState(callback)`
//
// If the workspace is configured to use *pending pane items*, the workspace
// will subscribe to this method to terminate the pending state of the item.
// Must return a {Disposable}.
//
// #### `shouldPromptToSave()`
//
// This method indicates whether Atom should prompt the user to save this item
// when the user closes or reloads the window. Returns a boolean.
module.exports = (function (_Model) {
  _inherits(Workspace, _Model);

  function Workspace(params) {
    _classCallCheck(this, Workspace);

    _get(Object.getPrototypeOf(Workspace.prototype), 'constructor', this).apply(this, arguments);

    this.updateWindowTitle = this.updateWindowTitle.bind(this);
    this.updateDocumentEdited = this.updateDocumentEdited.bind(this);
    this.didDestroyPaneItem = this.didDestroyPaneItem.bind(this);
    this.didChangeActivePaneOnPaneContainer = this.didChangeActivePaneOnPaneContainer.bind(this);
    this.didChangeActivePaneItemOnPaneContainer = this.didChangeActivePaneItemOnPaneContainer.bind(this);
    this.didActivatePaneContainer = this.didActivatePaneContainer.bind(this);
    this.didHideDock = this.didHideDock.bind(this);

    this.enablePersistence = params.enablePersistence;
    this.packageManager = params.packageManager;
    this.config = params.config;
    this.project = params.project;
    this.notificationManager = params.notificationManager;
    this.viewRegistry = params.viewRegistry;
    this.grammarRegistry = params.grammarRegistry;
    this.applicationDelegate = params.applicationDelegate;
    this.assert = params.assert;
    this.deserializerManager = params.deserializerManager;
    this.textEditorRegistry = params.textEditorRegistry;
    this.styleManager = params.styleManager;
    this.draggingItem = false;
    this.itemLocationStore = new StateStore('AtomPreviousItemLocations', 1);

    this.emitter = new Emitter();
    this.openers = [];
    this.destroyedItemURIs = [];
    this.stoppedChangingActivePaneItemTimeout = null;

    this.defaultDirectorySearcher = new DefaultDirectorySearcher();
    this.consumeServices(this.packageManager);

    this.paneContainers = {
      center: this.createCenter(),
      left: this.createDock('left'),
      right: this.createDock('right'),
      bottom: this.createDock('bottom')
    };
    this.activePaneContainer = this.paneContainers.center;
    this.hasActiveTextEditor = false;

    this.panelContainers = {
      top: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'top' }),
      left: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'left', dock: this.paneContainers.left }),
      right: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'right', dock: this.paneContainers.right }),
      bottom: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'bottom', dock: this.paneContainers.bottom }),
      header: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'header' }),
      footer: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'footer' }),
      modal: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'modal' })
    };

    this.subscribeToEvents();
  }

  _createClass(Workspace, [{
    key: 'getElement',
    value: function getElement() {
      if (!this.element) {
        this.element = new WorkspaceElement().initialize(this, {
          config: this.config,
          project: this.project,
          viewRegistry: this.viewRegistry,
          styleManager: this.styleManager
        });
      }
      return this.element;
    }
  }, {
    key: 'createCenter',
    value: function createCenter() {
      return new WorkspaceCenter({
        config: this.config,
        applicationDelegate: this.applicationDelegate,
        notificationManager: this.notificationManager,
        deserializerManager: this.deserializerManager,
        viewRegistry: this.viewRegistry,
        didActivate: this.didActivatePaneContainer,
        didChangeActivePane: this.didChangeActivePaneOnPaneContainer,
        didChangeActivePaneItem: this.didChangeActivePaneItemOnPaneContainer,
        didDestroyPaneItem: this.didDestroyPaneItem
      });
    }
  }, {
    key: 'createDock',
    value: function createDock(location) {
      return new Dock({
        location: location,
        config: this.config,
        applicationDelegate: this.applicationDelegate,
        deserializerManager: this.deserializerManager,
        notificationManager: this.notificationManager,
        viewRegistry: this.viewRegistry,
        didHide: this.didHideDock,
        didActivate: this.didActivatePaneContainer,
        didChangeActivePane: this.didChangeActivePaneOnPaneContainer,
        didChangeActivePaneItem: this.didChangeActivePaneItemOnPaneContainer,
        didDestroyPaneItem: this.didDestroyPaneItem
      });
    }
  }, {
    key: 'reset',
    value: function reset(packageManager) {
      this.packageManager = packageManager;
      this.emitter.dispose();
      this.emitter = new Emitter();

      this.paneContainers.center.destroy();
      this.paneContainers.left.destroy();
      this.paneContainers.right.destroy();
      this.paneContainers.bottom.destroy();

      _.values(this.panelContainers).forEach(function (panelContainer) {
        panelContainer.destroy();
      });

      this.paneContainers = {
        center: this.createCenter(),
        left: this.createDock('left'),
        right: this.createDock('right'),
        bottom: this.createDock('bottom')
      };
      this.activePaneContainer = this.paneContainers.center;
      this.hasActiveTextEditor = false;

      this.panelContainers = {
        top: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'top' }),
        left: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'left', dock: this.paneContainers.left }),
        right: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'right', dock: this.paneContainers.right }),
        bottom: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'bottom', dock: this.paneContainers.bottom }),
        header: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'header' }),
        footer: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'footer' }),
        modal: new PanelContainer({ viewRegistry: this.viewRegistry, location: 'modal' })
      };

      this.originalFontSize = null;
      this.openers = [];
      this.destroyedItemURIs = [];
      this.element = null;
      this.consumeServices(this.packageManager);
    }
  }, {
    key: 'subscribeToEvents',
    value: function subscribeToEvents() {
      this.project.onDidChangePaths(this.updateWindowTitle);
      this.subscribeToFontSize();
      this.subscribeToAddedItems();
      this.subscribeToMovedItems();
    }
  }, {
    key: 'consumeServices',
    value: function consumeServices(_ref) {
      var _this = this;

      var serviceHub = _ref.serviceHub;

      this.directorySearchers = [];
      serviceHub.consume('atom.directory-searcher', '^0.1.0', function (provider) {
        return _this.directorySearchers.unshift(provider);
      });
    }

    // Called by the Serializable mixin during serialization.
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'Workspace',
        packagesWithActiveGrammars: this.getPackageNamesWithActiveGrammars(),
        destroyedItemURIs: this.destroyedItemURIs.slice(),
        // Ensure deserializing 1.17 state with pre 1.17 Atom does not error
        // TODO: Remove after 1.17 has been on stable for a while
        paneContainer: { version: 2 },
        paneContainers: {
          center: this.paneContainers.center.serialize(),
          left: this.paneContainers.left.serialize(),
          right: this.paneContainers.right.serialize(),
          bottom: this.paneContainers.bottom.serialize()
        }
      };
    }
  }, {
    key: 'deserialize',
    value: function deserialize(state, deserializerManager) {
      var packagesWithActiveGrammars = state.packagesWithActiveGrammars != null ? state.packagesWithActiveGrammars : [];
      for (var packageName of packagesWithActiveGrammars) {
        var pkg = this.packageManager.getLoadedPackage(packageName);
        if (pkg != null) {
          pkg.loadGrammarsSync();
        }
      }
      if (state.destroyedItemURIs != null) {
        this.destroyedItemURIs = state.destroyedItemURIs;
      }

      if (state.paneContainers) {
        this.paneContainers.center.deserialize(state.paneContainers.center, deserializerManager);
        this.paneContainers.left.deserialize(state.paneContainers.left, deserializerManager);
        this.paneContainers.right.deserialize(state.paneContainers.right, deserializerManager);
        this.paneContainers.bottom.deserialize(state.paneContainers.bottom, deserializerManager);
      } else if (state.paneContainer) {
        // TODO: Remove this fallback once a lot of time has passed since 1.17 was released
        this.paneContainers.center.deserialize(state.paneContainer, deserializerManager);
      }

      this.hasActiveTextEditor = this.getActiveTextEditor() != null;

      this.updateWindowTitle();
    }
  }, {
    key: 'getPackageNamesWithActiveGrammars',
    value: function getPackageNamesWithActiveGrammars() {
      var _this2 = this;

      var packageNames = [];
      var addGrammar = function addGrammar() {
        var _ref2 = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

        var includedGrammarScopes = _ref2.includedGrammarScopes;
        var packageName = _ref2.packageName;

        if (!packageName) {
          return;
        }
        // Prevent cycles
        if (packageNames.indexOf(packageName) !== -1) {
          return;
        }

        packageNames.push(packageName);
        for (var scopeName of includedGrammarScopes != null ? includedGrammarScopes : []) {
          addGrammar(_this2.grammarRegistry.grammarForScopeName(scopeName));
        }
      };

      var editors = this.getTextEditors();
      for (var editor of editors) {
        addGrammar(editor.getGrammar());
      }

      if (editors.length > 0) {
        for (var grammar of this.grammarRegistry.getGrammars()) {
          if (grammar.injectionSelector) {
            addGrammar(grammar);
          }
        }
      }

      return _.uniq(packageNames);
    }
  }, {
    key: 'didActivatePaneContainer',
    value: function didActivatePaneContainer(paneContainer) {
      if (paneContainer !== this.getActivePaneContainer()) {
        this.activePaneContainer = paneContainer;
        this.didChangeActivePaneItem(this.activePaneContainer.getActivePaneItem());
        this.emitter.emit('did-change-active-pane-container', this.activePaneContainer);
        this.emitter.emit('did-change-active-pane', this.activePaneContainer.getActivePane());
        this.emitter.emit('did-change-active-pane-item', this.activePaneContainer.getActivePaneItem());
      }
    }
  }, {
    key: 'didChangeActivePaneOnPaneContainer',
    value: function didChangeActivePaneOnPaneContainer(paneContainer, pane) {
      if (paneContainer === this.getActivePaneContainer()) {
        this.emitter.emit('did-change-active-pane', pane);
      }
    }
  }, {
    key: 'didChangeActivePaneItemOnPaneContainer',
    value: function didChangeActivePaneItemOnPaneContainer(paneContainer, item) {
      if (paneContainer === this.getActivePaneContainer()) {
        this.didChangeActivePaneItem(item);
        this.emitter.emit('did-change-active-pane-item', item);
      }

      if (paneContainer === this.getCenter()) {
        var hadActiveTextEditor = this.hasActiveTextEditor;
        this.hasActiveTextEditor = item instanceof TextEditor;

        if (this.hasActiveTextEditor || hadActiveTextEditor) {
          var itemValue = this.hasActiveTextEditor ? item : undefined;
          this.emitter.emit('did-change-active-text-editor', itemValue);
        }
      }
    }
  }, {
    key: 'didChangeActivePaneItem',
    value: function didChangeActivePaneItem(item) {
      var _this3 = this;

      this.updateWindowTitle();
      this.updateDocumentEdited();
      if (this.activeItemSubscriptions) this.activeItemSubscriptions.dispose();
      this.activeItemSubscriptions = new CompositeDisposable();

      var modifiedSubscription = undefined,
          titleSubscription = undefined;

      if (item != null && typeof item.onDidChangeTitle === 'function') {
        titleSubscription = item.onDidChangeTitle(this.updateWindowTitle);
      } else if (item != null && typeof item.on === 'function') {
        titleSubscription = item.on('title-changed', this.updateWindowTitle);
        if (titleSubscription == null || typeof titleSubscription.dispose !== 'function') {
          titleSubscription = new Disposable(function () {
            item.off('title-changed', _this3.updateWindowTitle);
          });
        }
      }

      if (item != null && typeof item.onDidChangeModified === 'function') {
        modifiedSubscription = item.onDidChangeModified(this.updateDocumentEdited);
      } else if (item != null && typeof item.on === 'function') {
        modifiedSubscription = item.on('modified-status-changed', this.updateDocumentEdited);
        if (modifiedSubscription == null || typeof modifiedSubscription.dispose !== 'function') {
          modifiedSubscription = new Disposable(function () {
            item.off('modified-status-changed', _this3.updateDocumentEdited);
          });
        }
      }

      if (titleSubscription != null) {
        this.activeItemSubscriptions.add(titleSubscription);
      }
      if (modifiedSubscription != null) {
        this.activeItemSubscriptions.add(modifiedSubscription);
      }

      this.cancelStoppedChangingActivePaneItemTimeout();
      this.stoppedChangingActivePaneItemTimeout = setTimeout(function () {
        _this3.stoppedChangingActivePaneItemTimeout = null;
        _this3.emitter.emit('did-stop-changing-active-pane-item', item);
      }, STOPPED_CHANGING_ACTIVE_PANE_ITEM_DELAY);
    }
  }, {
    key: 'cancelStoppedChangingActivePaneItemTimeout',
    value: function cancelStoppedChangingActivePaneItemTimeout() {
      if (this.stoppedChangingActivePaneItemTimeout != null) {
        clearTimeout(this.stoppedChangingActivePaneItemTimeout);
      }
    }
  }, {
    key: 'didHideDock',
    value: function didHideDock(dock) {
      var activeElement = document.activeElement;

      var dockElement = dock.getElement();
      if (dockElement === activeElement || dockElement.contains(activeElement)) {
        this.getCenter().activate();
      }
    }
  }, {
    key: 'setDraggingItem',
    value: function setDraggingItem(draggingItem) {
      _.values(this.paneContainers).forEach(function (dock) {
        dock.setDraggingItem(draggingItem);
      });
    }
  }, {
    key: 'subscribeToAddedItems',
    value: function subscribeToAddedItems() {
      var _this4 = this;

      this.onDidAddPaneItem(function (_ref3) {
        var item = _ref3.item;
        var pane = _ref3.pane;
        var index = _ref3.index;

        if (item instanceof TextEditor) {
          (function () {
            var subscriptions = new CompositeDisposable(_this4.textEditorRegistry.add(item), _this4.textEditorRegistry.maintainGrammar(item), _this4.textEditorRegistry.maintainConfig(item), item.observeGrammar(_this4.handleGrammarUsed.bind(_this4)));
            item.onDidDestroy(function () {
              subscriptions.dispose();
            });
            _this4.emitter.emit('did-add-text-editor', { textEditor: item, pane: pane, index: index });
          })();
        }
      });
    }
  }, {
    key: 'subscribeToMovedItems',
    value: function subscribeToMovedItems() {
      var _this5 = this;

      var _loop = function (paneContainer) {
        paneContainer.observePanes(function (pane) {
          pane.onDidAddItem(function (_ref4) {
            var item = _ref4.item;

            if (typeof item.getURI === 'function' && _this5.enablePersistence) {
              var uri = item.getURI();
              if (uri) {
                var _location = paneContainer.getLocation();
                var defaultLocation = undefined;
                if (typeof item.getDefaultLocation === 'function') {
                  defaultLocation = item.getDefaultLocation();
                }
                defaultLocation = defaultLocation || 'center';
                if (_location === defaultLocation) {
                  _this5.itemLocationStore['delete'](item.getURI());
                } else {
                  _this5.itemLocationStore.save(item.getURI(), _location);
                }
              }
            }
          });
        });
      };

      for (var paneContainer of this.getPaneContainers()) {
        _loop(paneContainer);
      }
    }

    // Updates the application's title and proxy icon based on whichever file is
    // open.
  }, {
    key: 'updateWindowTitle',
    value: function updateWindowTitle() {
      var itemPath = undefined,
          itemTitle = undefined,
          projectPath = undefined,
          representedPath = undefined;
      var appName = 'Atom';
      var left = this.project.getPaths();
      var projectPaths = left != null ? left : [];
      var item = this.getActivePaneItem();
      if (item) {
        itemPath = typeof item.getPath === 'function' ? item.getPath() : undefined;
        var longTitle = typeof item.getLongTitle === 'function' ? item.getLongTitle() : undefined;
        itemTitle = longTitle == null ? typeof item.getTitle === 'function' ? item.getTitle() : undefined : longTitle;
        projectPath = _.find(projectPaths, function (projectPath) {
          return itemPath === projectPath || (itemPath != null ? itemPath.startsWith(projectPath + path.sep) : undefined);
        });
      }
      if (itemTitle == null) {
        itemTitle = 'untitled';
      }
      if (projectPath == null) {
        projectPath = itemPath ? path.dirname(itemPath) : projectPaths[0];
      }
      if (projectPath != null) {
        projectPath = fs.tildify(projectPath);
      }

      var titleParts = [];
      if (item != null && projectPath != null) {
        titleParts.push(itemTitle, projectPath);
        representedPath = itemPath != null ? itemPath : projectPath;
      } else if (projectPath != null) {
        titleParts.push(projectPath);
        representedPath = projectPath;
      } else {
        titleParts.push(itemTitle);
        representedPath = '';
      }

      if (process.platform !== 'darwin') {
        titleParts.push(appName);
      }

      document.title = titleParts.join(' — ');
      this.applicationDelegate.setRepresentedFilename(representedPath);
    }

    // On macOS, fades the application window's proxy icon when the current file
    // has been modified.
  }, {
    key: 'updateDocumentEdited',
    value: function updateDocumentEdited() {
      var activePaneItem = this.getActivePaneItem();
      var modified = activePaneItem != null && typeof activePaneItem.isModified === 'function' ? activePaneItem.isModified() || false : false;
      this.applicationDelegate.setWindowDocumentEdited(modified);
    }

    /*
    Section: Event Subscription
    */

  }, {
    key: 'onDidChangeActivePaneContainer',
    value: function onDidChangeActivePaneContainer(callback) {
      return this.emitter.on('did-change-active-pane-container', callback);
    }

    // Essential: Invoke the given callback with all current and future text
    // editors in the workspace.
    //
    // * `callback` {Function} to be called with current and future text editors.
    //   * `editor` An {TextEditor} that is present in {::getTextEditors} at the time
    //     of subscription or that is added at some later time.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observeTextEditors',
    value: function observeTextEditors(callback) {
      for (var textEditor of this.getTextEditors()) {
        callback(textEditor);
      }
      return this.onDidAddTextEditor(function (_ref5) {
        var textEditor = _ref5.textEditor;
        return callback(textEditor);
      });
    }

    // Essential: Invoke the given callback with all current and future panes items
    // in the workspace.
    //
    // * `callback` {Function} to be called with current and future pane items.
    //   * `item` An item that is present in {::getPaneItems} at the time of
    //      subscription or that is added at some later time.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observePaneItems',
    value: function observePaneItems(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.observePaneItems(callback);
      })))))();
    }

    // Essential: Invoke the given callback when the active pane item changes.
    //
    // Because observers are invoked synchronously, it's important not to perform
    // any expensive operations via this method. Consider
    // {::onDidStopChangingActivePaneItem} to delay operations until after changes
    // stop occurring.
    //
    // * `callback` {Function} to be called when the active pane item changes.
    //   * `item` The active pane item.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidChangeActivePaneItem',
    value: function onDidChangeActivePaneItem(callback) {
      return this.emitter.on('did-change-active-pane-item', callback);
    }

    // Essential: Invoke the given callback when the active pane item stops
    // changing.
    //
    // Observers are called asynchronously 100ms after the last active pane item
    // change. Handling changes here rather than in the synchronous
    // {::onDidChangeActivePaneItem} prevents unneeded work if the user is quickly
    // changing or closing tabs and ensures critical UI feedback, like changing the
    // highlighted tab, gets priority over work that can be done asynchronously.
    //
    // * `callback` {Function} to be called when the active pane item stopts
    //   changing.
    //   * `item` The active pane item.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidStopChangingActivePaneItem',
    value: function onDidStopChangingActivePaneItem(callback) {
      return this.emitter.on('did-stop-changing-active-pane-item', callback);
    }

    // Essential: Invoke the given callback when a text editor becomes the active
    // text editor and when there is no longer an active text editor.
    //
    // * `callback` {Function} to be called when the active text editor changes.
    //   * `editor` The active {TextEditor} or undefined if there is no longer an
    //      active text editor.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidChangeActiveTextEditor',
    value: function onDidChangeActiveTextEditor(callback) {
      return this.emitter.on('did-change-active-text-editor', callback);
    }

    // Essential: Invoke the given callback with the current active pane item and
    // with all future active pane items in the workspace.
    //
    // * `callback` {Function} to be called when the active pane item changes.
    //   * `item` The current active pane item.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observeActivePaneItem',
    value: function observeActivePaneItem(callback) {
      callback(this.getActivePaneItem());
      return this.onDidChangeActivePaneItem(callback);
    }

    // Essential: Invoke the given callback with the current active text editor
    // (if any), with all future active text editors, and when there is no longer
    // an active text editor.
    //
    // * `callback` {Function} to be called when the active text editor changes.
    //   * `editor` The active {TextEditor} or undefined if there is not an
    //      active text editor.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observeActiveTextEditor',
    value: function observeActiveTextEditor(callback) {
      callback(this.getActiveTextEditor());

      return this.onDidChangeActiveTextEditor(callback);
    }

    // Essential: Invoke the given callback whenever an item is opened. Unlike
    // {::onDidAddPaneItem}, observers will be notified for items that are already
    // present in the workspace when they are reopened.
    //
    // * `callback` {Function} to be called whenever an item is opened.
    //   * `event` {Object} with the following keys:
    //     * `uri` {String} representing the opened URI. Could be `undefined`.
    //     * `item` The opened item.
    //     * `pane` The pane in which the item was opened.
    //     * `index` The index of the opened item on its pane.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidOpen',
    value: function onDidOpen(callback) {
      return this.emitter.on('did-open', callback);
    }

    // Extended: Invoke the given callback when a pane is added to the workspace.
    //
    // * `callback` {Function} to be called panes are added.
    //   * `event` {Object} with the following keys:
    //     * `pane` The added pane.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidAddPane',
    value: function onDidAddPane(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onDidAddPane(callback);
      })))))();
    }

    // Extended: Invoke the given callback before a pane is destroyed in the
    // workspace.
    //
    // * `callback` {Function} to be called before panes are destroyed.
    //   * `event` {Object} with the following keys:
    //     * `pane` The pane to be destroyed.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onWillDestroyPane',
    value: function onWillDestroyPane(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onWillDestroyPane(callback);
      })))))();
    }

    // Extended: Invoke the given callback when a pane is destroyed in the
    // workspace.
    //
    // * `callback` {Function} to be called panes are destroyed.
    //   * `event` {Object} with the following keys:
    //     * `pane` The destroyed pane.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidDestroyPane',
    value: function onDidDestroyPane(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onDidDestroyPane(callback);
      })))))();
    }

    // Extended: Invoke the given callback with all current and future panes in the
    // workspace.
    //
    // * `callback` {Function} to be called with current and future panes.
    //   * `pane` A {Pane} that is present in {::getPanes} at the time of
    //      subscription or that is added at some later time.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observePanes',
    value: function observePanes(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.observePanes(callback);
      })))))();
    }

    // Extended: Invoke the given callback when the active pane changes.
    //
    // * `callback` {Function} to be called when the active pane changes.
    //   * `pane` A {Pane} that is the current return value of {::getActivePane}.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidChangeActivePane',
    value: function onDidChangeActivePane(callback) {
      return this.emitter.on('did-change-active-pane', callback);
    }

    // Extended: Invoke the given callback with the current active pane and when
    // the active pane changes.
    //
    // * `callback` {Function} to be called with the current and future active#
    //   panes.
    //   * `pane` A {Pane} that is the current return value of {::getActivePane}.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observeActivePane',
    value: function observeActivePane(callback) {
      callback(this.getActivePane());
      return this.onDidChangeActivePane(callback);
    }

    // Extended: Invoke the given callback when a pane item is added to the
    // workspace.
    //
    // * `callback` {Function} to be called when pane items are added.
    //   * `event` {Object} with the following keys:
    //     * `item` The added pane item.
    //     * `pane` {Pane} containing the added item.
    //     * `index` {Number} indicating the index of the added item in its pane.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidAddPaneItem',
    value: function onDidAddPaneItem(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onDidAddPaneItem(callback);
      })))))();
    }

    // Extended: Invoke the given callback when a pane item is about to be
    // destroyed, before the user is prompted to save it.
    //
    // * `callback` {Function} to be called before pane items are destroyed.
    //   * `event` {Object} with the following keys:
    //     * `item` The item to be destroyed.
    //     * `pane` {Pane} containing the item to be destroyed.
    //     * `index` {Number} indicating the index of the item to be destroyed in
    //       its pane.
    //
    // Returns a {Disposable} on which `.dispose` can be called to unsubscribe.
  }, {
    key: 'onWillDestroyPaneItem',
    value: function onWillDestroyPaneItem(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onWillDestroyPaneItem(callback);
      })))))();
    }

    // Extended: Invoke the given callback when a pane item is destroyed.
    //
    // * `callback` {Function} to be called when pane items are destroyed.
    //   * `event` {Object} with the following keys:
    //     * `item` The destroyed item.
    //     * `pane` {Pane} containing the destroyed item.
    //     * `index` {Number} indicating the index of the destroyed item in its
    //       pane.
    //
    // Returns a {Disposable} on which `.dispose` can be called to unsubscribe.
  }, {
    key: 'onDidDestroyPaneItem',
    value: function onDidDestroyPaneItem(callback) {
      return new (_bind.apply(CompositeDisposable, [null].concat(_toConsumableArray(this.getPaneContainers().map(function (container) {
        return container.onDidDestroyPaneItem(callback);
      })))))();
    }

    // Extended: Invoke the given callback when a text editor is added to the
    // workspace.
    //
    // * `callback` {Function} to be called panes are added.
    //   * `event` {Object} with the following keys:
    //     * `textEditor` {TextEditor} that was added.
    //     * `pane` {Pane} containing the added text editor.
    //     * `index` {Number} indicating the index of the added text editor in its
    //        pane.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidAddTextEditor',
    value: function onDidAddTextEditor(callback) {
      return this.emitter.on('did-add-text-editor', callback);
    }

    /*
    Section: Opening
    */

    // Essential: Opens the given URI in Atom asynchronously.
    // If the URI is already open, the existing item for that URI will be
    // activated. If no URI is given, or no registered opener can open
    // the URI, a new empty {TextEditor} will be created.
    //
    // * `uri` (optional) A {String} containing a URI.
    // * `options` (optional) {Object}
    //   * `initialLine` A {Number} indicating which row to move the cursor to
    //     initially. Defaults to `0`.
    //   * `initialColumn` A {Number} indicating which column to move the cursor to
    //     initially. Defaults to `0`.
    //   * `split` Either 'left', 'right', 'up' or 'down'.
    //     If 'left', the item will be opened in leftmost pane of the current active pane's row.
    //     If 'right', the item will be opened in the rightmost pane of the current active pane's row. If only one pane exists in the row, a new pane will be created.
    //     If 'up', the item will be opened in topmost pane of the current active pane's column.
    //     If 'down', the item will be opened in the bottommost pane of the current active pane's column. If only one pane exists in the column, a new pane will be created.
    //   * `activatePane` A {Boolean} indicating whether to call {Pane::activate} on
    //     containing pane. Defaults to `true`.
    //   * `activateItem` A {Boolean} indicating whether to call {Pane::activateItem}
    //     on containing pane. Defaults to `true`.
    //   * `pending` A {Boolean} indicating whether or not the item should be opened
    //     in a pending state. Existing pending items in a pane are replaced with
    //     new pending items when they are opened.
    //   * `searchAllPanes` A {Boolean}. If `true`, the workspace will attempt to
    //     activate an existing item for the given URI on any pane.
    //     If `false`, only the active pane will be searched for
    //     an existing item for the same URI. Defaults to `false`.
    //   * `location` (optional) A {String} containing the name of the location
    //     in which this item should be opened (one of "left", "right", "bottom",
    //     or "center"). If omitted, Atom will fall back to the last location in
    //     which a user has placed an item with the same URI or, if this is a new
    //     URI, the default location specified by the item. NOTE: This option
    //     should almost always be omitted to honor user preference.
    //
    // Returns a {Promise} that resolves to the {TextEditor} for the file URI.
  }, {
    key: 'open',
    value: _asyncToGenerator(function* (itemOrURI) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var uri = undefined,
          item = undefined;
      if (typeof itemOrURI === 'string') {
        uri = this.project.resolvePath(itemOrURI);
      } else if (itemOrURI) {
        item = itemOrURI;
        if (typeof item.getURI === 'function') uri = item.getURI();
      }

      if (!atom.config.get('core.allowPendingPaneItems')) {
        options.pending = false;
      }

      // Avoid adding URLs as recent documents to work-around this Spotlight crash:
      // https://github.com/atom/atom/issues/10071
      if (uri && (!url.parse(uri).protocol || process.platform === 'win32')) {
        this.applicationDelegate.addRecentDocument(uri);
      }

      var pane = undefined,
          itemExistsInWorkspace = undefined;

      // Try to find an existing item in the workspace.
      if (item || uri) {
        if (options.pane) {
          pane = options.pane;
        } else if (options.searchAllPanes) {
          pane = item ? this.paneForItem(item) : this.paneForURI(uri);
        } else {
          // If an item with the given URI is already in the workspace, assume
          // that item's pane container is the preferred location for that URI.
          var container = undefined;
          if (uri) container = this.paneContainerForURI(uri);
          if (!container) container = this.getActivePaneContainer();

          // The `split` option affects where we search for the item.
          pane = container.getActivePane();
          switch (options.split) {
            case 'left':
              pane = pane.findLeftmostSibling();
              break;
            case 'right':
              pane = pane.findRightmostSibling();
              break;
            case 'up':
              pane = pane.findTopmostSibling();
              break;
            case 'down':
              pane = pane.findBottommostSibling();
              break;
          }
        }

        if (pane) {
          if (item) {
            itemExistsInWorkspace = pane.getItems().includes(item);
          } else {
            item = pane.itemForURI(uri);
            itemExistsInWorkspace = item != null;
          }
        }
      }

      // If we already have an item at this stage, we won't need to do an async
      // lookup of the URI, so we yield the event loop to ensure this method
      // is consistently asynchronous.
      if (item) yield Promise.resolve();

      if (!itemExistsInWorkspace) {
        item = item || (yield this.createItemForURI(uri, options));
        if (!item) return;

        if (options.pane) {
          pane = options.pane;
        } else {
          var _location2 = options.location;
          if (!_location2 && !options.split && uri && this.enablePersistence) {
            _location2 = yield this.itemLocationStore.load(uri);
          }
          if (!_location2 && typeof item.getDefaultLocation === 'function') {
            _location2 = item.getDefaultLocation();
          }

          var allowedLocations = typeof item.getAllowedLocations === 'function' ? item.getAllowedLocations() : ALL_LOCATIONS;
          _location2 = allowedLocations.includes(_location2) ? _location2 : allowedLocations[0];

          var container = this.paneContainers[_location2] || this.getCenter();
          pane = container.getActivePane();
          switch (options.split) {
            case 'left':
              pane = pane.findLeftmostSibling();
              break;
            case 'right':
              pane = pane.findOrCreateRightmostSibling();
              break;
            case 'up':
              pane = pane.findTopmostSibling();
              break;
            case 'down':
              pane = pane.findOrCreateBottommostSibling();
              break;
          }
        }
      }

      if (!options.pending && pane.getPendingItem() === item) {
        pane.clearPendingItem();
      }

      this.itemOpened(item);

      if (options.activateItem === false) {
        pane.addItem(item, { pending: options.pending });
      } else {
        pane.activateItem(item, { pending: options.pending });
      }

      if (options.activatePane !== false) {
        pane.activate();
      }

      var initialColumn = 0;
      var initialLine = 0;
      if (!Number.isNaN(options.initialLine)) {
        initialLine = options.initialLine;
      }
      if (!Number.isNaN(options.initialColumn)) {
        initialColumn = options.initialColumn;
      }
      if (initialLine >= 0 || initialColumn >= 0) {
        if (typeof item.setCursorBufferPosition === 'function') {
          item.setCursorBufferPosition([initialLine, initialColumn]);
        }
      }

      var index = pane.getActiveItemIndex();
      this.emitter.emit('did-open', { uri: uri, pane: pane, item: item, index: index });
      return item;
    })

    // Essential: Search the workspace for items matching the given URI and hide them.
    //
    // * `itemOrURI` (optional) The item to hide or a {String} containing the URI
    //   of the item to hide.
    //
    // Returns a {boolean} indicating whether any items were found (and hidden).
  }, {
    key: 'hide',
    value: function hide(itemOrURI) {
      var foundItems = false;

      // If any visible item has the given URI, hide it
      for (var container of this.getPaneContainers()) {
        var isCenter = container === this.getCenter();
        if (isCenter || container.isVisible()) {
          for (var pane of container.getPanes()) {
            var activeItem = pane.getActiveItem();
            var foundItem = activeItem != null && (activeItem === itemOrURI || typeof activeItem.getURI === 'function' && activeItem.getURI() === itemOrURI);
            if (foundItem) {
              foundItems = true;
              // We can't really hide the center so we just destroy the item.
              if (isCenter) {
                pane.destroyItem(activeItem);
              } else {
                container.hide();
              }
            }
          }
        }
      }

      return foundItems;
    }

    // Essential: Search the workspace for items matching the given URI. If any are found, hide them.
    // Otherwise, open the URL.
    //
    // * `itemOrURI` (optional) The item to toggle or a {String} containing the URI
    //   of the item to toggle.
    //
    // Returns a Promise that resolves when the item is shown or hidden.
  }, {
    key: 'toggle',
    value: function toggle(itemOrURI) {
      if (this.hide(itemOrURI)) {
        return Promise.resolve();
      } else {
        return this.open(itemOrURI, { searchAllPanes: true });
      }
    }

    // Open Atom's license in the active pane.
  }, {
    key: 'openLicense',
    value: function openLicense() {
      return this.open(path.join(process.resourcesPath, 'LICENSE.md'));
    }

    // Synchronously open the given URI in the active pane. **Only use this method
    // in specs. Calling this in production code will block the UI thread and
    // everyone will be mad at you.**
    //
    // * `uri` A {String} containing a URI.
    // * `options` An optional options {Object}
    //   * `initialLine` A {Number} indicating which row to move the cursor to
    //     initially. Defaults to `0`.
    //   * `initialColumn` A {Number} indicating which column to move the cursor to
    //     initially. Defaults to `0`.
    //   * `activatePane` A {Boolean} indicating whether to call {Pane::activate} on
    //     the containing pane. Defaults to `true`.
    //   * `activateItem` A {Boolean} indicating whether to call {Pane::activateItem}
    //     on containing pane. Defaults to `true`.
  }, {
    key: 'openSync',
    value: function openSync() {
      var uri_ = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
      var initialLine = options.initialLine;
      var initialColumn = options.initialColumn;

      var activatePane = options.activatePane != null ? options.activatePane : true;
      var activateItem = options.activateItem != null ? options.activateItem : true;

      var uri = this.project.resolvePath(uri_);
      var item = this.getActivePane().itemForURI(uri);
      if (uri && item == null) {
        for (var _opener of this.getOpeners()) {
          item = _opener(uri, options);
          if (item) break;
        }
      }
      if (item == null) {
        item = this.project.openSync(uri, { initialLine: initialLine, initialColumn: initialColumn });
      }

      if (activateItem) {
        this.getActivePane().activateItem(item);
      }
      this.itemOpened(item);
      if (activatePane) {
        this.getActivePane().activate();
      }
      return item;
    }
  }, {
    key: 'openURIInPane',
    value: function openURIInPane(uri, pane) {
      return this.open(uri, { pane: pane });
    }

    // Public: Creates a new item that corresponds to the provided URI.
    //
    // If no URI is given, or no registered opener can open the URI, a new empty
    // {TextEditor} will be created.
    //
    // * `uri` A {String} containing a URI.
    //
    // Returns a {Promise} that resolves to the {TextEditor} (or other item) for the given URI.
  }, {
    key: 'createItemForURI',
    value: function createItemForURI(uri, options) {
      if (uri != null) {
        for (var _opener2 of this.getOpeners()) {
          var item = _opener2(uri, options);
          if (item != null) return Promise.resolve(item);
        }
      }

      try {
        return this.openTextFile(uri, options);
      } catch (error) {
        switch (error.code) {
          case 'CANCELLED':
            return Promise.resolve();
          case 'EACCES':
            this.notificationManager.addWarning('Permission denied \'' + error.path + '\'');
            return Promise.resolve();
          case 'EPERM':
          case 'EBUSY':
          case 'ENXIO':
          case 'EIO':
          case 'ENOTCONN':
          case 'UNKNOWN':
          case 'ECONNRESET':
          case 'EINVAL':
          case 'EMFILE':
          case 'ENOTDIR':
          case 'EAGAIN':
            this.notificationManager.addWarning('Unable to open \'' + (error.path != null ? error.path : uri) + '\'', { detail: error.message });
            return Promise.resolve();
          default:
            throw error;
        }
      }
    }
  }, {
    key: 'openTextFile',
    value: function openTextFile(uri, options) {
      var _this6 = this;

      var filePath = this.project.resolvePath(uri);

      if (filePath != null) {
        try {
          fs.closeSync(fs.openSync(filePath, 'r'));
        } catch (error) {
          // allow ENOENT errors to create an editor for paths that dont exist
          if (error.code !== 'ENOENT') {
            throw error;
          }
        }
      }

      var fileSize = fs.getSizeSync(filePath);

      var largeFileMode = fileSize >= 2 * 1048576; // 2MB
      if (fileSize >= this.config.get('core.warnOnLargeFileLimit') * 1048576) {
        // 20MB by default
        var choice = this.applicationDelegate.confirm({
          message: 'Atom will be unresponsive during the loading of very large files.',
          detailedMessage: 'Do you still want to load this file?',
          buttons: ['Proceed', 'Cancel']
        });
        if (choice === 1) {
          var error = new Error();
          error.code = 'CANCELLED';
          throw error;
        }
      }

      return this.project.bufferForPath(filePath, options).then(function (buffer) {
        return _this6.textEditorRegistry.build(Object.assign({ buffer: buffer, largeFileMode: largeFileMode, autoHeight: false }, options));
      });
    }
  }, {
    key: 'handleGrammarUsed',
    value: function handleGrammarUsed(grammar) {
      if (grammar == null) {
        return;
      }
      return this.packageManager.triggerActivationHook(grammar.packageName + ':grammar-used');
    }

    // Public: Returns a {Boolean} that is `true` if `object` is a `TextEditor`.
    //
    // * `object` An {Object} you want to perform the check against.
  }, {
    key: 'isTextEditor',
    value: function isTextEditor(object) {
      return object instanceof TextEditor;
    }

    // Extended: Create a new text editor.
    //
    // Returns a {TextEditor}.
  }, {
    key: 'buildTextEditor',
    value: function buildTextEditor(params) {
      var editor = this.textEditorRegistry.build(params);
      var subscriptions = new CompositeDisposable(this.textEditorRegistry.maintainGrammar(editor), this.textEditorRegistry.maintainConfig(editor));
      editor.onDidDestroy(function () {
        subscriptions.dispose();
      });
      return editor;
    }

    // Public: Asynchronously reopens the last-closed item's URI if it hasn't already been
    // reopened.
    //
    // Returns a {Promise} that is resolved when the item is opened
  }, {
    key: 'reopenItem',
    value: function reopenItem() {
      var uri = this.destroyedItemURIs.pop();
      if (uri) {
        return this.open(uri);
      } else {
        return Promise.resolve();
      }
    }

    // Public: Register an opener for a uri.
    //
    // When a URI is opened via {Workspace::open}, Atom loops through its registered
    // opener functions until one returns a value for the given uri.
    // Openers are expected to return an object that inherits from HTMLElement or
    // a model which has an associated view in the {ViewRegistry}.
    // A {TextEditor} will be used if no opener returns a value.
    //
    // ## Examples
    //
    // ```coffee
    // atom.workspace.addOpener (uri) ->
    //   if path.extname(uri) is '.toml'
    //     return new TomlEditor(uri)
    // ```
    //
    // * `opener` A {Function} to be called when a path is being opened.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to remove the
    // opener.
    //
    // Note that the opener will be called if and only if the URI is not already open
    // in the current pane. The searchAllPanes flag expands the search from the
    // current pane to all panes. If you wish to open a view of a different type for
    // a file that is already open, consider changing the protocol of the URI. For
    // example, perhaps you wish to preview a rendered version of the file `/foo/bar/baz.quux`
    // that is already open in a text editor view. You could signal this by calling
    // {Workspace::open} on the URI `quux-preview://foo/bar/baz.quux`. Then your opener
    // can check the protocol for quux-preview and only handle those URIs that match.
  }, {
    key: 'addOpener',
    value: function addOpener(opener) {
      var _this7 = this;

      this.openers.push(opener);
      return new Disposable(function () {
        _.remove(_this7.openers, opener);
      });
    }
  }, {
    key: 'getOpeners',
    value: function getOpeners() {
      return this.openers;
    }

    /*
    Section: Pane Items
    */

    // Essential: Get all pane items in the workspace.
    //
    // Returns an {Array} of items.
  }, {
    key: 'getPaneItems',
    value: function getPaneItems() {
      return _.flatten(this.getPaneContainers().map(function (container) {
        return container.getPaneItems();
      }));
    }

    // Essential: Get the active {Pane}'s active item.
    //
    // Returns an pane item {Object}.
  }, {
    key: 'getActivePaneItem',
    value: function getActivePaneItem() {
      return this.getActivePaneContainer().getActivePaneItem();
    }

    // Essential: Get all text editors in the workspace.
    //
    // Returns an {Array} of {TextEditor}s.
  }, {
    key: 'getTextEditors',
    value: function getTextEditors() {
      return this.getPaneItems().filter(function (item) {
        return item instanceof TextEditor;
      });
    }

    // Essential: Get the workspace center's active item if it is a {TextEditor}.
    //
    // Returns a {TextEditor} or `undefined` if the workspace center's current
    // active item is not a {TextEditor}.
  }, {
    key: 'getActiveTextEditor',
    value: function getActiveTextEditor() {
      var activeItem = this.getCenter().getActivePaneItem();
      if (activeItem instanceof TextEditor) {
        return activeItem;
      }
    }

    // Save all pane items.
  }, {
    key: 'saveAll',
    value: function saveAll() {
      this.getPaneContainers().forEach(function (container) {
        container.saveAll();
      });
    }
  }, {
    key: 'confirmClose',
    value: function confirmClose(options) {
      return Promise.all(this.getPaneContainers().map(function (container) {
        return container.confirmClose(options);
      })).then(function (results) {
        return !results.includes(false);
      });
    }

    // Save the active pane item.
    //
    // If the active pane item currently has a URI according to the item's
    // `.getURI` method, calls `.save` on the item. Otherwise
    // {::saveActivePaneItemAs} # will be called instead. This method does nothing
    // if the active item does not implement a `.save` method.
  }, {
    key: 'saveActivePaneItem',
    value: function saveActivePaneItem() {
      return this.getCenter().getActivePane().saveActiveItem();
    }

    // Prompt the user for a path and save the active pane item to it.
    //
    // Opens a native dialog where the user selects a path on disk, then calls
    // `.saveAs` on the item with the selected path. This method does nothing if
    // the active item does not implement a `.saveAs` method.
  }, {
    key: 'saveActivePaneItemAs',
    value: function saveActivePaneItemAs() {
      this.getCenter().getActivePane().saveActiveItemAs();
    }

    // Destroy (close) the active pane item.
    //
    // Removes the active pane item and calls the `.destroy` method on it if one is
    // defined.
  }, {
    key: 'destroyActivePaneItem',
    value: function destroyActivePaneItem() {
      return this.getActivePane().destroyActiveItem();
    }

    /*
    Section: Panes
    */

    // Extended: Get the most recently focused pane container.
    //
    // Returns a {Dock} or the {WorkspaceCenter}.
  }, {
    key: 'getActivePaneContainer',
    value: function getActivePaneContainer() {
      return this.activePaneContainer;
    }

    // Extended: Get all panes in the workspace.
    //
    // Returns an {Array} of {Pane}s.
  }, {
    key: 'getPanes',
    value: function getPanes() {
      return _.flatten(this.getPaneContainers().map(function (container) {
        return container.getPanes();
      }));
    }
  }, {
    key: 'getVisiblePanes',
    value: function getVisiblePanes() {
      return _.flatten(this.getVisiblePaneContainers().map(function (container) {
        return container.getPanes();
      }));
    }

    // Extended: Get the active {Pane}.
    //
    // Returns a {Pane}.
  }, {
    key: 'getActivePane',
    value: function getActivePane() {
      return this.getActivePaneContainer().getActivePane();
    }

    // Extended: Make the next pane active.
  }, {
    key: 'activateNextPane',
    value: function activateNextPane() {
      return this.getActivePaneContainer().activateNextPane();
    }

    // Extended: Make the previous pane active.
  }, {
    key: 'activatePreviousPane',
    value: function activatePreviousPane() {
      return this.getActivePaneContainer().activatePreviousPane();
    }

    // Extended: Get the first pane container that contains an item with the given
    // URI.
    //
    // * `uri` {String} uri
    //
    // Returns a {Dock}, the {WorkspaceCenter}, or `undefined` if no item exists
    // with the given URI.
  }, {
    key: 'paneContainerForURI',
    value: function paneContainerForURI(uri) {
      return this.getPaneContainers().find(function (container) {
        return container.paneForURI(uri);
      });
    }

    // Extended: Get the first pane container that contains the given item.
    //
    // * `item` the Item that the returned pane container must contain.
    //
    // Returns a {Dock}, the {WorkspaceCenter}, or `undefined` if no item exists
    // with the given URI.
  }, {
    key: 'paneContainerForItem',
    value: function paneContainerForItem(uri) {
      return this.getPaneContainers().find(function (container) {
        return container.paneForItem(uri);
      });
    }

    // Extended: Get the first {Pane} that contains an item with the given URI.
    //
    // * `uri` {String} uri
    //
    // Returns a {Pane} or `undefined` if no item exists with the given URI.
  }, {
    key: 'paneForURI',
    value: function paneForURI(uri) {
      for (var _location3 of this.getPaneContainers()) {
        var pane = _location3.paneForURI(uri);
        if (pane != null) {
          return pane;
        }
      }
    }

    // Extended: Get the {Pane} containing the given item.
    //
    // * `item` the Item that the returned pane must contain.
    //
    // Returns a {Pane} or `undefined` if no pane exists for the given item.
  }, {
    key: 'paneForItem',
    value: function paneForItem(item) {
      for (var _location4 of this.getPaneContainers()) {
        var pane = _location4.paneForItem(item);
        if (pane != null) {
          return pane;
        }
      }
    }

    // Destroy (close) the active pane.
  }, {
    key: 'destroyActivePane',
    value: function destroyActivePane() {
      var activePane = this.getActivePane();
      if (activePane != null) {
        activePane.destroy();
      }
    }

    // Close the active center pane item, or the active center pane if it is
    // empty, or the current window if there is only the empty root pane.
  }, {
    key: 'closeActivePaneItemOrEmptyPaneOrWindow',
    value: function closeActivePaneItemOrEmptyPaneOrWindow() {
      if (this.getCenter().getActivePaneItem() != null) {
        this.getCenter().getActivePane().destroyActiveItem();
      } else if (this.getCenter().getPanes().length > 1) {
        this.getCenter().destroyActivePane();
      } else if (this.config.get('core.closeEmptyWindows')) {
        atom.close();
      }
    }

    // Increase the editor font size by 1px.
  }, {
    key: 'increaseFontSize',
    value: function increaseFontSize() {
      this.config.set('editor.fontSize', this.config.get('editor.fontSize') + 1);
    }

    // Decrease the editor font size by 1px.
  }, {
    key: 'decreaseFontSize',
    value: function decreaseFontSize() {
      var fontSize = this.config.get('editor.fontSize');
      if (fontSize > 1) {
        this.config.set('editor.fontSize', fontSize - 1);
      }
    }

    // Restore to the window's original editor font size.
  }, {
    key: 'resetFontSize',
    value: function resetFontSize() {
      if (this.originalFontSize) {
        this.config.set('editor.fontSize', this.originalFontSize);
      }
    }
  }, {
    key: 'subscribeToFontSize',
    value: function subscribeToFontSize() {
      var _this8 = this;

      return this.config.onDidChange('editor.fontSize', function (_ref6) {
        var oldValue = _ref6.oldValue;

        if (_this8.originalFontSize == null) {
          _this8.originalFontSize = oldValue;
        }
      });
    }

    // Removes the item's uri from the list of potential items to reopen.
  }, {
    key: 'itemOpened',
    value: function itemOpened(item) {
      var uri = undefined;
      if (typeof item.getURI === 'function') {
        uri = item.getURI();
      } else if (typeof item.getUri === 'function') {
        uri = item.getUri();
      }

      if (uri != null) {
        _.remove(this.destroyedItemURIs, uri);
      }
    }

    // Adds the destroyed item's uri to the list of items to reopen.
  }, {
    key: 'didDestroyPaneItem',
    value: function didDestroyPaneItem(_ref7) {
      var item = _ref7.item;

      var uri = undefined;
      if (typeof item.getURI === 'function') {
        uri = item.getURI();
      } else if (typeof item.getUri === 'function') {
        uri = item.getUri();
      }

      if (uri != null) {
        this.destroyedItemURIs.push(uri);
      }
    }

    // Called by Model superclass when destroyed
  }, {
    key: 'destroyed',
    value: function destroyed() {
      this.paneContainers.center.destroy();
      this.paneContainers.left.destroy();
      this.paneContainers.right.destroy();
      this.paneContainers.bottom.destroy();
      this.cancelStoppedChangingActivePaneItemTimeout();
      if (this.activeItemSubscriptions != null) {
        this.activeItemSubscriptions.dispose();
      }
    }

    /*
    Section: Pane Locations
    */

    // Essential: Get the {WorkspaceCenter} at the center of the editor window.
  }, {
    key: 'getCenter',
    value: function getCenter() {
      return this.paneContainers.center;
    }

    // Essential: Get the {Dock} to the left of the editor window.
  }, {
    key: 'getLeftDock',
    value: function getLeftDock() {
      return this.paneContainers.left;
    }

    // Essential: Get the {Dock} to the right of the editor window.
  }, {
    key: 'getRightDock',
    value: function getRightDock() {
      return this.paneContainers.right;
    }

    // Essential: Get the {Dock} below the editor window.
  }, {
    key: 'getBottomDock',
    value: function getBottomDock() {
      return this.paneContainers.bottom;
    }
  }, {
    key: 'getPaneContainers',
    value: function getPaneContainers() {
      return [this.paneContainers.center, this.paneContainers.left, this.paneContainers.right, this.paneContainers.bottom];
    }
  }, {
    key: 'getVisiblePaneContainers',
    value: function getVisiblePaneContainers() {
      var center = this.getCenter();
      return atom.workspace.getPaneContainers().filter(function (container) {
        return container === center || container.isVisible();
      });
    }

    /*
    Section: Panels
     Panels are used to display UI related to an editor window. They are placed at one of the four
    edges of the window: left, right, top or bottom. If there are multiple panels on the same window
    edge they are stacked in order of priority: higher priority is closer to the center, lower
    priority towards the edge.
     *Note:* If your panel changes its size throughout its lifetime, consider giving it a higher
    priority, allowing fixed size panels to be closer to the edge. This allows control targets to
    remain more static for easier targeting by users that employ mice or trackpads. (See
    [atom/atom#4834](https://github.com/atom/atom/issues/4834) for discussion.)
    */

    // Essential: Get an {Array} of all the panel items at the bottom of the editor window.
  }, {
    key: 'getBottomPanels',
    value: function getBottomPanels() {
      return this.getPanels('bottom');
    }

    // Essential: Adds a panel item to the bottom of the editor window.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addBottomPanel',
    value: function addBottomPanel(options) {
      return this.addPanel('bottom', options);
    }

    // Essential: Get an {Array} of all the panel items to the left of the editor window.
  }, {
    key: 'getLeftPanels',
    value: function getLeftPanels() {
      return this.getPanels('left');
    }

    // Essential: Adds a panel item to the left of the editor window.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addLeftPanel',
    value: function addLeftPanel(options) {
      return this.addPanel('left', options);
    }

    // Essential: Get an {Array} of all the panel items to the right of the editor window.
  }, {
    key: 'getRightPanels',
    value: function getRightPanels() {
      return this.getPanels('right');
    }

    // Essential: Adds a panel item to the right of the editor window.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addRightPanel',
    value: function addRightPanel(options) {
      return this.addPanel('right', options);
    }

    // Essential: Get an {Array} of all the panel items at the top of the editor window.
  }, {
    key: 'getTopPanels',
    value: function getTopPanels() {
      return this.getPanels('top');
    }

    // Essential: Adds a panel item to the top of the editor window above the tabs.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addTopPanel',
    value: function addTopPanel(options) {
      return this.addPanel('top', options);
    }

    // Essential: Get an {Array} of all the panel items in the header.
  }, {
    key: 'getHeaderPanels',
    value: function getHeaderPanels() {
      return this.getPanels('header');
    }

    // Essential: Adds a panel item to the header.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addHeaderPanel',
    value: function addHeaderPanel(options) {
      return this.addPanel('header', options);
    }

    // Essential: Get an {Array} of all the panel items in the footer.
  }, {
    key: 'getFooterPanels',
    value: function getFooterPanels() {
      return this.getPanels('footer');
    }

    // Essential: Adds a panel item to the footer.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     latter. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addFooterPanel',
    value: function addFooterPanel(options) {
      return this.addPanel('footer', options);
    }

    // Essential: Get an {Array} of all the modal panel items
  }, {
    key: 'getModalPanels',
    value: function getModalPanels() {
      return this.getPanels('modal');
    }

    // Essential: Adds a panel item as a modal dialog.
    //
    // * `options` {Object}
    //   * `item` Your panel content. It can be a DOM element, a jQuery element, or
    //     a model with a view registered via {ViewRegistry::addViewProvider}. We recommend the
    //     model option. See {ViewRegistry::addViewProvider} for more information.
    //   * `visible` (optional) {Boolean} false if you want the panel to initially be hidden
    //     (default: true)
    //   * `priority` (optional) {Number} Determines stacking order. Lower priority items are
    //     forced closer to the edges of the window. (default: 100)
    //
    // Returns a {Panel}
  }, {
    key: 'addModalPanel',
    value: function addModalPanel() {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      return this.addPanel('modal', options);
    }

    // Essential: Returns the {Panel} associated with the given item. Returns
    // `null` when the item has no panel.
    //
    // * `item` Item the panel contains
  }, {
    key: 'panelForItem',
    value: function panelForItem(item) {
      for (var _location5 in this.panelContainers) {
        var container = this.panelContainers[_location5];
        var panel = container.panelForItem(item);
        if (panel != null) {
          return panel;
        }
      }
      return null;
    }
  }, {
    key: 'getPanels',
    value: function getPanels(location) {
      return this.panelContainers[location].getPanels();
    }
  }, {
    key: 'addPanel',
    value: function addPanel(location, options) {
      if (options == null) {
        options = {};
      }
      return this.panelContainers[location].addPanel(new Panel(options, this.viewRegistry));
    }

    /*
    Section: Searching and Replacing
    */

    // Public: Performs a search across all files in the workspace.
    //
    // * `regex` {RegExp} to search with.
    // * `options` (optional) {Object}
    //   * `paths` An {Array} of glob patterns to search within.
    //   * `onPathsSearched` (optional) {Function} to be periodically called
    //     with number of paths searched.
    //   * `leadingContextLineCount` {Number} default `0`; The number of lines
    //      before the matched line to include in the results object.
    //   * `trailingContextLineCount` {Number} default `0`; The number of lines
    //      after the matched line to include in the results object.
    // * `iterator` {Function} callback on each file found.
    //
    // Returns a {Promise} with a `cancel()` method that will cancel all
    // of the underlying searches that were started as part of this scan.
  }, {
    key: 'scan',
    value: function scan(regex, options, iterator) {
      var _this9 = this;

      if (options === undefined) options = {};

      if (_.isFunction(options)) {
        iterator = options;
        options = {};
      }

      // Find a searcher for every Directory in the project. Each searcher that is matched
      // will be associated with an Array of Directory objects in the Map.
      var directoriesForSearcher = new Map();
      for (var directory of this.project.getDirectories()) {
        var searcher = this.defaultDirectorySearcher;
        for (var directorySearcher of this.directorySearchers) {
          if (directorySearcher.canSearchDirectory(directory)) {
            searcher = directorySearcher;
            break;
          }
        }
        var directories = directoriesForSearcher.get(searcher);
        if (!directories) {
          directories = [];
          directoriesForSearcher.set(searcher, directories);
        }
        directories.push(directory);
      }

      // Define the onPathsSearched callback.
      var onPathsSearched = undefined;
      if (_.isFunction(options.onPathsSearched)) {
        (function () {
          // Maintain a map of directories to the number of search results. When notified of a new count,
          // replace the entry in the map and update the total.
          var onPathsSearchedOption = options.onPathsSearched;
          var totalNumberOfPathsSearched = 0;
          var numberOfPathsSearchedForSearcher = new Map();
          onPathsSearched = function (searcher, numberOfPathsSearched) {
            var oldValue = numberOfPathsSearchedForSearcher.get(searcher);
            if (oldValue) {
              totalNumberOfPathsSearched -= oldValue;
            }
            numberOfPathsSearchedForSearcher.set(searcher, numberOfPathsSearched);
            totalNumberOfPathsSearched += numberOfPathsSearched;
            return onPathsSearchedOption(totalNumberOfPathsSearched);
          };
        })();
      } else {
        onPathsSearched = function () {};
      }

      // Kick off all of the searches and unify them into one Promise.
      var allSearches = [];
      directoriesForSearcher.forEach(function (directories, searcher) {
        var searchOptions = {
          inclusions: options.paths || [],
          includeHidden: true,
          excludeVcsIgnores: _this9.config.get('core.excludeVcsIgnoredPaths'),
          exclusions: _this9.config.get('core.ignoredNames'),
          follow: _this9.config.get('core.followSymlinks'),
          leadingContextLineCount: options.leadingContextLineCount || 0,
          trailingContextLineCount: options.trailingContextLineCount || 0,
          didMatch: function didMatch(result) {
            if (!_this9.project.isPathModified(result.filePath)) {
              return iterator(result);
            }
          },
          didError: function didError(error) {
            return iterator(null, error);
          },
          didSearchPaths: function didSearchPaths(count) {
            return onPathsSearched(searcher, count);
          }
        };
        var directorySearcher = searcher.search(directories, regex, searchOptions);
        allSearches.push(directorySearcher);
      });
      var searchPromise = Promise.all(allSearches);

      for (var buffer of this.project.getBuffers()) {
        if (buffer.isModified()) {
          var filePath = buffer.getPath();
          if (!this.project.contains(filePath)) {
            continue;
          }
          var matches = [];
          buffer.scan(regex, function (match) {
            return matches.push(match);
          });
          if (matches.length > 0) {
            iterator({ filePath: filePath, matches: matches });
          }
        }
      }

      // Make sure the Promise that is returned to the client is cancelable. To be consistent
      // with the existing behavior, instead of cancel() rejecting the promise, it should
      // resolve it with the special value 'cancelled'. At least the built-in find-and-replace
      // package relies on this behavior.
      var isCancelled = false;
      var cancellablePromise = new Promise(function (resolve, reject) {
        var onSuccess = function onSuccess() {
          if (isCancelled) {
            resolve('cancelled');
          } else {
            resolve(null);
          }
        };

        var onFailure = function onFailure() {
          for (var promise of allSearches) {
            promise.cancel();
          }
          reject();
        };

        searchPromise.then(onSuccess, onFailure);
      });
      cancellablePromise.cancel = function () {
        isCancelled = true;
        // Note that cancelling all of the members of allSearches will cause all of the searches
        // to resolve, which causes searchPromise to resolve, which is ultimately what causes
        // cancellablePromise to resolve.
        allSearches.map(function (promise) {
          return promise.cancel();
        });
      };

      // Although this method claims to return a `Promise`, the `ResultsPaneView.onSearch()`
      // method in the find-and-replace package expects the object returned by this method to have a
      // `done()` method. Include a done() method until find-and-replace can be updated.
      cancellablePromise.done = function (onSuccessOrFailure) {
        cancellablePromise.then(onSuccessOrFailure, onSuccessOrFailure);
      };
      return cancellablePromise;
    }

    // Public: Performs a replace across all the specified files in the project.
    //
    // * `regex` A {RegExp} to search with.
    // * `replacementText` {String} to replace all matches of regex with.
    // * `filePaths` An {Array} of file path strings to run the replace on.
    // * `iterator` A {Function} callback on each file with replacements:
    //   * `options` {Object} with keys `filePath` and `replacements`.
    //
    // Returns a {Promise}.
  }, {
    key: 'replace',
    value: function replace(regex, replacementText, filePaths, iterator) {
      var _this10 = this;

      return new Promise(function (resolve, reject) {
        var buffer = undefined;
        var openPaths = _this10.project.getBuffers().map(function (buffer) {
          return buffer.getPath();
        });
        var outOfProcessPaths = _.difference(filePaths, openPaths);

        var inProcessFinished = !openPaths.length;
        var outOfProcessFinished = !outOfProcessPaths.length;
        var checkFinished = function checkFinished() {
          if (outOfProcessFinished && inProcessFinished) {
            resolve();
          }
        };

        if (!outOfProcessFinished.length) {
          var flags = 'g';
          if (regex.ignoreCase) {
            flags += 'i';
          }

          var task = Task.once(require.resolve('./replace-handler'), outOfProcessPaths, regex.source, flags, replacementText, function () {
            outOfProcessFinished = true;
            checkFinished();
          });

          task.on('replace:path-replaced', iterator);
          task.on('replace:file-error', function (error) {
            iterator(null, error);
          });
        }

        for (buffer of _this10.project.getBuffers()) {
          if (!filePaths.includes(buffer.getPath())) {
            continue;
          }
          var replacements = buffer.replace(regex, replacementText, iterator);
          if (replacements) {
            iterator({ filePath: buffer.getPath(), replacements: replacements });
          }
        }

        inProcessFinished = true;
        checkFinished();
      });
    }
  }, {
    key: 'checkoutHeadRevision',
    value: function checkoutHeadRevision(editor) {
      var _this11 = this;

      if (editor.getPath()) {
        var checkoutHead = function checkoutHead() {
          return _this11.project.repositoryForDirectory(new Directory(editor.getDirectoryPath())).then(function (repository) {
            return repository && repository.checkoutHeadForEditor(editor);
          });
        };

        if (this.config.get('editor.confirmCheckoutHeadRevision')) {
          this.applicationDelegate.confirm({
            message: 'Confirm Checkout HEAD Revision',
            detailedMessage: 'Are you sure you want to discard all changes to "' + editor.getFileName() + '" since the last Git commit?',
            buttons: {
              OK: checkoutHead,
              Cancel: null
            }
          });
        } else {
          return checkoutHead();
        }
      } else {
        return Promise.resolve(false);
      }
    }
  }, {
    key: 'paneContainer',
    get: function get() {
      Grim.deprecate('`atom.workspace.paneContainer` has always been private, but it is now gone. Please use `atom.workspace.getCenter()` instead and consult the workspace API docs for public methods.');
      return this.paneContainers.center.paneContainer;
    }
  }]);

  return Workspace;
})(Model);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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