(function() {
  var AnyConstructor, Disposable, Grim, ViewRegistry, _,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  Grim = require('grim');

  Disposable = require('event-kit').Disposable;

  _ = require('underscore-plus');

  AnyConstructor = Symbol('any-constructor');

  module.exports = ViewRegistry = (function() {
    ViewRegistry.prototype.animationFrameRequest = null;

    ViewRegistry.prototype.documentReadInProgress = false;

    function ViewRegistry(atomEnvironment) {
      this.atomEnvironment = atomEnvironment;
      this.performDocumentUpdate = bind(this.performDocumentUpdate, this);
      this.clear();
    }

    ViewRegistry.prototype.clear = function() {
      this.views = new WeakMap;
      this.providers = [];
      return this.clearDocumentRequests();
    };

    ViewRegistry.prototype.addViewProvider = function(modelConstructor, createView) {
      var provider;
      if (arguments.length === 1) {
        switch (typeof modelConstructor) {
          case 'function':
            provider = {
              createView: modelConstructor,
              modelConstructor: AnyConstructor
            };
            break;
          case 'object':
            Grim.deprecate("atom.views.addViewProvider now takes 2 arguments: a model constructor and a createView function. See docs for details.");
            provider = modelConstructor;
            break;
          default:
            throw new TypeError("Arguments to addViewProvider must be functions");
        }
      } else {
        provider = {
          modelConstructor: modelConstructor,
          createView: createView
        };
      }
      this.providers.push(provider);
      return new Disposable((function(_this) {
        return function() {
          return _this.providers = _this.providers.filter(function(p) {
            return p !== provider;
          });
        };
      })(this));
    };

    ViewRegistry.prototype.getViewProviderCount = function() {
      return this.providers.length;
    };

    ViewRegistry.prototype.getView = function(object) {
      var view;
      if (object == null) {
        return;
      }
      if (view = this.views.get(object)) {
        return view;
      } else {
        view = this.createView(object);
        this.views.set(object, view);
        return view;
      }
    };

    ViewRegistry.prototype.createView = function(object) {
      var element, i, len, provider, ref, ref1, view, viewConstructor;
      if (object instanceof HTMLElement) {
        return object;
      }
      if (typeof (object != null ? object.getElement : void 0) === 'function') {
        element = object.getElement();
        if (element instanceof HTMLElement) {
          return element;
        }
      }
      if ((object != null ? object.element : void 0) instanceof HTMLElement) {
        return object.element;
      }
      if (object != null ? object.jquery : void 0) {
        return object[0];
      }
      ref = this.providers;
      for (i = 0, len = ref.length; i < len; i++) {
        provider = ref[i];
        if (provider.modelConstructor === AnyConstructor) {
          if (element = provider.createView(object, this.atomEnvironment)) {
            return element;
          }
          continue;
        }
        if (object instanceof provider.modelConstructor) {
          if (element = typeof provider.createView === "function" ? provider.createView(object, this.atomEnvironment) : void 0) {
            return element;
          }
          if (viewConstructor = provider.viewConstructor) {
            element = new viewConstructor;
                        if ((ref1 = typeof element.initialize === "function" ? element.initialize(object) : void 0) != null) {
              ref1;
            } else {
              if (typeof element.setModel === "function") {
                element.setModel(object);
              }
            };
            return element;
          }
        }
      }
      if (viewConstructor = object != null ? typeof object.getViewClass === "function" ? object.getViewClass() : void 0 : void 0) {
        view = new viewConstructor(object);
        return view[0];
      }
      throw new Error("Can't create a view for " + object.constructor.name + " instance. Please register a view provider.");
    };

    ViewRegistry.prototype.updateDocument = function(fn) {
      this.documentWriters.push(fn);
      if (!this.documentReadInProgress) {
        this.requestDocumentUpdate();
      }
      return new Disposable((function(_this) {
        return function() {
          return _this.documentWriters = _this.documentWriters.filter(function(writer) {
            return writer !== fn;
          });
        };
      })(this));
    };

    ViewRegistry.prototype.readDocument = function(fn) {
      this.documentReaders.push(fn);
      this.requestDocumentUpdate();
      return new Disposable((function(_this) {
        return function() {
          return _this.documentReaders = _this.documentReaders.filter(function(reader) {
            return reader !== fn;
          });
        };
      })(this));
    };

    ViewRegistry.prototype.getNextUpdatePromise = function() {
      return this.nextUpdatePromise != null ? this.nextUpdatePromise : this.nextUpdatePromise = new Promise((function(_this) {
        return function(resolve) {
          return _this.resolveNextUpdatePromise = resolve;
        };
      })(this));
    };

    ViewRegistry.prototype.clearDocumentRequests = function() {
      this.documentReaders = [];
      this.documentWriters = [];
      this.nextUpdatePromise = null;
      this.resolveNextUpdatePromise = null;
      if (this.animationFrameRequest != null) {
        cancelAnimationFrame(this.animationFrameRequest);
        return this.animationFrameRequest = null;
      }
    };

    ViewRegistry.prototype.requestDocumentUpdate = function() {
      return this.animationFrameRequest != null ? this.animationFrameRequest : this.animationFrameRequest = requestAnimationFrame(this.performDocumentUpdate);
    };

    ViewRegistry.prototype.performDocumentUpdate = function() {
      var reader, resolveNextUpdatePromise, writer;
      resolveNextUpdatePromise = this.resolveNextUpdatePromise;
      this.animationFrameRequest = null;
      this.nextUpdatePromise = null;
      this.resolveNextUpdatePromise = null;
      while (writer = this.documentWriters.shift()) {
        writer();
      }
      this.documentReadInProgress = true;
      while (reader = this.documentReaders.shift()) {
        reader();
      }
      this.documentReadInProgress = false;
      while (writer = this.documentWriters.shift()) {
        writer();
      }
      return typeof resolveNextUpdatePromise === "function" ? resolveNextUpdatePromise() : void 0;
    };

    return ViewRegistry;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
