(function() {
  var CompositeDisposable, Disposable, Tooltip, TooltipManager, _, getKeystroke, humanizeKeystrokes, ref;

  _ = require('underscore-plus');

  ref = require('event-kit'), Disposable = ref.Disposable, CompositeDisposable = ref.CompositeDisposable;

  Tooltip = null;

  module.exports = TooltipManager = (function() {
    TooltipManager.prototype.defaults = {
      trigger: 'hover',
      container: 'body',
      html: true,
      placement: 'auto top',
      viewportPadding: 2
    };

    TooltipManager.prototype.hoverDefaults = {
      delay: {
        show: 1000,
        hide: 100
      }
    };

    function TooltipManager(arg) {
      this.keymapManager = arg.keymapManager, this.viewRegistry = arg.viewRegistry;
      this.tooltips = new Map();
    }

    TooltipManager.prototype.add = function(target, options) {
      var bindings, disposable, element, hideTooltip, i, keyBindingCommand, keyBindingTarget, keystroke, len, tooltip;
      if (target.jquery) {
        disposable = new CompositeDisposable;
        for (i = 0, len = target.length; i < len; i++) {
          element = target[i];
          disposable.add(this.add(element, options));
        }
        return disposable;
      }
      if (Tooltip == null) {
        Tooltip = require('./tooltip');
      }
      keyBindingCommand = options.keyBindingCommand, keyBindingTarget = options.keyBindingTarget;
      if (keyBindingCommand != null) {
        bindings = this.keymapManager.findKeyBindings({
          command: keyBindingCommand,
          target: keyBindingTarget
        });
        keystroke = getKeystroke(bindings);
        if ((options.title != null) && (keystroke != null)) {
          options.title += " " + getKeystroke(bindings);
        } else if (keystroke != null) {
          options.title = getKeystroke(bindings);
        }
      }
      delete options.selector;
      options = _.defaults(options, this.defaults);
      if (options.trigger === 'hover') {
        options = _.defaults(options, this.hoverDefaults);
      }
      tooltip = new Tooltip(target, options, this.viewRegistry);
      if (!this.tooltips.has(target)) {
        this.tooltips.set(target, []);
      }
      this.tooltips.get(target).push(tooltip);
      hideTooltip = function() {
        tooltip.leave({
          currentTarget: target
        });
        return tooltip.hide();
      };
      window.addEventListener('resize', hideTooltip);
      disposable = new Disposable((function(_this) {
        return function() {
          var index, tooltipsForTarget;
          window.removeEventListener('resize', hideTooltip);
          hideTooltip();
          tooltip.destroy();
          if (_this.tooltips.has(target)) {
            tooltipsForTarget = _this.tooltips.get(target);
            index = tooltipsForTarget.indexOf(tooltip);
            if (index !== -1) {
              tooltipsForTarget.splice(index, 1);
            }
            if (tooltipsForTarget.length === 0) {
              return _this.tooltips["delete"](target);
            }
          }
        };
      })(this));
      return disposable;
    };

    TooltipManager.prototype.findTooltips = function(target) {
      if (this.tooltips.has(target)) {
        return this.tooltips.get(target).slice();
      } else {
        return [];
      }
    };

    return TooltipManager;

  })();

  humanizeKeystrokes = function(keystroke) {
    var keystrokes, stroke;
    keystrokes = keystroke.split(' ');
    keystrokes = (function() {
      var i, len, results;
      results = [];
      for (i = 0, len = keystrokes.length; i < len; i++) {
        stroke = keystrokes[i];
        results.push(_.humanizeKeystroke(stroke));
      }
      return results;
    })();
    return keystrokes.join(' ');
  };

  getKeystroke = function(bindings) {
    if (bindings != null ? bindings.length : void 0) {
      return "<span class=\"keystroke\">" + (humanizeKeystrokes(bindings[0].keystrokes)) + "</span>";
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
