Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _eventKit = require('event-kit');

var _textBuffer = require('text-buffer');

var _textEditor = require('./text-editor');

var _textEditor2 = _interopRequireDefault(_textEditor);

var _scopeDescriptor = require('./scope-descriptor');

var _scopeDescriptor2 = _interopRequireDefault(_scopeDescriptor);

var EDITOR_PARAMS_BY_SETTING_KEY = [['core.fileEncoding', 'encoding'], ['editor.atomicSoftTabs', 'atomicSoftTabs'], ['editor.showInvisibles', 'showInvisibles'], ['editor.tabLength', 'tabLength'], ['editor.invisibles', 'invisibles'], ['editor.showCursorOnSelection', 'showCursorOnSelection'], ['editor.showIndentGuide', 'showIndentGuide'], ['editor.showLineNumbers', 'showLineNumbers'], ['editor.softWrap', 'softWrapped'], ['editor.softWrapHangingIndent', 'softWrapHangingIndentLength'], ['editor.softWrapAtPreferredLineLength', 'softWrapAtPreferredLineLength'], ['editor.preferredLineLength', 'preferredLineLength'], ['editor.autoIndent', 'autoIndent'], ['editor.autoIndentOnPaste', 'autoIndentOnPaste'], ['editor.scrollPastEnd', 'scrollPastEnd'], ['editor.undoGroupingInterval', 'undoGroupingInterval'], ['editor.nonWordCharacters', 'nonWordCharacters'], ['editor.scrollSensitivity', 'scrollSensitivity']];

var GRAMMAR_SELECTION_RANGE = (0, _textBuffer.Range)(_textBuffer.Point.ZERO, (0, _textBuffer.Point)(10, 0)).freeze();

// Experimental: This global registry tracks registered `TextEditors`.
//
// If you want to add functionality to a wider set of text editors than just
// those appearing within workspace panes, use `atom.textEditors.observe` to
// invoke a callback for all current and future registered text editors.
//
// If you want packages to be able to add functionality to your non-pane text
// editors (such as a search field in a custom user interface element), register
// them for observation via `atom.textEditors.add`. **Important:** When you're
// done using your editor, be sure to call `dispose` on the returned disposable
// to avoid leaking editors.

var TextEditorRegistry = (function () {
  function TextEditorRegistry(_ref) {
    var config = _ref.config;
    var grammarRegistry = _ref.grammarRegistry;
    var assert = _ref.assert;
    var packageManager = _ref.packageManager;

    _classCallCheck(this, TextEditorRegistry);

    this.assert = assert;
    this.config = config;
    this.grammarRegistry = grammarRegistry;
    this.scopedSettingsDelegate = new ScopedSettingsDelegate(config);
    this.grammarAddedOrUpdated = this.grammarAddedOrUpdated.bind(this);
    this.clear();

    this.initialPackageActivationPromise = new Promise(function (resolve) {
      // TODO: Remove this usage of a private property of PackageManager.
      // Should PackageManager just expose a promise-based API like this?
      if (packageManager.deferredActivationHooks) {
        packageManager.onDidActivateInitialPackages(resolve);
      } else {
        resolve();
      }
    });
  }

  _createClass(TextEditorRegistry, [{
    key: 'deserialize',
    value: function deserialize(state) {
      this.editorGrammarOverrides = state.editorGrammarOverrides;
    }
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        editorGrammarOverrides: Object.assign({}, this.editorGrammarOverrides)
      };
    }
  }, {
    key: 'clear',
    value: function clear() {
      if (this.subscriptions) {
        this.subscriptions.dispose();
      }

      this.subscriptions = new _eventKit.CompositeDisposable();
      this.editors = new Set();
      this.emitter = new _eventKit.Emitter();
      this.scopesWithConfigSubscriptions = new Set();
      this.editorsWithMaintainedConfig = new Set();
      this.editorsWithMaintainedGrammar = new Set();
      this.editorGrammarOverrides = {};
      this.editorGrammarScores = new WeakMap();
      this.subscriptions.add(this.grammarRegistry.onDidAddGrammar(this.grammarAddedOrUpdated), this.grammarRegistry.onDidUpdateGrammar(this.grammarAddedOrUpdated));
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      this.editorsWithMaintainedConfig = null;
    }

    // Register a `TextEditor`.
    //
    // * `editor` The editor to register.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to remove the
    // added editor. To avoid any memory leaks this should be called when the
    // editor is destroyed.
  }, {
    key: 'add',
    value: function add(editor) {
      var _this = this;

      this.editors.add(editor);
      editor.registered = true;
      this.emitter.emit('did-add-editor', editor);

      return new _eventKit.Disposable(function () {
        return _this.remove(editor);
      });
    }
  }, {
    key: 'build',
    value: function build(params) {
      params = Object.assign({ assert: this.assert }, params);

      var scope = null;
      if (params.buffer) {
        var filePath = params.buffer.getPath();
        var headContent = params.buffer.getTextInRange(GRAMMAR_SELECTION_RANGE);
        params.grammar = this.grammarRegistry.selectGrammar(filePath, headContent);
        scope = new _scopeDescriptor2['default']({ scopes: [params.grammar.scopeName] });
      }

      Object.assign(params, this.textEditorParamsForScope(scope));

      return new _textEditor2['default'](params);
    }

    // Remove a `TextEditor`.
    //
    // * `editor` The editor to remove.
    //
    // Returns a {Boolean} indicating whether the editor was successfully removed.
  }, {
    key: 'remove',
    value: function remove(editor) {
      var removed = this.editors['delete'](editor);
      editor.registered = false;
      return removed;
    }

    // Invoke the given callback with all the current and future registered
    // `TextEditors`.
    //
    // * `callback` {Function} to be called with current and future text editors.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'observe',
    value: function observe(callback) {
      this.editors.forEach(callback);
      return this.emitter.on('did-add-editor', callback);
    }

    // Keep a {TextEditor}'s configuration in sync with Atom's settings.
    //
    // * `editor` The editor whose configuration will be maintained.
    //
    // Returns a {Disposable} that can be used to stop updating the editor's
    // configuration.
  }, {
    key: 'maintainConfig',
    value: function maintainConfig(editor) {
      var _this2 = this;

      if (this.editorsWithMaintainedConfig.has(editor)) {
        return new _eventKit.Disposable(noop);
      }
      this.editorsWithMaintainedConfig.add(editor);

      editor.setScopedSettingsDelegate(this.scopedSettingsDelegate);

      this.subscribeToSettingsForEditorScope(editor);
      var grammarChangeSubscription = editor.onDidChangeGrammar(function () {
        _this2.subscribeToSettingsForEditorScope(editor);
      });
      this.subscriptions.add(grammarChangeSubscription);

      var updateTabTypes = function updateTabTypes() {
        var configOptions = { scope: editor.getRootScopeDescriptor() };
        editor.setSoftTabs(shouldEditorUseSoftTabs(editor, _this2.config.get('editor.tabType', configOptions), _this2.config.get('editor.softTabs', configOptions)));
      };

      updateTabTypes();
      var tokenizeSubscription = editor.onDidTokenize(updateTabTypes);
      this.subscriptions.add(tokenizeSubscription);

      return new _eventKit.Disposable(function () {
        _this2.editorsWithMaintainedConfig['delete'](editor);
        editor.setScopedSettingsDelegate(null);
        tokenizeSubscription.dispose();
        grammarChangeSubscription.dispose();
        _this2.subscriptions.remove(grammarChangeSubscription);
        _this2.subscriptions.remove(tokenizeSubscription);
      });
    }

    // Set a {TextEditor}'s grammar based on its path and content, and continue
    // to update its grammar as grammars are added or updated, or the editor's
    // file path changes.
    //
    // * `editor` The editor whose grammar will be maintained.
    //
    // Returns a {Disposable} that can be used to stop updating the editor's
    // grammar.
  }, {
    key: 'maintainGrammar',
    value: function maintainGrammar(editor) {
      var _this3 = this;

      if (this.editorsWithMaintainedGrammar.has(editor)) {
        return new _eventKit.Disposable(noop);
      }

      this.editorsWithMaintainedGrammar.add(editor);

      var buffer = editor.getBuffer();
      for (var existingEditor of this.editorsWithMaintainedGrammar) {
        if (existingEditor.getBuffer() === buffer) {
          var existingOverride = this.editorGrammarOverrides[existingEditor.id];
          if (existingOverride) {
            this.editorGrammarOverrides[editor.id] = existingOverride;
          }
          break;
        }
      }

      this.selectGrammarForEditor(editor);

      var pathChangeSubscription = editor.onDidChangePath(function () {
        _this3.editorGrammarScores['delete'](editor);
        _this3.selectGrammarForEditor(editor);
      });

      this.subscriptions.add(pathChangeSubscription);

      return new _eventKit.Disposable(function () {
        delete _this3.editorGrammarOverrides[editor.id];
        _this3.editorsWithMaintainedGrammar['delete'](editor);
        _this3.subscriptions.remove(pathChangeSubscription);
        pathChangeSubscription.dispose();
      });
    }

    // Force a {TextEditor} to use a different grammar than the one that would
    // otherwise be selected for it.
    //
    // * `editor` The editor whose gramamr will be set.
    // * `scopeName` The {String} root scope name for the desired {Grammar}.
  }, {
    key: 'setGrammarOverride',
    value: function setGrammarOverride(editor, scopeName) {
      this.editorGrammarOverrides[editor.id] = scopeName;
      this.editorGrammarScores['delete'](editor);
      editor.setGrammar(this.grammarRegistry.grammarForScopeName(scopeName));
    }

    // Retrieve the grammar scope name that has been set as a grammar override
    // for the given {TextEditor}.
    //
    // * `editor` The editor.
    //
    // Returns a {String} scope name, or `null` if no override has been set
    // for the given editor.
  }, {
    key: 'getGrammarOverride',
    value: function getGrammarOverride(editor) {
      return this.editorGrammarOverrides[editor.id];
    }

    // Remove any grammar override that has been set for the given {TextEditor}.
    //
    // * `editor` The editor.
  }, {
    key: 'clearGrammarOverride',
    value: function clearGrammarOverride(editor) {
      delete this.editorGrammarOverrides[editor.id];
      this.selectGrammarForEditor(editor);
    }

    // Private

  }, {
    key: 'grammarAddedOrUpdated',
    value: function grammarAddedOrUpdated(grammar) {
      var _this4 = this;

      this.editorsWithMaintainedGrammar.forEach(function (editor) {
        if (grammar.injectionSelector) {
          if (editor.tokenizedBuffer.hasTokenForSelector(grammar.injectionSelector)) {
            editor.tokenizedBuffer.retokenizeLines();
          }
          return;
        }

        var grammarOverride = _this4.editorGrammarOverrides[editor.id];
        if (grammarOverride) {
          if (grammar.scopeName === grammarOverride) {
            editor.setGrammar(grammar);
          }
        } else {
          var score = _this4.grammarRegistry.getGrammarScore(grammar, editor.getPath(), editor.getTextInBufferRange(GRAMMAR_SELECTION_RANGE));

          var currentScore = _this4.editorGrammarScores.get(editor);
          if (currentScore == null || score > currentScore) {
            editor.setGrammar(grammar, score);
            _this4.editorGrammarScores.set(editor, score);
          }
        }
      });
    }
  }, {
    key: 'selectGrammarForEditor',
    value: function selectGrammarForEditor(editor) {
      var grammarOverride = this.editorGrammarOverrides[editor.id];

      if (grammarOverride) {
        var _grammar = this.grammarRegistry.grammarForScopeName(grammarOverride);
        editor.setGrammar(_grammar);
        return;
      }

      var _grammarRegistry$selectGrammarWithScore = this.grammarRegistry.selectGrammarWithScore(editor.getPath(), editor.getTextInBufferRange(GRAMMAR_SELECTION_RANGE));

      var grammar = _grammarRegistry$selectGrammarWithScore.grammar;
      var score = _grammarRegistry$selectGrammarWithScore.score;

      if (!grammar) {
        throw new Error('No grammar found for path: ' + editor.getPath());
      }

      var currentScore = this.editorGrammarScores.get(editor);
      if (currentScore == null || score > currentScore) {
        editor.setGrammar(grammar);
        this.editorGrammarScores.set(editor, score);
      }
    }
  }, {
    key: 'subscribeToSettingsForEditorScope',
    value: _asyncToGenerator(function* (editor) {
      var _this5 = this;

      yield this.initialPackageActivationPromise;

      var scopeDescriptor = editor.getRootScopeDescriptor();
      var scopeChain = scopeDescriptor.getScopeChain();

      editor.update(this.textEditorParamsForScope(scopeDescriptor));

      if (!this.scopesWithConfigSubscriptions.has(scopeChain)) {
        (function () {
          _this5.scopesWithConfigSubscriptions.add(scopeChain);
          var configOptions = { scope: scopeDescriptor };

          var _loop = function (_ref2) {
            _ref22 = _slicedToArray(_ref2, 2);
            var settingKey = _ref22[0];
            var paramName = _ref22[1];

            _this5.subscriptions.add(_this5.config.onDidChange(settingKey, configOptions, function (_ref3) {
              var newValue = _ref3.newValue;

              _this5.editorsWithMaintainedConfig.forEach(function (editor) {
                if (editor.getRootScopeDescriptor().isEqual(scopeDescriptor)) {
                  editor.update(_defineProperty({}, paramName, newValue));
                }
              });
            }));
          };

          for (var _ref2 of EDITOR_PARAMS_BY_SETTING_KEY) {
            var _ref22;

            _loop(_ref2);
          }

          var updateTabTypes = function updateTabTypes() {
            var tabType = _this5.config.get('editor.tabType', configOptions);
            var softTabs = _this5.config.get('editor.softTabs', configOptions);
            _this5.editorsWithMaintainedConfig.forEach(function (editor) {
              if (editor.getRootScopeDescriptor().isEqual(scopeDescriptor)) {
                editor.setSoftTabs(shouldEditorUseSoftTabs(editor, tabType, softTabs));
              }
            });
          };

          _this5.subscriptions.add(_this5.config.onDidChange('editor.tabType', configOptions, updateTabTypes), _this5.config.onDidChange('editor.softTabs', configOptions, updateTabTypes));
        })();
      }
    })
  }, {
    key: 'textEditorParamsForScope',
    value: function textEditorParamsForScope(scopeDescriptor) {
      var result = {};
      var configOptions = { scope: scopeDescriptor };
      for (var _ref43 of EDITOR_PARAMS_BY_SETTING_KEY) {
        var _ref42 = _slicedToArray(_ref43, 2);

        var settingKey = _ref42[0];
        var paramName = _ref42[1];

        result[paramName] = this.config.get(settingKey, configOptions);
      }
      return result;
    }
  }]);

  return TextEditorRegistry;
})();

exports['default'] = TextEditorRegistry;

function shouldEditorUseSoftTabs(editor, tabType, softTabs) {
  switch (tabType) {
    case 'hard':
      return false;
    case 'soft':
      return true;
    case 'auto':
      switch (editor.usesSoftTabs()) {
        case true:
          return true;
        case false:
          return false;
        default:
          return softTabs;
      }
  }
}

function noop() {}

var ScopedSettingsDelegate = (function () {
  function ScopedSettingsDelegate(config) {
    _classCallCheck(this, ScopedSettingsDelegate);

    this.config = config;
  }

  _createClass(ScopedSettingsDelegate, [{
    key: 'getNonWordCharacters',
    value: function getNonWordCharacters(scope) {
      return this.config.get('editor.nonWordCharacters', { scope: scope });
    }
  }, {
    key: 'getIncreaseIndentPattern',
    value: function getIncreaseIndentPattern(scope) {
      return this.config.get('editor.increaseIndentPattern', { scope: scope });
    }
  }, {
    key: 'getDecreaseIndentPattern',
    value: function getDecreaseIndentPattern(scope) {
      return this.config.get('editor.decreaseIndentPattern', { scope: scope });
    }
  }, {
    key: 'getDecreaseNextIndentPattern',
    value: function getDecreaseNextIndentPattern(scope) {
      return this.config.get('editor.decreaseNextIndentPattern', { scope: scope });
    }
  }, {
    key: 'getFoldEndPattern',
    value: function getFoldEndPattern(scope) {
      return this.config.get('editor.foldEndPattern', { scope: scope });
    }
  }, {
    key: 'getCommentStrings',
    value: function getCommentStrings(scope) {
      var commentStartEntries = this.config.getAll('editor.commentStart', { scope: scope });
      var commentEndEntries = this.config.getAll('editor.commentEnd', { scope: scope });
      var commentStartEntry = commentStartEntries[0];
      var commentEndEntry = commentEndEntries.find(function (entry) {
        return entry.scopeSelector === commentStartEntry.scopeSelector;
      });
      return {
        commentStartString: commentStartEntry && commentStartEntry.value,
        commentEndString: commentEndEntry && commentEndEntry.value
      };
    }
  }]);

  return ScopedSettingsDelegate;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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