(function() {
  var ChildProcess, Emitter, Grim, Task, _,
    slice = [].slice;

  _ = require('underscore-plus');

  ChildProcess = require('child_process');

  Emitter = require('event-kit').Emitter;

  Grim = require('grim');

  module.exports = Task = (function() {
    Task.once = function() {
      var args, task, taskPath;
      taskPath = arguments[0], args = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      task = new Task(taskPath);
      task.once('task:completed', function() {
        return task.terminate();
      });
      task.start.apply(task, args);
      return task;
    };

    Task.prototype.callback = null;

    function Task(taskPath) {
      var compileCachePath, env;
      this.emitter = new Emitter;
      compileCachePath = require('./compile-cache').getCacheDirectory();
      taskPath = require.resolve(taskPath);
      env = Object.assign({}, process.env, {
        userAgent: navigator.userAgent
      });
      this.childProcess = ChildProcess.fork(require.resolve('./task-bootstrap'), [compileCachePath, taskPath], {
        env: env,
        silent: true
      });
      this.on("task:log", function() {
        return console.log.apply(console, arguments);
      });
      this.on("task:warn", function() {
        return console.warn.apply(console, arguments);
      });
      this.on("task:error", function() {
        return console.error.apply(console, arguments);
      });
      this.on("task:deprecations", function(deprecations) {
        var deprecation, i, len;
        for (i = 0, len = deprecations.length; i < len; i++) {
          deprecation = deprecations[i];
          Grim.addSerializedDeprecation(deprecation);
        }
      });
      this.on("task:completed", (function(_this) {
        return function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return typeof _this.callback === "function" ? _this.callback.apply(_this, args) : void 0;
        };
      })(this));
      this.handleEvents();
    }

    Task.prototype.handleEvents = function() {
      this.childProcess.removeAllListeners();
      this.childProcess.on('message', (function(_this) {
        return function(arg) {
          var args, event;
          event = arg.event, args = arg.args;
          if (_this.childProcess != null) {
            return _this.emitter.emit(event, args);
          }
        };
      })(this));
      if (this.childProcess.stdout != null) {
        this.childProcess.stdout.removeAllListeners();
        this.childProcess.stdout.on('data', function(data) {
          return console.log(data.toString());
        });
      }
      if (this.childProcess.stderr != null) {
        this.childProcess.stderr.removeAllListeners();
        return this.childProcess.stderr.on('data', function(data) {
          return console.error(data.toString());
        });
      }
    };

    Task.prototype.start = function() {
      var args, callback, i;
      args = 2 <= arguments.length ? slice.call(arguments, 0, i = arguments.length - 1) : (i = 0, []), callback = arguments[i++];
      if (this.childProcess == null) {
        throw new Error('Cannot start terminated process');
      }
      this.handleEvents();
      if (_.isFunction(callback)) {
        this.callback = callback;
      } else {
        args.push(callback);
      }
      this.send({
        event: 'start',
        args: args
      });
      return void 0;
    };

    Task.prototype.send = function(message) {
      if (this.childProcess != null) {
        this.childProcess.send(message);
      } else {
        throw new Error('Cannot send message to terminated process');
      }
      return void 0;
    };

    Task.prototype.on = function(eventName, callback) {
      return this.emitter.on(eventName, function(args) {
        return callback.apply(null, args);
      });
    };

    Task.prototype.once = function(eventName, callback) {
      var disposable;
      return disposable = this.on(eventName, function() {
        var args;
        args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        disposable.dispose();
        return callback.apply(null, args);
      });
    };

    Task.prototype.terminate = function() {
      var ref, ref1;
      if (this.childProcess == null) {
        return false;
      }
      this.childProcess.removeAllListeners();
      if ((ref = this.childProcess.stdout) != null) {
        ref.removeAllListeners();
      }
      if ((ref1 = this.childProcess.stderr) != null) {
        ref1.removeAllListeners();
      }
      this.childProcess.kill();
      this.childProcess = null;
      return true;
    };

    Task.prototype.cancel = function() {
      var didForcefullyTerminate;
      didForcefullyTerminate = this.terminate();
      if (didForcefullyTerminate) {
        this.emitter.emit('task:cancelled');
      }
      return didForcefullyTerminate;
    };

    return Task;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
