(function() {
  var Grim, copyPathToClipboard, ipcRenderer, showCursorScope, stopEventPropagation, stopEventPropagationAndGroupUndo;

  ipcRenderer = require('electron').ipcRenderer;

  Grim = require('grim');

  module.exports = function(arg) {
    var clipboard, commandInstaller, commandRegistry, config, notificationManager, project;
    commandRegistry = arg.commandRegistry, commandInstaller = arg.commandInstaller, config = arg.config, notificationManager = arg.notificationManager, project = arg.project, clipboard = arg.clipboard;
    commandRegistry.add('atom-workspace', {
      'pane:show-next-recently-used-item': function() {
        return this.getModel().getActivePane().activateNextRecentlyUsedItem();
      },
      'pane:show-previous-recently-used-item': function() {
        return this.getModel().getActivePane().activatePreviousRecentlyUsedItem();
      },
      'pane:move-active-item-to-top-of-stack': function() {
        return this.getModel().getActivePane().moveActiveItemToTopOfStack();
      },
      'pane:show-next-item': function() {
        return this.getModel().getActivePane().activateNextItem();
      },
      'pane:show-previous-item': function() {
        return this.getModel().getActivePane().activatePreviousItem();
      },
      'pane:show-item-1': function() {
        return this.getModel().getActivePane().activateItemAtIndex(0);
      },
      'pane:show-item-2': function() {
        return this.getModel().getActivePane().activateItemAtIndex(1);
      },
      'pane:show-item-3': function() {
        return this.getModel().getActivePane().activateItemAtIndex(2);
      },
      'pane:show-item-4': function() {
        return this.getModel().getActivePane().activateItemAtIndex(3);
      },
      'pane:show-item-5': function() {
        return this.getModel().getActivePane().activateItemAtIndex(4);
      },
      'pane:show-item-6': function() {
        return this.getModel().getActivePane().activateItemAtIndex(5);
      },
      'pane:show-item-7': function() {
        return this.getModel().getActivePane().activateItemAtIndex(6);
      },
      'pane:show-item-8': function() {
        return this.getModel().getActivePane().activateItemAtIndex(7);
      },
      'pane:show-item-9': function() {
        return this.getModel().getActivePane().activateLastItem();
      },
      'pane:move-item-right': function() {
        return this.getModel().getActivePane().moveItemRight();
      },
      'pane:move-item-left': function() {
        return this.getModel().getActivePane().moveItemLeft();
      },
      'window:increase-font-size': function() {
        return this.getModel().increaseFontSize();
      },
      'window:decrease-font-size': function() {
        return this.getModel().decreaseFontSize();
      },
      'window:reset-font-size': function() {
        return this.getModel().resetFontSize();
      },
      'application:about': function() {
        return ipcRenderer.send('command', 'application:about');
      },
      'application:show-preferences': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:show-settings': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:quit': function() {
        return ipcRenderer.send('command', 'application:quit');
      },
      'application:hide': function() {
        return ipcRenderer.send('command', 'application:hide');
      },
      'application:hide-other-applications': function() {
        return ipcRenderer.send('command', 'application:hide-other-applications');
      },
      'application:install-update': function() {
        return ipcRenderer.send('command', 'application:install-update');
      },
      'application:unhide-all-applications': function() {
        return ipcRenderer.send('command', 'application:unhide-all-applications');
      },
      'application:new-window': function() {
        return ipcRenderer.send('command', 'application:new-window');
      },
      'application:new-file': function() {
        return ipcRenderer.send('command', 'application:new-file');
      },
      'application:open': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-command', 'application:open', defaultPath);
      },
      'application:open-file': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-command', 'application:open-file', defaultPath);
      },
      'application:open-folder': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-command', 'application:open-folder', defaultPath);
      },
      'application:open-dev': function() {
        return ipcRenderer.send('command', 'application:open-dev');
      },
      'application:open-safe': function() {
        return ipcRenderer.send('command', 'application:open-safe');
      },
      'application:add-project-folder': function() {
        return atom.addProjectFolder();
      },
      'application:minimize': function() {
        return ipcRenderer.send('command', 'application:minimize');
      },
      'application:zoom': function() {
        return ipcRenderer.send('command', 'application:zoom');
      },
      'application:bring-all-windows-to-front': function() {
        return ipcRenderer.send('command', 'application:bring-all-windows-to-front');
      },
      'application:open-your-config': function() {
        return ipcRenderer.send('command', 'application:open-your-config');
      },
      'application:open-your-init-script': function() {
        return ipcRenderer.send('command', 'application:open-your-init-script');
      },
      'application:open-your-keymap': function() {
        return ipcRenderer.send('command', 'application:open-your-keymap');
      },
      'application:open-your-snippets': function() {
        return ipcRenderer.send('command', 'application:open-your-snippets');
      },
      'application:open-your-stylesheet': function() {
        return ipcRenderer.send('command', 'application:open-your-stylesheet');
      },
      'application:open-license': function() {
        return this.getModel().openLicense();
      },
      'window:run-package-specs': function() {
        return this.runPackageSpecs();
      },
      'window:run-benchmarks': function() {
        return this.runBenchmarks();
      },
      'window:toggle-left-dock': function() {
        return this.getModel().getLeftDock().toggle();
      },
      'window:toggle-right-dock': function() {
        return this.getModel().getRightDock().toggle();
      },
      'window:toggle-bottom-dock': function() {
        return this.getModel().getBottomDock().toggle();
      },
      'window:focus-next-pane': function() {
        return this.getModel().activateNextPane();
      },
      'window:focus-previous-pane': function() {
        return this.getModel().activatePreviousPane();
      },
      'window:focus-pane-above': function() {
        return this.focusPaneViewAbove();
      },
      'window:focus-pane-below': function() {
        return this.focusPaneViewBelow();
      },
      'window:focus-pane-on-left': function() {
        return this.focusPaneViewOnLeft();
      },
      'window:focus-pane-on-right': function() {
        return this.focusPaneViewOnRight();
      },
      'window:move-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove();
      },
      'window:move-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow();
      },
      'window:move-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft();
      },
      'window:move-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight();
      },
      'window:copy-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight({
          keepOriginal: true
        });
      },
      'window:save-all': function() {
        return this.getModel().saveAll();
      },
      'window:toggle-invisibles': function() {
        return config.set("editor.showInvisibles", !config.get("editor.showInvisibles"));
      },
      'window:log-deprecation-warnings': function() {
        return Grim.logDeprecations();
      },
      'window:toggle-auto-indent': function() {
        return config.set("editor.autoIndent", !config.get("editor.autoIndent"));
      },
      'pane:reopen-closed-item': function() {
        return this.getModel().reopenItem();
      },
      'core:close': function() {
        return this.getModel().closeActivePaneItemOrEmptyPaneOrWindow();
      },
      'core:save': function() {
        return this.getModel().saveActivePaneItem();
      },
      'core:save-as': function() {
        return this.getModel().saveActivePaneItemAs();
      }
    }, false);
    if (process.platform === 'darwin') {
      commandRegistry.add('atom-workspace', 'window:install-shell-commands', (function() {
        return commandInstaller.installShellCommandsInteractively();
      }), false);
    }
    commandRegistry.add('atom-pane', {
      'pane:save-items': function() {
        return this.getModel().saveItems();
      },
      'pane:split-left': function() {
        return this.getModel().splitLeft();
      },
      'pane:split-right': function() {
        return this.getModel().splitRight();
      },
      'pane:split-up': function() {
        return this.getModel().splitUp();
      },
      'pane:split-down': function() {
        return this.getModel().splitDown();
      },
      'pane:split-left-and-copy-active-item': function() {
        return this.getModel().splitLeft({
          copyActiveItem: true
        });
      },
      'pane:split-right-and-copy-active-item': function() {
        return this.getModel().splitRight({
          copyActiveItem: true
        });
      },
      'pane:split-up-and-copy-active-item': function() {
        return this.getModel().splitUp({
          copyActiveItem: true
        });
      },
      'pane:split-down-and-copy-active-item': function() {
        return this.getModel().splitDown({
          copyActiveItem: true
        });
      },
      'pane:split-left-and-move-active-item': function() {
        return this.getModel().splitLeft({
          moveActiveItem: true
        });
      },
      'pane:split-right-and-move-active-item': function() {
        return this.getModel().splitRight({
          moveActiveItem: true
        });
      },
      'pane:split-up-and-move-active-item': function() {
        return this.getModel().splitUp({
          moveActiveItem: true
        });
      },
      'pane:split-down-and-move-active-item': function() {
        return this.getModel().splitDown({
          moveActiveItem: true
        });
      },
      'pane:close': function() {
        return this.getModel().close();
      },
      'pane:close-other-items': function() {
        return this.getModel().destroyInactiveItems();
      },
      'pane:increase-size': function() {
        return this.getModel().increaseSize();
      },
      'pane:decrease-size': function() {
        return this.getModel().decreaseSize();
      }
    }, false);
    commandRegistry.add('atom-text-editor', stopEventPropagation({
      'core:undo': function() {
        return this.undo();
      },
      'core:redo': function() {
        return this.redo();
      },
      'core:move-left': function() {
        return this.moveLeft();
      },
      'core:move-right': function() {
        return this.moveRight();
      },
      'core:select-left': function() {
        return this.selectLeft();
      },
      'core:select-right': function() {
        return this.selectRight();
      },
      'core:select-up': function() {
        return this.selectUp();
      },
      'core:select-down': function() {
        return this.selectDown();
      },
      'core:select-all': function() {
        return this.selectAll();
      },
      'editor:select-word': function() {
        return this.selectWordsContainingCursors();
      },
      'editor:consolidate-selections': function(event) {
        if (!this.consolidateSelections()) {
          return event.abortKeyBinding();
        }
      },
      'editor:move-to-beginning-of-next-paragraph': function() {
        return this.moveToBeginningOfNextParagraph();
      },
      'editor:move-to-beginning-of-previous-paragraph': function() {
        return this.moveToBeginningOfPreviousParagraph();
      },
      'editor:move-to-beginning-of-screen-line': function() {
        return this.moveToBeginningOfScreenLine();
      },
      'editor:move-to-beginning-of-line': function() {
        return this.moveToBeginningOfLine();
      },
      'editor:move-to-end-of-screen-line': function() {
        return this.moveToEndOfScreenLine();
      },
      'editor:move-to-end-of-line': function() {
        return this.moveToEndOfLine();
      },
      'editor:move-to-first-character-of-line': function() {
        return this.moveToFirstCharacterOfLine();
      },
      'editor:move-to-beginning-of-word': function() {
        return this.moveToBeginningOfWord();
      },
      'editor:move-to-end-of-word': function() {
        return this.moveToEndOfWord();
      },
      'editor:move-to-beginning-of-next-word': function() {
        return this.moveToBeginningOfNextWord();
      },
      'editor:move-to-previous-word-boundary': function() {
        return this.moveToPreviousWordBoundary();
      },
      'editor:move-to-next-word-boundary': function() {
        return this.moveToNextWordBoundary();
      },
      'editor:move-to-previous-subword-boundary': function() {
        return this.moveToPreviousSubwordBoundary();
      },
      'editor:move-to-next-subword-boundary': function() {
        return this.moveToNextSubwordBoundary();
      },
      'editor:select-to-beginning-of-next-paragraph': function() {
        return this.selectToBeginningOfNextParagraph();
      },
      'editor:select-to-beginning-of-previous-paragraph': function() {
        return this.selectToBeginningOfPreviousParagraph();
      },
      'editor:select-to-end-of-line': function() {
        return this.selectToEndOfLine();
      },
      'editor:select-to-beginning-of-line': function() {
        return this.selectToBeginningOfLine();
      },
      'editor:select-to-end-of-word': function() {
        return this.selectToEndOfWord();
      },
      'editor:select-to-beginning-of-word': function() {
        return this.selectToBeginningOfWord();
      },
      'editor:select-to-beginning-of-next-word': function() {
        return this.selectToBeginningOfNextWord();
      },
      'editor:select-to-next-word-boundary': function() {
        return this.selectToNextWordBoundary();
      },
      'editor:select-to-previous-word-boundary': function() {
        return this.selectToPreviousWordBoundary();
      },
      'editor:select-to-next-subword-boundary': function() {
        return this.selectToNextSubwordBoundary();
      },
      'editor:select-to-previous-subword-boundary': function() {
        return this.selectToPreviousSubwordBoundary();
      },
      'editor:select-to-first-character-of-line': function() {
        return this.selectToFirstCharacterOfLine();
      },
      'editor:select-line': function() {
        return this.selectLinesContainingCursors();
      }
    }), false);
    commandRegistry.add('atom-text-editor', stopEventPropagationAndGroupUndo(config, {
      'core:backspace': function() {
        return this.backspace();
      },
      'core:delete': function() {
        return this["delete"]();
      },
      'core:cut': function() {
        return this.cutSelectedText();
      },
      'core:copy': function() {
        return this.copySelectedText();
      },
      'core:paste': function() {
        return this.pasteText();
      },
      'editor:delete-to-previous-word-boundary': function() {
        return this.deleteToPreviousWordBoundary();
      },
      'editor:delete-to-next-word-boundary': function() {
        return this.deleteToNextWordBoundary();
      },
      'editor:delete-to-beginning-of-word': function() {
        return this.deleteToBeginningOfWord();
      },
      'editor:delete-to-beginning-of-line': function() {
        return this.deleteToBeginningOfLine();
      },
      'editor:delete-to-end-of-line': function() {
        return this.deleteToEndOfLine();
      },
      'editor:delete-to-end-of-word': function() {
        return this.deleteToEndOfWord();
      },
      'editor:delete-to-beginning-of-subword': function() {
        return this.deleteToBeginningOfSubword();
      },
      'editor:delete-to-end-of-subword': function() {
        return this.deleteToEndOfSubword();
      },
      'editor:delete-line': function() {
        return this.deleteLine();
      },
      'editor:cut-to-end-of-line': function() {
        return this.cutToEndOfLine();
      },
      'editor:cut-to-end-of-buffer-line': function() {
        return this.cutToEndOfBufferLine();
      },
      'editor:transpose': function() {
        return this.transpose();
      },
      'editor:upper-case': function() {
        return this.upperCase();
      },
      'editor:lower-case': function() {
        return this.lowerCase();
      },
      'editor:copy-selection': function() {
        return this.copyOnlySelectedText();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([mini])', stopEventPropagation({
      'core:move-up': function() {
        return this.moveUp();
      },
      'core:move-down': function() {
        return this.moveDown();
      },
      'core:move-to-top': function() {
        return this.moveToTop();
      },
      'core:move-to-bottom': function() {
        return this.moveToBottom();
      },
      'core:page-up': function() {
        return this.pageUp();
      },
      'core:page-down': function() {
        return this.pageDown();
      },
      'core:select-to-top': function() {
        return this.selectToTop();
      },
      'core:select-to-bottom': function() {
        return this.selectToBottom();
      },
      'core:select-page-up': function() {
        return this.selectPageUp();
      },
      'core:select-page-down': function() {
        return this.selectPageDown();
      },
      'editor:add-selection-below': function() {
        return this.addSelectionBelow();
      },
      'editor:add-selection-above': function() {
        return this.addSelectionAbove();
      },
      'editor:split-selections-into-lines': function() {
        return this.splitSelectionsIntoLines();
      },
      'editor:toggle-soft-tabs': function() {
        return this.toggleSoftTabs();
      },
      'editor:toggle-soft-wrap': function() {
        return this.toggleSoftWrapped();
      },
      'editor:fold-all': function() {
        return this.foldAll();
      },
      'editor:unfold-all': function() {
        return this.unfoldAll();
      },
      'editor:fold-current-row': function() {
        return this.foldCurrentRow();
      },
      'editor:unfold-current-row': function() {
        return this.unfoldCurrentRow();
      },
      'editor:fold-selection': function() {
        return this.foldSelectedLines();
      },
      'editor:fold-at-indent-level-1': function() {
        return this.foldAllAtIndentLevel(0);
      },
      'editor:fold-at-indent-level-2': function() {
        return this.foldAllAtIndentLevel(1);
      },
      'editor:fold-at-indent-level-3': function() {
        return this.foldAllAtIndentLevel(2);
      },
      'editor:fold-at-indent-level-4': function() {
        return this.foldAllAtIndentLevel(3);
      },
      'editor:fold-at-indent-level-5': function() {
        return this.foldAllAtIndentLevel(4);
      },
      'editor:fold-at-indent-level-6': function() {
        return this.foldAllAtIndentLevel(5);
      },
      'editor:fold-at-indent-level-7': function() {
        return this.foldAllAtIndentLevel(6);
      },
      'editor:fold-at-indent-level-8': function() {
        return this.foldAllAtIndentLevel(7);
      },
      'editor:fold-at-indent-level-9': function() {
        return this.foldAllAtIndentLevel(8);
      },
      'editor:log-cursor-scope': function() {
        return showCursorScope(this.getCursorScope(), notificationManager);
      },
      'editor:copy-path': function() {
        return copyPathToClipboard(this, project, clipboard, false);
      },
      'editor:copy-project-path': function() {
        return copyPathToClipboard(this, project, clipboard, true);
      },
      'editor:toggle-indent-guide': function() {
        return config.set('editor.showIndentGuide', !config.get('editor.showIndentGuide'));
      },
      'editor:toggle-line-numbers': function() {
        return config.set('editor.showLineNumbers', !config.get('editor.showLineNumbers'));
      },
      'editor:scroll-to-cursor': function() {
        return this.scrollToCursorPosition();
      }
    }), false);
    return commandRegistry.add('atom-text-editor:not([mini])', stopEventPropagationAndGroupUndo(config, {
      'editor:indent': function() {
        return this.indent();
      },
      'editor:auto-indent': function() {
        return this.autoIndentSelectedRows();
      },
      'editor:indent-selected-rows': function() {
        return this.indentSelectedRows();
      },
      'editor:outdent-selected-rows': function() {
        return this.outdentSelectedRows();
      },
      'editor:newline': function() {
        return this.insertNewline();
      },
      'editor:newline-below': function() {
        return this.insertNewlineBelow();
      },
      'editor:newline-above': function() {
        return this.insertNewlineAbove();
      },
      'editor:toggle-line-comments': function() {
        return this.toggleLineCommentsInSelection();
      },
      'editor:checkout-head-revision': function() {
        return atom.workspace.checkoutHeadRevision(this);
      },
      'editor:move-line-up': function() {
        return this.moveLineUp();
      },
      'editor:move-line-down': function() {
        return this.moveLineDown();
      },
      'editor:move-selection-left': function() {
        return this.moveSelectionLeft();
      },
      'editor:move-selection-right': function() {
        return this.moveSelectionRight();
      },
      'editor:duplicate-lines': function() {
        return this.duplicateLines();
      },
      'editor:join-lines': function() {
        return this.joinLines();
      }
    }), false);
  };

  stopEventPropagation = function(commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        event.stopPropagation();
        return commandListener.call(this.getModel(), event);
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  stopEventPropagationAndGroupUndo = function(config, commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        var model;
        event.stopPropagation();
        model = this.getModel();
        return model.transact(model.getUndoGroupingInterval(), function() {
          return commandListener.call(model, event);
        });
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  showCursorScope = function(descriptor, notificationManager) {
    var content, list;
    list = descriptor.scopes.toString().split(',');
    list = list.map(function(item) {
      return "* " + item;
    });
    content = "Scopes at Cursor\n" + (list.join('\n'));
    return notificationManager.addInfo(content, {
      dismissable: true
    });
  };

  copyPathToClipboard = function(editor, project, clipboard, relative) {
    var filePath;
    if (filePath = editor.getPath()) {
      if (relative) {
        filePath = project.relativize(filePath);
      }
      return clipboard.write(filePath);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
