(function() {
  var CompositeDisposable, Emitter, Grim, Pane, PaneAxis, PaneElement, SaveCancelledError, TextEditor, compact, extend, find, last, nextInstanceId, promisify, ref, ref1,
    extend1 = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Grim = require('grim');

  ref = require('underscore-plus'), find = ref.find, compact = ref.compact, extend = ref.extend, last = ref.last;

  ref1 = require('event-kit'), CompositeDisposable = ref1.CompositeDisposable, Emitter = ref1.Emitter;

  PaneAxis = require('./pane-axis');

  TextEditor = require('./text-editor');

  PaneElement = require('./pane-element');

  nextInstanceId = 1;

  SaveCancelledError = (function(superClass) {
    extend1(SaveCancelledError, superClass);

    function SaveCancelledError() {
      SaveCancelledError.__super__.constructor.apply(this, arguments);
    }

    return SaveCancelledError;

  })(Error);

  module.exports = Pane = (function() {
    Pane.prototype.inspect = function() {
      return "Pane " + this.id;
    };

    Pane.deserialize = function(state, arg) {
      var activeItemIndex, activeItemURI, activeItemUri, applicationDelegate, config, deserializers, items, notifications, views;
      deserializers = arg.deserializers, applicationDelegate = arg.applicationDelegate, config = arg.config, notifications = arg.notifications, views = arg.views;
      items = state.items, activeItemIndex = state.activeItemIndex, activeItemURI = state.activeItemURI, activeItemUri = state.activeItemUri;
      if (activeItemURI == null) {
        activeItemURI = activeItemUri;
      }
      items = items.map(function(itemState) {
        return deserializers.deserialize(itemState);
      });
      state.activeItem = items[activeItemIndex];
      state.items = compact(items);
      if (activeItemURI != null) {
        if (state.activeItem == null) {
          state.activeItem = find(state.items, function(item) {
            var itemURI;
            if (typeof item.getURI === 'function') {
              itemURI = item.getURI();
            }
            return itemURI === activeItemURI;
          });
        }
      }
      return new Pane(extend(state, {
        deserializerManager: deserializers,
        notificationManager: notifications,
        viewRegistry: views,
        config: config,
        applicationDelegate: applicationDelegate
      }));
    };

    function Pane(params) {
      this.saveItemAs = bind(this.saveItemAs, this);
      this.saveItem = bind(this.saveItem, this);
      this.onItemDidTerminatePendingState = bind(this.onItemDidTerminatePendingState, this);
      this.clearPendingItem = bind(this.clearPendingItem, this);
      this.getPendingItem = bind(this.getPendingItem, this);
      this.setPendingItem = bind(this.setPendingItem, this);
      var ref2, ref3, ref4;
      this.id = params.id, this.activeItem = params.activeItem, this.focused = params.focused, this.applicationDelegate = params.applicationDelegate, this.notificationManager = params.notificationManager, this.config = params.config, this.deserializerManager = params.deserializerManager, this.viewRegistry = params.viewRegistry;
      if (this.id != null) {
        nextInstanceId = Math.max(nextInstanceId, this.id + 1);
      } else {
        this.id = nextInstanceId++;
      }
      this.emitter = new Emitter;
      this.alive = true;
      this.subscriptionsPerItem = new WeakMap;
      this.items = [];
      this.itemStack = [];
      this.container = null;
      if (this.activeItem == null) {
        this.activeItem = void 0;
      }
      if (this.focused == null) {
        this.focused = false;
      }
      this.addItems(compact((ref2 = params != null ? params.items : void 0) != null ? ref2 : []));
      if (this.getActiveItem() == null) {
        this.setActiveItem(this.items[0]);
      }
      this.addItemsToStack((ref3 = params != null ? params.itemStackIndices : void 0) != null ? ref3 : []);
      this.setFlexScale((ref4 = params != null ? params.flexScale : void 0) != null ? ref4 : 1);
    }

    Pane.prototype.getElement = function() {
      return this.element != null ? this.element : this.element = new PaneElement().initialize(this, {
        views: this.viewRegistry,
        applicationDelegate: this.applicationDelegate
      });
    };

    Pane.prototype.serialize = function() {
      var activeItemIndex, item, itemStackIndices, itemsToBeSerialized;
      itemsToBeSerialized = compact(this.items.map(function(item) {
        if (typeof item.serialize === 'function') {
          return item;
        }
      }));
      itemStackIndices = (function() {
        var j, len, ref2, results1;
        ref2 = this.itemStack;
        results1 = [];
        for (j = 0, len = ref2.length; j < len; j++) {
          item = ref2[j];
          if (typeof item.serialize === 'function') {
            results1.push(itemsToBeSerialized.indexOf(item));
          }
        }
        return results1;
      }).call(this);
      activeItemIndex = itemsToBeSerialized.indexOf(this.activeItem);
      return {
        deserializer: 'Pane',
        id: this.id,
        items: itemsToBeSerialized.map(function(item) {
          return item.serialize();
        }),
        itemStackIndices: itemStackIndices,
        activeItemIndex: activeItemIndex,
        focused: this.focused,
        flexScale: this.flexScale
      };
    };

    Pane.prototype.getParent = function() {
      return this.parent;
    };

    Pane.prototype.setParent = function(parent) {
      this.parent = parent;
      return this.parent;
    };

    Pane.prototype.getContainer = function() {
      return this.container;
    };

    Pane.prototype.setContainer = function(container) {
      if (container && container !== this.container) {
        this.container = container;
        return container.didAddPane({
          pane: this
        });
      }
    };

    Pane.prototype.isItemAllowed = function(item) {
      if (typeof item.getAllowedLocations !== 'function') {
        return true;
      } else {
        return item.getAllowedLocations().includes(this.getContainer().getLocation());
      }
    };

    Pane.prototype.setFlexScale = function(flexScale) {
      this.flexScale = flexScale;
      this.emitter.emit('did-change-flex-scale', this.flexScale);
      return this.flexScale;
    };

    Pane.prototype.getFlexScale = function() {
      return this.flexScale;
    };

    Pane.prototype.increaseSize = function() {
      return this.setFlexScale(this.getFlexScale() * 1.1);
    };

    Pane.prototype.decreaseSize = function() {
      return this.setFlexScale(this.getFlexScale() / 1.1);
    };


    /*
    Section: Event Subscription
     */

    Pane.prototype.onDidChangeFlexScale = function(callback) {
      return this.emitter.on('did-change-flex-scale', callback);
    };

    Pane.prototype.observeFlexScale = function(callback) {
      callback(this.flexScale);
      return this.onDidChangeFlexScale(callback);
    };

    Pane.prototype.onDidActivate = function(callback) {
      return this.emitter.on('did-activate', callback);
    };

    Pane.prototype.onWillDestroy = function(callback) {
      return this.emitter.on('will-destroy', callback);
    };

    Pane.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    Pane.prototype.onDidChangeActive = function(callback) {
      return this.container.onDidChangeActivePane((function(_this) {
        return function(activePane) {
          return callback(_this === activePane);
        };
      })(this));
    };

    Pane.prototype.observeActive = function(callback) {
      callback(this.isActive());
      return this.onDidChangeActive(callback);
    };

    Pane.prototype.onDidAddItem = function(callback) {
      return this.emitter.on('did-add-item', callback);
    };

    Pane.prototype.onDidRemoveItem = function(callback) {
      return this.emitter.on('did-remove-item', callback);
    };

    Pane.prototype.onWillRemoveItem = function(callback) {
      return this.emitter.on('will-remove-item', callback);
    };

    Pane.prototype.onDidMoveItem = function(callback) {
      return this.emitter.on('did-move-item', callback);
    };

    Pane.prototype.observeItems = function(callback) {
      var item, j, len, ref2;
      ref2 = this.getItems();
      for (j = 0, len = ref2.length; j < len; j++) {
        item = ref2[j];
        callback(item);
      }
      return this.onDidAddItem(function(arg) {
        var item;
        item = arg.item;
        return callback(item);
      });
    };

    Pane.prototype.onDidChangeActiveItem = function(callback) {
      return this.emitter.on('did-change-active-item', callback);
    };

    Pane.prototype.onChooseNextMRUItem = function(callback) {
      return this.emitter.on('choose-next-mru-item', callback);
    };

    Pane.prototype.onChooseLastMRUItem = function(callback) {
      return this.emitter.on('choose-last-mru-item', callback);
    };

    Pane.prototype.onDoneChoosingMRUItem = function(callback) {
      return this.emitter.on('done-choosing-mru-item', callback);
    };

    Pane.prototype.observeActiveItem = function(callback) {
      callback(this.getActiveItem());
      return this.onDidChangeActiveItem(callback);
    };

    Pane.prototype.onWillDestroyItem = function(callback) {
      return this.emitter.on('will-destroy-item', callback);
    };

    Pane.prototype.focus = function() {
      this.focused = true;
      return this.activate();
    };

    Pane.prototype.blur = function() {
      this.focused = false;
      return true;
    };

    Pane.prototype.isFocused = function() {
      return this.focused;
    };

    Pane.prototype.getPanes = function() {
      return [this];
    };

    Pane.prototype.unsubscribeFromItem = function(item) {
      var ref2;
      if ((ref2 = this.subscriptionsPerItem.get(item)) != null) {
        ref2.dispose();
      }
      return this.subscriptionsPerItem["delete"](item);
    };


    /*
    Section: Items
     */

    Pane.prototype.getItems = function() {
      return this.items.slice();
    };

    Pane.prototype.getActiveItem = function() {
      return this.activeItem;
    };

    Pane.prototype.setActiveItem = function(activeItem, options) {
      var modifyStack, ref2;
      if (options != null) {
        modifyStack = options.modifyStack;
      }
      if (activeItem !== this.activeItem) {
        if (modifyStack !== false) {
          this.addItemToStack(activeItem);
        }
        this.activeItem = activeItem;
        this.emitter.emit('did-change-active-item', this.activeItem);
        if ((ref2 = this.container) != null) {
          ref2.didChangeActiveItemOnPane(this, this.activeItem);
        }
      }
      return this.activeItem;
    };

    Pane.prototype.addItemsToStack = function(itemStackIndices) {
      var i, itemIndex, j, len;
      if (this.items.length > 0) {
        if (itemStackIndices.length === 0 || itemStackIndices.length !== this.items.length || itemStackIndices.indexOf(-1) >= 0) {
          itemStackIndices = (function() {
            var j, ref2, results1;
            results1 = [];
            for (i = j = 0, ref2 = this.items.length - 1; 0 <= ref2 ? j <= ref2 : j >= ref2; i = 0 <= ref2 ? ++j : --j) {
              results1.push(i);
            }
            return results1;
          }).call(this);
        }
        for (j = 0, len = itemStackIndices.length; j < len; j++) {
          itemIndex = itemStackIndices[j];
          this.addItemToStack(this.items[itemIndex]);
        }
      }
    };

    Pane.prototype.addItemToStack = function(newItem) {
      var index;
      if (newItem == null) {
        return;
      }
      index = this.itemStack.indexOf(newItem);
      if (index !== -1) {
        this.itemStack.splice(index, 1);
      }
      return this.itemStack.push(newItem);
    };

    Pane.prototype.getActiveEditor = function() {
      if (this.activeItem instanceof TextEditor) {
        return this.activeItem;
      }
    };

    Pane.prototype.itemAtIndex = function(index) {
      return this.items[index];
    };

    Pane.prototype.activateNextRecentlyUsedItem = function() {
      var nextRecentlyUsedItem;
      if (this.items.length > 1) {
        if (this.itemStackIndex == null) {
          this.itemStackIndex = this.itemStack.length - 1;
        }
        if (this.itemStackIndex === 0) {
          this.itemStackIndex = this.itemStack.length;
        }
        this.itemStackIndex = this.itemStackIndex - 1;
        nextRecentlyUsedItem = this.itemStack[this.itemStackIndex];
        this.emitter.emit('choose-next-mru-item', nextRecentlyUsedItem);
        return this.setActiveItem(nextRecentlyUsedItem, {
          modifyStack: false
        });
      }
    };

    Pane.prototype.activatePreviousRecentlyUsedItem = function() {
      var previousRecentlyUsedItem;
      if (this.items.length > 1) {
        if (this.itemStackIndex + 1 === this.itemStack.length || (this.itemStackIndex == null)) {
          this.itemStackIndex = -1;
        }
        this.itemStackIndex = this.itemStackIndex + 1;
        previousRecentlyUsedItem = this.itemStack[this.itemStackIndex];
        this.emitter.emit('choose-last-mru-item', previousRecentlyUsedItem);
        return this.setActiveItem(previousRecentlyUsedItem, {
          modifyStack: false
        });
      }
    };

    Pane.prototype.moveActiveItemToTopOfStack = function() {
      delete this.itemStackIndex;
      this.addItemToStack(this.activeItem);
      return this.emitter.emit('done-choosing-mru-item');
    };

    Pane.prototype.activateNextItem = function() {
      var index;
      index = this.getActiveItemIndex();
      if (index < this.items.length - 1) {
        return this.activateItemAtIndex(index + 1);
      } else {
        return this.activateItemAtIndex(0);
      }
    };

    Pane.prototype.activatePreviousItem = function() {
      var index;
      index = this.getActiveItemIndex();
      if (index > 0) {
        return this.activateItemAtIndex(index - 1);
      } else {
        return this.activateItemAtIndex(this.items.length - 1);
      }
    };

    Pane.prototype.activateLastItem = function() {
      return this.activateItemAtIndex(this.items.length - 1);
    };

    Pane.prototype.moveItemRight = function() {
      var index, rightItemIndex;
      index = this.getActiveItemIndex();
      rightItemIndex = index + 1;
      if (!(rightItemIndex > this.items.length - 1)) {
        return this.moveItem(this.getActiveItem(), rightItemIndex);
      }
    };

    Pane.prototype.moveItemLeft = function() {
      var index, leftItemIndex;
      index = this.getActiveItemIndex();
      leftItemIndex = index - 1;
      if (!(leftItemIndex < 0)) {
        return this.moveItem(this.getActiveItem(), leftItemIndex);
      }
    };

    Pane.prototype.getActiveItemIndex = function() {
      return this.items.indexOf(this.activeItem);
    };

    Pane.prototype.activateItemAtIndex = function(index) {
      var item;
      item = this.itemAtIndex(index) || this.getActiveItem();
      return this.setActiveItem(item);
    };

    Pane.prototype.activateItem = function(item, options) {
      var index;
      if (options == null) {
        options = {};
      }
      if (item != null) {
        if (this.getPendingItem() === this.activeItem) {
          index = this.getActiveItemIndex();
        } else {
          index = this.getActiveItemIndex() + 1;
        }
        this.addItem(item, extend({}, options, {
          index: index
        }));
        return this.setActiveItem(item);
      }
    };

    Pane.prototype.addItem = function(item, options) {
      var index, itemSubscriptions, lastPendingItem, moved, pending, ref2, ref3, ref4, ref5, replacingPendingItem;
      if (options == null) {
        options = {};
      }
      if (typeof options === "number") {
        Grim.deprecate("Pane::addItem(item, " + options + ") is deprecated in favor of Pane::addItem(item, {index: " + options + "})");
        options = {
          index: options
        };
      }
      index = (ref2 = options.index) != null ? ref2 : this.getActiveItemIndex() + 1;
      moved = (ref3 = options.moved) != null ? ref3 : false;
      pending = (ref4 = options.pending) != null ? ref4 : false;
      if (!((item != null) && typeof item === 'object')) {
        throw new Error("Pane items must be objects. Attempted to add item " + item + ".");
      }
      if (typeof item.isDestroyed === "function" ? item.isDestroyed() : void 0) {
        throw new Error("Adding a pane item with URI '" + (typeof item.getURI === "function" ? item.getURI() : void 0) + "' that has already been destroyed");
      }
      if (indexOf.call(this.items, item) >= 0) {
        return;
      }
      if (typeof item.onDidDestroy === 'function') {
        itemSubscriptions = new CompositeDisposable;
        itemSubscriptions.add(item.onDidDestroy((function(_this) {
          return function() {
            return _this.removeItem(item, false);
          };
        })(this)));
        if (typeof item.onDidTerminatePendingState === "function") {
          itemSubscriptions.add(item.onDidTerminatePendingState((function(_this) {
            return function() {
              if (_this.getPendingItem() === item) {
                return _this.clearPendingItem();
              }
            };
          })(this)));
        }
        this.subscriptionsPerItem.set(item, itemSubscriptions);
      }
      this.items.splice(index, 0, item);
      lastPendingItem = this.getPendingItem();
      replacingPendingItem = (lastPendingItem != null) && !moved;
      if (replacingPendingItem) {
        this.pendingItem = null;
      }
      if (pending) {
        this.setPendingItem(item);
      }
      this.emitter.emit('did-add-item', {
        item: item,
        index: index,
        moved: moved
      });
      if (!moved) {
        if ((ref5 = this.container) != null) {
          ref5.didAddPaneItem(item, this, index);
        }
      }
      if (replacingPendingItem) {
        this.destroyItem(lastPendingItem);
      }
      if (this.getActiveItem() == null) {
        this.setActiveItem(item);
      }
      return item;
    };

    Pane.prototype.setPendingItem = function(item) {
      var mostRecentPendingItem;
      if (this.pendingItem !== item) {
        mostRecentPendingItem = this.pendingItem;
        this.pendingItem = item;
        if (mostRecentPendingItem != null) {
          return this.emitter.emit('item-did-terminate-pending-state', mostRecentPendingItem);
        }
      }
    };

    Pane.prototype.getPendingItem = function() {
      return this.pendingItem || null;
    };

    Pane.prototype.clearPendingItem = function() {
      return this.setPendingItem(null);
    };

    Pane.prototype.onItemDidTerminatePendingState = function(callback) {
      return this.emitter.on('item-did-terminate-pending-state', callback);
    };

    Pane.prototype.addItems = function(items, index) {
      var i, item, j, len;
      if (index == null) {
        index = this.getActiveItemIndex() + 1;
      }
      items = items.filter((function(_this) {
        return function(item) {
          return !(indexOf.call(_this.items, item) >= 0);
        };
      })(this));
      for (i = j = 0, len = items.length; j < len; i = ++j) {
        item = items[i];
        this.addItem(item, {
          index: index + i
        });
      }
      return items;
    };

    Pane.prototype.removeItem = function(item, moved) {
      var index, ref2;
      index = this.items.indexOf(item);
      if (index === -1) {
        return;
      }
      if (this.getPendingItem() === item) {
        this.pendingItem = null;
      }
      this.removeItemFromStack(item);
      this.emitter.emit('will-remove-item', {
        item: item,
        index: index,
        destroyed: !moved,
        moved: moved
      });
      this.unsubscribeFromItem(item);
      if (item === this.activeItem) {
        if (this.items.length === 1) {
          this.setActiveItem(void 0);
        } else if (index === 0) {
          this.activateNextItem();
        } else {
          this.activatePreviousItem();
        }
      }
      this.items.splice(index, 1);
      this.emitter.emit('did-remove-item', {
        item: item,
        index: index,
        destroyed: !moved,
        moved: moved
      });
      if (!moved) {
        if ((ref2 = this.container) != null) {
          ref2.didDestroyPaneItem({
            item: item,
            index: index,
            pane: this
          });
        }
      }
      if (this.items.length === 0 && this.config.get('core.destroyEmptyPanes')) {
        return this.destroy();
      }
    };

    Pane.prototype.removeItemFromStack = function(item) {
      var index;
      index = this.itemStack.indexOf(item);
      if (index !== -1) {
        return this.itemStack.splice(index, 1);
      }
    };

    Pane.prototype.moveItem = function(item, newIndex) {
      var oldIndex;
      oldIndex = this.items.indexOf(item);
      this.items.splice(oldIndex, 1);
      this.items.splice(newIndex, 0, item);
      return this.emitter.emit('did-move-item', {
        item: item,
        oldIndex: oldIndex,
        newIndex: newIndex
      });
    };

    Pane.prototype.moveItemToPane = function(item, pane, index) {
      this.removeItem(item, true);
      return pane.addItem(item, {
        index: index,
        moved: true
      });
    };

    Pane.prototype.destroyActiveItem = function() {
      this.destroyItem(this.activeItem);
      return false;
    };

    Pane.prototype.destroyItem = function(item, force) {
      var index, ref2, ref3;
      index = this.items.indexOf(item);
      if (index !== -1) {
        if (!force && ((ref2 = this.getContainer()) != null ? ref2.getLocation() : void 0) !== 'center' && (typeof item.isPermanentDockItem === "function" ? item.isPermanentDockItem() : void 0)) {
          return false;
        }
        this.emitter.emit('will-destroy-item', {
          item: item,
          index: index
        });
        if ((ref3 = this.container) != null) {
          ref3.willDestroyPaneItem({
            item: item,
            index: index,
            pane: this
          });
        }
        if (force || !(item != null ? typeof item.shouldPromptToSave === "function" ? item.shouldPromptToSave() : void 0 : void 0)) {
          this.removeItem(item, false);
          return typeof item.destroy === "function" ? item.destroy() : void 0;
        } else {
          return this.promptToSaveItem(item).then((function(_this) {
            return function(result) {
              if (result) {
                _this.removeItem(item, false);
                if (typeof item.destroy === "function") {
                  item.destroy();
                }
              }
              return result;
            };
          })(this));
        }
      }
    };

    Pane.prototype.destroyItems = function() {
      return Promise.all(this.getItems().map(this.destroyItem.bind(this)));
    };

    Pane.prototype.destroyInactiveItems = function() {
      return Promise.all(this.getItems().filter((function(_this) {
        return function(item) {
          return item !== _this.activeItem;
        };
      })(this)).map(this.destroyItem.bind(this)));
    };

    Pane.prototype.promptToSaveItem = function(item, options) {
      var ref2, saveDialog, saveError, uri;
      if (options == null) {
        options = {};
      }
      if (!(typeof item.shouldPromptToSave === "function" ? item.shouldPromptToSave(options) : void 0)) {
        return Promise.resolve(true);
      }
      if (typeof item.getURI === 'function') {
        uri = item.getURI();
      } else if (typeof item.getUri === 'function') {
        uri = item.getUri();
      } else {
        return Promise.resolve(true);
      }
      saveDialog = (function(_this) {
        return function(saveButtonText, saveFn, message) {
          var chosen;
          chosen = _this.applicationDelegate.confirm({
            message: message,
            detailedMessage: "Your changes will be lost if you close this item without saving.",
            buttons: [saveButtonText, "Cancel", "Don't Save"]
          });
          switch (chosen) {
            case 0:
              return new Promise(function(resolve) {
                return saveFn(item, function(error) {
                  if (error instanceof SaveCancelledError) {
                    return resolve(false);
                  } else {
                    return saveError(error).then(resolve);
                  }
                });
              });
            case 1:
              return Promise.resolve(false);
            case 2:
              return Promise.resolve(true);
          }
        };
      })(this);
      saveError = (function(_this) {
        return function(error) {
          var ref2;
          if (error) {
            return saveDialog("Save as", _this.saveItemAs, "'" + ((ref2 = typeof item.getTitle === "function" ? item.getTitle() : void 0) != null ? ref2 : uri) + "' could not be saved.\nError: " + (_this.getMessageForErrorCode(error.code)));
          } else {
            return Promise.resolve(true);
          }
        };
      })(this);
      return saveDialog("Save", this.saveItem, "'" + ((ref2 = typeof item.getTitle === "function" ? item.getTitle() : void 0) != null ? ref2 : uri) + "' has changes, do you want to save them?");
    };

    Pane.prototype.saveActiveItem = function(nextAction) {
      return this.saveItem(this.getActiveItem(), nextAction);
    };

    Pane.prototype.saveActiveItemAs = function(nextAction) {
      return this.saveItemAs(this.getActiveItem(), nextAction);
    };

    Pane.prototype.saveItem = function(item, nextAction) {
      var itemURI;
      if (typeof (item != null ? item.getURI : void 0) === 'function') {
        itemURI = item.getURI();
      } else if (typeof (item != null ? item.getUri : void 0) === 'function') {
        itemURI = item.getUri();
      }
      if (itemURI != null) {
        if (item.save != null) {
          return promisify(function() {
            return item.save();
          }).then(function() {
            return typeof nextAction === "function" ? nextAction() : void 0;
          })["catch"]((function(_this) {
            return function(error) {
              if (nextAction) {
                return nextAction(error);
              } else {
                return _this.handleSaveError(error, item);
              }
            };
          })(this));
        } else {
          return typeof nextAction === "function" ? nextAction() : void 0;
        }
      } else {
        return this.saveItemAs(item, nextAction);
      }
    };

    Pane.prototype.saveItemAs = function(item, nextAction) {
      var newItemPath, ref2, saveOptions;
      if ((item != null ? item.saveAs : void 0) == null) {
        return;
      }
      saveOptions = (ref2 = typeof item.getSaveDialogOptions === "function" ? item.getSaveDialogOptions() : void 0) != null ? ref2 : {};
      if (saveOptions.defaultPath == null) {
        saveOptions.defaultPath = item.getPath();
      }
      newItemPath = this.applicationDelegate.showSaveDialog(saveOptions);
      if (newItemPath) {
        return promisify(function() {
          return item.saveAs(newItemPath);
        }).then(function() {
          return typeof nextAction === "function" ? nextAction() : void 0;
        })["catch"]((function(_this) {
          return function(error) {
            if (nextAction != null) {
              return nextAction(error);
            } else {
              return _this.handleSaveError(error, item);
            }
          };
        })(this));
      } else if (nextAction != null) {
        return nextAction(new SaveCancelledError('Save Cancelled'));
      }
    };

    Pane.prototype.saveItems = function() {
      var item, j, len, ref2;
      ref2 = this.getItems();
      for (j = 0, len = ref2.length; j < len; j++) {
        item = ref2[j];
        if (typeof item.isModified === "function" ? item.isModified() : void 0) {
          this.saveItem(item);
        }
      }
    };

    Pane.prototype.itemForURI = function(uri) {
      return find(this.items, function(item) {
        var itemUri;
        if (typeof item.getURI === 'function') {
          itemUri = item.getURI();
        } else if (typeof item.getUri === 'function') {
          itemUri = item.getUri();
        }
        return itemUri === uri;
      });
    };

    Pane.prototype.activateItemForURI = function(uri) {
      var item;
      if (item = this.itemForURI(uri)) {
        this.activateItem(item);
        return true;
      } else {
        return false;
      }
    };

    Pane.prototype.copyActiveItem = function() {
      var ref2;
      return (ref2 = this.activeItem) != null ? typeof ref2.copy === "function" ? ref2.copy() : void 0 : void 0;
    };


    /*
    Section: Lifecycle
     */

    Pane.prototype.isActive = function() {
      var ref2;
      return ((ref2 = this.container) != null ? ref2.getActivePane() : void 0) === this;
    };

    Pane.prototype.activate = function() {
      var ref2;
      if (this.isDestroyed()) {
        throw new Error("Pane has been destroyed");
      }
      if ((ref2 = this.container) != null) {
        ref2.didActivatePane(this);
      }
      return this.emitter.emit('did-activate');
    };

    Pane.prototype.destroy = function() {
      var item, j, len, ref2, ref3, ref4, ref5;
      if (((ref2 = this.container) != null ? ref2.isAlive() : void 0) && this.container.getPanes().length === 1) {
        return this.destroyItems();
      } else {
        this.emitter.emit('will-destroy');
        this.alive = false;
        if ((ref3 = this.container) != null) {
          ref3.willDestroyPane({
            pane: this
          });
        }
        if (this.isActive()) {
          this.container.activateNextPane();
        }
        this.emitter.emit('did-destroy');
        this.emitter.dispose();
        ref4 = this.items.slice();
        for (j = 0, len = ref4.length; j < len; j++) {
          item = ref4[j];
          if (typeof item.destroy === "function") {
            item.destroy();
          }
        }
        return (ref5 = this.container) != null ? ref5.didDestroyPane({
          pane: this
        }) : void 0;
      }
    };

    Pane.prototype.isAlive = function() {
      return this.alive;
    };

    Pane.prototype.isDestroyed = function() {
      return !this.isAlive();
    };


    /*
    Section: Splitting
     */

    Pane.prototype.splitLeft = function(params) {
      return this.split('horizontal', 'before', params);
    };

    Pane.prototype.splitRight = function(params) {
      return this.split('horizontal', 'after', params);
    };

    Pane.prototype.splitUp = function(params) {
      return this.split('vertical', 'before', params);
    };

    Pane.prototype.splitDown = function(params) {
      return this.split('vertical', 'after', params);
    };

    Pane.prototype.split = function(orientation, side, params) {
      var newPane;
      if (params != null ? params.copyActiveItem : void 0) {
        if (params.items == null) {
          params.items = [];
        }
        params.items.push(this.copyActiveItem());
      }
      if (this.parent.orientation !== orientation) {
        this.parent.replaceChild(this, new PaneAxis({
          container: this.container,
          orientation: orientation,
          children: [this],
          flexScale: this.flexScale
        }, this.viewRegistry));
        this.setFlexScale(1);
      }
      newPane = new Pane(extend({
        applicationDelegate: this.applicationDelegate,
        notificationManager: this.notificationManager,
        deserializerManager: this.deserializerManager,
        config: this.config,
        viewRegistry: this.viewRegistry
      }, params));
      switch (side) {
        case 'before':
          this.parent.insertChildBefore(this, newPane);
          break;
        case 'after':
          this.parent.insertChildAfter(this, newPane);
      }
      if (params != null ? params.moveActiveItem : void 0) {
        this.moveItemToPane(this.activeItem, newPane);
      }
      newPane.activate();
      return newPane;
    };

    Pane.prototype.findLeftmostSibling = function() {
      var leftmostSibling;
      if (this.parent.orientation === 'horizontal') {
        leftmostSibling = this.parent.children[0];
        if (leftmostSibling instanceof PaneAxis) {
          return this;
        } else {
          return leftmostSibling;
        }
      } else {
        return this;
      }
    };

    Pane.prototype.findRightmostSibling = function() {
      var rightmostSibling;
      if (this.parent.orientation === 'horizontal') {
        rightmostSibling = last(this.parent.children);
        if (rightmostSibling instanceof PaneAxis) {
          return this;
        } else {
          return rightmostSibling;
        }
      } else {
        return this;
      }
    };

    Pane.prototype.findOrCreateRightmostSibling = function() {
      var rightmostSibling;
      rightmostSibling = this.findRightmostSibling();
      if (rightmostSibling === this) {
        return this.splitRight();
      } else {
        return rightmostSibling;
      }
    };

    Pane.prototype.findTopmostSibling = function() {
      var topmostSibling;
      if (this.parent.orientation === 'vertical') {
        topmostSibling = this.parent.children[0];
        if (topmostSibling instanceof PaneAxis) {
          return this;
        } else {
          return topmostSibling;
        }
      } else {
        return this;
      }
    };

    Pane.prototype.findBottommostSibling = function() {
      var bottommostSibling;
      if (this.parent.orientation === 'vertical') {
        bottommostSibling = last(this.parent.children);
        if (bottommostSibling instanceof PaneAxis) {
          return this;
        } else {
          return bottommostSibling;
        }
      } else {
        return this;
      }
    };

    Pane.prototype.findOrCreateBottommostSibling = function() {
      var bottommostSibling;
      bottommostSibling = this.findBottommostSibling();
      if (bottommostSibling === this) {
        return this.splitDown();
      } else {
        return bottommostSibling;
      }
    };

    Pane.prototype.close = function() {
      return Promise.all(this.getItems().map(this.promptToSaveItem.bind(this))).then((function(_this) {
        return function(results) {
          if (!results.includes(false)) {
            return _this.destroy();
          }
        };
      })(this));
    };

    Pane.prototype.handleSaveError = function(error, item) {
      var addWarningWithPath, customMessage, errorMatch, fileName, itemPath, ref2, ref3, ref4;
      itemPath = (ref2 = error.path) != null ? ref2 : item != null ? typeof item.getPath === "function" ? item.getPath() : void 0 : void 0;
      addWarningWithPath = (function(_this) {
        return function(message, options) {
          if (itemPath) {
            message = message + " '" + itemPath + "'";
          }
          return _this.notificationManager.addWarning(message, options);
        };
      })(this);
      customMessage = this.getMessageForErrorCode(error.code);
      if (customMessage != null) {
        return addWarningWithPath("Unable to save file: " + customMessage);
      } else if (error.code === 'EISDIR' || ((ref3 = error.message) != null ? typeof ref3.endsWith === "function" ? ref3.endsWith('is a directory') : void 0 : void 0)) {
        return this.notificationManager.addWarning("Unable to save file: " + error.message);
      } else if ((ref4 = error.code) === 'EPERM' || ref4 === 'EBUSY' || ref4 === 'UNKNOWN' || ref4 === 'EEXIST' || ref4 === 'ELOOP' || ref4 === 'EAGAIN') {
        return addWarningWithPath('Unable to save file', {
          detail: error.message
        });
      } else if (errorMatch = /ENOTDIR, not a directory '([^']+)'/.exec(error.message)) {
        fileName = errorMatch[1];
        return this.notificationManager.addWarning("Unable to save file: A directory in the path '" + fileName + "' could not be written to");
      } else {
        throw error;
      }
    };

    Pane.prototype.getMessageForErrorCode = function(errorCode) {
      switch (errorCode) {
        case 'EACCES':
          return 'Permission denied';
        case 'ECONNRESET':
          return 'Connection reset';
        case 'EINTR':
          return 'Interrupted system call';
        case 'EIO':
          return 'I/O error writing file';
        case 'ENOSPC':
          return 'No space left on device';
        case 'ENOTSUP':
          return 'Operation not supported on socket';
        case 'ENXIO':
          return 'No such device or address';
        case 'EROFS':
          return 'Read-only file system';
        case 'ESPIPE':
          return 'Invalid seek';
        case 'ETIMEDOUT':
          return 'Connection timed out';
      }
    };

    return Pane;

  })();

  promisify = function(callback) {
    var error;
    try {
      return Promise.resolve(callback());
    } catch (error1) {
      error = error1;
      return Promise.reject(error);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
