(function() {
  var Module, Range, cache, isAbsolute, isCorePath, loadDependencies, loadExtensions, loadFolderCompatibility, nativeModules, path, registerBuiltins, resolveFilePath, resolveModulePath, satisfies, semver,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  Module = require('module');

  path = require('path');

  semver = require('semver');

  Range = (function(superClass) {
    extend(Range, superClass);

    function Range() {
      Range.__super__.constructor.apply(this, arguments);
      this.matchedVersions = new Set();
      this.unmatchedVersions = new Set();
    }

    Range.prototype.test = function(version) {
      var matches;
      if (this.matchedVersions.has(version)) {
        return true;
      }
      if (this.unmatchedVersions.has(version)) {
        return false;
      }
      matches = Range.__super__.test.apply(this, arguments);
      if (matches) {
        this.matchedVersions.add(version);
      } else {
        this.unmatchedVersions.add(version);
      }
      return matches;
    };

    return Range;

  })(semver.Range);

  nativeModules = null;

  cache = {
    builtins: {},
    debug: false,
    dependencies: {},
    extensions: {},
    folders: {},
    ranges: {},
    registered: false,
    resourcePath: null,
    resourcePathWithTrailingSlash: null
  };

  if (process.platform === 'win32') {
    isAbsolute = function(pathToCheck) {
      return pathToCheck && (pathToCheck[1] === ':' || (pathToCheck[0] === '\\' && pathToCheck[1] === '\\'));
    };
  } else {
    isAbsolute = function(pathToCheck) {
      return pathToCheck && pathToCheck[0] === '/';
    };
  }

  isCorePath = function(pathToCheck) {
    return pathToCheck.startsWith(cache.resourcePathWithTrailingSlash);
  };

  loadDependencies = function(modulePath, rootPath, rootMetadata, moduleCache) {
    var childMetadata, childMetadataPath, childPath, error, fs, i, len, mainPath, ref, ref1;
    fs = require('fs-plus');
    ref = fs.listSync(path.join(modulePath, 'node_modules'));
    for (i = 0, len = ref.length; i < len; i++) {
      childPath = ref[i];
      if (path.basename(childPath) === '.bin') {
        continue;
      }
      if (rootPath === modulePath && ((ref1 = rootMetadata.packageDependencies) != null ? ref1.hasOwnProperty(path.basename(childPath)) : void 0)) {
        continue;
      }
      childMetadataPath = path.join(childPath, 'package.json');
      if (!fs.isFileSync(childMetadataPath)) {
        continue;
      }
      childMetadata = JSON.parse(fs.readFileSync(childMetadataPath));
      if (childMetadata != null ? childMetadata.version : void 0) {
        try {
          mainPath = require.resolve(childPath);
        } catch (error1) {
          error = error1;
          mainPath = null;
        }
        if (mainPath) {
          moduleCache.dependencies.push({
            name: childMetadata.name,
            version: childMetadata.version,
            path: path.relative(rootPath, mainPath)
          });
        }
        loadDependencies(childPath, rootPath, rootMetadata, moduleCache);
      }
    }
  };

  loadFolderCompatibility = function(modulePath, rootPath, rootMetadata, moduleCache) {
    var childPath, dependencies, error, extensions, fs, i, len, metadataPath, name, onDirectory, onFile, paths, ref, ref1, ref2, ref3, version;
    fs = require('fs-plus');
    metadataPath = path.join(modulePath, 'package.json');
    if (!fs.isFileSync(metadataPath)) {
      return;
    }
    dependencies = (ref = (ref1 = JSON.parse(fs.readFileSync(metadataPath))) != null ? ref1.dependencies : void 0) != null ? ref : {};
    for (name in dependencies) {
      version = dependencies[name];
      try {
        new Range(version);
      } catch (error1) {
        error = error1;
        delete dependencies[name];
      }
    }
    onDirectory = function(childPath) {
      return path.basename(childPath) !== 'node_modules';
    };
    extensions = ['.js', '.coffee', '.json', '.node'];
    paths = {};
    onFile = function(childPath) {
      var ref2, relativePath;
      if (ref2 = path.extname(childPath), indexOf.call(extensions, ref2) >= 0) {
        relativePath = path.relative(rootPath, path.dirname(childPath));
        return paths[relativePath] = true;
      }
    };
    fs.traverseTreeSync(modulePath, onFile, onDirectory);
    paths = Object.keys(paths);
    if (paths.length > 0 && Object.keys(dependencies).length > 0) {
      moduleCache.folders.push({
        paths: paths,
        dependencies: dependencies
      });
    }
    ref2 = fs.listSync(path.join(modulePath, 'node_modules'));
    for (i = 0, len = ref2.length; i < len; i++) {
      childPath = ref2[i];
      if (path.basename(childPath) === '.bin') {
        continue;
      }
      if (rootPath === modulePath && ((ref3 = rootMetadata.packageDependencies) != null ? ref3.hasOwnProperty(path.basename(childPath)) : void 0)) {
        continue;
      }
      loadFolderCompatibility(childPath, rootPath, rootMetadata, moduleCache);
    }
  };

  loadExtensions = function(modulePath, rootPath, rootMetadata, moduleCache) {
    var extensions, fs, nodeModulesPath, onDirectory, onFile;
    fs = require('fs-plus');
    extensions = ['.js', '.coffee', '.json', '.node'];
    nodeModulesPath = path.join(rootPath, 'node_modules');
    onFile = function(filePath) {
      var base, extension, ref, segments;
      filePath = path.relative(rootPath, filePath);
      segments = filePath.split(path.sep);
      if (indexOf.call(segments, 'test') >= 0) {
        return;
      }
      if (indexOf.call(segments, 'tests') >= 0) {
        return;
      }
      if (indexOf.call(segments, 'spec') >= 0) {
        return;
      }
      if (indexOf.call(segments, 'specs') >= 0) {
        return;
      }
      if (segments.length > 1 && !((ref = segments[0]) === 'exports' || ref === 'lib' || ref === 'node_modules' || ref === 'src' || ref === 'static' || ref === 'vendor')) {
        return;
      }
      extension = path.extname(filePath);
      if (indexOf.call(extensions, extension) >= 0) {
        if ((base = moduleCache.extensions)[extension] == null) {
          base[extension] = [];
        }
        return moduleCache.extensions[extension].push(filePath);
      }
    };
    onDirectory = function(childPath) {
      var packageName, parentPath, ref;
      if (rootMetadata.name === 'atom') {
        parentPath = path.dirname(childPath);
        if (parentPath === nodeModulesPath) {
          packageName = path.basename(childPath);
          if ((ref = rootMetadata.packageDependencies) != null ? ref.hasOwnProperty(packageName) : void 0) {
            return false;
          }
        }
      }
      return true;
    };
    fs.traverseTreeSync(rootPath, onFile, onDirectory);
  };

  satisfies = function(version, rawRange) {
    var parsedRange;
    if (!(parsedRange = cache.ranges[rawRange])) {
      parsedRange = new Range(rawRange);
      cache.ranges[rawRange] = parsedRange;
    }
    return parsedRange.test(version);
  };

  resolveFilePath = function(relativePath, parentModule) {
    var extension, paths, ref, ref1, resolvedPath, resolvedPathWithExtension;
    if (!relativePath) {
      return;
    }
    if (!(parentModule != null ? parentModule.filename : void 0)) {
      return;
    }
    if (!(relativePath[0] === '.' || isAbsolute(relativePath))) {
      return;
    }
    resolvedPath = path.resolve(path.dirname(parentModule.filename), relativePath);
    if (!isCorePath(resolvedPath)) {
      return;
    }
    extension = path.extname(resolvedPath);
    if (extension) {
      if ((ref = cache.extensions[extension]) != null ? ref.has(resolvedPath) : void 0) {
        return resolvedPath;
      }
    } else {
      ref1 = cache.extensions;
      for (extension in ref1) {
        paths = ref1[extension];
        resolvedPathWithExtension = "" + resolvedPath + extension;
        if (paths.has(resolvedPathWithExtension)) {
          return resolvedPathWithExtension;
        }
      }
    }
  };

  resolveModulePath = function(relativePath, parentModule) {
    var builtinPath, candidates, folderPath, range, ref, resolvedPath, version;
    if (!relativePath) {
      return;
    }
    if (!(parentModule != null ? parentModule.filename : void 0)) {
      return;
    }
    if (nativeModules == null) {
      nativeModules = process.binding('natives');
    }
    if (nativeModules.hasOwnProperty(relativePath)) {
      return;
    }
    if (relativePath[0] === '.') {
      return;
    }
    if (isAbsolute(relativePath)) {
      return;
    }
    folderPath = path.dirname(parentModule.filename);
    range = (ref = cache.folders[folderPath]) != null ? ref[relativePath] : void 0;
    if (range == null) {
      if (builtinPath = cache.builtins[relativePath]) {
        return builtinPath;
      } else {
        return;
      }
    }
    candidates = cache.dependencies[relativePath];
    if (candidates == null) {
      return;
    }
    for (version in candidates) {
      resolvedPath = candidates[version];
      if (Module._cache.hasOwnProperty(resolvedPath) || isCorePath(resolvedPath)) {
        if (satisfies(version, range)) {
          return resolvedPath;
        }
      }
    }
  };

  registerBuiltins = function(devMode) {
    var atomJsPath, base, builtin, commonBuiltins, commonRoot, electronAsarRoot, fs, i, j, len, len1, rendererBuiltins, rendererRoot, results;
    if (devMode || !cache.resourcePath.startsWith("" + process.resourcesPath + path.sep)) {
      fs = require('fs-plus');
      atomJsPath = path.join(cache.resourcePath, 'exports', 'atom.js');
      if (fs.isFileSync(atomJsPath)) {
        cache.builtins.atom = atomJsPath;
      }
    }
    if ((base = cache.builtins).atom == null) {
      base.atom = path.join(cache.resourcePath, 'exports', 'atom.js');
    }
    electronAsarRoot = path.join(process.resourcesPath, 'electron.asar');
    commonRoot = path.join(electronAsarRoot, 'common', 'api');
    commonBuiltins = ['callbacks-registry', 'clipboard', 'crash-reporter', 'shell'];
    for (i = 0, len = commonBuiltins.length; i < len; i++) {
      builtin = commonBuiltins[i];
      cache.builtins[builtin] = path.join(commonRoot, builtin + ".js");
    }
    rendererRoot = path.join(electronAsarRoot, 'renderer', 'api');
    rendererBuiltins = ['ipc-renderer', 'remote', 'screen'];
    results = [];
    for (j = 0, len1 = rendererBuiltins.length; j < len1; j++) {
      builtin = rendererBuiltins[j];
      results.push(cache.builtins[builtin] = path.join(rendererRoot, builtin + ".js"));
    }
    return results;
  };

  exports.create = function(modulePath) {
    var fs, metadata, metadataPath, moduleCache;
    fs = require('fs-plus');
    modulePath = fs.realpathSync(modulePath);
    metadataPath = path.join(modulePath, 'package.json');
    metadata = JSON.parse(fs.readFileSync(metadataPath));
    moduleCache = {
      version: 1,
      dependencies: [],
      extensions: {},
      folders: []
    };
    loadDependencies(modulePath, modulePath, metadata, moduleCache);
    loadFolderCompatibility(modulePath, modulePath, metadata, moduleCache);
    loadExtensions(modulePath, modulePath, metadata, moduleCache);
    metadata._atomModuleCache = moduleCache;
    fs.writeFileSync(metadataPath, JSON.stringify(metadata, null, 2));
  };

  exports.register = function(arg) {
    var devMode, originalResolveFilename, ref, resourcePath;
    ref = arg != null ? arg : {}, resourcePath = ref.resourcePath, devMode = ref.devMode;
    if (cache.registered) {
      return;
    }
    originalResolveFilename = Module._resolveFilename;
    Module._resolveFilename = function(relativePath, parentModule) {
      var resolvedPath;
      resolvedPath = resolveModulePath(relativePath, parentModule);
      if (resolvedPath == null) {
        resolvedPath = resolveFilePath(relativePath, parentModule);
      }
      return resolvedPath != null ? resolvedPath : originalResolveFilename(relativePath, parentModule);
    };
    cache.registered = true;
    cache.resourcePath = resourcePath;
    cache.resourcePathWithTrailingSlash = "" + resourcePath + path.sep;
    registerBuiltins(devMode);
  };

  exports.add = function(directoryPath, metadata) {
    var base, base1, base2, cacheToAdd, dependency, entry, error, extension, filePath, folderPath, i, j, k, l, len, len1, len2, len3, name1, name2, paths, ref, ref1, ref2, ref3, ref4, ref5;
    if (metadata == null) {
      try {
        metadata = require("" + directoryPath + path.sep + "package.json");
      } catch (error1) {
        error = error1;
        return;
      }
    }
    cacheToAdd = metadata != null ? metadata._atomModuleCache : void 0;
    if (cacheToAdd == null) {
      return;
    }
    ref1 = (ref = cacheToAdd.dependencies) != null ? ref : [];
    for (i = 0, len = ref1.length; i < len; i++) {
      dependency = ref1[i];
      if ((base = cache.dependencies)[name1 = dependency.name] == null) {
        base[name1] = {};
      }
      if ((base1 = cache.dependencies[dependency.name])[name2 = dependency.version] == null) {
        base1[name2] = "" + directoryPath + path.sep + dependency.path;
      }
    }
    ref3 = (ref2 = cacheToAdd.folders) != null ? ref2 : [];
    for (j = 0, len1 = ref3.length; j < len1; j++) {
      entry = ref3[j];
      ref4 = entry.paths;
      for (k = 0, len2 = ref4.length; k < len2; k++) {
        folderPath = ref4[k];
        if (folderPath) {
          cache.folders["" + directoryPath + path.sep + folderPath] = entry.dependencies;
        } else {
          cache.folders[directoryPath] = entry.dependencies;
        }
      }
    }
    ref5 = cacheToAdd.extensions;
    for (extension in ref5) {
      paths = ref5[extension];
      if ((base2 = cache.extensions)[extension] == null) {
        base2[extension] = new Set();
      }
      for (l = 0, len3 = paths.length; l < len3; l++) {
        filePath = paths[l];
        cache.extensions[extension].add("" + directoryPath + path.sep + filePath);
      }
    }
  };

  exports.cache = cache;

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL3NyYy9tb2R1bGUtY2FjaGUuY29mZmVlIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEsTUFBQSxxTUFBQTtJQUFBOzs7O0VBQUEsTUFBQSxHQUFTLE9BQUEsQ0FBUSxRQUFSOztFQUNULElBQUEsR0FBTyxPQUFBLENBQVEsTUFBUjs7RUFDUCxNQUFBLEdBQVMsT0FBQSxDQUFRLFFBQVI7O0VBR0g7OztJQUNTLGVBQUE7TUFDWCx3Q0FBQSxTQUFBO01BQ0EsSUFBQyxDQUFBLGVBQUQsR0FBdUIsSUFBQSxHQUFBLENBQUE7TUFDdkIsSUFBQyxDQUFBLGlCQUFELEdBQXlCLElBQUEsR0FBQSxDQUFBO0lBSGQ7O29CQUtiLElBQUEsR0FBTSxTQUFDLE9BQUQ7QUFDSixVQUFBO01BQUEsSUFBZSxJQUFDLENBQUEsZUFBZSxDQUFDLEdBQWpCLENBQXFCLE9BQXJCLENBQWY7QUFBQSxlQUFPLEtBQVA7O01BQ0EsSUFBZ0IsSUFBQyxDQUFBLGlCQUFpQixDQUFDLEdBQW5CLENBQXVCLE9BQXZCLENBQWhCO0FBQUEsZUFBTyxNQUFQOztNQUVBLE9BQUEsR0FBVSxpQ0FBQSxTQUFBO01BQ1YsSUFBRyxPQUFIO1FBQ0UsSUFBQyxDQUFBLGVBQWUsQ0FBQyxHQUFqQixDQUFxQixPQUFyQixFQURGO09BQUEsTUFBQTtRQUdFLElBQUMsQ0FBQSxpQkFBaUIsQ0FBQyxHQUFuQixDQUF1QixPQUF2QixFQUhGOzthQUlBO0lBVEk7Ozs7S0FOWSxNQUFNLENBQUM7O0VBaUIzQixhQUFBLEdBQWdCOztFQUVoQixLQUFBLEdBQ0U7SUFBQSxRQUFBLEVBQVUsRUFBVjtJQUNBLEtBQUEsRUFBTyxLQURQO0lBRUEsWUFBQSxFQUFjLEVBRmQ7SUFHQSxVQUFBLEVBQVksRUFIWjtJQUlBLE9BQUEsRUFBUyxFQUpUO0lBS0EsTUFBQSxFQUFRLEVBTFI7SUFNQSxVQUFBLEVBQVksS0FOWjtJQU9BLFlBQUEsRUFBYyxJQVBkO0lBUUEsNkJBQUEsRUFBK0IsSUFSL0I7OztFQVlGLElBQUcsT0FBTyxDQUFDLFFBQVIsS0FBb0IsT0FBdkI7SUFDRSxVQUFBLEdBQWEsU0FBQyxXQUFEO2FBQ1gsV0FBQSxJQUFnQixDQUFDLFdBQVksQ0FBQSxDQUFBLENBQVosS0FBa0IsR0FBbEIsSUFBeUIsQ0FBQyxXQUFZLENBQUEsQ0FBQSxDQUFaLEtBQWtCLElBQWxCLElBQTJCLFdBQVksQ0FBQSxDQUFBLENBQVosS0FBa0IsSUFBOUMsQ0FBMUI7SUFETCxFQURmO0dBQUEsTUFBQTtJQUlFLFVBQUEsR0FBYSxTQUFDLFdBQUQ7YUFDWCxXQUFBLElBQWdCLFdBQVksQ0FBQSxDQUFBLENBQVosS0FBa0I7SUFEdkIsRUFKZjs7O0VBT0EsVUFBQSxHQUFhLFNBQUMsV0FBRDtXQUNYLFdBQVcsQ0FBQyxVQUFaLENBQXVCLEtBQUssQ0FBQyw2QkFBN0I7RUFEVzs7RUFHYixnQkFBQSxHQUFtQixTQUFDLFVBQUQsRUFBYSxRQUFiLEVBQXVCLFlBQXZCLEVBQXFDLFdBQXJDO0FBQ2pCLFFBQUE7SUFBQSxFQUFBLEdBQUssT0FBQSxDQUFRLFNBQVI7QUFFTDtBQUFBLFNBQUEscUNBQUE7O01BQ0UsSUFBWSxJQUFJLENBQUMsUUFBTCxDQUFjLFNBQWQsQ0FBQSxLQUE0QixNQUF4QztBQUFBLGlCQUFBOztNQUNBLElBQVksUUFBQSxLQUFZLFVBQVosNkRBQTJELENBQUUsY0FBbEMsQ0FBaUQsSUFBSSxDQUFDLFFBQUwsQ0FBYyxTQUFkLENBQWpELFdBQXZDO0FBQUEsaUJBQUE7O01BRUEsaUJBQUEsR0FBb0IsSUFBSSxDQUFDLElBQUwsQ0FBVSxTQUFWLEVBQXFCLGNBQXJCO01BQ3BCLElBQUEsQ0FBZ0IsRUFBRSxDQUFDLFVBQUgsQ0FBYyxpQkFBZCxDQUFoQjtBQUFBLGlCQUFBOztNQUVBLGFBQUEsR0FBZ0IsSUFBSSxDQUFDLEtBQUwsQ0FBVyxFQUFFLENBQUMsWUFBSCxDQUFnQixpQkFBaEIsQ0FBWDtNQUNoQiw0QkFBRyxhQUFhLENBQUUsZ0JBQWxCO0FBQ0U7VUFDRSxRQUFBLEdBQVcsT0FBTyxDQUFDLE9BQVIsQ0FBZ0IsU0FBaEIsRUFEYjtTQUFBLGNBQUE7VUFFTTtVQUNKLFFBQUEsR0FBVyxLQUhiOztRQUtBLElBQUcsUUFBSDtVQUNFLFdBQVcsQ0FBQyxZQUFZLENBQUMsSUFBekIsQ0FDRTtZQUFBLElBQUEsRUFBTSxhQUFhLENBQUMsSUFBcEI7WUFDQSxPQUFBLEVBQVMsYUFBYSxDQUFDLE9BRHZCO1lBRUEsSUFBQSxFQUFNLElBQUksQ0FBQyxRQUFMLENBQWMsUUFBZCxFQUF3QixRQUF4QixDQUZOO1dBREYsRUFERjs7UUFNQSxnQkFBQSxDQUFpQixTQUFqQixFQUE0QixRQUE1QixFQUFzQyxZQUF0QyxFQUFvRCxXQUFwRCxFQVpGOztBQVJGO0VBSGlCOztFQTJCbkIsdUJBQUEsR0FBMEIsU0FBQyxVQUFELEVBQWEsUUFBYixFQUF1QixZQUF2QixFQUFxQyxXQUFyQztBQUN4QixRQUFBO0lBQUEsRUFBQSxHQUFLLE9BQUEsQ0FBUSxTQUFSO0lBRUwsWUFBQSxHQUFlLElBQUksQ0FBQyxJQUFMLENBQVUsVUFBVixFQUFzQixjQUF0QjtJQUNmLElBQUEsQ0FBYyxFQUFFLENBQUMsVUFBSCxDQUFjLFlBQWQsQ0FBZDtBQUFBLGFBQUE7O0lBRUEsWUFBQSxtSEFBeUU7QUFFekUsU0FBQSxvQkFBQTs7QUFDRTtRQUNNLElBQUEsS0FBQSxDQUFNLE9BQU4sRUFETjtPQUFBLGNBQUE7UUFFTTtRQUNKLE9BQU8sWUFBYSxDQUFBLElBQUEsRUFIdEI7O0FBREY7SUFNQSxXQUFBLEdBQWMsU0FBQyxTQUFEO2FBQ1osSUFBSSxDQUFDLFFBQUwsQ0FBYyxTQUFkLENBQUEsS0FBOEI7SUFEbEI7SUFHZCxVQUFBLEdBQWEsQ0FBQyxLQUFELEVBQVEsU0FBUixFQUFtQixPQUFuQixFQUE0QixPQUE1QjtJQUNiLEtBQUEsR0FBUTtJQUNSLE1BQUEsR0FBUyxTQUFDLFNBQUQ7QUFDUCxVQUFBO01BQUEsV0FBRyxJQUFJLENBQUMsT0FBTCxDQUFhLFNBQWIsQ0FBQSxFQUFBLGFBQTJCLFVBQTNCLEVBQUEsSUFBQSxNQUFIO1FBQ0UsWUFBQSxHQUFlLElBQUksQ0FBQyxRQUFMLENBQWMsUUFBZCxFQUF3QixJQUFJLENBQUMsT0FBTCxDQUFhLFNBQWIsQ0FBeEI7ZUFDZixLQUFNLENBQUEsWUFBQSxDQUFOLEdBQXNCLEtBRnhCOztJQURPO0lBSVQsRUFBRSxDQUFDLGdCQUFILENBQW9CLFVBQXBCLEVBQWdDLE1BQWhDLEVBQXdDLFdBQXhDO0lBRUEsS0FBQSxHQUFRLE1BQU0sQ0FBQyxJQUFQLENBQVksS0FBWjtJQUNSLElBQUcsS0FBSyxDQUFDLE1BQU4sR0FBZSxDQUFmLElBQXFCLE1BQU0sQ0FBQyxJQUFQLENBQVksWUFBWixDQUF5QixDQUFDLE1BQTFCLEdBQW1DLENBQTNEO01BQ0UsV0FBVyxDQUFDLE9BQU8sQ0FBQyxJQUFwQixDQUF5QjtRQUFDLE9BQUEsS0FBRDtRQUFRLGNBQUEsWUFBUjtPQUF6QixFQURGOztBQUdBO0FBQUEsU0FBQSxzQ0FBQTs7TUFDRSxJQUFZLElBQUksQ0FBQyxRQUFMLENBQWMsU0FBZCxDQUFBLEtBQTRCLE1BQXhDO0FBQUEsaUJBQUE7O01BQ0EsSUFBWSxRQUFBLEtBQVksVUFBWiw2REFBMkQsQ0FBRSxjQUFsQyxDQUFpRCxJQUFJLENBQUMsUUFBTCxDQUFjLFNBQWQsQ0FBakQsV0FBdkM7QUFBQSxpQkFBQTs7TUFFQSx1QkFBQSxDQUF3QixTQUF4QixFQUFtQyxRQUFuQyxFQUE2QyxZQUE3QyxFQUEyRCxXQUEzRDtBQUpGO0VBN0J3Qjs7RUFxQzFCLGNBQUEsR0FBaUIsU0FBQyxVQUFELEVBQWEsUUFBYixFQUF1QixZQUF2QixFQUFxQyxXQUFyQztBQUNmLFFBQUE7SUFBQSxFQUFBLEdBQUssT0FBQSxDQUFRLFNBQVI7SUFDTCxVQUFBLEdBQWEsQ0FBQyxLQUFELEVBQVEsU0FBUixFQUFtQixPQUFuQixFQUE0QixPQUE1QjtJQUNiLGVBQUEsR0FBa0IsSUFBSSxDQUFDLElBQUwsQ0FBVSxRQUFWLEVBQW9CLGNBQXBCO0lBRWxCLE1BQUEsR0FBUyxTQUFDLFFBQUQ7QUFDUCxVQUFBO01BQUEsUUFBQSxHQUFXLElBQUksQ0FBQyxRQUFMLENBQWMsUUFBZCxFQUF3QixRQUF4QjtNQUNYLFFBQUEsR0FBVyxRQUFRLENBQUMsS0FBVCxDQUFlLElBQUksQ0FBQyxHQUFwQjtNQUNYLElBQVUsYUFBVSxRQUFWLEVBQUEsTUFBQSxNQUFWO0FBQUEsZUFBQTs7TUFDQSxJQUFVLGFBQVcsUUFBWCxFQUFBLE9BQUEsTUFBVjtBQUFBLGVBQUE7O01BQ0EsSUFBVSxhQUFVLFFBQVYsRUFBQSxNQUFBLE1BQVY7QUFBQSxlQUFBOztNQUNBLElBQVUsYUFBVyxRQUFYLEVBQUEsT0FBQSxNQUFWO0FBQUEsZUFBQTs7TUFDQSxJQUFVLFFBQVEsQ0FBQyxNQUFULEdBQWtCLENBQWxCLElBQXdCLENBQUksUUFBQyxRQUFTLENBQUEsQ0FBQSxFQUFULEtBQWdCLFNBQWhCLElBQUEsR0FBQSxLQUEyQixLQUEzQixJQUFBLEdBQUEsS0FBa0MsY0FBbEMsSUFBQSxHQUFBLEtBQWtELEtBQWxELElBQUEsR0FBQSxLQUF5RCxRQUF6RCxJQUFBLEdBQUEsS0FBbUUsUUFBcEUsQ0FBdEM7QUFBQSxlQUFBOztNQUVBLFNBQUEsR0FBWSxJQUFJLENBQUMsT0FBTCxDQUFhLFFBQWI7TUFDWixJQUFHLGFBQWEsVUFBYixFQUFBLFNBQUEsTUFBSDs7Y0FDeUIsQ0FBQSxTQUFBLElBQWM7O2VBQ3JDLFdBQVcsQ0FBQyxVQUFXLENBQUEsU0FBQSxDQUFVLENBQUMsSUFBbEMsQ0FBdUMsUUFBdkMsRUFGRjs7SUFWTztJQWNULFdBQUEsR0FBYyxTQUFDLFNBQUQ7QUFHWixVQUFBO01BQUEsSUFBRyxZQUFZLENBQUMsSUFBYixLQUFxQixNQUF4QjtRQUNFLFVBQUEsR0FBYSxJQUFJLENBQUMsT0FBTCxDQUFhLFNBQWI7UUFDYixJQUFHLFVBQUEsS0FBYyxlQUFqQjtVQUNFLFdBQUEsR0FBYyxJQUFJLENBQUMsUUFBTCxDQUFjLFNBQWQ7VUFDZCwwREFBZ0QsQ0FBRSxjQUFsQyxDQUFpRCxXQUFqRCxVQUFoQjtBQUFBLG1CQUFPLE1BQVA7V0FGRjtTQUZGOzthQU1BO0lBVFk7SUFXZCxFQUFFLENBQUMsZ0JBQUgsQ0FBb0IsUUFBcEIsRUFBOEIsTUFBOUIsRUFBc0MsV0FBdEM7RUE5QmU7O0VBa0NqQixTQUFBLEdBQVksU0FBQyxPQUFELEVBQVUsUUFBVjtBQUNWLFFBQUE7SUFBQSxJQUFBLENBQU8sQ0FBQSxXQUFBLEdBQWMsS0FBSyxDQUFDLE1BQU8sQ0FBQSxRQUFBLENBQTNCLENBQVA7TUFDRSxXQUFBLEdBQWtCLElBQUEsS0FBQSxDQUFNLFFBQU47TUFDbEIsS0FBSyxDQUFDLE1BQU8sQ0FBQSxRQUFBLENBQWIsR0FBeUIsWUFGM0I7O1dBR0EsV0FBVyxDQUFDLElBQVosQ0FBaUIsT0FBakI7RUFKVTs7RUFNWixlQUFBLEdBQWtCLFNBQUMsWUFBRCxFQUFlLFlBQWY7QUFDaEIsUUFBQTtJQUFBLElBQUEsQ0FBYyxZQUFkO0FBQUEsYUFBQTs7SUFDQSxJQUFBLHlCQUFjLFlBQVksQ0FBRSxrQkFBNUI7QUFBQSxhQUFBOztJQUNBLElBQUEsQ0FBQSxDQUFjLFlBQWEsQ0FBQSxDQUFBLENBQWIsS0FBbUIsR0FBbkIsSUFBMEIsVUFBQSxDQUFXLFlBQVgsQ0FBeEMsQ0FBQTtBQUFBLGFBQUE7O0lBRUEsWUFBQSxHQUFlLElBQUksQ0FBQyxPQUFMLENBQWEsSUFBSSxDQUFDLE9BQUwsQ0FBYSxZQUFZLENBQUMsUUFBMUIsQ0FBYixFQUFrRCxZQUFsRDtJQUNmLElBQUEsQ0FBYyxVQUFBLENBQVcsWUFBWCxDQUFkO0FBQUEsYUFBQTs7SUFFQSxTQUFBLEdBQVksSUFBSSxDQUFDLE9BQUwsQ0FBYSxZQUFiO0lBQ1osSUFBRyxTQUFIO01BQ0UscURBQWtELENBQUUsR0FBN0IsQ0FBaUMsWUFBakMsVUFBdkI7QUFBQSxlQUFPLGFBQVA7T0FERjtLQUFBLE1BQUE7QUFHRTtBQUFBLFdBQUEsaUJBQUE7O1FBQ0UseUJBQUEsR0FBNEIsRUFBQSxHQUFHLFlBQUgsR0FBa0I7UUFDOUMsSUFBb0MsS0FBSyxDQUFDLEdBQU4sQ0FBVSx5QkFBVixDQUFwQztBQUFBLGlCQUFPLDBCQUFQOztBQUZGLE9BSEY7O0VBVGdCOztFQWtCbEIsaUJBQUEsR0FBb0IsU0FBQyxZQUFELEVBQWUsWUFBZjtBQUNsQixRQUFBO0lBQUEsSUFBQSxDQUFjLFlBQWQ7QUFBQSxhQUFBOztJQUNBLElBQUEseUJBQWMsWUFBWSxDQUFFLGtCQUE1QjtBQUFBLGFBQUE7OztNQUVBLGdCQUFpQixPQUFPLENBQUMsT0FBUixDQUFnQixTQUFoQjs7SUFDakIsSUFBVSxhQUFhLENBQUMsY0FBZCxDQUE2QixZQUE3QixDQUFWO0FBQUEsYUFBQTs7SUFDQSxJQUFVLFlBQWEsQ0FBQSxDQUFBLENBQWIsS0FBbUIsR0FBN0I7QUFBQSxhQUFBOztJQUNBLElBQVUsVUFBQSxDQUFXLFlBQVgsQ0FBVjtBQUFBLGFBQUE7O0lBRUEsVUFBQSxHQUFhLElBQUksQ0FBQyxPQUFMLENBQWEsWUFBWSxDQUFDLFFBQTFCO0lBRWIsS0FBQSxrREFBbUMsQ0FBQSxZQUFBO0lBQ25DLElBQU8sYUFBUDtNQUNFLElBQUcsV0FBQSxHQUFjLEtBQUssQ0FBQyxRQUFTLENBQUEsWUFBQSxDQUFoQztBQUNFLGVBQU8sWUFEVDtPQUFBLE1BQUE7QUFHRSxlQUhGO09BREY7O0lBTUEsVUFBQSxHQUFhLEtBQUssQ0FBQyxZQUFhLENBQUEsWUFBQTtJQUNoQyxJQUFjLGtCQUFkO0FBQUEsYUFBQTs7QUFFQSxTQUFBLHFCQUFBOztNQUNFLElBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQyxjQUFkLENBQTZCLFlBQTdCLENBQUEsSUFBOEMsVUFBQSxDQUFXLFlBQVgsQ0FBakQ7UUFDRSxJQUF1QixTQUFBLENBQVUsT0FBVixFQUFtQixLQUFuQixDQUF2QjtBQUFBLGlCQUFPLGFBQVA7U0FERjs7QUFERjtFQXJCa0I7O0VBMkJwQixnQkFBQSxHQUFtQixTQUFDLE9BQUQ7QUFDakIsUUFBQTtJQUFBLElBQUcsT0FBQSxJQUFXLENBQUksS0FBSyxDQUFDLFlBQVksQ0FBQyxVQUFuQixDQUE4QixFQUFBLEdBQUcsT0FBTyxDQUFDLGFBQVgsR0FBMkIsSUFBSSxDQUFDLEdBQTlELENBQWxCO01BQ0UsRUFBQSxHQUFLLE9BQUEsQ0FBUSxTQUFSO01BQ0wsVUFBQSxHQUFhLElBQUksQ0FBQyxJQUFMLENBQVUsS0FBSyxDQUFDLFlBQWhCLEVBQThCLFNBQTlCLEVBQXlDLFNBQXpDO01BQ2IsSUFBb0MsRUFBRSxDQUFDLFVBQUgsQ0FBYyxVQUFkLENBQXBDO1FBQUEsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFmLEdBQXNCLFdBQXRCO09BSEY7OztVQUljLENBQUMsT0FBUSxJQUFJLENBQUMsSUFBTCxDQUFVLEtBQUssQ0FBQyxZQUFoQixFQUE4QixTQUE5QixFQUF5QyxTQUF6Qzs7SUFFdkIsZ0JBQUEsR0FBbUIsSUFBSSxDQUFDLElBQUwsQ0FBVSxPQUFPLENBQUMsYUFBbEIsRUFBaUMsZUFBakM7SUFFbkIsVUFBQSxHQUFhLElBQUksQ0FBQyxJQUFMLENBQVUsZ0JBQVYsRUFBNEIsUUFBNUIsRUFBc0MsS0FBdEM7SUFDYixjQUFBLEdBQWlCLENBQUMsb0JBQUQsRUFBdUIsV0FBdkIsRUFBb0MsZ0JBQXBDLEVBQXNELE9BQXREO0FBQ2pCLFNBQUEsZ0RBQUE7O01BQ0UsS0FBSyxDQUFDLFFBQVMsQ0FBQSxPQUFBLENBQWYsR0FBMEIsSUFBSSxDQUFDLElBQUwsQ0FBVSxVQUFWLEVBQXlCLE9BQUQsR0FBUyxLQUFqQztBQUQ1QjtJQUdBLFlBQUEsR0FBZSxJQUFJLENBQUMsSUFBTCxDQUFVLGdCQUFWLEVBQTRCLFVBQTVCLEVBQXdDLEtBQXhDO0lBQ2YsZ0JBQUEsR0FBbUIsQ0FBQyxjQUFELEVBQWlCLFFBQWpCLEVBQTJCLFFBQTNCO0FBQ25CO1NBQUEsb0RBQUE7O21CQUNFLEtBQUssQ0FBQyxRQUFTLENBQUEsT0FBQSxDQUFmLEdBQTBCLElBQUksQ0FBQyxJQUFMLENBQVUsWUFBVixFQUEyQixPQUFELEdBQVMsS0FBbkM7QUFENUI7O0VBaEJpQjs7RUFtQm5CLE9BQU8sQ0FBQyxNQUFSLEdBQWlCLFNBQUMsVUFBRDtBQUNmLFFBQUE7SUFBQSxFQUFBLEdBQUssT0FBQSxDQUFRLFNBQVI7SUFFTCxVQUFBLEdBQWEsRUFBRSxDQUFDLFlBQUgsQ0FBZ0IsVUFBaEI7SUFDYixZQUFBLEdBQWUsSUFBSSxDQUFDLElBQUwsQ0FBVSxVQUFWLEVBQXNCLGNBQXRCO0lBQ2YsUUFBQSxHQUFXLElBQUksQ0FBQyxLQUFMLENBQVcsRUFBRSxDQUFDLFlBQUgsQ0FBZ0IsWUFBaEIsQ0FBWDtJQUVYLFdBQUEsR0FDRTtNQUFBLE9BQUEsRUFBUyxDQUFUO01BQ0EsWUFBQSxFQUFjLEVBRGQ7TUFFQSxVQUFBLEVBQVksRUFGWjtNQUdBLE9BQUEsRUFBUyxFQUhUOztJQUtGLGdCQUFBLENBQWlCLFVBQWpCLEVBQTZCLFVBQTdCLEVBQXlDLFFBQXpDLEVBQW1ELFdBQW5EO0lBQ0EsdUJBQUEsQ0FBd0IsVUFBeEIsRUFBb0MsVUFBcEMsRUFBZ0QsUUFBaEQsRUFBMEQsV0FBMUQ7SUFDQSxjQUFBLENBQWUsVUFBZixFQUEyQixVQUEzQixFQUF1QyxRQUF2QyxFQUFpRCxXQUFqRDtJQUVBLFFBQVEsQ0FBQyxnQkFBVCxHQUE0QjtJQUM1QixFQUFFLENBQUMsYUFBSCxDQUFpQixZQUFqQixFQUErQixJQUFJLENBQUMsU0FBTCxDQUFlLFFBQWYsRUFBeUIsSUFBekIsRUFBK0IsQ0FBL0IsQ0FBL0I7RUFsQmU7O0VBc0JqQixPQUFPLENBQUMsUUFBUixHQUFtQixTQUFDLEdBQUQ7QUFDakIsUUFBQTt3QkFEa0IsTUFBd0IsSUFBdkIsaUNBQWM7SUFDakMsSUFBVSxLQUFLLENBQUMsVUFBaEI7QUFBQSxhQUFBOztJQUVBLHVCQUFBLEdBQTBCLE1BQU0sQ0FBQztJQUNqQyxNQUFNLENBQUMsZ0JBQVAsR0FBMEIsU0FBQyxZQUFELEVBQWUsWUFBZjtBQUN4QixVQUFBO01BQUEsWUFBQSxHQUFlLGlCQUFBLENBQWtCLFlBQWxCLEVBQWdDLFlBQWhDOztRQUNmLGVBQWdCLGVBQUEsQ0FBZ0IsWUFBaEIsRUFBOEIsWUFBOUI7O29DQUNoQixlQUFlLHVCQUFBLENBQXdCLFlBQXhCLEVBQXNDLFlBQXRDO0lBSFM7SUFLMUIsS0FBSyxDQUFDLFVBQU4sR0FBbUI7SUFDbkIsS0FBSyxDQUFDLFlBQU4sR0FBcUI7SUFDckIsS0FBSyxDQUFDLDZCQUFOLEdBQXNDLEVBQUEsR0FBRyxZQUFILEdBQWtCLElBQUksQ0FBQztJQUM3RCxnQkFBQSxDQUFpQixPQUFqQjtFQVppQjs7RUFnQm5CLE9BQU8sQ0FBQyxHQUFSLEdBQWMsU0FBQyxhQUFELEVBQWdCLFFBQWhCO0FBSVosUUFBQTtJQUFBLElBQU8sZ0JBQVA7QUFDRTtRQUNFLFFBQUEsR0FBVyxPQUFBLENBQVEsRUFBQSxHQUFHLGFBQUgsR0FBbUIsSUFBSSxDQUFDLEdBQXhCLEdBQTRCLGNBQXBDLEVBRGI7T0FBQSxjQUFBO1FBRU07QUFDSixlQUhGO09BREY7O0lBTUEsVUFBQSxzQkFBYSxRQUFRLENBQUU7SUFDdkIsSUFBYyxrQkFBZDtBQUFBLGFBQUE7O0FBRUE7QUFBQSxTQUFBLHNDQUFBOzs7c0JBQ3lDOzs7dUJBQ29CLEVBQUEsR0FBRyxhQUFILEdBQW1CLElBQUksQ0FBQyxHQUF4QixHQUE4QixVQUFVLENBQUM7O0FBRnRHO0FBSUE7QUFBQSxTQUFBLHdDQUFBOztBQUNFO0FBQUEsV0FBQSx3Q0FBQTs7UUFDRSxJQUFHLFVBQUg7VUFDRSxLQUFLLENBQUMsT0FBUSxDQUFBLEVBQUEsR0FBRyxhQUFILEdBQW1CLElBQUksQ0FBQyxHQUF4QixHQUE4QixVQUE5QixDQUFkLEdBQTRELEtBQUssQ0FBQyxhQURwRTtTQUFBLE1BQUE7VUFHRSxLQUFLLENBQUMsT0FBUSxDQUFBLGFBQUEsQ0FBZCxHQUErQixLQUFLLENBQUMsYUFIdkM7O0FBREY7QUFERjtBQU9BO0FBQUEsU0FBQSxpQkFBQTs7O2FBQ21CLENBQUEsU0FBQSxJQUFrQixJQUFBLEdBQUEsQ0FBQTs7QUFDbkMsV0FBQSx5Q0FBQTs7UUFDRSxLQUFLLENBQUMsVUFBVyxDQUFBLFNBQUEsQ0FBVSxDQUFDLEdBQTVCLENBQWdDLEVBQUEsR0FBRyxhQUFILEdBQW1CLElBQUksQ0FBQyxHQUF4QixHQUE4QixRQUE5RDtBQURGO0FBRkY7RUF4Qlk7O0VBK0JkLE9BQU8sQ0FBQyxLQUFSLEdBQWdCO0FBNVJoQiIsInNvdXJjZXNDb250ZW50IjpbIk1vZHVsZSA9IHJlcXVpcmUgJ21vZHVsZSdcbnBhdGggPSByZXF1aXJlICdwYXRoJ1xuc2VtdmVyID0gcmVxdWlyZSAnc2VtdmVyJ1xuXG4jIEV4dGVuZCBzZW12ZXIuUmFuZ2UgdG8gbWVtb2l6ZSBtYXRjaGVkIHZlcnNpb25zIGZvciBzcGVlZFxuY2xhc3MgUmFuZ2UgZXh0ZW5kcyBzZW12ZXIuUmFuZ2VcbiAgY29uc3RydWN0b3I6IC0+XG4gICAgc3VwZXJcbiAgICBAbWF0Y2hlZFZlcnNpb25zID0gbmV3IFNldCgpXG4gICAgQHVubWF0Y2hlZFZlcnNpb25zID0gbmV3IFNldCgpXG5cbiAgdGVzdDogKHZlcnNpb24pIC0+XG4gICAgcmV0dXJuIHRydWUgaWYgQG1hdGNoZWRWZXJzaW9ucy5oYXModmVyc2lvbilcbiAgICByZXR1cm4gZmFsc2UgaWYgQHVubWF0Y2hlZFZlcnNpb25zLmhhcyh2ZXJzaW9uKVxuXG4gICAgbWF0Y2hlcyA9IHN1cGVyXG4gICAgaWYgbWF0Y2hlc1xuICAgICAgQG1hdGNoZWRWZXJzaW9ucy5hZGQodmVyc2lvbilcbiAgICBlbHNlXG4gICAgICBAdW5tYXRjaGVkVmVyc2lvbnMuYWRkKHZlcnNpb24pXG4gICAgbWF0Y2hlc1xuXG5uYXRpdmVNb2R1bGVzID0gbnVsbFxuXG5jYWNoZSA9XG4gIGJ1aWx0aW5zOiB7fVxuICBkZWJ1ZzogZmFsc2VcbiAgZGVwZW5kZW5jaWVzOiB7fVxuICBleHRlbnNpb25zOiB7fVxuICBmb2xkZXJzOiB7fVxuICByYW5nZXM6IHt9XG4gIHJlZ2lzdGVyZWQ6IGZhbHNlXG4gIHJlc291cmNlUGF0aDogbnVsbFxuICByZXNvdXJjZVBhdGhXaXRoVHJhaWxpbmdTbGFzaDogbnVsbFxuXG4jIGlzQWJzb2x1dGUgaXMgaW5saW5lZCBmcm9tIGZzLXBsdXMgc28gdGhhdCBmcy1wbHVzIGl0c2VsZiBjYW4gYmUgcmVxdWlyZWRcbiMgZnJvbSB0aGlzIGNhY2hlLlxuaWYgcHJvY2Vzcy5wbGF0Zm9ybSBpcyAnd2luMzInXG4gIGlzQWJzb2x1dGUgPSAocGF0aFRvQ2hlY2spIC0+XG4gICAgcGF0aFRvQ2hlY2sgYW5kIChwYXRoVG9DaGVja1sxXSBpcyAnOicgb3IgKHBhdGhUb0NoZWNrWzBdIGlzICdcXFxcJyBhbmQgcGF0aFRvQ2hlY2tbMV0gaXMgJ1xcXFwnKSlcbmVsc2VcbiAgaXNBYnNvbHV0ZSA9IChwYXRoVG9DaGVjaykgLT5cbiAgICBwYXRoVG9DaGVjayBhbmQgcGF0aFRvQ2hlY2tbMF0gaXMgJy8nXG5cbmlzQ29yZVBhdGggPSAocGF0aFRvQ2hlY2spIC0+XG4gIHBhdGhUb0NoZWNrLnN0YXJ0c1dpdGgoY2FjaGUucmVzb3VyY2VQYXRoV2l0aFRyYWlsaW5nU2xhc2gpXG5cbmxvYWREZXBlbmRlbmNpZXMgPSAobW9kdWxlUGF0aCwgcm9vdFBhdGgsIHJvb3RNZXRhZGF0YSwgbW9kdWxlQ2FjaGUpIC0+XG4gIGZzID0gcmVxdWlyZSAnZnMtcGx1cydcblxuICBmb3IgY2hpbGRQYXRoIGluIGZzLmxpc3RTeW5jKHBhdGguam9pbihtb2R1bGVQYXRoLCAnbm9kZV9tb2R1bGVzJykpXG4gICAgY29udGludWUgaWYgcGF0aC5iYXNlbmFtZShjaGlsZFBhdGgpIGlzICcuYmluJ1xuICAgIGNvbnRpbnVlIGlmIHJvb3RQYXRoIGlzIG1vZHVsZVBhdGggYW5kIHJvb3RNZXRhZGF0YS5wYWNrYWdlRGVwZW5kZW5jaWVzPy5oYXNPd25Qcm9wZXJ0eShwYXRoLmJhc2VuYW1lKGNoaWxkUGF0aCkpXG5cbiAgICBjaGlsZE1ldGFkYXRhUGF0aCA9IHBhdGguam9pbihjaGlsZFBhdGgsICdwYWNrYWdlLmpzb24nKVxuICAgIGNvbnRpbnVlIHVubGVzcyBmcy5pc0ZpbGVTeW5jKGNoaWxkTWV0YWRhdGFQYXRoKVxuXG4gICAgY2hpbGRNZXRhZGF0YSA9IEpTT04ucGFyc2UoZnMucmVhZEZpbGVTeW5jKGNoaWxkTWV0YWRhdGFQYXRoKSlcbiAgICBpZiBjaGlsZE1ldGFkYXRhPy52ZXJzaW9uXG4gICAgICB0cnlcbiAgICAgICAgbWFpblBhdGggPSByZXF1aXJlLnJlc29sdmUoY2hpbGRQYXRoKVxuICAgICAgY2F0Y2ggZXJyb3JcbiAgICAgICAgbWFpblBhdGggPSBudWxsXG5cbiAgICAgIGlmIG1haW5QYXRoXG4gICAgICAgIG1vZHVsZUNhY2hlLmRlcGVuZGVuY2llcy5wdXNoXG4gICAgICAgICAgbmFtZTogY2hpbGRNZXRhZGF0YS5uYW1lXG4gICAgICAgICAgdmVyc2lvbjogY2hpbGRNZXRhZGF0YS52ZXJzaW9uXG4gICAgICAgICAgcGF0aDogcGF0aC5yZWxhdGl2ZShyb290UGF0aCwgbWFpblBhdGgpXG5cbiAgICAgIGxvYWREZXBlbmRlbmNpZXMoY2hpbGRQYXRoLCByb290UGF0aCwgcm9vdE1ldGFkYXRhLCBtb2R1bGVDYWNoZSlcblxuICByZXR1cm5cblxubG9hZEZvbGRlckNvbXBhdGliaWxpdHkgPSAobW9kdWxlUGF0aCwgcm9vdFBhdGgsIHJvb3RNZXRhZGF0YSwgbW9kdWxlQ2FjaGUpIC0+XG4gIGZzID0gcmVxdWlyZSAnZnMtcGx1cydcblxuICBtZXRhZGF0YVBhdGggPSBwYXRoLmpvaW4obW9kdWxlUGF0aCwgJ3BhY2thZ2UuanNvbicpXG4gIHJldHVybiB1bmxlc3MgZnMuaXNGaWxlU3luYyhtZXRhZGF0YVBhdGgpXG5cbiAgZGVwZW5kZW5jaWVzID0gSlNPTi5wYXJzZShmcy5yZWFkRmlsZVN5bmMobWV0YWRhdGFQYXRoKSk/LmRlcGVuZGVuY2llcyA/IHt9XG5cbiAgZm9yIG5hbWUsIHZlcnNpb24gb2YgZGVwZW5kZW5jaWVzXG4gICAgdHJ5XG4gICAgICBuZXcgUmFuZ2UodmVyc2lvbilcbiAgICBjYXRjaCBlcnJvclxuICAgICAgZGVsZXRlIGRlcGVuZGVuY2llc1tuYW1lXVxuXG4gIG9uRGlyZWN0b3J5ID0gKGNoaWxkUGF0aCkgLT5cbiAgICBwYXRoLmJhc2VuYW1lKGNoaWxkUGF0aCkgaXNudCAnbm9kZV9tb2R1bGVzJ1xuXG4gIGV4dGVuc2lvbnMgPSBbJy5qcycsICcuY29mZmVlJywgJy5qc29uJywgJy5ub2RlJ11cbiAgcGF0aHMgPSB7fVxuICBvbkZpbGUgPSAoY2hpbGRQYXRoKSAtPlxuICAgIGlmIHBhdGguZXh0bmFtZShjaGlsZFBhdGgpIGluIGV4dGVuc2lvbnNcbiAgICAgIHJlbGF0aXZlUGF0aCA9IHBhdGgucmVsYXRpdmUocm9vdFBhdGgsIHBhdGguZGlybmFtZShjaGlsZFBhdGgpKVxuICAgICAgcGF0aHNbcmVsYXRpdmVQYXRoXSA9IHRydWVcbiAgZnMudHJhdmVyc2VUcmVlU3luYyhtb2R1bGVQYXRoLCBvbkZpbGUsIG9uRGlyZWN0b3J5KVxuXG4gIHBhdGhzID0gT2JqZWN0LmtleXMocGF0aHMpXG4gIGlmIHBhdGhzLmxlbmd0aCA+IDAgYW5kIE9iamVjdC5rZXlzKGRlcGVuZGVuY2llcykubGVuZ3RoID4gMFxuICAgIG1vZHVsZUNhY2hlLmZvbGRlcnMucHVzaCh7cGF0aHMsIGRlcGVuZGVuY2llc30pXG5cbiAgZm9yIGNoaWxkUGF0aCBpbiBmcy5saXN0U3luYyhwYXRoLmpvaW4obW9kdWxlUGF0aCwgJ25vZGVfbW9kdWxlcycpKVxuICAgIGNvbnRpbnVlIGlmIHBhdGguYmFzZW5hbWUoY2hpbGRQYXRoKSBpcyAnLmJpbidcbiAgICBjb250aW51ZSBpZiByb290UGF0aCBpcyBtb2R1bGVQYXRoIGFuZCByb290TWV0YWRhdGEucGFja2FnZURlcGVuZGVuY2llcz8uaGFzT3duUHJvcGVydHkocGF0aC5iYXNlbmFtZShjaGlsZFBhdGgpKVxuXG4gICAgbG9hZEZvbGRlckNvbXBhdGliaWxpdHkoY2hpbGRQYXRoLCByb290UGF0aCwgcm9vdE1ldGFkYXRhLCBtb2R1bGVDYWNoZSlcblxuICByZXR1cm5cblxubG9hZEV4dGVuc2lvbnMgPSAobW9kdWxlUGF0aCwgcm9vdFBhdGgsIHJvb3RNZXRhZGF0YSwgbW9kdWxlQ2FjaGUpIC0+XG4gIGZzID0gcmVxdWlyZSAnZnMtcGx1cydcbiAgZXh0ZW5zaW9ucyA9IFsnLmpzJywgJy5jb2ZmZWUnLCAnLmpzb24nLCAnLm5vZGUnXVxuICBub2RlTW9kdWxlc1BhdGggPSBwYXRoLmpvaW4ocm9vdFBhdGgsICdub2RlX21vZHVsZXMnKVxuXG4gIG9uRmlsZSA9IChmaWxlUGF0aCkgLT5cbiAgICBmaWxlUGF0aCA9IHBhdGgucmVsYXRpdmUocm9vdFBhdGgsIGZpbGVQYXRoKVxuICAgIHNlZ21lbnRzID0gZmlsZVBhdGguc3BsaXQocGF0aC5zZXApXG4gICAgcmV0dXJuIGlmICd0ZXN0JyBpbiBzZWdtZW50c1xuICAgIHJldHVybiBpZiAndGVzdHMnIGluIHNlZ21lbnRzXG4gICAgcmV0dXJuIGlmICdzcGVjJyBpbiBzZWdtZW50c1xuICAgIHJldHVybiBpZiAnc3BlY3MnIGluIHNlZ21lbnRzXG4gICAgcmV0dXJuIGlmIHNlZ21lbnRzLmxlbmd0aCA+IDEgYW5kIG5vdCAoc2VnbWVudHNbMF0gaW4gWydleHBvcnRzJywgJ2xpYicsICdub2RlX21vZHVsZXMnLCAnc3JjJywgJ3N0YXRpYycsICd2ZW5kb3InXSlcblxuICAgIGV4dGVuc2lvbiA9IHBhdGguZXh0bmFtZShmaWxlUGF0aClcbiAgICBpZiBleHRlbnNpb24gaW4gZXh0ZW5zaW9uc1xuICAgICAgbW9kdWxlQ2FjaGUuZXh0ZW5zaW9uc1tleHRlbnNpb25dID89IFtdXG4gICAgICBtb2R1bGVDYWNoZS5leHRlbnNpb25zW2V4dGVuc2lvbl0ucHVzaChmaWxlUGF0aClcblxuICBvbkRpcmVjdG9yeSA9IChjaGlsZFBhdGgpIC0+XG4gICAgIyBEb24ndCBpbmNsdWRlIGV4dGVuc2lvbnPCoGZyb20gYnVuZGxlZCBwYWNrYWdlc1xuICAgICMgVGhlc2UgYXJlIGdlbmVyYXRlZCBhbmQgc3RvcmVkIGluIHRoZSBwYWNrYWdlJ3Mgb3duIG1ldGFkYXRhIGNhY2hlXG4gICAgaWYgcm9vdE1ldGFkYXRhLm5hbWUgaXMgJ2F0b20nXG4gICAgICBwYXJlbnRQYXRoID0gcGF0aC5kaXJuYW1lKGNoaWxkUGF0aClcbiAgICAgIGlmIHBhcmVudFBhdGggaXMgbm9kZU1vZHVsZXNQYXRoXG4gICAgICAgIHBhY2thZ2VOYW1lID0gcGF0aC5iYXNlbmFtZShjaGlsZFBhdGgpXG4gICAgICAgIHJldHVybiBmYWxzZSBpZiByb290TWV0YWRhdGEucGFja2FnZURlcGVuZGVuY2llcz8uaGFzT3duUHJvcGVydHkocGFja2FnZU5hbWUpXG5cbiAgICB0cnVlXG5cbiAgZnMudHJhdmVyc2VUcmVlU3luYyhyb290UGF0aCwgb25GaWxlLCBvbkRpcmVjdG9yeSlcblxuICByZXR1cm5cblxuc2F0aXNmaWVzID0gKHZlcnNpb24sIHJhd1JhbmdlKSAtPlxuICB1bmxlc3MgcGFyc2VkUmFuZ2UgPSBjYWNoZS5yYW5nZXNbcmF3UmFuZ2VdXG4gICAgcGFyc2VkUmFuZ2UgPSBuZXcgUmFuZ2UocmF3UmFuZ2UpXG4gICAgY2FjaGUucmFuZ2VzW3Jhd1JhbmdlXSA9IHBhcnNlZFJhbmdlXG4gIHBhcnNlZFJhbmdlLnRlc3QodmVyc2lvbilcblxucmVzb2x2ZUZpbGVQYXRoID0gKHJlbGF0aXZlUGF0aCwgcGFyZW50TW9kdWxlKSAtPlxuICByZXR1cm4gdW5sZXNzIHJlbGF0aXZlUGF0aFxuICByZXR1cm4gdW5sZXNzIHBhcmVudE1vZHVsZT8uZmlsZW5hbWVcbiAgcmV0dXJuIHVubGVzcyByZWxhdGl2ZVBhdGhbMF0gaXMgJy4nIG9yIGlzQWJzb2x1dGUocmVsYXRpdmVQYXRoKVxuXG4gIHJlc29sdmVkUGF0aCA9IHBhdGgucmVzb2x2ZShwYXRoLmRpcm5hbWUocGFyZW50TW9kdWxlLmZpbGVuYW1lKSwgcmVsYXRpdmVQYXRoKVxuICByZXR1cm4gdW5sZXNzIGlzQ29yZVBhdGgocmVzb2x2ZWRQYXRoKVxuXG4gIGV4dGVuc2lvbiA9IHBhdGguZXh0bmFtZShyZXNvbHZlZFBhdGgpXG4gIGlmIGV4dGVuc2lvblxuICAgIHJldHVybiByZXNvbHZlZFBhdGggaWYgY2FjaGUuZXh0ZW5zaW9uc1tleHRlbnNpb25dPy5oYXMocmVzb2x2ZWRQYXRoKVxuICBlbHNlXG4gICAgZm9yIGV4dGVuc2lvbiwgcGF0aHMgb2YgY2FjaGUuZXh0ZW5zaW9uc1xuICAgICAgcmVzb2x2ZWRQYXRoV2l0aEV4dGVuc2lvbiA9IFwiI3tyZXNvbHZlZFBhdGh9I3tleHRlbnNpb259XCJcbiAgICAgIHJldHVybiByZXNvbHZlZFBhdGhXaXRoRXh0ZW5zaW9uIGlmIHBhdGhzLmhhcyhyZXNvbHZlZFBhdGhXaXRoRXh0ZW5zaW9uKVxuXG4gIHJldHVyblxuXG5yZXNvbHZlTW9kdWxlUGF0aCA9IChyZWxhdGl2ZVBhdGgsIHBhcmVudE1vZHVsZSkgLT5cbiAgcmV0dXJuIHVubGVzcyByZWxhdGl2ZVBhdGhcbiAgcmV0dXJuIHVubGVzcyBwYXJlbnRNb2R1bGU/LmZpbGVuYW1lXG5cbiAgbmF0aXZlTW9kdWxlcyA/PSBwcm9jZXNzLmJpbmRpbmcoJ25hdGl2ZXMnKVxuICByZXR1cm4gaWYgbmF0aXZlTW9kdWxlcy5oYXNPd25Qcm9wZXJ0eShyZWxhdGl2ZVBhdGgpXG4gIHJldHVybiBpZiByZWxhdGl2ZVBhdGhbMF0gaXMgJy4nXG4gIHJldHVybiBpZiBpc0Fic29sdXRlKHJlbGF0aXZlUGF0aClcblxuICBmb2xkZXJQYXRoID0gcGF0aC5kaXJuYW1lKHBhcmVudE1vZHVsZS5maWxlbmFtZSlcblxuICByYW5nZSA9IGNhY2hlLmZvbGRlcnNbZm9sZGVyUGF0aF0/W3JlbGF0aXZlUGF0aF1cbiAgdW5sZXNzIHJhbmdlP1xuICAgIGlmIGJ1aWx0aW5QYXRoID0gY2FjaGUuYnVpbHRpbnNbcmVsYXRpdmVQYXRoXVxuICAgICAgcmV0dXJuIGJ1aWx0aW5QYXRoXG4gICAgZWxzZVxuICAgICAgcmV0dXJuXG5cbiAgY2FuZGlkYXRlcyA9IGNhY2hlLmRlcGVuZGVuY2llc1tyZWxhdGl2ZVBhdGhdXG4gIHJldHVybiB1bmxlc3MgY2FuZGlkYXRlcz9cblxuICBmb3IgdmVyc2lvbiwgcmVzb2x2ZWRQYXRoIG9mIGNhbmRpZGF0ZXNcbiAgICBpZiBNb2R1bGUuX2NhY2hlLmhhc093blByb3BlcnR5KHJlc29sdmVkUGF0aCkgb3IgaXNDb3JlUGF0aChyZXNvbHZlZFBhdGgpXG4gICAgICByZXR1cm4gcmVzb2x2ZWRQYXRoIGlmIHNhdGlzZmllcyh2ZXJzaW9uLCByYW5nZSlcblxuICByZXR1cm5cblxucmVnaXN0ZXJCdWlsdGlucyA9IChkZXZNb2RlKSAtPlxuICBpZiBkZXZNb2RlIG9yIG5vdCBjYWNoZS5yZXNvdXJjZVBhdGguc3RhcnRzV2l0aChcIiN7cHJvY2Vzcy5yZXNvdXJjZXNQYXRofSN7cGF0aC5zZXB9XCIpXG4gICAgZnMgPSByZXF1aXJlICdmcy1wbHVzJ1xuICAgIGF0b21Kc1BhdGggPSBwYXRoLmpvaW4oY2FjaGUucmVzb3VyY2VQYXRoLCAnZXhwb3J0cycsICdhdG9tLmpzJylcbiAgICBjYWNoZS5idWlsdGlucy5hdG9tID0gYXRvbUpzUGF0aCBpZiBmcy5pc0ZpbGVTeW5jKGF0b21Kc1BhdGgpXG4gIGNhY2hlLmJ1aWx0aW5zLmF0b20gPz0gcGF0aC5qb2luKGNhY2hlLnJlc291cmNlUGF0aCwgJ2V4cG9ydHMnLCAnYXRvbS5qcycpXG5cbiAgZWxlY3Ryb25Bc2FyUm9vdCA9IHBhdGguam9pbihwcm9jZXNzLnJlc291cmNlc1BhdGgsICdlbGVjdHJvbi5hc2FyJylcblxuICBjb21tb25Sb290ID0gcGF0aC5qb2luKGVsZWN0cm9uQXNhclJvb3QsICdjb21tb24nLCAnYXBpJylcbiAgY29tbW9uQnVpbHRpbnMgPSBbJ2NhbGxiYWNrcy1yZWdpc3RyeScsICdjbGlwYm9hcmQnLCAnY3Jhc2gtcmVwb3J0ZXInLCAnc2hlbGwnXVxuICBmb3IgYnVpbHRpbiBpbiBjb21tb25CdWlsdGluc1xuICAgIGNhY2hlLmJ1aWx0aW5zW2J1aWx0aW5dID0gcGF0aC5qb2luKGNvbW1vblJvb3QsIFwiI3tidWlsdGlufS5qc1wiKVxuXG4gIHJlbmRlcmVyUm9vdCA9IHBhdGguam9pbihlbGVjdHJvbkFzYXJSb290LCAncmVuZGVyZXInLCAnYXBpJylcbiAgcmVuZGVyZXJCdWlsdGlucyA9IFsnaXBjLXJlbmRlcmVyJywgJ3JlbW90ZScsICdzY3JlZW4nXVxuICBmb3IgYnVpbHRpbiBpbiByZW5kZXJlckJ1aWx0aW5zXG4gICAgY2FjaGUuYnVpbHRpbnNbYnVpbHRpbl0gPSBwYXRoLmpvaW4ocmVuZGVyZXJSb290LCBcIiN7YnVpbHRpbn0uanNcIilcblxuZXhwb3J0cy5jcmVhdGUgPSAobW9kdWxlUGF0aCkgLT5cbiAgZnMgPSByZXF1aXJlICdmcy1wbHVzJ1xuXG4gIG1vZHVsZVBhdGggPSBmcy5yZWFscGF0aFN5bmMobW9kdWxlUGF0aClcbiAgbWV0YWRhdGFQYXRoID0gcGF0aC5qb2luKG1vZHVsZVBhdGgsICdwYWNrYWdlLmpzb24nKVxuICBtZXRhZGF0YSA9IEpTT04ucGFyc2UoZnMucmVhZEZpbGVTeW5jKG1ldGFkYXRhUGF0aCkpXG5cbiAgbW9kdWxlQ2FjaGUgPVxuICAgIHZlcnNpb246IDFcbiAgICBkZXBlbmRlbmNpZXM6IFtdXG4gICAgZXh0ZW5zaW9uczoge31cbiAgICBmb2xkZXJzOiBbXVxuXG4gIGxvYWREZXBlbmRlbmNpZXMobW9kdWxlUGF0aCwgbW9kdWxlUGF0aCwgbWV0YWRhdGEsIG1vZHVsZUNhY2hlKVxuICBsb2FkRm9sZGVyQ29tcGF0aWJpbGl0eShtb2R1bGVQYXRoLCBtb2R1bGVQYXRoLCBtZXRhZGF0YSwgbW9kdWxlQ2FjaGUpXG4gIGxvYWRFeHRlbnNpb25zKG1vZHVsZVBhdGgsIG1vZHVsZVBhdGgsIG1ldGFkYXRhLCBtb2R1bGVDYWNoZSlcblxuICBtZXRhZGF0YS5fYXRvbU1vZHVsZUNhY2hlID0gbW9kdWxlQ2FjaGVcbiAgZnMud3JpdGVGaWxlU3luYyhtZXRhZGF0YVBhdGgsIEpTT04uc3RyaW5naWZ5KG1ldGFkYXRhLCBudWxsLCAyKSlcblxuICByZXR1cm5cblxuZXhwb3J0cy5yZWdpc3RlciA9ICh7cmVzb3VyY2VQYXRoLCBkZXZNb2RlfT17fSkgLT5cbiAgcmV0dXJuIGlmIGNhY2hlLnJlZ2lzdGVyZWRcblxuICBvcmlnaW5hbFJlc29sdmVGaWxlbmFtZSA9IE1vZHVsZS5fcmVzb2x2ZUZpbGVuYW1lXG4gIE1vZHVsZS5fcmVzb2x2ZUZpbGVuYW1lID0gKHJlbGF0aXZlUGF0aCwgcGFyZW50TW9kdWxlKSAtPlxuICAgIHJlc29sdmVkUGF0aCA9IHJlc29sdmVNb2R1bGVQYXRoKHJlbGF0aXZlUGF0aCwgcGFyZW50TW9kdWxlKVxuICAgIHJlc29sdmVkUGF0aCA/PSByZXNvbHZlRmlsZVBhdGgocmVsYXRpdmVQYXRoLCBwYXJlbnRNb2R1bGUpXG4gICAgcmVzb2x2ZWRQYXRoID8gb3JpZ2luYWxSZXNvbHZlRmlsZW5hbWUocmVsYXRpdmVQYXRoLCBwYXJlbnRNb2R1bGUpXG5cbiAgY2FjaGUucmVnaXN0ZXJlZCA9IHRydWVcbiAgY2FjaGUucmVzb3VyY2VQYXRoID0gcmVzb3VyY2VQYXRoXG4gIGNhY2hlLnJlc291cmNlUGF0aFdpdGhUcmFpbGluZ1NsYXNoID0gXCIje3Jlc291cmNlUGF0aH0je3BhdGguc2VwfVwiXG4gIHJlZ2lzdGVyQnVpbHRpbnMoZGV2TW9kZSlcblxuICByZXR1cm5cblxuZXhwb3J0cy5hZGQgPSAoZGlyZWN0b3J5UGF0aCwgbWV0YWRhdGEpIC0+XG4gICMgcGF0aC5qb2luIGlzbid0IHVzZWQgaW4gdGhpcyBmdW5jdGlvbiBmb3Igc3BlZWQgc2luY2UgcGF0aC5qb2luIGNhbGxzXG4gICMgcGF0aC5ub3JtYWxpemUgYW5kIGFsbCB0aGUgcGF0aHMgYXJlIGFscmVhZHkgbm9ybWFsaXplZCBoZXJlLlxuXG4gIHVubGVzcyBtZXRhZGF0YT9cbiAgICB0cnlcbiAgICAgIG1ldGFkYXRhID0gcmVxdWlyZShcIiN7ZGlyZWN0b3J5UGF0aH0je3BhdGguc2VwfXBhY2thZ2UuanNvblwiKVxuICAgIGNhdGNoIGVycm9yXG4gICAgICByZXR1cm5cblxuICBjYWNoZVRvQWRkID0gbWV0YWRhdGE/Ll9hdG9tTW9kdWxlQ2FjaGVcbiAgcmV0dXJuIHVubGVzcyBjYWNoZVRvQWRkP1xuXG4gIGZvciBkZXBlbmRlbmN5IGluIGNhY2hlVG9BZGQuZGVwZW5kZW5jaWVzID8gW11cbiAgICBjYWNoZS5kZXBlbmRlbmNpZXNbZGVwZW5kZW5jeS5uYW1lXSA/PSB7fVxuICAgIGNhY2hlLmRlcGVuZGVuY2llc1tkZXBlbmRlbmN5Lm5hbWVdW2RlcGVuZGVuY3kudmVyc2lvbl0gPz0gXCIje2RpcmVjdG9yeVBhdGh9I3twYXRoLnNlcH0je2RlcGVuZGVuY3kucGF0aH1cIlxuXG4gIGZvciBlbnRyeSBpbiBjYWNoZVRvQWRkLmZvbGRlcnMgPyBbXVxuICAgIGZvciBmb2xkZXJQYXRoIGluIGVudHJ5LnBhdGhzXG4gICAgICBpZiBmb2xkZXJQYXRoXG4gICAgICAgIGNhY2hlLmZvbGRlcnNbXCIje2RpcmVjdG9yeVBhdGh9I3twYXRoLnNlcH0je2ZvbGRlclBhdGh9XCJdID0gZW50cnkuZGVwZW5kZW5jaWVzXG4gICAgICBlbHNlXG4gICAgICAgIGNhY2hlLmZvbGRlcnNbZGlyZWN0b3J5UGF0aF0gPSBlbnRyeS5kZXBlbmRlbmNpZXNcblxuICBmb3IgZXh0ZW5zaW9uLCBwYXRocyBvZiBjYWNoZVRvQWRkLmV4dGVuc2lvbnNcbiAgICBjYWNoZS5leHRlbnNpb25zW2V4dGVuc2lvbl0gPz0gbmV3IFNldCgpXG4gICAgZm9yIGZpbGVQYXRoIGluIHBhdGhzXG4gICAgICBjYWNoZS5leHRlbnNpb25zW2V4dGVuc2lvbl0uYWRkKFwiI3tkaXJlY3RvcnlQYXRofSN7cGF0aC5zZXB9I3tmaWxlUGF0aH1cIilcblxuICByZXR1cm5cblxuZXhwb3J0cy5jYWNoZSA9IGNhY2hlXG4iXX0=
