var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _winreg = require('winreg');

var _winreg2 = _interopRequireDefault(_winreg);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

'use babel';

var exeName = _path2['default'].basename(process.execPath);
var appPath = '"' + process.execPath + '"';
var fileIconPath = '"' + _path2['default'].join(process.execPath, '..', 'resources', 'cli', 'file.ico') + '"';
var isBeta = appPath.includes(' Beta');
var appName = exeName.replace('atom', isBeta ? 'Atom Beta' : 'Atom').replace('.exe', '');

var ShellOption = (function () {
  function ShellOption(key, parts) {
    _classCallCheck(this, ShellOption);

    this.isRegistered = this.isRegistered.bind(this);
    this.register = this.register.bind(this);
    this.deregister = this.deregister.bind(this);
    this.update = this.update.bind(this);
    this.key = key;
    this.parts = parts;
  }

  _createClass(ShellOption, [{
    key: 'isRegistered',
    value: function isRegistered(callback) {
      var _this = this;

      new _winreg2['default']({ hive: 'HKCU', key: this.key + '\\' + this.parts[0].key }).get(this.parts[0].name, function (err, val) {
        return callback(err == null && val != null && val.value === _this.parts[0].value);
      });
    }
  }, {
    key: 'register',
    value: function register(callback) {
      var _this2 = this;

      var doneCount = this.parts.length;
      this.parts.forEach(function (part) {
        var reg = new _winreg2['default']({ hive: 'HKCU', key: part.key != null ? _this2.key + '\\' + part.key : _this2.key });
        return reg.create(function () {
          return reg.set(part.name, _winreg2['default'].REG_SZ, part.value, function () {
            if (--doneCount === 0) return callback();
          });
        });
      });
    }
  }, {
    key: 'deregister',
    value: function deregister(callback) {
      var _this3 = this;

      this.isRegistered(function (isRegistered) {
        if (isRegistered) {
          new _winreg2['default']({ hive: 'HKCU', key: _this3.key }).destroy(function () {
            return callback(null, true);
          });
        } else {
          callback(null, false);
        }
      });
    }
  }, {
    key: 'update',
    value: function update(callback) {
      var _this4 = this;

      new _winreg2['default']({ hive: 'HKCU', key: this.key + '\\' + this.parts[0].key }).get(this.parts[0].name, function (err, val) {
        if (err != null || val == null) {
          callback(err);
        } else {
          _this4.register(callback);
        }
      });
    }
  }]);

  return ShellOption;
})();

exports.appName = appName;

exports.fileHandler = new ShellOption('\\Software\\Classes\\Applications\\' + exeName, [{ key: 'shell\\open\\command', name: '', value: appPath + ' "%1"' }, { key: 'shell\\open', name: 'FriendlyAppName', value: '' + appName }, { key: 'DefaultIcon', name: '', value: '' + fileIconPath }]);

var contextParts = [{ key: 'command', name: '', value: appPath + ' "%1"' }, { name: '', value: 'Open with ' + appName }, { name: 'Icon', value: '' + appPath }];

exports.fileContextMenu = new ShellOption('\\Software\\Classes\\*\\shell\\' + appName, contextParts);
exports.folderContextMenu = new ShellOption('\\Software\\Classes\\Directory\\shell\\' + appName, contextParts);
exports.folderBackgroundContextMenu = new ShellOption('\\Software\\Classes\\Directory\\background\\shell\\' + appName, JSON.parse(JSON.stringify(contextParts).replace('%1', '%V')));
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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