(function() {
  var Spawner, path, powershellPath, spawnPowershell, system32Path;

  path = require('path');

  Spawner = require('./spawner');

  if (process.env.SystemRoot) {
    system32Path = path.join(process.env.SystemRoot, 'System32');
    powershellPath = path.join(system32Path, 'WindowsPowerShell', 'v1.0', 'powershell.exe');
  } else {
    powershellPath = 'powershell.exe';
  }

  spawnPowershell = function(args, callback) {
    args[0] = "[Console]::OutputEncoding=[System.Text.Encoding]::UTF8\n$output=" + args[0] + "\n[Console]::WriteLine($output)";
    args.unshift('-command');
    args.unshift('RemoteSigned');
    args.unshift('-ExecutionPolicy');
    args.unshift('-noprofile');
    return Spawner.spawn(powershellPath, args, callback);
  };

  exports.getPath = function(callback) {
    return spawnPowershell(['[environment]::GetEnvironmentVariable(\'Path\',\'User\')'], function(error, stdout) {
      var pathOutput;
      if (error != null) {
        return callback(error);
      }
      pathOutput = stdout.replace(/^\s+|\s+$/g, '');
      return callback(null, pathOutput);
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
