(function() {
  var ApplicationDelegate, AtomEnvironment, Clipboard, CompileCache, FileSystemBlobStore, ModuleCache, NativeCompileCache, TextEditor, TextEditorComponent, clipboard;

  AtomEnvironment = require('./atom-environment');

  ApplicationDelegate = require('./application-delegate');

  Clipboard = require('./clipboard');

  TextEditor = require('./text-editor');

  TextEditorComponent = require('./text-editor-component');

  FileSystemBlobStore = require('./file-system-blob-store');

  NativeCompileCache = require('./native-compile-cache');

  CompileCache = require('./compile-cache');

  ModuleCache = require('./module-cache');

  if (global.isGeneratingSnapshot) {
    require('about');
    require('archive-view');
    require('autocomplete-atom-api');
    require('autocomplete-css');
    require('autocomplete-html');
    require('autocomplete-plus');
    require('autocomplete-snippets');
    require('autoflow');
    require('autosave');
    require('background-tips');
    require('bookmarks');
    require('bracket-matcher');
    require('command-palette');
    require('deprecation-cop');
    require('dev-live-reload');
    require('encoding-selector');
    require('exception-reporting');
    require('dalek');
    require('find-and-replace');
    require('fuzzy-finder');
    require('github');
    require('git-diff');
    require('go-to-line');
    require('grammar-selector');
    require('image-view');
    require('incompatible-packages');
    require('keybinding-resolver');
    require('line-ending-selector');
    require('link');
    require('markdown-preview');
    require('metrics');
    require('notifications');
    require('open-on-github');
    require('package-generator');
    require('settings-view');
    require('snippets');
    require('spell-check');
    require('status-bar');
    require('styleguide');
    require('symbols-view');
    require('tabs');
    require('timecop');
    require('tree-view');
    require('update-package-dependencies');
    require('welcome');
    require('whitespace');
    require('wrap-guide');
  }

  clipboard = new Clipboard;

  TextEditor.setClipboard(clipboard);

  TextEditor.viewForItem = function(item) {
    return atom.views.getView(item);
  };

  global.atom = new AtomEnvironment({
    clipboard: clipboard,
    applicationDelegate: new ApplicationDelegate,
    enablePersistence: true
  });

  global.atom.preloadPackages();

  module.exports = function(arg) {
    var base, blobStore, devMode, env, exportsPath, getWindowLoadSettings, ipcRenderer, path, ref, resourcePath, updateProcessEnv;
    blobStore = arg.blobStore;
    updateProcessEnv = require('./update-process-env').updateProcessEnv;
    path = require('path');
    require('./window');
    getWindowLoadSettings = require('./get-window-load-settings');
    ipcRenderer = require('electron').ipcRenderer;
    ref = getWindowLoadSettings(), resourcePath = ref.resourcePath, devMode = ref.devMode, env = ref.env;
    require('./electron-shims');
    exportsPath = path.join(resourcePath, 'exports');
    require('module').globalPaths.push(exportsPath);
    process.env.NODE_PATH = exportsPath;
    if (!devMode) {
      if ((base = process.env).NODE_ENV == null) {
        base.NODE_ENV = 'production';
      }
    }
    global.atom.initialize({
      window: window,
      document: document,
      blobStore: blobStore,
      configDirPath: process.env.ATOM_HOME,
      env: process.env
    });
    return global.atom.startEditorWindow().then(function() {
      var windowFocused;
      windowFocused = function() {
        window.removeEventListener('focus', windowFocused);
        return setTimeout((function() {
          return document.querySelector('atom-workspace').focus();
        }), 0);
      };
      window.addEventListener('focus', windowFocused);
      return ipcRenderer.on('environment', function(event, env) {
        return updateProcessEnv(env);
      });
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
