(function() {
  var FirstMate, GrammarRegistry, Grim, PathSplitRegex, Token, _, fs, getEditorForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  _ = require('underscore-plus');

  FirstMate = require('first-mate');

  Token = require('./token');

  fs = require('fs-plus');

  Grim = require('grim');

  PathSplitRegex = new RegExp("[/.]");

  module.exports = GrammarRegistry = (function(superClass) {
    extend(GrammarRegistry, superClass);

    function GrammarRegistry(arg) {
      this.config = (arg != null ? arg : {}).config;
      GrammarRegistry.__super__.constructor.call(this, {
        maxTokensPerLine: 100,
        maxLineLength: 1000
      });
    }

    GrammarRegistry.prototype.createToken = function(value, scopes) {
      return new Token({
        value: value,
        scopes: scopes
      });
    };

    GrammarRegistry.prototype.selectGrammar = function(filePath, fileContents) {
      return this.selectGrammarWithScore(filePath, fileContents).grammar;
    };

    GrammarRegistry.prototype.selectGrammarWithScore = function(filePath, fileContents) {
      var bestMatch, grammar, highestScore, j, len, ref, score;
      bestMatch = null;
      highestScore = -2e308;
      ref = this.grammars;
      for (j = 0, len = ref.length; j < len; j++) {
        grammar = ref[j];
        score = this.getGrammarScore(grammar, filePath, fileContents);
        if (score > highestScore || (bestMatch == null)) {
          bestMatch = grammar;
          highestScore = score;
        }
      }
      return {
        grammar: bestMatch,
        score: highestScore
      };
    };

    GrammarRegistry.prototype.getGrammarScore = function(grammar, filePath, contents) {
      var score;
      if ((contents == null) && fs.isFileSync(filePath)) {
        contents = fs.readFileSync(filePath, 'utf8');
      }
      score = this.getGrammarPathScore(grammar, filePath);
      if (score > 0 && !grammar.bundledPackage) {
        score += 0.25;
      }
      if (this.grammarMatchesContents(grammar, contents)) {
        score += 0.125;
      }
      return score;
    };

    GrammarRegistry.prototype.getGrammarPathScore = function(grammar, filePath) {
      var customFileTypes, fileType, fileTypeComponents, fileTypes, i, j, len, pathComponents, pathScore, pathSuffix, ref;
      if (!filePath) {
        return -1;
      }
      if (process.platform === 'win32') {
        filePath = filePath.replace(/\\/g, '/');
      }
      pathComponents = filePath.toLowerCase().split(PathSplitRegex);
      pathScore = -1;
      fileTypes = grammar.fileTypes;
      if (customFileTypes = (ref = this.config.get('core.customFileTypes')) != null ? ref[grammar.scopeName] : void 0) {
        fileTypes = fileTypes.concat(customFileTypes);
      }
      for (i = j = 0, len = fileTypes.length; j < len; i = ++j) {
        fileType = fileTypes[i];
        fileTypeComponents = fileType.toLowerCase().split(PathSplitRegex);
        pathSuffix = pathComponents.slice(-fileTypeComponents.length);
        if (_.isEqual(pathSuffix, fileTypeComponents)) {
          pathScore = Math.max(pathScore, fileType.length);
          if (i >= grammar.fileTypes.length) {
            pathScore += 0.5;
          }
        }
      }
      return pathScore;
    };

    GrammarRegistry.prototype.grammarMatchesContents = function(grammar, contents) {
      var character, escaped, j, len, lines, numberOfNewlinesInRegex, ref;
      if (!((contents != null) && (grammar.firstLineRegex != null))) {
        return false;
      }
      escaped = false;
      numberOfNewlinesInRegex = 0;
      ref = grammar.firstLineRegex.source;
      for (j = 0, len = ref.length; j < len; j++) {
        character = ref[j];
        switch (character) {
          case '\\':
            escaped = !escaped;
            break;
          case 'n':
            if (escaped) {
              numberOfNewlinesInRegex++;
            }
            escaped = false;
            break;
          default:
            escaped = false;
        }
      }
      lines = contents.split('\n');
      return grammar.firstLineRegex.testSync(lines.slice(0, +numberOfNewlinesInRegex + 1 || 9e9).join('\n'));
    };

    GrammarRegistry.prototype.grammarOverrideForPath = function(filePath) {
      var editor;
      Grim.deprecate('Use atom.textEditors.getGrammarOverride(editor) instead');
      if (editor = getEditorForPath(filePath)) {
        return atom.textEditors.getGrammarOverride(editor);
      }
    };

    GrammarRegistry.prototype.setGrammarOverrideForPath = function(filePath, scopeName) {
      var editor;
      Grim.deprecate('Use atom.textEditors.setGrammarOverride(editor, scopeName) instead');
      if (editor = getEditorForPath(filePath)) {
        atom.textEditors.setGrammarOverride(editor, scopeName);
      }
    };

    GrammarRegistry.prototype.clearGrammarOverrideForPath = function(filePath) {
      var editor;
      Grim.deprecate('Use atom.textEditors.clearGrammarOverride(editor) instead');
      if (editor = getEditorForPath(filePath)) {
        atom.textEditors.clearGrammarOverride(editor);
      }
    };

    return GrammarRegistry;

  })(FirstMate.GrammarRegistry);

  getEditorForPath = function(filePath) {
    if (filePath != null) {
      return atom.workspace.getTextEditors().find(function(editor) {
        return editor.getPath() === filePath;
      });
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
