(function() {
  var DefaultDirectorySearcher, DirectorySearch, Task,
    slice = [].slice;

  Task = require('./task');

  DirectorySearch = (function() {
    function DirectorySearch(rootPaths, regex, options) {
      var scanHandlerOptions, searchOptions;
      scanHandlerOptions = {
        ignoreCase: regex.ignoreCase,
        inclusions: options.inclusions,
        includeHidden: options.includeHidden,
        excludeVcsIgnores: options.excludeVcsIgnores,
        globalExclusions: options.exclusions,
        follow: options.follow
      };
      searchOptions = {
        leadingContextLineCount: options.leadingContextLineCount,
        trailingContextLineCount: options.trailingContextLineCount
      };
      this.task = new Task(require.resolve('./scan-handler'));
      this.task.on('scan:result-found', options.didMatch);
      this.task.on('scan:file-error', options.didError);
      this.task.on('scan:paths-searched', options.didSearchPaths);
      this.promise = new Promise((function(_this) {
        return function(resolve, reject) {
          _this.task.on('task:cancelled', reject);
          return _this.task.start(rootPaths, regex.source, scanHandlerOptions, searchOptions, function() {
            _this.task.terminate();
            return resolve();
          });
        };
      })(this));
    }

    DirectorySearch.prototype.then = function() {
      var args;
      args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
      return this.promise.then.apply(this.promise, args);
    };

    DirectorySearch.prototype.cancel = function() {
      this.task.cancel();
      return null;
    };

    return DirectorySearch;

  })();

  module.exports = DefaultDirectorySearcher = (function() {
    function DefaultDirectorySearcher() {}

    DefaultDirectorySearcher.prototype.canSearchDirectory = function(directory) {
      return true;
    };

    DefaultDirectorySearcher.prototype.search = function(directories, regex, options) {
      var directorySearch, isCancelled, promise, rootPaths;
      rootPaths = directories.map(function(directory) {
        return directory.getPath();
      });
      isCancelled = false;
      directorySearch = new DirectorySearch(rootPaths, regex, options);
      promise = new Promise(function(resolve, reject) {
        return directorySearch.then(resolve, function() {
          if (isCancelled) {
            return resolve();
          } else {
            return reject();
          }
        });
      });
      return {
        then: promise.then.bind(promise),
        "catch": promise["catch"].bind(promise),
        cancel: function() {
          isCancelled = true;
          return directorySearch.cancel();
        }
      };
    };

    return DefaultDirectorySearcher;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL3NyYy9kZWZhdWx0LWRpcmVjdG9yeS1zZWFyY2hlci5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBLCtDQUFBO0lBQUE7O0VBQUEsSUFBQSxHQUFPLE9BQUEsQ0FBUSxRQUFSOztFQUlEO0lBQ1MseUJBQUMsU0FBRCxFQUFZLEtBQVosRUFBbUIsT0FBbkI7QUFDWCxVQUFBO01BQUEsa0JBQUEsR0FDRTtRQUFBLFVBQUEsRUFBWSxLQUFLLENBQUMsVUFBbEI7UUFDQSxVQUFBLEVBQVksT0FBTyxDQUFDLFVBRHBCO1FBRUEsYUFBQSxFQUFlLE9BQU8sQ0FBQyxhQUZ2QjtRQUdBLGlCQUFBLEVBQW1CLE9BQU8sQ0FBQyxpQkFIM0I7UUFJQSxnQkFBQSxFQUFrQixPQUFPLENBQUMsVUFKMUI7UUFLQSxNQUFBLEVBQVEsT0FBTyxDQUFDLE1BTGhCOztNQU1GLGFBQUEsR0FDRTtRQUFBLHVCQUFBLEVBQXlCLE9BQU8sQ0FBQyx1QkFBakM7UUFDQSx3QkFBQSxFQUEwQixPQUFPLENBQUMsd0JBRGxDOztNQUVGLElBQUMsQ0FBQSxJQUFELEdBQVksSUFBQSxJQUFBLENBQUssT0FBTyxDQUFDLE9BQVIsQ0FBZ0IsZ0JBQWhCLENBQUw7TUFDWixJQUFDLENBQUEsSUFBSSxDQUFDLEVBQU4sQ0FBUyxtQkFBVCxFQUE4QixPQUFPLENBQUMsUUFBdEM7TUFDQSxJQUFDLENBQUEsSUFBSSxDQUFDLEVBQU4sQ0FBUyxpQkFBVCxFQUE0QixPQUFPLENBQUMsUUFBcEM7TUFDQSxJQUFDLENBQUEsSUFBSSxDQUFDLEVBQU4sQ0FBUyxxQkFBVCxFQUFnQyxPQUFPLENBQUMsY0FBeEM7TUFDQSxJQUFDLENBQUEsT0FBRCxHQUFlLElBQUEsT0FBQSxDQUFRLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQyxPQUFELEVBQVUsTUFBVjtVQUNyQixLQUFDLENBQUEsSUFBSSxDQUFDLEVBQU4sQ0FBUyxnQkFBVCxFQUEyQixNQUEzQjtpQkFDQSxLQUFDLENBQUEsSUFBSSxDQUFDLEtBQU4sQ0FBWSxTQUFaLEVBQXVCLEtBQUssQ0FBQyxNQUE3QixFQUFxQyxrQkFBckMsRUFBeUQsYUFBekQsRUFBd0UsU0FBQTtZQUN0RSxLQUFDLENBQUEsSUFBSSxDQUFDLFNBQU4sQ0FBQTttQkFDQSxPQUFBLENBQUE7VUFGc0UsQ0FBeEU7UUFGcUI7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQVI7SUFmSjs7OEJBcUJiLElBQUEsR0FBTSxTQUFBO0FBQ0osVUFBQTtNQURLO2FBQ0wsSUFBQyxDQUFBLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBZCxDQUFvQixJQUFDLENBQUEsT0FBckIsRUFBOEIsSUFBOUI7SUFESTs7OEJBR04sTUFBQSxHQUFRLFNBQUE7TUFFTixJQUFDLENBQUEsSUFBSSxDQUFDLE1BQU4sQ0FBQTthQUNBO0lBSE07Ozs7OztFQU1WLE1BQU0sQ0FBQyxPQUFQLEdBQ007Ozt1Q0FNSixrQkFBQSxHQUFvQixTQUFDLFNBQUQ7YUFBZTtJQUFmOzt1Q0FtQ3BCLE1BQUEsR0FBUSxTQUFDLFdBQUQsRUFBYyxLQUFkLEVBQXFCLE9BQXJCO0FBQ04sVUFBQTtNQUFBLFNBQUEsR0FBWSxXQUFXLENBQUMsR0FBWixDQUFnQixTQUFDLFNBQUQ7ZUFBZSxTQUFTLENBQUMsT0FBVixDQUFBO01BQWYsQ0FBaEI7TUFDWixXQUFBLEdBQWM7TUFDZCxlQUFBLEdBQXNCLElBQUEsZUFBQSxDQUFnQixTQUFoQixFQUEyQixLQUEzQixFQUFrQyxPQUFsQztNQUN0QixPQUFBLEdBQWMsSUFBQSxPQUFBLENBQVEsU0FBQyxPQUFELEVBQVUsTUFBVjtlQUNwQixlQUFlLENBQUMsSUFBaEIsQ0FBcUIsT0FBckIsRUFBOEIsU0FBQTtVQUM1QixJQUFHLFdBQUg7bUJBQ0UsT0FBQSxDQUFBLEVBREY7V0FBQSxNQUFBO21CQUdFLE1BQUEsQ0FBQSxFQUhGOztRQUQ0QixDQUE5QjtNQURvQixDQUFSO0FBTWQsYUFBTztRQUNMLElBQUEsRUFBTSxPQUFPLENBQUMsSUFBSSxDQUFDLElBQWIsQ0FBa0IsT0FBbEIsQ0FERDtRQUVMLENBQUEsS0FBQSxDQUFBLEVBQU8sT0FBTyxFQUFDLEtBQUQsRUFBTSxDQUFDLElBQWQsQ0FBbUIsT0FBbkIsQ0FGRjtRQUdMLE1BQUEsRUFBUSxTQUFBO1VBQ04sV0FBQSxHQUFjO2lCQUNkLGVBQWUsQ0FBQyxNQUFoQixDQUFBO1FBRk0sQ0FISDs7SUFWRDs7Ozs7QUE3RVYiLCJzb3VyY2VzQ29udGVudCI6WyJUYXNrID0gcmVxdWlyZSAnLi90YXNrJ1xuXG4jIFNlYXJjaGVzIGxvY2FsIGZpbGVzIGZvciBsaW5lcyBtYXRjaGluZyBhIHNwZWNpZmllZCByZWdleC4gSW1wbGVtZW50cyBgLnRoZW4oKWBcbiMgc28gdGhhdCBpdCBjYW4gYmUgdXNlZCB3aXRoIGBQcm9taXNlLmFsbCgpYC5cbmNsYXNzIERpcmVjdG9yeVNlYXJjaFxuICBjb25zdHJ1Y3RvcjogKHJvb3RQYXRocywgcmVnZXgsIG9wdGlvbnMpIC0+XG4gICAgc2NhbkhhbmRsZXJPcHRpb25zID1cbiAgICAgIGlnbm9yZUNhc2U6IHJlZ2V4Lmlnbm9yZUNhc2VcbiAgICAgIGluY2x1c2lvbnM6IG9wdGlvbnMuaW5jbHVzaW9uc1xuICAgICAgaW5jbHVkZUhpZGRlbjogb3B0aW9ucy5pbmNsdWRlSGlkZGVuXG4gICAgICBleGNsdWRlVmNzSWdub3Jlczogb3B0aW9ucy5leGNsdWRlVmNzSWdub3Jlc1xuICAgICAgZ2xvYmFsRXhjbHVzaW9uczogb3B0aW9ucy5leGNsdXNpb25zXG4gICAgICBmb2xsb3c6IG9wdGlvbnMuZm9sbG93XG4gICAgc2VhcmNoT3B0aW9ucyA9XG4gICAgICBsZWFkaW5nQ29udGV4dExpbmVDb3VudDogb3B0aW9ucy5sZWFkaW5nQ29udGV4dExpbmVDb3VudFxuICAgICAgdHJhaWxpbmdDb250ZXh0TGluZUNvdW50OiBvcHRpb25zLnRyYWlsaW5nQ29udGV4dExpbmVDb3VudFxuICAgIEB0YXNrID0gbmV3IFRhc2socmVxdWlyZS5yZXNvbHZlKCcuL3NjYW4taGFuZGxlcicpKVxuICAgIEB0YXNrLm9uICdzY2FuOnJlc3VsdC1mb3VuZCcsIG9wdGlvbnMuZGlkTWF0Y2hcbiAgICBAdGFzay5vbiAnc2NhbjpmaWxlLWVycm9yJywgb3B0aW9ucy5kaWRFcnJvclxuICAgIEB0YXNrLm9uICdzY2FuOnBhdGhzLXNlYXJjaGVkJywgb3B0aW9ucy5kaWRTZWFyY2hQYXRoc1xuICAgIEBwcm9taXNlID0gbmV3IFByb21pc2UgKHJlc29sdmUsIHJlamVjdCkgPT5cbiAgICAgIEB0YXNrLm9uKCd0YXNrOmNhbmNlbGxlZCcsIHJlamVjdClcbiAgICAgIEB0YXNrLnN0YXJ0IHJvb3RQYXRocywgcmVnZXguc291cmNlLCBzY2FuSGFuZGxlck9wdGlvbnMsIHNlYXJjaE9wdGlvbnMsID0+XG4gICAgICAgIEB0YXNrLnRlcm1pbmF0ZSgpXG4gICAgICAgIHJlc29sdmUoKVxuXG4gIHRoZW46IChhcmdzLi4uKSAtPlxuICAgIEBwcm9taXNlLnRoZW4uYXBwbHkoQHByb21pc2UsIGFyZ3MpXG5cbiAgY2FuY2VsOiAtPlxuICAgICMgVGhpcyB3aWxsIGNhdXNlIEBwcm9taXNlIHRvIHJlamVjdC5cbiAgICBAdGFzay5jYW5jZWwoKVxuICAgIG51bGxcblxuIyBEZWZhdWx0IHByb3ZpZGVyIGZvciB0aGUgYGF0b20uZGlyZWN0b3J5LXNlYXJjaGVyYCBzZXJ2aWNlLlxubW9kdWxlLmV4cG9ydHMgPVxuY2xhc3MgRGVmYXVsdERpcmVjdG9yeVNlYXJjaGVyXG4gICMgRGV0ZXJtaW5lcyB3aGV0aGVyIHRoaXMgb2JqZWN0IHN1cHBvcnRzIHNlYXJjaCBmb3IgYSBgRGlyZWN0b3J5YC5cbiAgI1xuICAjICogYGRpcmVjdG9yeWAge0RpcmVjdG9yeX0gd2hvc2Ugc2VhcmNoIG5lZWRzIG1pZ2h0IGJlIHN1cHBvcnRlZCBieSB0aGlzIG9iamVjdC5cbiAgI1xuICAjIFJldHVybnMgYSBgYm9vbGVhbmAgaW5kaWNhdGluZyB3aGV0aGVyIHRoaXMgb2JqZWN0IGNhbiBzZWFyY2ggdGhpcyBgRGlyZWN0b3J5YC5cbiAgY2FuU2VhcmNoRGlyZWN0b3J5OiAoZGlyZWN0b3J5KSAtPiB0cnVlXG5cbiAgIyBQZXJmb3JtcyBhIHRleHQgc2VhcmNoIGZvciBmaWxlcyBpbiB0aGUgc3BlY2lmaWVkIGBEaXJlY3RvcnlgLCBzdWJqZWN0IHRvIHRoZVxuICAjIHNwZWNpZmllZCBwYXJhbWV0ZXJzLlxuICAjXG4gICMgUmVzdWx0cyBhcmUgc3RyZWFtZWQgYmFjayB0byB0aGUgY2FsbGVyIGJ5IGludm9raW5nIG1ldGhvZHMgb24gdGhlIHNwZWNpZmllZCBgb3B0aW9uc2AsXG4gICMgc3VjaCBhcyBgZGlkTWF0Y2hgIGFuZCBgZGlkRXJyb3JgLlxuICAjXG4gICMgKiBgZGlyZWN0b3JpZXNgIHtBcnJheX0gb2Yge0RpcmVjdG9yeX0gb2JqZWN0cyB0byBzZWFyY2gsIGFsbCBvZiB3aGljaCBoYXZlIGJlZW4gYWNjZXB0ZWQgYnlcbiAgIyB0aGlzIHNlYXJjaGVyJ3MgYGNhblNlYXJjaERpcmVjdG9yeSgpYCBwcmVkaWNhdGUuXG4gICMgKiBgcmVnZXhgIHtSZWdFeHB9IHRvIHNlYXJjaCB3aXRoLlxuICAjICogYG9wdGlvbnNgIHtPYmplY3R9IHdpdGggdGhlIGZvbGxvd2luZyBwcm9wZXJ0aWVzOlxuICAjICAgKiBgZGlkTWF0Y2hgIHtGdW5jdGlvbn0gY2FsbCB3aXRoIGEgc2VhcmNoIHJlc3VsdCBzdHJ1Y3R1cmVkIGFzIGZvbGxvd3M6XG4gICMgICAgICogYHNlYXJjaFJlc3VsdGAge09iamVjdH0gd2l0aCB0aGUgZm9sbG93aW5nIGtleXM6XG4gICMgICAgICAgKiBgZmlsZVBhdGhgIHtTdHJpbmd9IGFic29sdXRlIHBhdGggdG8gdGhlIG1hdGNoaW5nIGZpbGUuXG4gICMgICAgICAgKiBgbWF0Y2hlc2Age0FycmF5fSB3aXRoIG9iamVjdCBlbGVtZW50cyB3aXRoIHRoZSBmb2xsb3dpbmcga2V5czpcbiAgIyAgICAgICAgICogYGxpbmVUZXh0YCB7U3RyaW5nfSBUaGUgZnVsbCB0ZXh0IG9mIHRoZSBtYXRjaGluZyBsaW5lICh3aXRob3V0IGEgbGluZSB0ZXJtaW5hdG9yIGNoYXJhY3RlcikuXG4gICMgICAgICAgICAqIGBsaW5lVGV4dE9mZnNldGAge051bWJlcn0gKFRoaXMgYWx3YXlzIHNlZW1zIHRvIGJlIDA/KVxuICAjICAgICAgICAgKiBgbWF0Y2hUZXh0YCB7U3RyaW5nfSBUaGUgdGV4dCB0aGF0IG1hdGNoZWQgdGhlIGByZWdleGAgdXNlZCBmb3IgdGhlIHNlYXJjaC5cbiAgIyAgICAgICAgICogYHJhbmdlYCB7UmFuZ2V9IElkZW50aWZpZXMgdGhlIG1hdGNoaW5nIHJlZ2lvbiBpbiB0aGUgZmlsZS4gKExpa2VseSBhcyBhbiBhcnJheSBvZiBudW1lcmljIGFycmF5cy4pXG4gICMgICAqIGBkaWRFcnJvcmAge0Z1bmN0aW9ufSBjYWxsIHdpdGggYW4gRXJyb3IgaWYgdGhlcmUgaXMgYSBwcm9ibGVtIGR1cmluZyB0aGUgc2VhcmNoLlxuICAjICAgKiBgZGlkU2VhcmNoUGF0aHNgIHtGdW5jdGlvbn0gcGVyaW9kaWNhbGx5IGNhbGwgd2l0aCB0aGUgbnVtYmVyIG9mIHBhdGhzIHNlYXJjaGVkIHRodXMgZmFyLlxuICAjICAgKiBgaW5jbHVzaW9uc2Age0FycmF5fSBvZiBnbG9iIHBhdHRlcm5zIChhcyBzdHJpbmdzKSB0byBzZWFyY2ggd2l0aGluLiBOb3RlIHRoYXQgdGhpc1xuICAjICAgYXJyYXkgbWF5IGJlIGVtcHR5LCBpbmRpY2F0aW5nIHRoYXQgYWxsIGZpbGVzIHNob3VsZCBiZSBzZWFyY2hlZC5cbiAgI1xuICAjICAgRWFjaCBpdGVtIGluIHRoZSBhcnJheSBpcyBhIGZpbGUvZGlyZWN0b3J5IHBhdHRlcm4sIGUuZy4sIGBzcmNgIHRvIHNlYXJjaCBpbiB0aGUgXCJzcmNcIlxuICAjICAgZGlyZWN0b3J5IG9yIGAqLmpzYCB0byBzZWFyY2ggYWxsIEphdmFTY3JpcHQgZmlsZXMuIEluIHByYWN0aWNlLCB0aGlzIG9mdGVuIGNvbWVzIGZyb20gdGhlXG4gICMgICBjb21tYS1kZWxpbWl0ZWQgbGlzdCBvZiBwYXR0ZXJucyBpbiB0aGUgYm90dG9tIHRleHQgaW5wdXQgb2YgdGhlIFByb2plY3RGaW5kVmlldyBkaWFsb2cuXG4gICMgICAqIGBpZ25vcmVIaWRkZW5gIHtib29sZWFufSB3aGV0aGVyIHRvIGlnbm9yZSBoaWRkZW4gZmlsZXMuXG4gICMgICAqIGBleGNsdWRlVmNzSWdub3Jlc2Age2Jvb2xlYW59IHdoZXRoZXIgdG8gZXhjbHVkZSBWQ1MgaWdub3JlZCBwYXRocy5cbiAgIyAgICogYGV4Y2x1c2lvbnNgIHtBcnJheX0gc2ltaWxhciB0byBpbmNsdXNpb25zXG4gICMgICAqIGBmb2xsb3dgIHtib29sZWFufSB3aGV0aGVyIHN5bWxpbmtzIHNob3VsZCBiZSBmb2xsb3dlZC5cbiAgI1xuICAjIFJldHVybnMgYSAqdGhlbmFibGUqIGBEaXJlY3RvcnlTZWFyY2hgIHRoYXQgaW5jbHVkZXMgYSBgY2FuY2VsKClgIG1ldGhvZC4gSWYgYGNhbmNlbCgpYCBpc1xuICAjIGludm9rZWQgYmVmb3JlIHRoZSBgRGlyZWN0b3J5U2VhcmNoYCBpcyBkZXRlcm1pbmVkLCBpdCB3aWxsIHJlc29sdmUgdGhlIGBEaXJlY3RvcnlTZWFyY2hgLlxuICBzZWFyY2g6IChkaXJlY3RvcmllcywgcmVnZXgsIG9wdGlvbnMpIC0+XG4gICAgcm9vdFBhdGhzID0gZGlyZWN0b3JpZXMubWFwIChkaXJlY3RvcnkpIC0+IGRpcmVjdG9yeS5nZXRQYXRoKClcbiAgICBpc0NhbmNlbGxlZCA9IGZhbHNlXG4gICAgZGlyZWN0b3J5U2VhcmNoID0gbmV3IERpcmVjdG9yeVNlYXJjaChyb290UGF0aHMsIHJlZ2V4LCBvcHRpb25zKVxuICAgIHByb21pc2UgPSBuZXcgUHJvbWlzZSAocmVzb2x2ZSwgcmVqZWN0KSAtPlxuICAgICAgZGlyZWN0b3J5U2VhcmNoLnRoZW4gcmVzb2x2ZSwgLT5cbiAgICAgICAgaWYgaXNDYW5jZWxsZWRcbiAgICAgICAgICByZXNvbHZlKClcbiAgICAgICAgZWxzZVxuICAgICAgICAgIHJlamVjdCgpXG4gICAgcmV0dXJuIHtcbiAgICAgIHRoZW46IHByb21pc2UudGhlbi5iaW5kKHByb21pc2UpXG4gICAgICBjYXRjaDogcHJvbWlzZS5jYXRjaC5iaW5kKHByb21pc2UpXG4gICAgICBjYW5jZWw6IC0+XG4gICAgICAgIGlzQ2FuY2VsbGVkID0gdHJ1ZVxuICAgICAgICBkaXJlY3RvcnlTZWFyY2guY2FuY2VsKClcbiAgICB9XG4iXX0=
