(function() {
  var Decoration, Emitter, _, idCounter, nextId, translateDecorationParamsOldToNew,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  _ = require('underscore-plus');

  Emitter = require('event-kit').Emitter;

  idCounter = 0;

  nextId = function() {
    return idCounter++;
  };

  translateDecorationParamsOldToNew = function(decorationParams) {
    if (decorationParams.type === 'line-number') {
      decorationParams.gutterName = 'line-number';
    }
    return decorationParams;
  };

  module.exports = Decoration = (function() {
    Decoration.isType = function(decorationProperties, type) {
      var ref;
      if (_.isArray(decorationProperties.type)) {
        if (indexOf.call(decorationProperties.type, type) >= 0) {
          return true;
        }
        if (type === 'gutter') {
          if (indexOf.call(decorationProperties.type, 'line-number') >= 0) {
            return true;
          }
        }
        return false;
      } else {
        if (type === 'gutter') {
          if ((ref = decorationProperties.type) === 'gutter' || ref === 'line-number') {
            return true;
          }
        } else {
          return type === decorationProperties.type;
        }
      }
    };


    /*
    Section: Construction and Destruction
     */

    function Decoration(marker, decorationManager, properties) {
      this.marker = marker;
      this.decorationManager = decorationManager;
      this.emitter = new Emitter;
      this.id = nextId();
      this.setProperties(properties);
      this.destroyed = false;
      this.markerDestroyDisposable = this.marker.onDidDestroy((function(_this) {
        return function() {
          return _this.destroy();
        };
      })(this));
    }

    Decoration.prototype.destroy = function() {
      if (this.destroyed) {
        return;
      }
      this.markerDestroyDisposable.dispose();
      this.markerDestroyDisposable = null;
      this.destroyed = true;
      this.decorationManager.didDestroyMarkerDecoration(this);
      this.emitter.emit('did-destroy');
      return this.emitter.dispose();
    };

    Decoration.prototype.isDestroyed = function() {
      return this.destroyed;
    };


    /*
    Section: Event Subscription
     */

    Decoration.prototype.onDidChangeProperties = function(callback) {
      return this.emitter.on('did-change-properties', callback);
    };

    Decoration.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };


    /*
    Section: Decoration Details
     */

    Decoration.prototype.getId = function() {
      return this.id;
    };

    Decoration.prototype.getMarker = function() {
      return this.marker;
    };

    Decoration.prototype.isType = function(type) {
      return Decoration.isType(this.properties, type);
    };


    /*
    Section: Properties
     */

    Decoration.prototype.getProperties = function() {
      return this.properties;
    };

    Decoration.prototype.setProperties = function(newProperties) {
      var oldProperties;
      if (this.destroyed) {
        return;
      }
      oldProperties = this.properties;
      this.properties = translateDecorationParamsOldToNew(newProperties);
      if (newProperties.type != null) {
        this.decorationManager.decorationDidChangeType(this);
      }
      this.decorationManager.emitDidUpdateDecorations();
      return this.emitter.emit('did-change-properties', {
        oldProperties: oldProperties,
        newProperties: newProperties
      });
    };


    /*
    Section: Utility
     */

    Decoration.prototype.inspect = function() {
      return "<Decoration " + this.id + ">";
    };


    /*
    Section: Private methods
     */

    Decoration.prototype.matchesPattern = function(decorationPattern) {
      var key, value;
      if (decorationPattern == null) {
        return false;
      }
      for (key in decorationPattern) {
        value = decorationPattern[key];
        if (this.properties[key] !== value) {
          return false;
        }
      }
      return true;
    };

    Decoration.prototype.flash = function(klass, duration) {
      if (duration == null) {
        duration = 500;
      }
      this.properties.flashRequested = true;
      this.properties.flashClass = klass;
      this.properties.flashDuration = duration;
      this.decorationManager.emitDidUpdateDecorations();
      return this.emitter.emit('did-flash');
    };

    return Decoration;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
