(function() {
  var CommandInstaller, fs, path, runas, symlinkCommand, symlinkCommandWithPrivilegeSync;

  path = require('path');

  fs = require('fs-plus');

  runas = null;

  symlinkCommand = function(sourcePath, destinationPath, callback) {
    return fs.unlink(destinationPath, function(error) {
      if ((error != null) && (error != null ? error.code : void 0) !== 'ENOENT') {
        return callback(error);
      } else {
        return fs.makeTree(path.dirname(destinationPath), function(error) {
          if (error != null) {
            return callback(error);
          } else {
            return fs.symlink(sourcePath, destinationPath, callback);
          }
        });
      }
    });
  };

  symlinkCommandWithPrivilegeSync = function(sourcePath, destinationPath) {
    if (runas == null) {
      runas = require('runas');
    }
    if (runas('/bin/rm', ['-f', destinationPath], {
      admin: true
    }) !== 0) {
      throw new Error("Failed to remove '" + destinationPath + "'");
    }
    if (runas('/bin/mkdir', ['-p', path.dirname(destinationPath)], {
      admin: true
    }) !== 0) {
      throw new Error("Failed to create directory '" + destinationPath + "'");
    }
    if (runas('/bin/ln', ['-s', sourcePath, destinationPath], {
      admin: true
    }) !== 0) {
      throw new Error("Failed to symlink '" + sourcePath + "' to '" + destinationPath + "'");
    }
  };

  module.exports = CommandInstaller = (function() {
    function CommandInstaller(applicationDelegate) {
      this.applicationDelegate = applicationDelegate;
    }

    CommandInstaller.prototype.initialize = function(appVersion) {
      this.appVersion = appVersion;
    };

    CommandInstaller.prototype.getInstallDirectory = function() {
      return "/usr/local/bin";
    };

    CommandInstaller.prototype.getResourcesDirectory = function() {
      return process.resourcesPath;
    };

    CommandInstaller.prototype.installShellCommandsInteractively = function() {
      var showErrorDialog;
      showErrorDialog = (function(_this) {
        return function(error) {
          return _this.applicationDelegate.confirm({
            message: "Failed to install shell commands",
            detailedMessage: error.message
          });
        };
      })(this);
      return this.installAtomCommand(true, (function(_this) {
        return function(error) {
          if (error != null) {
            return showErrorDialog(error);
          } else {
            return _this.installApmCommand(true, function(error) {
              if (error != null) {
                return showErrorDialog(error);
              } else {
                return _this.applicationDelegate.confirm({
                  message: "Commands installed.",
                  detailedMessage: "The shell commands `atom` and `apm` are installed."
                });
              }
            });
          }
        };
      })(this));
    };

    CommandInstaller.prototype.installAtomCommand = function(askForPrivilege, callback) {
      var commandPath, programName;
      programName = this.appVersion.includes("beta") ? "atom-beta" : "atom";
      commandPath = path.join(this.getResourcesDirectory(), 'app', 'atom.sh');
      return this.createSymlink(commandPath, programName, askForPrivilege, callback);
    };

    CommandInstaller.prototype.installApmCommand = function(askForPrivilege, callback) {
      var commandPath, programName;
      programName = this.appVersion.includes("beta") ? "apm-beta" : "apm";
      commandPath = path.join(this.getResourcesDirectory(), 'app', 'apm', 'node_modules', '.bin', 'apm');
      return this.createSymlink(commandPath, programName, askForPrivilege, callback);
    };

    CommandInstaller.prototype.createSymlink = function(commandPath, commandName, askForPrivilege, callback) {
      var destinationPath;
      if (process.platform !== 'darwin') {
        return;
      }
      destinationPath = path.join(this.getInstallDirectory(), commandName);
      return fs.readlink(destinationPath, function(error, realpath) {
        if (realpath === commandPath) {
          callback();
          return;
        }
        return symlinkCommand(commandPath, destinationPath, function(error) {
          var err;
          if (askForPrivilege && (error != null ? error.code : void 0) === 'EACCES') {
            try {
              error = null;
              symlinkCommandWithPrivilegeSync(commandPath, destinationPath);
            } catch (error1) {
              err = error1;
              error = err;
            }
          }
          return typeof callback === "function" ? callback(error) : void 0;
        });
      });
    };

    return CommandInstaller;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
