/** @babel */

var fs = require('fs-plus');
var path = require('path');

var hasWriteAccess = function hasWriteAccess(dir) {
  var testFilePath = path.join(dir, 'write.test');
  try {
    fs.writeFileSync(testFilePath, new Date().toISOString(), { flag: 'w+' });
    fs.unlinkSync(testFilePath);
    return true;
  } catch (err) {
    return false;
  }
};

var getAppDirectory = function getAppDirectory() {
  switch (process.platform) {
    case 'darwin':
      return process.execPath.substring(0, process.execPath.indexOf('.app') + 4);
    case 'linux':
    case 'win32':
      return path.join(process.execPath, '..');
  }
};

module.exports = {
  setAtomHome: function setAtomHome(homePath) {
    // When a read-writeable .atom folder exists above app use that
    var portableHomePath = path.join(getAppDirectory(), '..', '.atom');
    if (fs.existsSync(portableHomePath)) {
      if (hasWriteAccess(portableHomePath)) {
        process.env.ATOM_HOME = portableHomePath;
      } else {
        // A path exists so it was intended to be used but we didn't have rights, so warn.
        console.log('Insufficient permission to portable Atom home "' + portableHomePath + '".');
      }
    }

    // Check ATOM_HOME environment variable next
    if (process.env.ATOM_HOME !== undefined) {
      return;
    }

    // Fall back to default .atom folder in users home folder
    process.env.ATOM_HOME = path.join(homePath, '.atom');
  },

  setUserData: function setUserData(app) {
    var electronUserDataPath = path.join(process.env.ATOM_HOME, 'electronUserData');
    if (fs.existsSync(electronUserDataPath)) {
      if (hasWriteAccess(electronUserDataPath)) {
        app.setPath('userData', electronUserDataPath);
      } else {
        // A path exists so it was intended to be used but we didn't have rights, so warn.
        console.log('Insufficient permission to Electron user data "' + electronUserDataPath + '".');
      }
    }
  },

  getAppDirectory: getAppDirectory
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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