(function() {
  var CompositeDisposable, WrapGuideElement;

  CompositeDisposable = require('atom').CompositeDisposable;

  module.exports = WrapGuideElement = (function() {
    function WrapGuideElement(editor, editorElement) {
      this.editor = editor;
      this.editorElement = editorElement;
      this.element = document.createElement('div');
      this.element.setAttribute('is', 'wrap-guide');
      this.element.classList.add('wrap-guide');
      this.attachToLines();
      this.handleEvents();
      this.updateGuide();
      this.element.updateGuide = this.updateGuide.bind(this);
      this.element.getDefaultColumn = this.getDefaultColumn.bind(this);
    }

    WrapGuideElement.prototype.attachToLines = function() {
      var scrollView;
      scrollView = this.editorElement.querySelector('.scroll-view');
      return scrollView != null ? scrollView.appendChild(this.element) : void 0;
    };

    WrapGuideElement.prototype.handleEvents = function() {
      var configSubscriptions, subscriptions, updateGuideCallback;
      updateGuideCallback = (function(_this) {
        return function() {
          return _this.updateGuide();
        };
      })(this);
      subscriptions = new CompositeDisposable;
      configSubscriptions = this.handleConfigEvents();
      subscriptions.add(atom.config.onDidChange('wrap-guide.columns', updateGuideCallback));
      subscriptions.add(atom.config.onDidChange('editor.fontSize', function() {
        return setTimeout(updateGuideCallback, 0);
      }));
      subscriptions.add(this.editorElement.onDidChangeScrollLeft(updateGuideCallback));
      subscriptions.add(this.editor.onDidChangePath(updateGuideCallback));
      subscriptions.add(this.editor.onDidChangeGrammar((function(_this) {
        return function() {
          configSubscriptions.dispose();
          configSubscriptions = _this.handleConfigEvents();
          return updateGuideCallback();
        };
      })(this)));
      subscriptions.add(this.editor.onDidDestroy(function() {
        subscriptions.dispose();
        return configSubscriptions.dispose();
      }));
      return subscriptions.add(this.editorElement.onDidAttach((function(_this) {
        return function() {
          _this.attachToLines();
          return updateGuideCallback();
        };
      })(this)));
    };

    WrapGuideElement.prototype.handleConfigEvents = function() {
      var subscriptions, updateGuideCallback;
      updateGuideCallback = (function(_this) {
        return function() {
          return _this.updateGuide();
        };
      })(this);
      subscriptions = new CompositeDisposable;
      subscriptions.add(atom.config.onDidChange('editor.preferredLineLength', {
        scope: this.editor.getRootScopeDescriptor()
      }, updateGuideCallback));
      subscriptions.add(atom.config.onDidChange('wrap-guide.enabled', {
        scope: this.editor.getRootScopeDescriptor()
      }, updateGuideCallback));
      return subscriptions;
    };

    WrapGuideElement.prototype.getDefaultColumn = function() {
      return atom.config.get('editor.preferredLineLength', {
        scope: this.editor.getRootScopeDescriptor()
      });
    };

    WrapGuideElement.prototype.getGuideColumn = function(path, scopeName) {
      var column, customColumn, customColumns, i, len, pattern, regex, scope;
      customColumns = atom.config.get('wrap-guide.columns');
      if (!Array.isArray(customColumns)) {
        return this.getDefaultColumn();
      }
      for (i = 0, len = customColumns.length; i < len; i++) {
        customColumn = customColumns[i];
        if (!(typeof customColumn === 'object')) {
          continue;
        }
        pattern = customColumn.pattern, scope = customColumn.scope, column = customColumn.column;
        if (pattern) {
          try {
            regex = new RegExp(pattern);
          } catch (error) {
            continue;
          }
          if (regex.test(path)) {
            return parseInt(column);
          }
        } else if (scope) {
          if (scope === scopeName) {
            return parseInt(column);
          }
        }
      }
      return this.getDefaultColumn();
    };

    WrapGuideElement.prototype.isEnabled = function() {
      var ref;
      return (ref = atom.config.get('wrap-guide.enabled', {
        scope: this.editor.getRootScopeDescriptor()
      })) != null ? ref : true;
    };

    WrapGuideElement.prototype.updateGuide = function() {
      var column, columnWidth;
      column = this.getGuideColumn(this.editor.getPath(), this.editor.getGrammar().scopeName);
      if (column > 0 && this.isEnabled()) {
        columnWidth = this.editorElement.getDefaultCharacterWidth() * column;
        columnWidth -= this.editorElement.getScrollLeft();
        this.element.style.left = (Math.round(columnWidth)) + "px";
        return this.element.style.display = 'block';
      } else {
        return this.element.style.display = 'none';
      }
    };

    return WrapGuideElement;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
