Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom **/

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WelcomeView = (function () {
  function WelcomeView(props) {
    var _this = this;

    _classCallCheck(this, WelcomeView);

    this.props = props;
    _etch2['default'].initialize(this);

    this.element.addEventListener('click', function (event) {
      var link = event.target.closest('a');
      if (link && link.dataset.event) {
        _this.props.reporterProxy.sendEvent('clicked-welcome-' + link.dataset.event + '-link');
      }
    });
  }

  _createClass(WelcomeView, [{
    key: 'didChangeShowOnStartup',
    value: function didChangeShowOnStartup() {
      atom.config.set('welcome.showOnStartup', this.checked);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: 'WelcomeView',
        uri: this.props.uri
      };
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'welcome' },
        _etch2['default'].dom(
          'div',
          { className: 'welcome-container' },
          _etch2['default'].dom(
            'header',
            { className: 'welcome-header' },
            _etch2['default'].dom(
              'a',
              { href: 'https://atom.io/' },
              _etch2['default'].dom(
                'svg',
                { className: 'welcome-logo', width: '330px', height: '68px', viewBox: '0 0 330 68', version: '1.1' },
                _etch2['default'].dom(
                  'g',
                  { stroke: 'none', 'stroke-width': '1', fill: 'none', 'fill-rule': 'evenodd' },
                  _etch2['default'].dom(
                    'g',
                    { transform: 'translate(2.000000, 1.000000)' },
                    _etch2['default'].dom(
                      'g',
                      { transform: 'translate(96.000000, 8.000000)', fill: 'currentColor' },
                      _etch2['default'].dom('path', { d: 'M185.498,3.399 C185.498,2.417 186.34,1.573 187.324,1.573 L187.674,1.573 C188.447,1.573 189.01,1.995 189.5,2.628 L208.676,30.862 L227.852,2.628 C228.272,1.995 228.905,1.573 229.676,1.573 L230.028,1.573 C231.01,1.573 231.854,2.417 231.854,3.399 L231.854,49.403 C231.854,50.387 231.01,51.231 230.028,51.231 C229.044,51.231 228.202,50.387 228.202,49.403 L228.202,8.246 L210.151,34.515 C209.729,35.148 209.237,35.428 208.606,35.428 C207.973,35.428 207.481,35.148 207.061,34.515 L189.01,8.246 L189.01,49.475 C189.01,50.457 188.237,51.231 187.254,51.231 C186.27,51.231 185.498,50.458 185.498,49.475 L185.498,3.399 L185.498,3.399 Z' }),
                      _etch2['default'].dom('path', { d: 'M113.086,26.507 L113.086,26.367 C113.086,12.952 122.99,0.941 137.881,0.941 C152.77,0.941 162.533,12.811 162.533,26.225 L162.533,26.367 C162.533,39.782 152.629,51.792 137.74,51.792 C122.85,51.792 113.086,39.923 113.086,26.507 M158.74,26.507 L158.74,26.367 C158.74,14.216 149.89,4.242 137.74,4.242 C125.588,4.242 116.879,14.075 116.879,26.225 L116.879,26.367 C116.879,38.518 125.729,48.491 137.881,48.491 C150.031,48.491 158.74,38.658 158.74,26.507' }),
                      _etch2['default'].dom('path', { d: 'M76.705,5.155 L60.972,5.155 C60.06,5.155 59.287,4.384 59.287,3.469 C59.287,2.556 60.059,1.783 60.972,1.783 L96.092,1.783 C97.004,1.783 97.778,2.555 97.778,3.469 C97.778,4.383 97.005,5.155 96.092,5.155 L80.358,5.155 L80.358,49.405 C80.358,50.387 79.516,51.231 78.532,51.231 C77.55,51.231 76.706,50.387 76.706,49.405 L76.706,5.155 L76.705,5.155 Z' }),
                      _etch2['default'].dom('path', { d: 'M0.291,48.562 L21.291,3.05 C21.783,1.995 22.485,1.292 23.75,1.292 L23.891,1.292 C25.155,1.292 25.858,1.995 26.348,3.05 L47.279,48.421 C47.49,48.843 47.56,49.194 47.56,49.546 C47.56,50.458 46.788,51.231 45.803,51.231 C44.961,51.231 44.329,50.599 43.978,49.826 L38.219,37.183 L9.21,37.183 L3.45,49.897 C3.099,50.739 2.538,51.231 1.694,51.231 C0.781,51.231 0.008,50.529 0.008,49.685 C0.009,49.404 0.08,48.983 0.291,48.562 L0.291,48.562 Z M36.673,33.882 L23.749,5.437 L10.755,33.882 L36.673,33.882 L36.673,33.882 Z' })
                    ),
                    _etch2['default'].dom(
                      'g',
                      null,
                      _etch2['default'].dom('path', { d: 'M40.363,32.075 C40.874,34.44 39.371,36.77 37.006,37.282 C34.641,37.793 32.311,36.29 31.799,33.925 C31.289,31.56 32.791,29.23 35.156,28.718 C37.521,28.207 39.851,29.71 40.363,32.075', fill: 'currentColor' }),
                      _etch2['default'].dom('path', { d: 'M48.578,28.615 C56.851,45.587 58.558,61.581 52.288,64.778 C45.822,68.076 33.326,56.521 24.375,38.969 C15.424,21.418 13.409,4.518 19.874,1.221 C22.689,-0.216 26.648,1.166 30.959,4.629', stroke: 'currentColor', 'stroke-width': '3.08', 'stroke-linecap': 'round' }),
                      _etch2['default'].dom('path', { d: 'M7.64,39.45 C2.806,36.94 -0.009,33.915 0.154,30.79 C0.531,23.542 16.787,18.497 36.462,19.52 C56.137,20.544 71.781,27.249 71.404,34.497 C71.241,37.622 68.127,40.338 63.06,42.333', stroke: 'currentColor', 'stroke-width': '3.08', 'stroke-linecap': 'round' }),
                      _etch2['default'].dom('path', { d: 'M28.828,59.354 C23.545,63.168 18.843,64.561 15.902,62.653 C9.814,58.702 13.572,42.102 24.296,25.575 C35.02,9.048 48.649,-1.149 54.736,2.803 C57.566,4.639 58.269,9.208 57.133,15.232', stroke: 'currentColor', 'stroke-width': '3.08', 'stroke-linecap': 'round' })
                    )
                  )
                )
              ),
              _etch2['default'].dom(
                'h1',
                { className: 'welcome-title' },
                'A hackable text editor for the 21',
                _etch2['default'].dom(
                  'sup',
                  null,
                  'st'
                ),
                ' Century'
              )
            )
          ),
          _etch2['default'].dom(
            'section',
            { className: 'welcome-panel' },
            _etch2['default'].dom(
              'p',
              null,
              'For help, please visit'
            ),
            _etch2['default'].dom(
              'ul',
              null,
              _etch2['default'].dom(
                'li',
                null,
                'The ',
                _etch2['default'].dom(
                  'a',
                  { href: 'https://www.atom.io/docs', dataset: { event: 'atom-docs' } },
                  'Atom docs'
                ),
                ' for Guides and the API reference.'
              ),
              _etch2['default'].dom(
                'li',
                null,
                'The Atom forum at ',
                _etch2['default'].dom(
                  'a',
                  { href: 'http://discuss.atom.io', dataset: { event: 'discuss' } },
                  'discuss.atom.io'
                )
              ),
              _etch2['default'].dom(
                'li',
                null,
                'The ',
                _etch2['default'].dom(
                  'a',
                  { href: 'https://github.com/atom', dataset: { event: 'atom-org' } },
                  'Atom org'
                ),
                '. This is where all GitHub-created Atom packages can be found.'
              )
            )
          ),
          _etch2['default'].dom(
            'section',
            { className: 'welcome-panel' },
            _etch2['default'].dom('input', { className: 'input-checkbox', type: 'checkbox', id: 'show-welcome-on-startup', checked: atom.config.get('welcome.showOnStartup'), onchange: this.didChangeShowOnStartup }),
            _etch2['default'].dom(
              'label',
              { 'for': 'show-welcome-on-startup' },
              'Show Welcome Guide when opening Atom'
            )
          ),
          _etch2['default'].dom(
            'footer',
            { className: 'welcome-footer' },
            _etch2['default'].dom(
              'a',
              { href: 'https://atom.io/', dataset: { event: 'footer-atom-io' } },
              'atom.io'
            ),
            ' ',
            _etch2['default'].dom(
              'span',
              { className: 'text-subtle' },
              '×'
            ),
            ' ',
            _etch2['default'].dom('a', { className: 'icon icon-octoface', href: 'https://github.com/', dataset: { event: 'footer-octocat' } })
          )
        )
      );
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.props.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Welcome';
    }
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      other instanceof WelcomeView;
    }
  }]);

  return WelcomeView;
})();

exports['default'] = WelcomeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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