(function() {
  var Dialog, MoveDialog, fs, path, repoForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  repoForPath = require("./helpers").repoForPath;

  module.exports = MoveDialog = (function(superClass) {
    extend(MoveDialog, superClass);

    function MoveDialog(initialPath, arg) {
      var prompt;
      this.initialPath = initialPath;
      this.onMove = arg.onMove;
      if (fs.isDirectorySync(this.initialPath)) {
        prompt = 'Enter the new path for the directory.';
      } else {
        prompt = 'Enter the new path for the file.';
      }
      MoveDialog.__super__.constructor.call(this, {
        prompt: prompt,
        initialPath: atom.project.relativize(this.initialPath),
        select: true,
        iconClass: 'icon-arrow-right'
      });
    }

    MoveDialog.prototype.onConfirm = function(newPath) {
      var directoryPath, error, repo, rootPath;
      newPath = newPath.replace(/\s+$/, '');
      if (!path.isAbsolute(newPath)) {
        rootPath = atom.project.relativizePath(this.initialPath)[0];
        newPath = path.join(rootPath, newPath);
        if (!newPath) {
          return;
        }
      }
      if (this.initialPath === newPath) {
        this.close();
        return;
      }
      if (!this.isNewPathValid(newPath)) {
        this.showError("'" + newPath + "' already exists.");
        return;
      }
      directoryPath = path.dirname(newPath);
      try {
        if (!fs.existsSync(directoryPath)) {
          fs.makeTreeSync(directoryPath);
        }
        fs.moveSync(this.initialPath, newPath);
        if (typeof this.onMove === "function") {
          this.onMove({
            initialPath: this.initialPath,
            newPath: newPath
          });
        }
        if (repo = repoForPath(newPath)) {
          repo.getPathStatus(this.initialPath);
          repo.getPathStatus(newPath);
        }
        return this.close();
      } catch (error1) {
        error = error1;
        return this.showError(error.message + ".");
      }
    };

    MoveDialog.prototype.isNewPathValid = function(newPath) {
      var newStat, oldStat;
      try {
        oldStat = fs.statSync(this.initialPath);
        newStat = fs.statSync(newPath);
        return this.initialPath.toLowerCase() === newPath.toLowerCase() && oldStat.dev === newStat.dev && oldStat.ino === newStat.ino;
      } catch (error1) {
        return true;
      }
    };

    return MoveDialog;

  })(Dialog);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
