(function() {
  var CompositeDisposable, FileIcons, FileView;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  FileIcons = require('./file-icons');

  module.exports = FileView = (function() {
    function FileView(file) {
      var iconClass, ref;
      this.file = file;
      this.subscriptions = new CompositeDisposable();
      this.subscriptions.add(this.file.onDidDestroy((function(_this) {
        return function() {
          return _this.subscriptions.dispose();
        };
      })(this)));
      this.element = document.createElement('li');
      this.element.setAttribute('is', 'tree-view-file');
      this.element.draggable = true;
      this.element.classList.add('file', 'entry', 'list-item');
      this.fileName = document.createElement('span');
      this.fileName.classList.add('name', 'icon');
      this.element.appendChild(this.fileName);
      this.fileName.textContent = this.file.name;
      this.fileName.title = this.file.name;
      this.fileName.dataset.name = this.file.name;
      this.fileName.dataset.path = this.file.path;
      iconClass = FileIcons.getService().iconClassForPath(this.file.path, "tree-view");
      if (iconClass) {
        if (!Array.isArray(iconClass)) {
          iconClass = iconClass.toString().split(/\s+/g);
        }
        (ref = this.fileName.classList).add.apply(ref, iconClass);
      }
      this.subscriptions.add(this.file.onDidStatusChange((function(_this) {
        return function() {
          return _this.updateStatus();
        };
      })(this)));
      this.updateStatus();
      this.element.getPath = this.getPath.bind(this);
      this.element.isPathEqual = this.isPathEqual.bind(this);
      this.element.file = this.file;
      this.element.fileName = this.fileName;
      this.element.updateStatus = this.updateStatus.bind(this);
    }

    FileView.prototype.updateStatus = function() {
      this.element.classList.remove('status-ignored', 'status-modified', 'status-added');
      if (this.file.status != null) {
        return this.element.classList.add("status-" + this.file.status);
      }
    };

    FileView.prototype.getPath = function() {
      return this.fileName.dataset.path;
    };

    FileView.prototype.isPathEqual = function(pathToCompare) {
      return this.file.isPathEqual(pathToCompare);
    };

    return FileView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
