Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var PackagePanelView = (function () {
  function PackagePanelView(_ref) {
    var _this = this;

    var title = _ref.title;

    _classCallCheck(this, PackagePanelView);

    this.title = title;
    _etch2['default'].initialize(this);

    var clickHandler = function clickHandler(event) {
      var target = event.target.closest('a.package');
      if (target) {
        atom.workspace.open('atom://config/packages/' + target.dataset['package']);
      }
    };
    this.element.addEventListener('click', clickHandler);
    this.disposable = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(PackagePanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposable.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            this.title
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom('div', { className: 'text-info', ref: 'summary' }),
            _etch2['default'].dom('ul', { className: 'list-group', ref: 'list' })
          )
        )
      );
    }
  }, {
    key: 'addPackages',
    value: function addPackages(packages, timeKey) {
      for (var pack of packages) {
        this.addPackage(pack, timeKey);
      }
    }
  }, {
    key: 'addPackage',
    value: function addPackage(pack, timeKey) {
      var li = document.createElement('div');
      li.classList.add('list-item');

      var a = document.createElement('a');
      a.classList.add('inline-block', 'package');
      a.dataset['package'] = pack.name;
      a.textContent = pack.name;
      li.appendChild(a);

      var line = document.createElement('span');
      line.classList.add('timecop-line');
      li.appendChild(line);

      var timeSpan = document.createElement('span');
      timeSpan.classList.add('inline-block', pack[timeKey] > 25 ? 'highlight-error' : 'highlight-warning');
      timeSpan.textContent = pack[timeKey] + 'ms';
      li.appendChild(timeSpan);

      this.refs.list.appendChild(li);
    }
  }]);

  return PackagePanelView;
})();

exports['default'] = PackagePanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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