(function() {
  var TimecopView, ViewURI;

  TimecopView = null;

  ViewURI = 'atom://timecop';

  module.exports = {
    activate: function() {
      atom.workspace.addOpener((function(_this) {
        return function(filePath) {
          if (filePath === ViewURI) {
            return _this.createTimecopView({
              uri: ViewURI
            });
          }
        };
      })(this));
      return atom.commands.add('atom-workspace', 'timecop:view', function() {
        return atom.workspace.open(ViewURI);
      });
    },
    createTimecopView: function(state) {
      if (TimecopView == null) {
        TimecopView = require('./timecop-view');
      }
      return new TimecopView(state);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy90aW1lY29wL2xpYi9tYWluLmNvZmZlZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUFBLE1BQUE7O0VBQUEsV0FBQSxHQUFjOztFQUNkLE9BQUEsR0FBVTs7RUFFVixNQUFNLENBQUMsT0FBUCxHQUNFO0lBQUEsUUFBQSxFQUFVLFNBQUE7TUFDUixJQUFJLENBQUMsU0FBUyxDQUFDLFNBQWYsQ0FBeUIsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLFFBQUQ7VUFDdkIsSUFBb0MsUUFBQSxLQUFZLE9BQWhEO21CQUFBLEtBQUMsQ0FBQSxpQkFBRCxDQUFtQjtjQUFBLEdBQUEsRUFBSyxPQUFMO2FBQW5CLEVBQUE7O1FBRHVCO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUF6QjthQUdBLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixnQkFBbEIsRUFBb0MsY0FBcEMsRUFBb0QsU0FBQTtlQUNsRCxJQUFJLENBQUMsU0FBUyxDQUFDLElBQWYsQ0FBb0IsT0FBcEI7TUFEa0QsQ0FBcEQ7SUFKUSxDQUFWO0lBT0EsaUJBQUEsRUFBbUIsU0FBQyxLQUFEOztRQUNqQixjQUFlLE9BQUEsQ0FBUSxnQkFBUjs7YUFDWCxJQUFBLFdBQUEsQ0FBWSxLQUFaO0lBRmEsQ0FQbkI7O0FBSkYiLCJzb3VyY2VzQ29udGVudCI6WyJUaW1lY29wVmlldyA9IG51bGxcblZpZXdVUkkgPSAnYXRvbTovL3RpbWVjb3AnXG5cbm1vZHVsZS5leHBvcnRzID1cbiAgYWN0aXZhdGU6IC0+XG4gICAgYXRvbS53b3Jrc3BhY2UuYWRkT3BlbmVyIChmaWxlUGF0aCkgPT5cbiAgICAgIEBjcmVhdGVUaW1lY29wVmlldyh1cmk6IFZpZXdVUkkpIGlmIGZpbGVQYXRoIGlzIFZpZXdVUklcblxuICAgIGF0b20uY29tbWFuZHMuYWRkICdhdG9tLXdvcmtzcGFjZScsICd0aW1lY29wOnZpZXcnLCAtPlxuICAgICAgYXRvbS53b3Jrc3BhY2Uub3BlbihWaWV3VVJJKVxuXG4gIGNyZWF0ZVRpbWVjb3BWaWV3OiAoc3RhdGUpIC0+XG4gICAgVGltZWNvcFZpZXcgPz0gcmVxdWlyZSAnLi90aW1lY29wLXZpZXcnXG4gICAgbmV3IFRpbWVjb3BWaWV3KHN0YXRlKVxuIl19
