Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var _fileIcons = require('./file-icons');

var _fileIcons2 = _interopRequireDefault(_fileIcons);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

'use babel';

var MRUItemView = (function () {
  function MRUItemView() {
    _classCallCheck(this, MRUItemView);
  }

  _createClass(MRUItemView, [{
    key: 'initialize',
    value: function initialize(listView, item) {
      this.listView = listView;
      this.item = item;

      this.element = document.createElement('li');
      this.element.itemViewData = this;
      this.element.classList.add('two-lines');

      var itemPath = null;
      if (item.getPath && typeof item.getPath === 'function') {
        itemPath = item.getPath();
      }

      var repo = MRUItemView.repositoryForPath(itemPath);
      if (repo != null) {
        var statusIconDiv = document.createElement('div');
        var _status = repo.getCachedPathStatus(itemPath);
        if (repo.isStatusNew(_status)) {
          statusIconDiv.className = 'status status-added icon icon-diff-added';
          this.element.appendChild(statusIconDiv);
        } else if (repo.isStatusModified(_status)) {
          statusIconDiv.className = 'status status-modified icon icon-diff-modified';
          this.element.appendChild(statusIconDiv);
        }
      }

      var firstLineDiv = this.element.appendChild(document.createElement('div'));
      firstLineDiv.classList.add('primary-line', 'file');
      if (typeof item.getIconName === 'function') {
        if (atom.config.get('tabs.showIcons')) firstLineDiv.classList.add('icon', 'icon-' + item.getIconName());
      } else {
        var typeClasses = _fileIcons2['default'].getService().iconClassForPath(itemPath, 'tabs-mru-switcher');
        if (typeClasses) {
          var _firstLineDiv$classList;

          if (!Array.isArray(typeClasses)) typeClasses = typeClasses.split(/\s+/g);
          if (typeClasses) (_firstLineDiv$classList = firstLineDiv.classList).add.apply(_firstLineDiv$classList, ['icon'].concat(_toConsumableArray(typeClasses)));
        }
      }
      firstLineDiv.setAttribute('data-name', item.getTitle());
      firstLineDiv.innerText = item.getTitle();

      if (itemPath) {
        firstLineDiv.setAttribute('data-path', itemPath);
        var secondLineDiv = this.element.appendChild(document.createElement('div'));
        secondLineDiv.classList.add('secondary-line', 'path', 'no-icon');
        secondLineDiv.innerText = itemPath;
      }
    }
  }, {
    key: 'select',
    value: function select() {
      this.element.classList.add('selected');
    }
  }, {
    key: 'unselect',
    value: function unselect() {
      this.element.classList.remove('selected');
    }
  }], [{
    key: 'repositoryForPath',
    value: function repositoryForPath(filePath) {
      if (filePath) {
        var projectPaths = atom.project.getPaths();
        for (var i = 0; i < projectPaths.length; i++) {
          if (filePath === projectPaths[i] || filePath.startsWith(projectPaths[i] + _path2['default'].sep)) {
            return atom.project.getRepositories()[i];
          }
        }
      }
      return null;
    }
  }]);

  return MRUItemView;
})();

exports['default'] = MRUItemView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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