(function() {
  var itemIsAllowedInPane,
    indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  module.exports = {
    activate: function() {
      this.view = document.createElement('div');
      atom.workspace.getElement().appendChild(this.view);
      return this.view.classList.add('tabs-layout-overlay');
    },
    deactivate: function() {
      var ref;
      return (ref = this.view.parentElement) != null ? ref.removeChild(this.view) : void 0;
    },
    test: {},
    drag: function(e) {
      var coords, item, itemView, pane;
      this.lastCoords = e;
      pane = this.getPaneAt(e);
      itemView = this.getItemViewAt(e);
      item = e.target.item;
      if ((pane != null) && (itemView != null) && item && itemIsAllowedInPane(item, pane)) {
        coords = !(this.isOnlyTabInPane(pane, e.target) || pane.getItems().length === 0) ? [e.clientX, e.clientY] : void 0;
        return this.lastSplit = this.updateView(itemView, coords);
      } else {
        return this.disableView();
      }
    },
    end: function(e) {
      var fromPane, item, tab, target, toPane;
      this.disableView();
      if (!((this.lastCoords != null) && this.getItemViewAt(this.lastCoords))) {
        return;
      }
      target = this.getPaneAt(this.lastCoords);
      if (target == null) {
        return;
      }
      tab = e.target;
      fromPane = tab.pane;
      item = tab.item;
      if (!itemIsAllowedInPane(item, typeof toPane !== "undefined" && toPane !== null ? toPane : target)) {
        return;
      }
      toPane = (function() {
        switch (this.lastSplit) {
          case 'left':
            return target.splitLeft();
          case 'right':
            return target.splitRight();
          case 'up':
            return target.splitUp();
          case 'down':
            return target.splitDown();
        }
      }).call(this);
      if (toPane == null) {
        toPane = target;
      }
      if (toPane === fromPane) {
        return;
      }
      fromPane.moveItemToPane(item, toPane);
      toPane.activateItem(item);
      return toPane.activate();
    },
    getElement: function(arg, selector) {
      var clientX, clientY;
      clientX = arg.clientX, clientY = arg.clientY;
      if (selector == null) {
        selector = '*';
      }
      return document.elementFromPoint(clientX, clientY).closest(selector);
    },
    getItemViewAt: function(coords) {
      return this.test.itemView || this.getElement(coords, '.item-views');
    },
    getPaneAt: function(coords) {
      var ref;
      return this.test.pane || ((ref = this.getElement(this.lastCoords, 'atom-pane')) != null ? ref.getModel() : void 0);
    },
    isOnlyTabInPane: function(pane, tab) {
      return pane.getItems().length === 1 && pane === tab.pane;
    },
    normalizeCoords: function(arg, arg1) {
      var height, left, top, width, x, y;
      left = arg.left, top = arg.top, width = arg.width, height = arg.height;
      x = arg1[0], y = arg1[1];
      return [(x - left) / width, (y - top) / height];
    },
    splitType: function(arg) {
      var x, y;
      x = arg[0], y = arg[1];
      if (x < 1 / 3) {
        return 'left';
      } else if (x > 2 / 3) {
        return 'right';
      } else if (y < 1 / 3) {
        return 'up';
      } else if (y > 2 / 3) {
        return 'down';
      }
    },
    boundsForSplit: function(split) {
      var h, ref, w, x, y;
      return ref = (function() {
        switch (split) {
          case 'left':
            return [0, 0, 0.5, 1];
          case 'right':
            return [0.5, 0, 0.5, 1];
          case 'up':
            return [0, 0, 1, 0.5];
          case 'down':
            return [0, 0.5, 1, 0.5];
          default:
            return [0, 0, 1, 1];
        }
      })(), x = ref[0], y = ref[1], w = ref[2], h = ref[3], ref;
    },
    innerBounds: function(arg, arg1) {
      var h, height, left, top, w, width, x, y;
      left = arg.left, top = arg.top, width = arg.width, height = arg.height;
      x = arg1[0], y = arg1[1], w = arg1[2], h = arg1[3];
      left += x * width;
      top += y * height;
      width *= w;
      height *= h;
      return {
        left: left,
        top: top,
        width: width,
        height: height
      };
    },
    updateViewBounds: function(arg) {
      var height, left, top, width;
      left = arg.left, top = arg.top, width = arg.width, height = arg.height;
      this.view.style.left = left + "px";
      this.view.style.top = top + "px";
      this.view.style.width = width + "px";
      return this.view.style.height = height + "px";
    },
    updateView: function(pane, coords) {
      var rect, split;
      this.view.classList.add('visible');
      rect = this.test.rect || pane.getBoundingClientRect();
      split = coords ? this.splitType(this.normalizeCoords(rect, coords)) : void 0;
      this.updateViewBounds(this.innerBounds(rect, this.boundsForSplit(split)));
      return split;
    },
    disableView: function() {
      return this.view.classList.remove('visible');
    }
  };

  itemIsAllowedInPane = function(item, pane) {
    var allowedLocations, container, location, ref;
    allowedLocations = typeof item.getAllowedLocations === "function" ? item.getAllowedLocations() : void 0;
    if (allowedLocations == null) {
      return true;
    }
    container = pane.getContainer();
    location = (ref = typeof container.getLocation === "function" ? container.getLocation() : void 0) != null ? ref : 'center';
    return indexOf.call(allowedLocations, location) >= 0;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
