Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var TagGenerator = (function () {
  function TagGenerator(path1, scopeName) {
    _classCallCheck(this, TagGenerator);

    this.path = path1;
    this.scopeName = scopeName;
  }

  _createClass(TagGenerator, [{
    key: 'getPackageRoot',
    value: function getPackageRoot() {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      var currentFileWasRequiredFromSnapshot = !_fsPlus2['default'].isAbsolute(__dirname);
      if (currentFileWasRequiredFromSnapshot) {
        return _path2['default'].join(resourcePath, 'node_modules', 'symbols-view');
      } else {
        var packageRoot = _path2['default'].resolve(__dirname, '..');
        if (_path2['default'].extname(resourcePath) === '.asar') {
          if (packageRoot.indexOf(resourcePath) === 0) {
            return _path2['default'].join(resourcePath + '.unpacked', 'node_modules', 'symbols-view');
          }
        }
        return packageRoot;
      }
    }
  }, {
    key: 'parseTagLine',
    value: function parseTagLine(line) {
      var sections = line.split('\t');
      if (sections.length > 3) {
        return {
          position: new _atom.Point(parseInt(sections[2], 10) - 1),
          name: sections[0]
        };
      }
      return null;
    }
  }, {
    key: 'getLanguage',
    value: function getLanguage() {
      if (['.cson', '.gyp'].includes(_path2['default'].extname(this.path))) {
        return 'Cson';
      }

      switch (this.scopeName) {
        case 'source.c':
          return 'C';
        case 'source.cpp':
          return 'C++';
        case 'source.clojure':
          return 'Lisp';
        case 'source.capnp':
          return 'Capnp';
        case 'source.coffee':
          return 'CoffeeScript';
        case 'source.css':
          return 'Css';
        case 'source.css.less':
          return 'Css';
        case 'source.css.scss':
          return 'Css';
        case 'source.elixir':
          return 'Elixir';
        case 'source.fountain':
          return 'Fountain';
        case 'source.gfm':
          return 'Markdown';
        case 'source.go':
          return 'Go';
        case 'source.java':
          return 'Java';
        case 'source.js':
          return 'JavaScript';
        case 'source.js.jsx':
          return 'JavaScript';
        case 'source.jsx':
          return 'JavaScript';
        case 'source.json':
          return 'Json';
        case 'source.julia':
          return 'Julia';
        case 'source.makefile':
          return 'Make';
        case 'source.objc':
          return 'C';
        case 'source.objcpp':
          return 'C++';
        case 'source.python':
          return 'Python';
        case 'source.ruby':
          return 'Ruby';
        case 'source.sass':
          return 'Sass';
        case 'source.yaml':
          return 'Yaml';
        case 'text.html':
          return 'Html';
        case 'text.html.php':
          return 'Php';
        case 'text.tex.latex':
          return 'Latex';
      }
      return undefined;
    }
  }, {
    key: 'generate',
    value: function generate() {
      var _this = this;

      var tags = {};
      var packageRoot = this.getPackageRoot();
      var command = _path2['default'].join(packageRoot, 'vendor', 'ctags-' + process.platform);
      var defaultCtagsFile = _path2['default'].join(packageRoot, 'lib', 'ctags-config');
      var args = ['--options=' + defaultCtagsFile, '--fields=+KS'];

      if (atom.config.get('symbols-view.useEditorGrammarAsCtagsLanguage')) {
        var language = this.getLanguage();
        if (language) {
          args.push('--language-force=' + language);
        }
      }

      args.push('-nf', '-', this.path);

      return new Promise(function (resolve) {
        var result = undefined,
            tag = undefined;
        return new _atom.BufferedProcess({
          command: command,
          args: args,
          stdout: function stdout(lines) {
            return (function () {
              result = [];
              for (var line of Array.from(lines.split('\n'))) {
                var item = undefined;
                if (tag = _this.parseTagLine(line)) {
                  item = tags[tag.position.row] ? tags[tag.position.row] : tags[tag.position.row] = tag;
                }
                result.push(item);
              }
              return result;
            })();
          },
          stderr: function stderr() {},
          exit: function exit() {
            tags = (function () {
              result = [];
              for (var row in tags) {
                tag = tags[row];
                result.push(tag);
              }
              return result;
            })();
            return resolve(tags);
          }
        });
      });
    }
  }]);

  return TagGenerator;
})();

exports['default'] = TagGenerator;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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