Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

exports['default'] = {
  activate: function activate() {
    var _this = this;

    this.stack = [];

    this.workspaceSubscription = atom.commands.add('atom-workspace', {
      'symbols-view:toggle-project-symbols': function symbolsViewToggleProjectSymbols() {
        _this.createProjectView().toggle();
      }
    });

    this.editorSubscription = atom.commands.add('atom-text-editor', {
      'symbols-view:toggle-file-symbols': function symbolsViewToggleFileSymbols() {
        _this.createFileView().toggle();
      },
      'symbols-view:go-to-declaration': function symbolsViewGoToDeclaration() {
        _this.createGoToView().toggle();
      },
      'symbols-view:return-from-declaration': function symbolsViewReturnFromDeclaration() {
        _this.createGoBackView().toggle();
      }
    });
  },

  deactivate: function deactivate() {
    if (this.fileView != null) {
      this.fileView.destroy();
      this.fileView = null;
    }

    if (this.projectView != null) {
      this.projectView.destroy();
      this.projectView = null;
    }

    if (this.goToView != null) {
      this.goToView.destroy();
      this.goToView = null;
    }

    if (this.goBackView != null) {
      this.goBackView.destroy();
      this.goBackView = null;
    }

    if (this.workspaceSubscription != null) {
      this.workspaceSubscription.dispose();
      this.workspaceSubscription = null;
    }

    if (this.editorSubscription != null) {
      this.editorSubscription.dispose();
      this.editorSubscription = null;
    }
  },

  createFileView: function createFileView() {
    if (this.fileView) {
      return this.fileView;
    }
    var FileView = require('./file-view');
    this.fileView = new FileView(this.stack);
    return this.fileView;
  },

  createProjectView: function createProjectView() {
    if (this.projectView) {
      return this.projectView;
    }
    var ProjectView = require('./project-view');
    this.projectView = new ProjectView(this.stack);
    return this.projectView;
  },

  createGoToView: function createGoToView() {
    if (this.goToView) {
      return this.goToView;
    }
    var GoToView = require('./go-to-view');
    this.goToView = new GoToView(this.stack);
    return this.goToView;
  },

  createGoBackView: function createGoBackView() {
    if (this.goBackView) {
      return this.goBackView;
    }
    var GoBackView = require('./go-back-view');
    this.goBackView = new GoBackView(this.stack);
    return this.goBackView;
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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