Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _symbolsView = require('./symbols-view');

var _symbolsView2 = _interopRequireDefault(_symbolsView);

var _tagGenerator = require('./tag-generator');

var _tagGenerator2 = _interopRequireDefault(_tagGenerator);

var _fuzzaldrin = require('fuzzaldrin');

var FileView = (function (_SymbolsView) {
  _inherits(FileView, _SymbolsView);

  function FileView(stack) {
    var _this = this;

    _classCallCheck(this, FileView);

    _get(Object.getPrototypeOf(FileView.prototype), 'constructor', this).call(this, stack);
    this.cachedTags = {};

    this.editorsSubscription = atom.workspace.observeTextEditors(function (editor) {
      var removeFromCache = function removeFromCache() {
        delete _this.cachedTags[editor.getPath()];
      };
      var editorSubscriptions = new _atom.CompositeDisposable();
      editorSubscriptions.add(editor.onDidChangeGrammar(removeFromCache));
      editorSubscriptions.add(editor.onDidSave(removeFromCache));
      editorSubscriptions.add(editor.onDidChangePath(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidReload(removeFromCache));
      editorSubscriptions.add(editor.getBuffer().onDidDestroy(removeFromCache));
      editor.onDidDestroy(function () {
        editorSubscriptions.dispose();
      });
    });
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.editorsSubscription.dispose();
      return _get(Object.getPrototypeOf(FileView.prototype), 'destroy', this).call(this);
    }
  }, {
    key: 'elementForItem',
    value: function elementForItem(_ref) {
      var position = _ref.position;
      var name = _ref.name;

      // Style matched characters in search results
      var matches = (0, _fuzzaldrin.match)(name, this.selectListView.getFilterQuery());

      var li = document.createElement('li');
      li.classList.add('two-lines');

      var primaryLine = document.createElement('div');
      primaryLine.classList.add('primary-line');
      primaryLine.appendChild(_symbolsView2['default'].highlightMatches(this, name, matches));
      li.appendChild(primaryLine);

      var secondaryLine = document.createElement('div');
      secondaryLine.classList.add('secondary-line');
      secondaryLine.textContent = 'Line ' + (position.row + 1);
      li.appendChild(secondaryLine);

      return li;
    }
  }, {
    key: 'didChangeSelection',
    value: function didChangeSelection(item) {
      if (atom.config.get('symbols-view.quickJumpToFileSymbol') && item) {
        this.openTag(item);
      }
    }
  }, {
    key: 'didCancelSelection',
    value: _asyncToGenerator(function* () {
      yield this.cancel();
      var editor = this.getEditor();
      if (this.initialState && editor) {
        this.deserializeEditorState(editor, this.initialState);
      }
      this.initialState = null;
    })
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel.isVisible()) {
        yield this.cancel();
      }
      var filePath = this.getPath();
      if (filePath) {
        var editor = this.getEditor();
        if (atom.config.get('symbols-view.quickJumpToFileSymbol') && editor) {
          this.initialState = this.serializeEditorState(editor);
        }
        this.populate(filePath);
        this.attach();
      }
    })
  }, {
    key: 'serializeEditorState',
    value: function serializeEditorState(editor) {
      var editorElement = atom.views.getView(editor);
      var scrollTop = editorElement.getScrollTop();

      return {
        bufferRanges: editor.getSelectedBufferRanges(),
        scrollTop: scrollTop
      };
    }
  }, {
    key: 'deserializeEditorState',
    value: function deserializeEditorState(editor, _ref2) {
      var bufferRanges = _ref2.bufferRanges;
      var scrollTop = _ref2.scrollTop;

      var editorElement = atom.views.getView(editor);

      editor.setSelectedBufferRanges(bufferRanges);
      editorElement.setScrollTop(scrollTop);
    }
  }, {
    key: 'getEditor',
    value: function getEditor() {
      return atom.workspace.getActiveTextEditor();
    }
  }, {
    key: 'getPath',
    value: function getPath() {
      if (this.getEditor()) {
        return this.getEditor().getPath();
      }
      return undefined;
    }
  }, {
    key: 'getScopeName',
    value: function getScopeName() {
      if (this.getEditor() && this.getEditor().getGrammar()) {
        return this.getEditor().getGrammar().scopeName;
      }
      return undefined;
    }
  }, {
    key: 'populate',
    value: _asyncToGenerator(function* (filePath) {
      var tags = this.cachedTags[filePath];
      if (tags) {
        yield this.selectListView.update({ items: tags });
      } else {
        yield this.selectListView.update({
          items: [],
          loadingMessage: 'Generating symbols…'
        });
        yield this.selectListView.update({
          items: yield this.generateTags(filePath),
          loadingMessage: null
        });
      }
    })
  }, {
    key: 'generateTags',
    value: _asyncToGenerator(function* (filePath) {
      var generator = new _tagGenerator2['default'](filePath, this.getScopeName());
      this.cachedTags[filePath] = yield generator.generate();
      return this.cachedTags[filePath];
    })
  }]);

  return FileView;
})(_symbolsView2['default']);

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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