Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var StyleguideSection = (function () {
  function StyleguideSection(props, children) {
    _classCallCheck(this, StyleguideSection);

    this.collapsed = props.collapsed;
    this.title = props.title;
    this.name = props.name;
    this.children = children;
    _etch2['default'].initialize(this);
    if (props.onDidInitialize) {
      props.onDidInitialize(this);
    }
  }

  _createClass(StyleguideSection, [{
    key: 'render',
    value: function render() {
      var _this = this;

      if (this.loaded) {
        var className = 'bordered';
        if (this.collapsed) {
          className += ' collapsed';
        }
        return _etch2['default'].dom(
          'section',
          { className: className, dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          ),
          this.children
        );
      } else {
        return _etch2['default'].dom(
          'section',
          { className: 'bordered collapsed', dataset: { name: this.name } },
          _etch2['default'].dom(
            'h1',
            { className: 'section-heading', onclick: function () {
                return _this.toggle();
              } },
            this.title
          )
        );
      }
    }
  }, {
    key: 'update',
    value: function update(props, children) {
      if (props.title) {
        this.title = props.title;
      }

      if (props.name) {
        this.name = props.name;
      }

      if (children) {
        this.children = children;
      }

      if (props.didExpandOrCollapseSection) {
        this.didExpandOrCollapseSection = props.onDidExpandOrCollapseSection;
      }

      return _etch2['default'].update(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      return this.collapsed ? this.expand() : this.collapse();
    }
  }, {
    key: 'expand',
    value: function expand() {
      this.collapsed = false;
      this.loaded = true;
      return _etch2['default'].update(this);
    }
  }, {
    key: 'collapse',
    value: function collapse() {
      this.collapsed = true;
      return _etch2['default'].update(this);
    }
  }]);

  return StyleguideSection;
})();

exports['default'] = StyleguideSection;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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