(function() {
  var CursorPositionView, Disposable;

  Disposable = require('atom').Disposable;

  module.exports = CursorPositionView = (function() {
    function CursorPositionView() {
      var ref;
      this.viewUpdatePending = false;
      this.element = document.createElement('status-bar-cursor');
      this.element.classList.add('cursor-position', 'inline-block');
      this.goToLineLink = document.createElement('a');
      this.goToLineLink.classList.add('inline-block');
      this.goToLineLink.href = '#';
      this.element.appendChild(this.goToLineLink);
      this.formatString = (ref = atom.config.get('status-bar.cursorPositionFormat')) != null ? ref : '%L:%C';
      if (atom.workspace.onDidChangeActiveTextEditor) {
        this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
          return function(activeEditor) {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      } else {
        this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
          return function(activeItem) {
            return _this.subscribeToActiveTextEditor();
          };
        })(this));
      }
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
      this.tooltip = atom.tooltips.add(this.element, {
        title: (function(_this) {
          return function() {
            return "Line " + _this.row + ", Column " + _this.column;
          };
        })(this)
      });
      this.handleClick();
    }

    CursorPositionView.prototype.destroy = function() {
      var ref, ref1, ref2;
      this.activeItemSubscription.dispose();
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      this.tooltip.dispose();
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      this.clickSubscription.dispose();
      return (ref2 = this.updateSubscription) != null ? ref2.dispose() : void 0;
    };

    CursorPositionView.prototype.subscribeToActiveTextEditor = function() {
      var activeEditor, ref, selectionsMarkerLayer;
      if ((ref = this.cursorSubscription) != null) {
        ref.dispose();
      }
      activeEditor = this.getActiveTextEditor();
      selectionsMarkerLayer = activeEditor != null ? activeEditor.selectionsMarkerLayer : void 0;
      this.cursorSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdate.bind(this)) : void 0;
      return this.scheduleUpdate();
    };

    CursorPositionView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.cursorPositionFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '%L:%C';
          return _this.scheduleUpdate();
        };
      })(this));
    };

    CursorPositionView.prototype.handleClick = function() {
      var clickHandler;
      clickHandler = (function(_this) {
        return function() {
          return atom.commands.dispatch(atom.views.getView(_this.getActiveTextEditor()), 'go-to-line:toggle');
        };
      })(this);
      this.element.addEventListener('click', clickHandler);
      return this.clickSubscription = new Disposable((function(_this) {
        return function() {
          return _this.element.removeEventListener('click', clickHandler);
        };
      })(this));
    };

    CursorPositionView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    CursorPositionView.prototype.scheduleUpdate = function() {
      if (this.viewUpdatePending) {
        return;
      }
      this.viewUpdatePending = true;
      return this.updateSubscription = atom.views.updateDocument((function(_this) {
        return function() {
          var position, ref;
          _this.viewUpdatePending = false;
          if (position = (ref = _this.getActiveTextEditor()) != null ? ref.getCursorBufferPosition() : void 0) {
            _this.row = position.row + 1;
            _this.column = position.column + 1;
            _this.goToLineLink.textContent = _this.formatString.replace('%L', _this.row).replace('%C', _this.column);
            return _this.element.classList.remove('hide');
          } else {
            _this.goToLineLink.textContent = '';
            return _this.element.classList.add('hide');
          }
        };
      })(this));
    };

    return CursorPositionView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2hvbWUvdHJhdmlzL2J1aWxkL2F0b20vYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9zdGF0dXMtYmFyL2xpYi9jdXJzb3ItcG9zaXRpb24tdmlldy5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFDLGFBQWMsT0FBQSxDQUFRLE1BQVI7O0VBRWYsTUFBTSxDQUFDLE9BQVAsR0FDTTtJQUNTLDRCQUFBO0FBQ1gsVUFBQTtNQUFBLElBQUMsQ0FBQSxpQkFBRCxHQUFxQjtNQUVyQixJQUFDLENBQUEsT0FBRCxHQUFXLFFBQVEsQ0FBQyxhQUFULENBQXVCLG1CQUF2QjtNQUNYLElBQUMsQ0FBQSxPQUFPLENBQUMsU0FBUyxDQUFDLEdBQW5CLENBQXVCLGlCQUF2QixFQUEwQyxjQUExQztNQUNBLElBQUMsQ0FBQSxZQUFELEdBQWdCLFFBQVEsQ0FBQyxhQUFULENBQXVCLEdBQXZCO01BQ2hCLElBQUMsQ0FBQSxZQUFZLENBQUMsU0FBUyxDQUFDLEdBQXhCLENBQTRCLGNBQTVCO01BQ0EsSUFBQyxDQUFBLFlBQVksQ0FBQyxJQUFkLEdBQXFCO01BQ3JCLElBQUMsQ0FBQSxPQUFPLENBQUMsV0FBVCxDQUFxQixJQUFDLENBQUEsWUFBdEI7TUFFQSxJQUFDLENBQUEsWUFBRCw4RUFBcUU7TUFHckUsSUFBSSxJQUFJLENBQUMsU0FBUyxDQUFDLDJCQUFuQjtRQUNFLElBQUMsQ0FBQSxzQkFBRCxHQUEwQixJQUFJLENBQUMsU0FBUyxDQUFDLDJCQUFmLENBQTJDLENBQUEsU0FBQSxLQUFBO2lCQUFBLFNBQUMsWUFBRDttQkFBa0IsS0FBQyxDQUFBLDJCQUFELENBQUE7VUFBbEI7UUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQTNDLEVBRDVCO09BQUEsTUFBQTtRQUdFLElBQUMsQ0FBQSxzQkFBRCxHQUEwQixJQUFJLENBQUMsU0FBUyxDQUFDLHlCQUFmLENBQXlDLENBQUEsU0FBQSxLQUFBO2lCQUFBLFNBQUMsVUFBRDttQkFBZ0IsS0FBQyxDQUFBLDJCQUFELENBQUE7VUFBaEI7UUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXpDLEVBSDVCOztNQUtBLElBQUMsQ0FBQSxpQkFBRCxDQUFBO01BQ0EsSUFBQyxDQUFBLDJCQUFELENBQUE7TUFFQSxJQUFDLENBQUEsT0FBRCxHQUFXLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBZCxDQUFrQixJQUFDLENBQUEsT0FBbkIsRUFBNEI7UUFBQSxLQUFBLEVBQU8sQ0FBQSxTQUFBLEtBQUE7aUJBQUEsU0FBQTttQkFBRyxPQUFBLEdBQVEsS0FBQyxDQUFBLEdBQVQsR0FBYSxXQUFiLEdBQXdCLEtBQUMsQ0FBQTtVQUE1QjtRQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBUDtPQUE1QjtNQUVYLElBQUMsQ0FBQSxXQUFELENBQUE7SUF2Qlc7O2lDQXlCYixPQUFBLEdBQVMsU0FBQTtBQUNQLFVBQUE7TUFBQSxJQUFDLENBQUEsc0JBQXNCLENBQUMsT0FBeEIsQ0FBQTs7V0FDbUIsQ0FBRSxPQUFyQixDQUFBOztNQUNBLElBQUMsQ0FBQSxPQUFPLENBQUMsT0FBVCxDQUFBOztZQUNtQixDQUFFLE9BQXJCLENBQUE7O01BQ0EsSUFBQyxDQUFBLGlCQUFpQixDQUFDLE9BQW5CLENBQUE7NERBQ21CLENBQUUsT0FBckIsQ0FBQTtJQU5POztpQ0FRVCwyQkFBQSxHQUE2QixTQUFBO0FBQzNCLFVBQUE7O1dBQW1CLENBQUUsT0FBckIsQ0FBQTs7TUFDQSxZQUFBLEdBQWUsSUFBQyxDQUFBLG1CQUFELENBQUE7TUFDZixxQkFBQSwwQkFBd0IsWUFBWSxDQUFFO01BQ3RDLElBQUMsQ0FBQSxrQkFBRCxtQ0FBc0IscUJBQXFCLENBQUUsV0FBdkIsQ0FBbUMsSUFBQyxDQUFBLGNBQWMsQ0FBQyxJQUFoQixDQUFxQixJQUFyQixDQUFuQzthQUN0QixJQUFDLENBQUEsY0FBRCxDQUFBO0lBTDJCOztpQ0FPN0IsaUJBQUEsR0FBbUIsU0FBQTtBQUNqQixVQUFBOztXQUFtQixDQUFFLE9BQXJCLENBQUE7O2FBQ0EsSUFBQyxDQUFBLGtCQUFELEdBQXNCLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBWixDQUFvQixpQ0FBcEIsRUFBdUQsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFDLEtBQUQ7VUFDM0UsS0FBQyxDQUFBLFlBQUQsbUJBQWdCLFFBQVE7aUJBQ3hCLEtBQUMsQ0FBQSxjQUFELENBQUE7UUFGMkU7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBLENBQXZEO0lBRkw7O2lDQU1uQixXQUFBLEdBQWEsU0FBQTtBQUNYLFVBQUE7TUFBQSxZQUFBLEdBQWUsQ0FBQSxTQUFBLEtBQUE7ZUFBQSxTQUFBO2lCQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsUUFBZCxDQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLE9BQVgsQ0FBbUIsS0FBQyxDQUFBLG1CQUFELENBQUEsQ0FBbkIsQ0FBdkIsRUFBbUUsbUJBQW5FO1FBQUg7TUFBQSxDQUFBLENBQUEsQ0FBQSxJQUFBO01BQ2YsSUFBQyxDQUFBLE9BQU8sQ0FBQyxnQkFBVCxDQUEwQixPQUExQixFQUFtQyxZQUFuQzthQUNBLElBQUMsQ0FBQSxpQkFBRCxHQUF5QixJQUFBLFVBQUEsQ0FBVyxDQUFBLFNBQUEsS0FBQTtlQUFBLFNBQUE7aUJBQUcsS0FBQyxDQUFBLE9BQU8sQ0FBQyxtQkFBVCxDQUE2QixPQUE3QixFQUFzQyxZQUF0QztRQUFIO01BQUEsQ0FBQSxDQUFBLENBQUEsSUFBQSxDQUFYO0lBSGQ7O2lDQUtiLG1CQUFBLEdBQXFCLFNBQUE7YUFDbkIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxtQkFBZixDQUFBO0lBRG1COztpQ0FHckIsY0FBQSxHQUFnQixTQUFBO01BQ2QsSUFBVSxJQUFDLENBQUEsaUJBQVg7QUFBQSxlQUFBOztNQUVBLElBQUMsQ0FBQSxpQkFBRCxHQUFxQjthQUNyQixJQUFDLENBQUEsa0JBQUQsR0FBc0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFYLENBQTBCLENBQUEsU0FBQSxLQUFBO2VBQUEsU0FBQTtBQUM5QyxjQUFBO1VBQUEsS0FBQyxDQUFBLGlCQUFELEdBQXFCO1VBQ3JCLElBQUcsUUFBQSxvREFBaUMsQ0FBRSx1QkFBeEIsQ0FBQSxVQUFkO1lBQ0UsS0FBQyxDQUFBLEdBQUQsR0FBTyxRQUFRLENBQUMsR0FBVCxHQUFlO1lBQ3RCLEtBQUMsQ0FBQSxNQUFELEdBQVUsUUFBUSxDQUFDLE1BQVQsR0FBa0I7WUFDNUIsS0FBQyxDQUFBLFlBQVksQ0FBQyxXQUFkLEdBQTRCLEtBQUMsQ0FBQSxZQUFZLENBQUMsT0FBZCxDQUFzQixJQUF0QixFQUE0QixLQUFDLENBQUEsR0FBN0IsQ0FBaUMsQ0FBQyxPQUFsQyxDQUEwQyxJQUExQyxFQUFnRCxLQUFDLENBQUEsTUFBakQ7bUJBQzVCLEtBQUMsQ0FBQSxPQUFPLENBQUMsU0FBUyxDQUFDLE1BQW5CLENBQTBCLE1BQTFCLEVBSkY7V0FBQSxNQUFBO1lBTUUsS0FBQyxDQUFBLFlBQVksQ0FBQyxXQUFkLEdBQTRCO21CQUM1QixLQUFDLENBQUEsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFuQixDQUF1QixNQUF2QixFQVBGOztRQUY4QztNQUFBLENBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBMUI7SUFKUjs7Ozs7QUExRGxCIiwic291cmNlc0NvbnRlbnQiOlsie0Rpc3Bvc2FibGV9ID0gcmVxdWlyZSAnYXRvbSdcblxubW9kdWxlLmV4cG9ydHMgPVxuY2xhc3MgQ3Vyc29yUG9zaXRpb25WaWV3XG4gIGNvbnN0cnVjdG9yOiAtPlxuICAgIEB2aWV3VXBkYXRlUGVuZGluZyA9IGZhbHNlXG5cbiAgICBAZWxlbWVudCA9IGRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ3N0YXR1cy1iYXItY3Vyc29yJylcbiAgICBAZWxlbWVudC5jbGFzc0xpc3QuYWRkKCdjdXJzb3ItcG9zaXRpb24nLCAnaW5saW5lLWJsb2NrJylcbiAgICBAZ29Ub0xpbmVMaW5rID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudCgnYScpXG4gICAgQGdvVG9MaW5lTGluay5jbGFzc0xpc3QuYWRkKCdpbmxpbmUtYmxvY2snKVxuICAgIEBnb1RvTGluZUxpbmsuaHJlZiA9ICcjJ1xuICAgIEBlbGVtZW50LmFwcGVuZENoaWxkKEBnb1RvTGluZUxpbmspXG5cbiAgICBAZm9ybWF0U3RyaW5nID0gYXRvbS5jb25maWcuZ2V0KCdzdGF0dXMtYmFyLmN1cnNvclBvc2l0aW9uRm9ybWF0JykgPyAnJUw6JUMnXG5cbiAgICAjIFRPRE9bdjEuMTldOiBSZW1vdmUgY29uZGl0aW9uYWwgb25jZSBhdG9tLndvcmtzcGFjZS5vbkRpZENoYW5nZUFjdGl2ZVRleHRFZGl0b3Igc2hpcHMgaW4gQXRvbSB2MS4xOVxuICAgIGlmIChhdG9tLndvcmtzcGFjZS5vbkRpZENoYW5nZUFjdGl2ZVRleHRFZGl0b3IpXG4gICAgICBAYWN0aXZlSXRlbVN1YnNjcmlwdGlvbiA9IGF0b20ud29ya3NwYWNlLm9uRGlkQ2hhbmdlQWN0aXZlVGV4dEVkaXRvciAoYWN0aXZlRWRpdG9yKSA9PiBAc3Vic2NyaWJlVG9BY3RpdmVUZXh0RWRpdG9yKClcbiAgICBlbHNlXG4gICAgICBAYWN0aXZlSXRlbVN1YnNjcmlwdGlvbiA9IGF0b20ud29ya3NwYWNlLm9uRGlkQ2hhbmdlQWN0aXZlUGFuZUl0ZW0gKGFjdGl2ZUl0ZW0pID0+IEBzdWJzY3JpYmVUb0FjdGl2ZVRleHRFZGl0b3IoKVxuXG4gICAgQHN1YnNjcmliZVRvQ29uZmlnKClcbiAgICBAc3Vic2NyaWJlVG9BY3RpdmVUZXh0RWRpdG9yKClcblxuICAgIEB0b29sdGlwID0gYXRvbS50b29sdGlwcy5hZGQoQGVsZW1lbnQsIHRpdGxlOiA9PiBcIkxpbmUgI3tAcm93fSwgQ29sdW1uICN7QGNvbHVtbn1cIilcblxuICAgIEBoYW5kbGVDbGljaygpXG5cbiAgZGVzdHJveTogLT5cbiAgICBAYWN0aXZlSXRlbVN1YnNjcmlwdGlvbi5kaXNwb3NlKClcbiAgICBAY3Vyc29yU3Vic2NyaXB0aW9uPy5kaXNwb3NlKClcbiAgICBAdG9vbHRpcC5kaXNwb3NlKClcbiAgICBAY29uZmlnU3Vic2NyaXB0aW9uPy5kaXNwb3NlKClcbiAgICBAY2xpY2tTdWJzY3JpcHRpb24uZGlzcG9zZSgpXG4gICAgQHVwZGF0ZVN1YnNjcmlwdGlvbj8uZGlzcG9zZSgpXG5cbiAgc3Vic2NyaWJlVG9BY3RpdmVUZXh0RWRpdG9yOiAtPlxuICAgIEBjdXJzb3JTdWJzY3JpcHRpb24/LmRpc3Bvc2UoKVxuICAgIGFjdGl2ZUVkaXRvciA9IEBnZXRBY3RpdmVUZXh0RWRpdG9yKClcbiAgICBzZWxlY3Rpb25zTWFya2VyTGF5ZXIgPSBhY3RpdmVFZGl0b3I/LnNlbGVjdGlvbnNNYXJrZXJMYXllclxuICAgIEBjdXJzb3JTdWJzY3JpcHRpb24gPSBzZWxlY3Rpb25zTWFya2VyTGF5ZXI/Lm9uRGlkVXBkYXRlKEBzY2hlZHVsZVVwZGF0ZS5iaW5kKHRoaXMpKVxuICAgIEBzY2hlZHVsZVVwZGF0ZSgpXG5cbiAgc3Vic2NyaWJlVG9Db25maWc6IC0+XG4gICAgQGNvbmZpZ1N1YnNjcmlwdGlvbj8uZGlzcG9zZSgpXG4gICAgQGNvbmZpZ1N1YnNjcmlwdGlvbiA9IGF0b20uY29uZmlnLm9ic2VydmUgJ3N0YXR1cy1iYXIuY3Vyc29yUG9zaXRpb25Gb3JtYXQnLCAodmFsdWUpID0+XG4gICAgICBAZm9ybWF0U3RyaW5nID0gdmFsdWUgPyAnJUw6JUMnXG4gICAgICBAc2NoZWR1bGVVcGRhdGUoKVxuXG4gIGhhbmRsZUNsaWNrOiAtPlxuICAgIGNsaWNrSGFuZGxlciA9ID0+IGF0b20uY29tbWFuZHMuZGlzcGF0Y2goYXRvbS52aWV3cy5nZXRWaWV3KEBnZXRBY3RpdmVUZXh0RWRpdG9yKCkpLCAnZ28tdG8tbGluZTp0b2dnbGUnKVxuICAgIEBlbGVtZW50LmFkZEV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuICAgIEBjbGlja1N1YnNjcmlwdGlvbiA9IG5ldyBEaXNwb3NhYmxlID0+IEBlbGVtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NsaWNrJywgY2xpY2tIYW5kbGVyKVxuXG4gIGdldEFjdGl2ZVRleHRFZGl0b3I6IC0+XG4gICAgYXRvbS53b3Jrc3BhY2UuZ2V0QWN0aXZlVGV4dEVkaXRvcigpXG5cbiAgc2NoZWR1bGVVcGRhdGU6IC0+XG4gICAgcmV0dXJuIGlmIEB2aWV3VXBkYXRlUGVuZGluZ1xuXG4gICAgQHZpZXdVcGRhdGVQZW5kaW5nID0gdHJ1ZVxuICAgIEB1cGRhdGVTdWJzY3JpcHRpb24gPSBhdG9tLnZpZXdzLnVwZGF0ZURvY3VtZW50ID0+XG4gICAgICBAdmlld1VwZGF0ZVBlbmRpbmcgPSBmYWxzZVxuICAgICAgaWYgcG9zaXRpb24gPSBAZ2V0QWN0aXZlVGV4dEVkaXRvcigpPy5nZXRDdXJzb3JCdWZmZXJQb3NpdGlvbigpXG4gICAgICAgIEByb3cgPSBwb3NpdGlvbi5yb3cgKyAxXG4gICAgICAgIEBjb2x1bW4gPSBwb3NpdGlvbi5jb2x1bW4gKyAxXG4gICAgICAgIEBnb1RvTGluZUxpbmsudGV4dENvbnRlbnQgPSBAZm9ybWF0U3RyaW5nLnJlcGxhY2UoJyVMJywgQHJvdykucmVwbGFjZSgnJUMnLCBAY29sdW1uKVxuICAgICAgICBAZWxlbWVudC5jbGFzc0xpc3QucmVtb3ZlKCdoaWRlJylcbiAgICAgIGVsc2VcbiAgICAgICAgQGdvVG9MaW5lTGluay50ZXh0Q29udGVudCA9ICcnXG4gICAgICAgIEBlbGVtZW50LmNsYXNzTGlzdC5hZGQoJ2hpZGUnKVxuIl19
