(function() {
  var SpellCheckerManager, backgroundCheck, instance, loadGlobalSettings;

  SpellCheckerManager = require('./spell-check-manager');

  instance = SpellCheckerManager;

  instance.isTask = true;

  process.on("message", function(message) {
    switch (false) {
      case message.type !== "global":
        return loadGlobalSettings(message.global);
      case message.type !== "checker":
        return instance.addCheckerPath(message.checkerPath);
    }
  });

  loadGlobalSettings = function(data) {
    return instance.setGlobalArgs(data);
  };

  backgroundCheck = function(data) {
    var misspellings;
    misspellings = instance.check(data, data.text);
    return {
      id: data.id,
      misspellings: misspellings.misspellings
    };
  };

  module.exports = backgroundCheck;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
