Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var ThemesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(ThemesPanel, _CollapsibleSectionPanel);

  _createClass(ThemesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function ThemesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, ThemesPanel);

    _get(Object.getPrototypeOf(ThemesPanel.prototype), 'constructor', this).call(this);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    _etch2['default'].initialize(this);
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this))
    };

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(this.packageManager.on('theme-install-failed theme-uninstall-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.themeErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.handleEvents());
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
    this.loadPackages();

    this.disposables.add(this.packageManager.on('theme-installed theme-uninstalled', function () {
      var loadPackagesTimeout = undefined;
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(function () {
        _this.populateThemeMenus();
        _this.loadPackages();
      }, ThemesPanel.loadPackagesDelay());
    }));

    this.disposables.add(atom.themes.onDidChangeActiveThemes(function () {
      return _this.updateActiveThemes();
    }));
    this.disposables.add(atom.tooltips.add(this.refs.activeUiThemeSettings, { title: 'Settings' }));
    this.disposables.add(atom.tooltips.add(this.refs.activeSyntaxThemeSettings, { title: 'Settings' }));
    this.updateActiveThemes();

    this.disposables.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
  }

  _createClass(ThemesPanel, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages themes-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Choose a Theme'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom(
                'span',
                { className: 'icon icon-question' },
                'You can also style Atom by editing '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenUserStyleSheet },
                'your stylesheet'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'themes-picker' },
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'UI Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the tabs, status bar, tree view, and dropdowns'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'uiMenu', className: 'form-control', onchange: this.didChangeUiMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeUiThemeSettings',
                      className: 'btn icon icon-gear active-theme-settings',
                      onclick: this.didClickActiveUiThemeSettings.bind(this) })
                  )
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'themes-picker-item control-group' },
                _etch2['default'].dom(
                  'div',
                  { className: 'controls' },
                  _etch2['default'].dom(
                    'label',
                    { className: 'control-label' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-title themes-label text' },
                      'Syntax Theme'
                    ),
                    _etch2['default'].dom(
                      'div',
                      { className: 'setting-description text theme-description' },
                      'This styles the text inside the editor'
                    )
                  ),
                  _etch2['default'].dom(
                    'div',
                    { className: 'select-container' },
                    _etch2['default'].dom('select', { ref: 'syntaxMenu', className: 'form-control', onchange: this.didChangeSyntaxMenu.bind(this) }),
                    _etch2['default'].dom('button', {
                      ref: 'activeSyntaxThemeSettings',
                      className: 'btn icon icon-gear active-syntax-settings',
                      onclick: this.didClickActiveSyntaxThemeSettings.bind(this) })
                  )
                )
              )
            )
          )
        ),
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-paintcan' },
              'Installed Themes',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter themes by name' })
            ),
            _etch2['default'].dom('div', { ref: 'themeErrors' }),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Community Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'coreThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Core Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'developmentThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Development Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitThemesHeader', className: 'sub-section-heading icon icon-paintcan' },
                'Git Themes',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading themes…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterThemes',
    value: function filterThemes(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return theme;
      });
      packages.core = packages.core.filter(function (_ref4) {
        var theme = _ref4.theme;
        return theme;
      });
      packages.git = (packages.git || []).filter(function (_ref5) {
        var theme = _ref5.theme;
        return theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }
      return packages;
    }
  }, {
    key: 'sortThemes',
    value: function sortThemes(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      this.packageViews = [];
      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortThemes(_this2.filterThemes(packages));

        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
      })['catch'](function (error) {
        _this2.refs.themeErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      });
    }

    // Update the active UI and syntax themes and populate the menu
  }, {
    key: 'updateActiveThemes',
    value: function updateActiveThemes() {
      this.activeUiTheme = this.getActiveUiTheme();
      this.activeSyntaxTheme = this.getActiveSyntaxTheme();
      this.populateThemeMenus();
      this.toggleActiveThemeButtons();
    }
  }, {
    key: 'toggleActiveThemeButtons',
    value: function toggleActiveThemeButtons() {
      if (this.hasSettings(this.activeUiTheme)) {
        this.refs.activeUiThemeSettings.style.display = '';
      } else {
        this.refs.activeUiThemeSettings.style.display = 'none';
      }

      if (this.hasSettings(this.activeSyntaxTheme)) {
        this.refs.activeSyntaxThemeSettings.display = '';
      } else {
        this.refs.activeSyntaxThemeSettings.display = 'none';
      }
    }
  }, {
    key: 'hasSettings',
    value: function hasSettings(packageName) {
      return this.packageManager.packageHasSettings(packageName);
    }

    // Populate the theme menus from the theme manager's active themes
  }, {
    key: 'populateThemeMenus',
    value: function populateThemeMenus() {
      this.refs.uiMenu.innerHTML = "";
      this.refs.syntaxMenu.innerHTML = "";
      var availableThemes = _underscorePlus2['default'].sortBy(atom.themes.getLoadedThemes(), 'name');
      for (var _ref62 of availableThemes) {
        var _name = _ref62.name;
        var metadata = _ref62.metadata;

        switch (metadata.theme) {
          case 'ui':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeUiTheme) {
                themeItem.selected = true;
              }
              this.refs.uiMenu.appendChild(themeItem);
              break;
            }
          case 'syntax':
            {
              var themeItem = this.createThemeMenuItem(_name);
              if (_name === this.activeSyntaxTheme) {
                themeItem.selected = true;
              }
              this.refs.syntaxMenu.appendChild(themeItem);
              break;
            }
        }
      }
    }

    // Get the name of the active ui theme.
  }, {
    key: 'getActiveUiTheme',
    value: function getActiveUiTheme() {
      for (var _ref72 of atom.themes.getActiveThemes()) {
        var _name2 = _ref72.name;
        var metadata = _ref72.metadata;

        if (metadata.theme === 'ui') {
          return _name2;
        }
      }
      return null;
    }

    // Get the name of the active syntax theme.
  }, {
    key: 'getActiveSyntaxTheme',
    value: function getActiveSyntaxTheme() {
      for (var _ref82 of atom.themes.getActiveThemes()) {
        var _name3 = _ref82.name;
        var metadata = _ref82.metadata;

        if (metadata.theme === 'syntax') {
          return _name3;
        }
      }
      return null;
    }

    // Update the config with the selected themes
  }, {
    key: 'updateThemeConfig',
    value: function updateThemeConfig() {
      var themes = [];
      if (this.activeUiTheme) {
        themes.push(this.activeUiTheme);
      }
      if (this.activeSyntaxTheme) {
        themes.push(this.activeSyntaxTheme);
      }
      if (themes.length > 0) {
        atom.config.set("core.themes", themes);
      }
    }
  }, {
    key: 'scheduleUpdateThemeConfig',
    value: function scheduleUpdateThemeConfig() {
      var _this3 = this;

      setTimeout(function () {
        _this3.updateThemeConfig();
      }, 100);
    }

    // Create a menu item for the given theme name.
  }, {
    key: 'createThemeMenuItem',
    value: function createThemeMenuItem(themeName) {
      var title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(themeName.replace(/-(ui|syntax)/g, '').replace(/-theme$/g, '')));
      var option = document.createElement('option');
      option.value = themeName;
      option.textContent = title;
      return option;
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Themes' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, this.packages.git.length);

      this.refs.totalPackages.textContent = '' + (this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length);
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityThemesHeader, this.refs.communityCount, community, this.packages.user.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.developmentThemesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.coreThemesHeader, this.refs.coreCount, core, this.packages.core.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitThemesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownThemes = dev + core + community + git;
      var totalThemes = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownThemes + '/' + totalThemes;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.communityThemesHeader, this.refs.coreThemesHeader, this.refs.developmentThemesHeader, this.refs.gitThemesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'didClickOpenUserStyleSheet',
    value: function didClickOpenUserStyleSheet(e) {
      e.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace), 'application:open-your-stylesheet');
    }
  }, {
    key: 'didChangeUiMenu',
    value: function didChangeUiMenu() {
      this.activeUiTheme = this.refs.uiMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didChangeSyntaxMenu',
    value: function didChangeSyntaxMenu() {
      this.activeSyntaxTheme = this.refs.syntaxMenu.value;
      this.scheduleUpdateThemeConfig();
    }
  }, {
    key: 'didClickActiveUiThemeSettings',
    value: function didClickActiveUiThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'ui';
      });
      var activeUiTheme = theme != null ? theme.metadata : null;
      if (activeUiTheme != null) {
        this.settingsView.showPanel(this.activeUiTheme, {
          back: 'Themes',
          pack: activeUiTheme
        });
      }
    }
  }, {
    key: 'didClickActiveSyntaxThemeSettings',
    value: function didClickActiveSyntaxThemeSettings(event) {
      event.stopPropagation();
      var theme = atom.themes.getActiveThemes().find(function (theme) {
        return theme.metadata.theme === 'syntax';
      });
      var activeSyntaxTheme = theme != null ? theme.metadata : null;
      if (activeSyntaxTheme != null) {
        this.settingsView.showPanel(this.activeSyntaxTheme, {
          back: 'Themes',
          pack: activeSyntaxTheme
        });
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return ThemesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = ThemesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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