Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var SystemPanel = (function () {
  function SystemPanel() {
    var _this = this;

    _classCallCheck(this, SystemPanel);

    _etch2['default'].initialize(this);
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    _atom.WinShell.fileHandler.isRegistered(function (i) {
      _this.refs.fileHandlerCheckbox.checked = i;
    });
    _atom.WinShell.fileContextMenu.isRegistered(function (i) {
      _this.refs.fileContextMenuCheckbox.checked = i;
    });
    _atom.WinShell.folderContextMenu.isRegistered(function (i) {
      _this.refs.folderContextMenuCheckbox.checked = i;
    });
  }

  _createClass(SystemPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '0' },
        _etch2['default'].dom(
          'form',
          { className: 'general-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'settings-panel' },
            _etch2['default'].dom(
              'div',
              { className: 'section-container' },
              _etch2['default'].dom(
                'div',
                { className: 'block section-heading icon icon-device-desktop' },
                'System Settings'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'text icon icon-question' },
                'These settings determine how Atom integrates with your operating system.'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-body' },
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.file-handler' },
                        _etch2['default'].dom('input', {
                          ref: 'fileHandlerCheckbox',
                          id: 'system.windows.file-handler',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileHandler, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Register as file handler'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Show ',
                          _atom.WinShell.appName,
                          ' in the "Open with" application list for easy association with file types.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-files' },
                        _etch2['default'].dom('input', {
                          ref: 'fileContextMenuCheckbox',
                          id: 'system.windows.shell-menu-files',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.fileContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in file context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for files.'
                        )
                      )
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'div',
                      { className: 'checkbox' },
                      _etch2['default'].dom(
                        'label',
                        { 'for': 'system.windows.shell-menu-folders' },
                        _etch2['default'].dom('input', {
                          ref: 'folderContextMenuCheckbox',
                          id: 'system.windows.shell-menu-folders',
                          className: 'input-checkbox',
                          type: 'checkbox',
                          onclick: function (e) {
                            _this2.setRegistration(_atom.WinShell.folderContextMenu, e.target.checked);
                            _this2.setRegistration(_atom.WinShell.folderBackgroundContextMenu, e.target.checked);
                          } }),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-title' },
                          'Show in folder context menus'
                        ),
                        _etch2['default'].dom(
                          'div',
                          { className: 'setting-description' },
                          'Add "Open with ',
                          _atom.WinShell.appName,
                          '" to the File Explorer context menu for folders.'
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'setRegistration',
    value: function setRegistration(option, shouldBeRegistered) {
      if (shouldBeRegistered) {
        return option.register(function () {});
      } else {
        return option.deregister(function () {});
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return SystemPanel;
})();

exports['default'] = SystemPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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