Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _keybindingsPanel = require('./keybindings-panel');

var _keybindingsPanel2 = _interopRequireDefault(_keybindingsPanel);

// Displays the keybindings for a package namespace

var PackageKeymapView = (function () {
  function PackageKeymapView(pack) {
    var _this = this;

    _classCallCheck(this, PackageKeymapView);

    this.pack = pack;
    this.otherPlatformPattern = new RegExp('\\.platform-(?!' + _underscorePlus2['default'].escapeRegExp(process.platform) + '\\b)');
    this.namespace = this.pack.name;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);

    var packagesWithKeymapsDisabled = atom.config.get('core.packagesWithKeymapsDisabled') || [];
    this.refs.keybindingToggle.checked = !packagesWithKeymapsDisabled.includes(this.namespace);

    var changeHandler = function changeHandler(event) {
      event.stopPropagation();
      var value = _this.refs.keybindingToggle.checked;
      if (value) {
        atom.config.removeAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      } else {
        atom.config.pushAtKeyPath('core.packagesWithKeymapsDisabled', _this.namespace);
      }

      _this.updateKeyBindingView();
    };
    this.refs.keybindingToggle.addEventListener('change', changeHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.keybindingToggle.removeEventListener('change', changeHandler);
    }));

    var copyIconClickHandler = function copyIconClickHandler(event) {
      var target = event.target.closest('.copy-icon');
      if (target) {
        event.preventDefault();
        event.stopPropagation();
        _this.writeKeyBindingToClipboard(target.closest('tr').dataset);
      }
    };
    this.element.addEventListener('click', copyIconClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', copyIconClickHandler);
    }));

    this.updateKeyBindingView();

    var hasKeymaps = false;
    for (var _ref3 of atom.packages.getLoadedPackage(this.namespace).keymaps) {
      var _ref2 = _slicedToArray(_ref3, 2);

      var packageKeymapsPath = _ref2[0];
      var map = _ref2[1];

      if (map.length > 0) {
        hasKeymaps = true;
        break;
      }
    }

    if (this.refs.keybindingItems.children.length === 0 && !hasKeymaps) {
      this.element.style.display = 'none';
    }
  }

  _createClass(PackageKeymapView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'section',
        { className: 'section' },
        _etch2['default'].dom(
          'div',
          { className: 'section-heading icon icon-keyboard' },
          'Keybindings'
        ),
        _etch2['default'].dom(
          'div',
          { className: 'checkbox' },
          _etch2['default'].dom(
            'label',
            { 'for': 'toggleKeybindings' },
            _etch2['default'].dom('input', { id: 'toggleKeybindings', className: 'input-checkbox', type: 'checkbox', ref: 'keybindingToggle' }),
            _etch2['default'].dom(
              'div',
              { className: 'setting-title' },
              'Enable'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'setting-description' },
            'Disable this if you want to bind your own keystrokes for this package\\\'s commands in your keymap.'
          )
        ),
        _etch2['default'].dom(
          'table',
          { className: 'package-keymap-table table native-key-bindings text', tabIndex: '-1' },
          _etch2['default'].dom(
            'thead',
            null,
            _etch2['default'].dom(
              'tr',
              null,
              _etch2['default'].dom(
                'th',
                null,
                'Keystroke'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Command'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Selector'
              ),
              _etch2['default'].dom(
                'th',
                null,
                'Source'
              )
            )
          ),
          _etch2['default'].dom('tbody', { ref: 'keybindingItems' })
        )
      );
    }
  }, {
    key: 'updateKeyBindingView',
    value: function updateKeyBindingView() {
      this.refs.keybindingItems.innerHTML = '';

      for (var keyBinding of atom.keymaps.getKeyBindings()) {
        var command = keyBinding.command;
        var keystrokes = keyBinding.keystrokes;
        var selector = keyBinding.selector;
        var source = keyBinding.source;

        if (!command || !command.indexOf || command.indexOf(this.namespace + ':') !== 0) {
          continue;
        }

        if (this.otherPlatformPattern.test(selector)) {
          continue;
        }

        var keyBindingRow = document.createElement('tr');
        keyBindingRow.dataset.selector = selector;
        keyBindingRow.dataset.keystrokes = keystrokes;
        keyBindingRow.dataset.command = command;

        var keystrokesTd = document.createElement('td');

        var copyIconSpan = document.createElement('span');
        copyIconSpan.classList.add('icon', 'icon-clippy', 'copy-icon');
        keystrokesTd.appendChild(copyIconSpan);

        var keystrokesSpan = document.createElement('span');
        keystrokesSpan.textContent = keystrokes;
        keystrokesTd.appendChild(keystrokesSpan);

        keyBindingRow.appendChild(keystrokesTd);

        var commandTd = document.createElement('td');
        commandTd.textContent = command;
        keyBindingRow.appendChild(commandTd);

        var selectorTd = document.createElement('td');
        selectorTd.textContent = selector;
        keyBindingRow.appendChild(selectorTd);

        var sourceTd = document.createElement('td');
        sourceTd.textContent = _keybindingsPanel2['default'].determineSource(source);
        keyBindingRow.appendChild(sourceTd);

        this.refs.keybindingItems.appendChild(keyBindingRow);
      }
    }
  }, {
    key: 'writeKeyBindingToClipboard',
    value: function writeKeyBindingToClipboard(_ref4) {
      var selector = _ref4.selector;
      var keystrokes = _ref4.keystrokes;
      var command = _ref4.command;

      var content = undefined;
      var keymapExtension = _path2['default'].extname(atom.keymaps.getUserKeymapPath());
      if (keymapExtension === '.cson') {
        content = '\'' + selector + '\':\n  \'' + keystrokes + '\': \'' + command + '\'';
      } else {
        content = '"' + selector + '": {\n  "' + keystrokes + '": "' + command + '"\n}';
      }

      atom.clipboard.write(content);
    }
  }]);

  return PackageKeymapView;
})();

exports['default'] = PackageKeymapView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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