Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (repoUrl) {
        _electron.shell.openExternal(repoUrl);
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (repoUrl) {
        _electron.shell.openExternal(repoUrl + '/issues/new');
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail panels-item' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'form',
            { className: 'section-container package-detail-view' },
            _etch2['default'].dom(
              'div',
              { className: 'container package-container' },
              packageCardView
            ),
            _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
            _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
            _etch2['default'].dom(
              'div',
              { ref: 'buttons', className: 'btn-wrap-group hidden' },
              _etch2['default'].dom(
                'button',
                { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                'View on Atom.io'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                'Report Issue'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                'CHANGELOG'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                'LICENSE'
              ),
              _etch2['default'].dom(
                'button',
                { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                'View Code'
              )
            ),
            _etch2['default'].dom('div', { ref: 'errors' })
          )
        ),
        _etch2['default'].dom('div', { ref: 'sections' })
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack.path, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeView = new _packageReadmeView2['default'](readme);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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