Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _list = require('./list');

var _list2 = _interopRequireDefault(_list);

var _listView = require('./list-view');

var _listView2 = _interopRequireDefault(_listView);

var _utils = require('./utils');

var InstalledPackagesPanel = (function (_CollapsibleSectionPanel) {
  _inherits(InstalledPackagesPanel, _CollapsibleSectionPanel);

  _createClass(InstalledPackagesPanel, null, [{
    key: 'loadPackagesDelay',
    value: function loadPackagesDelay() {
      return 300;
    }
  }]);

  function InstalledPackagesPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstalledPackagesPanel);

    _get(Object.getPrototypeOf(InstalledPackagesPanel.prototype), 'constructor', this).call(this);
    _etch2['default'].initialize(this);
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.items = {
      dev: new _list2['default']('name'),
      core: new _list2['default']('name'),
      user: new _list2['default']('name'),
      git: new _list2['default']('name'),
      deprecated: new _list2['default']('name')
    };
    this.itemViews = {
      dev: new _listView2['default'](this.items.dev, this.refs.devPackages, this.createPackageCard.bind(this)),
      core: new _listView2['default'](this.items.core, this.refs.corePackages, this.createPackageCard.bind(this)),
      user: new _listView2['default'](this.items.user, this.refs.communityPackages, this.createPackageCard.bind(this)),
      git: new _listView2['default'](this.items.git, this.refs.gitPackages, this.createPackageCard.bind(this)),
      deprecated: new _listView2['default'](this.items.deprecated, this.refs.deprecatedPackages, this.createPackageCard.bind(this))
    };

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(this.refs.filterEditor.onDidStopChanging(function () {
      _this.matchPackages();
    }));
    this.subscriptions.add(this.packageManager.on('package-install-failed theme-install-failed package-uninstall-failed theme-uninstall-failed package-update-failed theme-update-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.updateErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));

    var loadPackagesTimeout = undefined;
    this.subscriptions.add(this.packageManager.on('package-updated package-installed package-uninstalled package-installed-alternative', function () {
      clearTimeout(loadPackagesTimeout);
      loadPackagesTimeout = setTimeout(_this.loadPackages.bind(_this), InstalledPackagesPanel.loadPackagesDelay());
    }));

    this.subscriptions.add(this.handleEvents());
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadPackages();
  }

  _createClass(InstalledPackagesPanel, [{
    key: 'focus',
    value: function focus() {
      this.refs.filterEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'section',
          { className: 'section' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'div',
              { className: 'section-heading icon icon-package' },
              'Installed Packages',
              _etch2['default'].dom(
                'span',
                { ref: 'totalPackages', className: 'section-heading-count badge badge-flexible' },
                '…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'editor-container' },
              _etch2['default'].dom(_atom.TextEditor, { ref: 'filterEditor', mini: true, placeholderText: 'Filter packages by name' })
            ),
            _etch2['default'].dom('div', { ref: 'updateErrors' }),
            _etch2['default'].dom(
              'section',
              { ref: 'deprecatedSection', className: 'sub-section deprecated-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'deprecatedPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Deprecated Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'deprecatedCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'p',
                null,
                'Atom does not load deprecated packages. These packages may have updates available.'
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'deprecatedPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'deprecatedLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section installed-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'communityPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Community Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'communityCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'communityPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'communityLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section core-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'corePackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Core Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'coreCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'corePackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'coreLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section dev-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'devPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Development Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'devCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'devPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'devLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            ),
            _etch2['default'].dom(
              'section',
              { className: 'sub-section git-packages' },
              _etch2['default'].dom(
                'h3',
                { ref: 'gitPackagesHeader', className: 'sub-section-heading icon icon-package' },
                'Git Packages',
                _etch2['default'].dom(
                  'span',
                  { ref: 'gitCount', className: 'section-heading-count badge badge-flexible' },
                  '…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { ref: 'gitPackages', className: 'container package-container' },
                _etch2['default'].dom(
                  'div',
                  { ref: 'gitLoadingArea', className: 'alert alert-info loading-area icon icon-hourglass' },
                  'Loading packages…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages) {
      packages.dev = packages.dev.filter(function (_ref2) {
        var theme = _ref2.theme;
        return !theme;
      });
      packages.user = packages.user.filter(function (_ref3) {
        var theme = _ref3.theme;
        return !theme;
      });
      packages.deprecated = packages.user.filter(function (_ref4) {
        var name = _ref4.name;
        var version = _ref4.version;
        return atom.packages.isDeprecatedPackage(name, version);
      });
      packages.core = packages.core.filter(function (_ref5) {
        var theme = _ref5.theme;
        return !theme;
      });
      packages.git = (packages.git || []).filter(function (_ref6) {
        var theme = _ref6.theme;
        return !theme;
      });

      for (var pack of packages.core) {
        if (pack.repository == null) {
          pack.repository = 'https://github.com/atom/' + pack.name;
        }
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var pack of packages[packageType]) {
          pack.owner = (0, _utils.ownerFromRepository)(pack.repository);
        }
      }

      return packages;
    }
  }, {
    key: 'sortPackages',
    value: function sortPackages(packages) {
      packages.dev.sort(_utils.packageComparatorAscending);
      packages.core.sort(_utils.packageComparatorAscending);
      packages.user.sort(_utils.packageComparatorAscending);
      packages.git.sort(_utils.packageComparatorAscending);
      packages.deprecated.sort(_utils.packageComparatorAscending);
      return packages;
    }
  }, {
    key: 'loadPackages',
    value: function loadPackages() {
      var _this2 = this;

      var packagesWithUpdates = {};
      this.packageManager.getOutdated().then(function (packages) {
        for (var _ref72 of packages) {
          var _name = _ref72.name;
          var latestVersion = _ref72.latestVersion;

          packagesWithUpdates[_name] = latestVersion;
        }
        _this2.displayPackageUpdates(packagesWithUpdates);
      });

      this.packageManager.getInstalled().then(function (packages) {
        _this2.packages = _this2.sortPackages(_this2.filterPackages(packages));
        _this2.refs.devLoadingArea.remove();
        _this2.items.dev.setItems(_this2.packages.dev);

        _this2.refs.coreLoadingArea.remove();
        _this2.items.core.setItems(_this2.packages.core);

        _this2.refs.communityLoadingArea.remove();
        _this2.items.user.setItems(_this2.packages.user);

        _this2.refs.gitLoadingArea.remove();
        _this2.items.git.setItems(_this2.packages.git);

        if (_this2.packages.deprecated.length) {
          _this2.refs.deprecatedSection.style.display = '';
        } else {
          _this2.refs.deprecatedSection.style.display = 'none';
        }
        _this2.refs.deprecatedLoadingArea.remove();
        _this2.items.deprecated.setItems(_this2.packages.deprecated);

        // TODO show empty mesage per section

        _this2.updateSectionCounts();
        _this2.displayPackageUpdates(packagesWithUpdates);

        _this2.matchPackages();
      })['catch'](function (error) {
        console.error(error.message, error.stack);
      });
    }
  }, {
    key: 'displayPackageUpdates',
    value: function displayPackageUpdates(packagesWithUpdates) {
      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        for (var packageCard of this.itemViews[packageType].getViews()) {
          var newVersion = packagesWithUpdates[packageCard.pack.name];
          if (newVersion) {
            packageCard.displayAvailableUpdate(newVersion);
          }
        }
      }
    }
  }, {
    key: 'createPackageCard',
    value: function createPackageCard(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Packages' });
    }
  }, {
    key: 'filterPackageListByText',
    value: function filterPackageListByText(text) {
      if (!this.packages) {
        return;
      }

      for (var packageType of ['dev', 'core', 'user', 'git', 'deprecated']) {
        var allViews = this.itemViews[packageType].getViews();
        var activeViews = this.itemViews[packageType].filterViews(function (pack) {
          if (text === '') {
            return true;
          } else {
            var owner = pack.owner != null ? pack.owner : (0, _utils.ownerFromRepository)(pack.repository);
            var filterText = pack.name + ' ' + owner;
            return _fuzzaldrin2['default'].score(filterText, text) > 0;
          }
        });

        for (var view of allViews) {
          if (view) {
            view.element.style.display = 'none';
            view.element.classList.add('hidden');
          }
        }

        for (var view of activeViews) {
          if (view) {
            view.element.style.display = '';
            view.element.classList.remove('hidden');
          }
        }
      }

      this.updateSectionCounts();
    }
  }, {
    key: 'updateUnfilteredSectionCounts',
    value: function updateUnfilteredSectionCounts() {
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, this.packages.deprecated.length);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, this.packages.user.length);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, this.packages.core.length);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, this.packages.dev.length);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, this.packages.git.length);

      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = totalPackages.toString();
    }
  }, {
    key: 'updateFilteredSectionCounts',
    value: function updateFilteredSectionCounts() {
      var deprecated = this.notHiddenCardsLength(this.refs.deprecatedPackages);
      this.updateSectionCount(this.refs.deprecatedPackagesHeader, this.refs.deprecatedCount, deprecated, this.packages.deprecated.length);

      var community = this.notHiddenCardsLength(this.refs.communityPackages);
      this.updateSectionCount(this.refs.communityPackagesHeader, this.refs.communityCount, community, this.packages.user.length);

      var core = this.notHiddenCardsLength(this.refs.corePackages);
      this.updateSectionCount(this.refs.corePackagesHeader, this.refs.coreCount, core, this.packages.core.length);

      var dev = this.notHiddenCardsLength(this.refs.devPackages);
      this.updateSectionCount(this.refs.devPackagesHeader, this.refs.devCount, dev, this.packages.dev.length);

      var git = this.notHiddenCardsLength(this.refs.gitPackages);
      this.updateSectionCount(this.refs.gitPackagesHeader, this.refs.gitCount, git, this.packages.git.length);

      var shownPackages = dev + core + community + git;
      var totalPackages = this.packages.user.length + this.packages.core.length + this.packages.dev.length + this.packages.git.length;
      this.refs.totalPackages.textContent = shownPackages + '/' + totalPackages;
    }
  }, {
    key: 'resetSectionHasItems',
    value: function resetSectionHasItems() {
      this.resetCollapsibleSections([this.refs.deprecatedPackagesHeader, this.refs.communityPackagesHeader, this.refs.corePackagesHeader, this.refs.devPackagesHeader, this.refs.gitPackagesHeader]);
    }
  }, {
    key: 'matchPackages',
    value: function matchPackages() {
      this.filterPackageListByText(this.refs.filterEditor.getText());
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstalledPackagesPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = InstalledPackagesPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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