Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _electron = require('electron');

var _electron2 = _interopRequireDefault(_electron);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _errorView = require('./error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _hostedGitInfo = require('hosted-git-info');

var _hostedGitInfo2 = _interopRequireDefault(_hostedGitInfo);

var PackageNameRegex = /config\/install\/(package|theme):([a-z0-9-_]+)/i;

var InstallPanel = (function () {
  function InstallPanel(settingsView, packageManager) {
    var _this = this;

    _classCallCheck(this, InstallPanel);

    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.disposables = new _atom.CompositeDisposable();
    this.client = this.packageManager.getClient();
    this.atomIoURL = 'https://atom.io/packages';

    _etch2['default'].initialize(this);

    this.refs.searchMessage.style.display = 'none';

    this.refs.searchEditor.setPlaceholderText('Search packages');
    this.searchType = 'packages';
    this.disposables.add(this.packageManager.on('package-install-failed', function (_ref) {
      var pack = _ref.pack;
      var error = _ref.error;

      _this.refs.searchErrors.appendChild(new _errorView2['default'](_this.packageManager, error).element);
    }));
    this.disposables.add(this.packageManager.on('package-installed theme-installed', function (_ref2) {
      var pack = _ref2.pack;

      var gitUrlInfo = _this.currentGitPackageCard && _this.currentGitPackageCard.pack && _this.currentGitPackageCard.pack.gitUrlInfo ? _this.currentGitPackageCard.pack.gitUrlInfo : null;

      if (gitUrlInfo && gitUrlInfo === pack.gitUrlInfo) {
        _this.updateGitPackageCard(pack);
      }
    }));

    this.disposables.add(atom.commands.add(this.refs.searchEditor.element, 'core:confirm', function () {
      _this.performSearch();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.loadFeaturedPackages();
  }

  _createClass(InstallPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'focus',
    value: function focus() {
      this.refs.searchEditor.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom(
              'h1',
              { ref: 'installHeading', className: 'section-heading icon icon-plus' },
              'Install Packages'
            ),
            _etch2['default'].dom(
              'div',
              { className: 'text native-key-bindings', tabIndex: '-1' },
              _etch2['default'].dom('span', { className: 'icon icon-question' }),
              _etch2['default'].dom(
                'span',
                { ref: 'publishedToText' },
                'Packages are published to '
              ),
              _etch2['default'].dom(
                'a',
                { className: 'link', onclick: this.didClickOpenAtomIo.bind(this) },
                'atom.io'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' and are installed to ',
                _path2['default'].join(process.env.ATOM_HOME, 'packages')
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'search-container clearfix' },
              _etch2['default'].dom(
                'div',
                { className: 'editor-container' },
                _etch2['default'].dom(_atom.TextEditor, { mini: true, ref: 'searchEditor' })
              ),
              _etch2['default'].dom(
                'div',
                { className: 'btn-group' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchPackagesButton', className: 'btn btn-default selected', onclick: this.didClickSearchPackagesButton.bind(this) },
                  'Packages'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'searchThemesButton', className: 'btn btn-default', onclick: this.didClickSearchThemesButton.bind(this) },
                  'Themes'
                )
              )
            ),
            _etch2['default'].dom('div', { ref: 'searchErrors' }),
            _etch2['default'].dom('div', { ref: 'searchMessage', className: 'alert alert-info search-message icon icon-search' }),
            _etch2['default'].dom('div', { ref: 'resultsContainer', className: 'container package-container' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'section packages' },
          _etch2['default'].dom(
            'div',
            { className: 'section-container' },
            _etch2['default'].dom('div', { ref: 'featuredHeading', className: 'section-heading icon icon-star' }),
            _etch2['default'].dom('div', { ref: 'featuredErrors' }),
            _etch2['default'].dom('div', { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' }),
            _etch2['default'].dom('div', { ref: 'featuredContainer', className: 'container package-container' })
          )
        )
      );
    }
  }, {
    key: 'setSearchType',
    value: function setSearchType(searchType) {
      if (searchType === 'theme') {
        this.searchType = 'themes';
        this.refs.searchThemesButton.classList.add('selected');
        this.refs.searchPackagesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search themes');
        this.refs.publishedToText.textContent = 'Themes are published to ';
        this.atomIoURL = 'https://atom.io/themes';
        this.loadFeaturedPackages(true);
      } else if (searchType === 'package') {
        this.searchType = 'packages';
        this.refs.searchPackagesButton.classList.add('selected');
        this.refs.searchThemesButton.classList.remove('selected');
        this.refs.searchEditor.setPlaceholderText('Search packages');
        this.refs.publishedToText.textContent = 'Packages are published to ';
        this.atomIoURL = 'https://atom.io/packages';
        this.loadFeaturedPackages();
      }
    }
  }, {
    key: 'beforeShow',
    value: function beforeShow(options) {
      if (options && options.uri) {
        var query = this.extractQueryFromURI(options.uri);
        if (query != null) {
          var searchType = query.searchType;
          var packageName = query.packageName;

          this.setSearchType(searchType);
          this.refs.searchEditor.setText(packageName);
          this.performSearch();
        }
      }
    }
  }, {
    key: 'extractQueryFromURI',
    value: function extractQueryFromURI(uri) {
      var matches = PackageNameRegex.exec(uri);
      if (matches) {
        var _Array$from = Array.from(matches);

        var _Array$from2 = _slicedToArray(_Array$from, 3);

        var searchType = _Array$from2[1];
        var packageName = _Array$from2[2];

        return { searchType: searchType, packageName: packageName };
      } else {
        return null;
      }
    }
  }, {
    key: 'performSearch',
    value: function performSearch() {
      var query = this.refs.searchEditor.getText().trim().toLowerCase();
      if (query) {
        this.performSearchForQuery(query);
      }
    }
  }, {
    key: 'performSearchForQuery',
    value: function performSearchForQuery(query) {
      var gitUrlInfo = undefined;
      if (gitUrlInfo = _hostedGitInfo2['default'].fromUrl(query)) {
        var type = gitUrlInfo['default'];
        if (type === 'sshurl' || type === 'https' || type === 'shortcut') {
          this.showGitInstallPackageCard({ name: query, gitUrlInfo: gitUrlInfo });
        }
      } else {
        this.search(query);
      }
    }
  }, {
    key: 'showGitInstallPackageCard',
    value: function showGitInstallPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.currentGitPackageCard.displayGitPackageInstallInformation();
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'updateGitPackageCard',
    value: function updateGitPackageCard(pack) {
      if (this.currentGitPackageCard) {
        this.currentGitPackageCard.destroy();
      }

      this.currentGitPackageCard = this.getPackageCardView(pack);
      this.replaceCurrentGitPackageCardView();
    }
  }, {
    key: 'replaceCurrentGitPackageCardView',
    value: function replaceCurrentGitPackageCardView() {
      this.refs.resultsContainer.innerHTML = '';
      this.addPackageCardView(this.refs.resultsContainer, this.currentGitPackageCard);
    }
  }, {
    key: 'search',
    value: _asyncToGenerator(function* (query) {
      this.refs.resultsContainer.innerHTML = '';
      this.refs.searchMessage.textContent = 'Searching ' + this.searchType + ' for “' + query + '”…';
      this.refs.searchMessage.style.display = '';

      var opts = {};
      opts[this.searchType] = true;
      opts['sortBy'] = 'downloads';

      try {
        var packages = (yield this.packageManager.search(query, opts)) || [];
        this.refs.resultsContainer.innerHTML = '';
        this.refs.searchMessage.style.display = 'none';
        if (packages.length === 0) {
          this.showNoResultMessage(query);
        }
        this.highlightExactMatch(this.refs.resultsContainer, query, packages);
        this.addCloseMatches(this.refs.resultsContainer, query, packages);
        this.addPackageViews(this.refs.resultsContainer, packages);
      } catch (error) {
        this.refs.searchMessage.style.display = 'none';
        this.refs.searchErrors.appendChild(new _errorView2['default'](this.packageManager, error).element);
      }
    })
  }, {
    key: 'showNoResultMessage',
    value: function showNoResultMessage(query) {
      this.refs.searchMessage.textContent = 'No ' + this.searchType.replace(/s$/, '') + ' results for “' + query + '”';
      this.refs.searchMessage.style.display = '';
    }
  }, {
    key: 'highlightExactMatch',
    value: function highlightExactMatch(container, query, packages) {
      var exactMatch = _underscorePlus2['default'].filter(packages, function (pkg) {
        return pkg.name === query;
      })[0];

      if (exactMatch) {
        this.addPackageCardView(container, this.getPackageCardView(exactMatch));
        packages.splice(packages.indexOf(exactMatch), 1);
      }
    }
  }, {
    key: 'addCloseMatches',
    value: function addCloseMatches(container, query, packages) {
      var matches = _underscorePlus2['default'].filter(packages, function (pkg) {
        return pkg.name.indexOf(query) >= 0;
      });

      for (var pack of matches) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
        packages.splice(packages.indexOf(pack), 1);
      }
    }
  }, {
    key: 'addPackageViews',
    value: function addPackageViews(container, packages) {
      for (var pack of packages) {
        this.addPackageCardView(container, this.getPackageCardView(pack));
      }
    }
  }, {
    key: 'addPackageCardView',
    value: function addPackageCardView(container, packageCard) {
      var packageRow = document.createElement('div');
      packageRow.classList.add('row');
      packageRow.appendChild(packageCard.element);
      container.appendChild(packageRow);
    }
  }, {
    key: 'getPackageCardView',
    value: function getPackageCardView(pack) {
      return new _packageCard2['default'](pack, this.settingsView, this.packageManager, { back: 'Install' });
    }
  }, {
    key: 'filterPackages',
    value: function filterPackages(packages, themes) {
      return packages.filter(function (_ref3) {
        var theme = _ref3.theme;
        return themes ? theme : !theme;
      });
    }

    // Load and display the featured packages that are available to install.
  }, {
    key: 'loadFeaturedPackages',
    value: function loadFeaturedPackages(loadThemes) {
      var _this2 = this;

      if (loadThemes == null) {
        loadThemes = false;
      }
      this.refs.featuredContainer.innerHTML = '';

      if (loadThemes) {
        this.refs.installHeading.textContent = 'Install Themes';
        this.refs.featuredHeading.textContent = 'Featured Themes';
        this.refs.loadingMessage.textContent = 'Loading featured themes…';
      } else {
        this.refs.installHeading.textContent = 'Install Packages';
        this.refs.featuredHeading.textContent = 'Featured Packages';
        this.refs.loadingMessage.textContent = 'Loading featured packages…';
      }

      this.refs.loadingMessage.style.display = '';

      var handle = function handle(error) {
        _this2.refs.loadingMessage.style.display = 'none';
        _this2.refs.featuredErrors.appendChild(new _errorView2['default'](_this2.packageManager, error).element);
      };

      if (loadThemes) {
        this.client.featuredThemes(function (error, themes) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Themes';
            _this2.addPackageViews(_this2.refs.featuredContainer, themes);
          }
        });
      } else {
        this.client.featuredPackages(function (error, packages) {
          if (error) {
            handle(error);
          } else {
            _this2.refs.loadingMessage.style.display = 'none';
            _this2.refs.featuredHeading.textContent = 'Featured Packages';
            _this2.addPackageViews(_this2.refs.featuredContainer, packages);
          }
        });
      }
    }
  }, {
    key: 'didClickOpenAtomIo',
    value: function didClickOpenAtomIo(event) {
      event.preventDefault();
      _electron2['default'].shell.openExternal(this.atomIoURL);
    }
  }, {
    key: 'didClickSearchPackagesButton',
    value: function didClickSearchPackagesButton() {
      if (!this.refs.searchPackagesButton.classList.contains('selected')) {
        this.setSearchType('package');
      }

      this.performSearch();
    }
  }, {
    key: 'didClickSearchThemesButton',
    value: function didClickSearchThemesButton() {
      if (!this.refs.searchThemesButton.classList.contains('selected')) {
        this.setSearchType('theme');
      }

      this.performSearch();
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return InstallPanel;
})();

exports['default'] = InstallPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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