Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var CollapsibleSectionPanel = (function () {
  function CollapsibleSectionPanel() {
    _classCallCheck(this, CollapsibleSectionPanel);
  }

  _createClass(CollapsibleSectionPanel, [{
    key: 'notHiddenCardsLength',
    value: function notHiddenCardsLength(sectionElement) {
      return sectionElement.querySelectorAll('.package-card:not(.hidden)').length;
    }
  }, {
    key: 'updateSectionCount',
    value: function updateSectionCount(headerElement, countElement, packageCount, totalCount) {
      if (totalCount != null) {
        countElement.textContent = packageCount + '/' + totalCount;
      } else {
        countElement.textContent = packageCount;
      }

      if (packageCount > 0) {
        headerElement.classList.add("has-items");
      }
    }
  }, {
    key: 'updateSectionCounts',
    value: function updateSectionCounts() {
      this.resetSectionHasItems();

      var filterText = this.refs.filterEditor.getText();
      if (filterText === '') {
        this.updateUnfilteredSectionCounts();
      } else {
        this.updateFilteredSectionCounts();
      }
    }
  }, {
    key: 'handleEvents',
    value: function handleEvents() {
      var _this = this;

      var handler = function handler(e) {
        var target = e.target.closest('.sub-section .has-items');
        if (target) {
          target.parentNode.classList.toggle('collapsed');
        }
      };
      this.element.addEventListener('click', handler);
      return new _atom.Disposable(function () {
        return _this.element.removeEventListener('click', handler);
      });
    }
  }, {
    key: 'resetCollapsibleSections',
    value: function resetCollapsibleSections(headerSections) {
      for (var headerSection of headerSections) {
        this.resetCollapsibleSection(headerSection);
      }
    }
  }, {
    key: 'resetCollapsibleSection',
    value: function resetCollapsibleSection(headerSection) {
      headerSection.classList.remove('has-items');
    }
  }]);

  return CollapsibleSectionPanel;
})();

exports['default'] = CollapsibleSectionPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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