(function() {
  var splitKeyPath;

  exports.getValueAtKeyPath = function(object, keyPath) {
    var key, keys, _i, _len;
    keys = splitKeyPath(keyPath);
    for (_i = 0, _len = keys.length; _i < _len; _i++) {
      key = keys[_i];
      object = object[key];
      if (object == null) {
        return;
      }
    }
    return object;
  };

  exports.setValueAtKeyPath = function(object, keyPath, value) {
    var key, keys;
    keys = splitKeyPath(keyPath);
    while (keys.length > 1) {
      key = keys.shift();
      if (object[key] == null) {
        object[key] = {};
      }
      object = object[key];
    }
    return object[keys.shift()] = value;
  };

  splitKeyPath = function(keyPath) {
    var char, i, keys, startIndex, _i, _len;
    if (keyPath == null) {
      return [];
    }
    startIndex = 0;
    keys = [];
    for (i = _i = 0, _len = keyPath.length; _i < _len; i = ++_i) {
      char = keyPath[i];
      if (char === '.' && (i === 0 || keyPath[i - 1] !== '\\')) {
        keys.push(keyPath.substring(startIndex, i));
        startIndex = i + 1;
      }
    }
    keys.push(keyPath.substr(startIndex, keyPath.length));
    return keys;
  };

}).call(this);
