(function() {
  var root, setFontSize, setHideDockButtons, setTabSizing, unsetFontSize, unsetHideDockButtons, unsetTabSizing;

  root = document.documentElement;

  module.exports = {
    activate: function(state) {
      atom.config.observe('one-light-ui.fontSize', function(value) {
        return setFontSize(value);
      });
      atom.config.observe('one-light-ui.tabSizing', function(value) {
        return setTabSizing(value);
      });
      atom.config.observe('one-light-ui.hideDockButtons', function(value) {
        return setHideDockButtons(value);
      });
      if (atom.config.get('one-light-ui.layoutMode')) {
        return atom.config.unset('one-light-ui.layoutMode');
      }
    },
    deactivate: function() {
      unsetFontSize();
      unsetTabSizing();
      return unsetHideDockButtons();
    }
  };

  setFontSize = function(currentFontSize) {
    if (Number.isInteger(currentFontSize)) {
      return root.style.fontSize = currentFontSize + "px";
    } else if (currentFontSize === 'Auto') {
      return unsetFontSize();
    }
  };

  unsetFontSize = function() {
    return root.style.fontSize = '';
  };

  setTabSizing = function(tabSizing) {
    return root.setAttribute('theme-one-light-ui-tabsizing', tabSizing.toLowerCase());
  };

  unsetTabSizing = function() {
    return root.removeAttribute('theme-one-light-ui-tabsizing');
  };

  setHideDockButtons = function(hideDockButtons) {
    if (hideDockButtons) {
      return root.setAttribute('theme-one-light-ui-dock-buttons', 'hidden');
    } else {
      return unsetHideDockButtons();
    }
  };

  unsetHideDockButtons = function() {
    return root.removeAttribute('theme-one-light-ui-dock-buttons');
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
