(function() {
  var root, setFontSize, setHideDockButtons, setTabSizing, unsetFontSize, unsetHideDockButtons, unsetTabSizing;

  root = document.documentElement;

  module.exports = {
    activate: function(state) {
      atom.config.observe('one-dark-ui.fontSize', function(value) {
        return setFontSize(value);
      });
      atom.config.observe('one-dark-ui.tabSizing', function(value) {
        return setTabSizing(value);
      });
      atom.config.observe('one-dark-ui.hideDockButtons', function(value) {
        return setHideDockButtons(value);
      });
      if (atom.config.get('one-dark-ui.layoutMode')) {
        return atom.config.unset('one-dark-ui.layoutMode');
      }
    },
    deactivate: function() {
      unsetFontSize();
      unsetTabSizing();
      return unsetHideDockButtons();
    }
  };

  setFontSize = function(currentFontSize) {
    if (Number.isInteger(currentFontSize)) {
      return root.style.fontSize = currentFontSize + "px";
    } else if (currentFontSize === 'Auto') {
      return unsetFontSize();
    }
  };

  unsetFontSize = function() {
    return root.style.fontSize = '';
  };

  setTabSizing = function(tabSizing) {
    return root.setAttribute('theme-one-dark-ui-tabsizing', tabSizing.toLowerCase());
  };

  unsetTabSizing = function() {
    return root.removeAttribute('theme-one-dark-ui-tabsizing');
  };

  setHideDockButtons = function(hideDockButtons) {
    if (hideDockButtons) {
      return root.setAttribute('theme-one-dark-ui-dock-buttons', 'hidden');
    } else {
      return unsetHideDockButtons();
    }
  };

  unsetHideDockButtons = function() {
    return root.removeAttribute('theme-one-dark-ui-dock-buttons');
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
