(function() {
  var ButtonListTemplate, ButtonTemplate, FatalMetaNotificationTemplate, MetaNotificationTemplate, NotificationElement, NotificationIssue, NotificationTemplate, TemplateHelper, UserUtilities, addSplitLinesToContainer, fs, marked, path, shell;

  fs = require('fs-plus');

  path = require('path');

  marked = require('marked');

  shell = require('electron').shell;

  NotificationIssue = require('./notification-issue');

  TemplateHelper = require('./template-helper');

  UserUtilities = require('./user-utilities');

  NotificationTemplate = "<div class=\"content\">\n  <div class=\"message item\"></div>\n  <div class=\"detail item\">\n    <div class=\"detail-content\"></div>\n    <a href=\"#\" class=\"stack-toggle\"></a>\n    <div class=\"stack-container\"></div>\n  </div>\n  <div class=\"meta item\"></div>\n</div>\n<div class=\"close icon icon-x\"></div>\n<div class=\"close-all btn btn-error\">Close All</div>";

  FatalMetaNotificationTemplate = "<div class=\"description fatal-notification\"></div>\n<div class=\"btn-toolbar\">\n  <a href=\"#\" class=\"btn-issue btn btn-error\"></a>\n  <a href=\"#\" class=\"btn-copy-report icon icon-clippy\" title=\"Copy error report to clipboard\"></a>\n</div>";

  MetaNotificationTemplate = "<div class=\"description\"></div>";

  ButtonListTemplate = "<div class=\"btn-toolbar\"></div>";

  ButtonTemplate = "<a href=\"#\" class=\"btn\"></a>";

  module.exports = NotificationElement = (function() {
    NotificationElement.prototype.animationDuration = 360;

    NotificationElement.prototype.visibilityDuration = 5000;

    function NotificationElement(model) {
      this.model = model;
      this.fatalTemplate = TemplateHelper.create(FatalMetaNotificationTemplate);
      this.metaTemplate = TemplateHelper.create(MetaNotificationTemplate);
      this.buttonListTemplate = TemplateHelper.create(ButtonListTemplate);
      this.buttonTemplate = TemplateHelper.create(ButtonTemplate);
      this.element = document.createElement('atom-notification');
      if (this.model.getType() === 'fatal') {
        this.issue = new NotificationIssue(this.model);
      }
      this.renderPromise = this.render()["catch"](function(e) {
        console.error(e.message);
        return console.error(e.stack);
      });
      if (this.model.isDismissable()) {
        this.model.onDidDismiss((function(_this) {
          return function() {
            return _this.removeNotification();
          };
        })(this));
      } else {
        this.autohide();
      }
      this.element.issue = this.issue;
      this.element.getRenderPromise = this.getRenderPromise.bind(this);
    }

    NotificationElement.prototype.getModel = function() {
      return this.model;
    };

    NotificationElement.prototype.getRenderPromise = function() {
      return this.renderPromise;
    };

    NotificationElement.prototype.render = function() {
      var buttonClass, closeAllButton, closeButton, description, detail, metaContainer, metaContent, notificationContainer, options, stack, stackContainer, stackToggle, toolbar;
      this.element.classList.add("" + (this.model.getType()));
      this.element.classList.add("icon", "icon-" + (this.model.getIcon()), "native-key-bindings");
      if (detail = this.model.getDetail()) {
        this.element.classList.add('has-detail');
      }
      if (this.model.isDismissable()) {
        this.element.classList.add('has-close');
      }
      if (this.model.getOptions().stack != null) {
        this.element.classList.add('has-stack');
      }
      this.element.setAttribute('tabindex', '-1');
      this.element.innerHTML = NotificationTemplate;
      options = this.model.getOptions();
      notificationContainer = this.element.querySelector('.message');
      notificationContainer.innerHTML = marked(this.model.getMessage());
      if (detail = this.model.getDetail()) {
        addSplitLinesToContainer(this.element.querySelector('.detail-content'), detail);
        if (stack = options.stack) {
          stackToggle = this.element.querySelector('.stack-toggle');
          stackContainer = this.element.querySelector('.stack-container');
          addSplitLinesToContainer(stackContainer, stack);
          stackToggle.addEventListener('click', (function(_this) {
            return function(e) {
              return _this.handleStackTraceToggleClick(e, stackContainer);
            };
          })(this));
          this.handleStackTraceToggleClick({
            currentTarget: stackToggle
          }, stackContainer);
        }
      }
      if (metaContent = options.description) {
        this.element.classList.add('has-description');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.metaTemplate));
        description = this.element.querySelector('.description');
        description.innerHTML = marked(metaContent);
      }
      if (options.buttons && options.buttons.length > 0) {
        this.element.classList.add('has-buttons');
        metaContainer = this.element.querySelector('.meta');
        metaContainer.appendChild(TemplateHelper.render(this.buttonListTemplate));
        toolbar = this.element.querySelector('.btn-toolbar');
        buttonClass = this.model.getType();
        if (buttonClass === 'fatal') {
          buttonClass = 'error';
        }
        buttonClass = "btn-" + buttonClass;
        options.buttons.forEach((function(_this) {
          return function(button) {
            var buttonEl;
            toolbar.appendChild(TemplateHelper.render(_this.buttonTemplate));
            buttonEl = toolbar.childNodes[toolbar.childNodes.length - 1];
            buttonEl.textContent = button.text;
            buttonEl.classList.add(buttonClass);
            if (button.className != null) {
              buttonEl.classList.add.apply(buttonEl.classList, button.className.split(' '));
            }
            if (button.onDidClick != null) {
              return buttonEl.addEventListener('click', function(e) {
                return button.onDidClick.call(_this, e);
              });
            }
          };
        })(this));
      }
      if (this.model.isDismissable()) {
        closeButton = this.element.querySelector('.close');
        closeButton.addEventListener('click', (function(_this) {
          return function() {
            return _this.handleRemoveNotificationClick();
          };
        })(this));
        closeAllButton = this.element.querySelector('.close-all');
        closeAllButton.classList.add(this.getButtonClass());
        closeAllButton.addEventListener('click', (function(_this) {
          return function() {
            return _this.handleRemoveAllNotificationsClick();
          };
        })(this));
      }
      if (this.model.getType() === 'fatal') {
        return this.renderFatalError();
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.renderFatalError = function() {
      var copyReportButton, fatalContainer, fatalNotification, issueButton, packageName, promises, repoUrl;
      repoUrl = this.issue.getRepoUrl();
      packageName = this.issue.getPackageName();
      fatalContainer = this.element.querySelector('.meta');
      fatalContainer.appendChild(TemplateHelper.render(this.fatalTemplate));
      fatalNotification = this.element.querySelector('.fatal-notification');
      issueButton = fatalContainer.querySelector('.btn-issue');
      copyReportButton = fatalContainer.querySelector('.btn-copy-report');
      atom.tooltips.add(copyReportButton, {
        title: copyReportButton.getAttribute('title')
      });
      copyReportButton.addEventListener('click', (function(_this) {
        return function(e) {
          e.preventDefault();
          return _this.issue.getIssueBody().then(function(issueBody) {
            return atom.clipboard.write(issueBody);
          });
        };
      })(this));
      if ((packageName != null) && (repoUrl != null)) {
        fatalNotification.innerHTML = "The error was thrown from the <a href=\"" + repoUrl + "\">" + packageName + " package</a>. ";
      } else if (packageName != null) {
        issueButton.remove();
        fatalNotification.textContent = "The error was thrown from the " + packageName + " package. ";
      } else {
        fatalNotification.textContent = "This is likely a bug in Atom. ";
      }
      if (issueButton.parentNode != null) {
        if ((packageName != null) && (repoUrl != null)) {
          issueButton.textContent = "Create issue on the " + packageName + " package";
        } else {
          issueButton.textContent = "Create issue on atom/atom";
        }
        promises = [];
        promises.push(this.issue.findSimilarIssues());
        promises.push(UserUtilities.checkAtomUpToDate());
        if (packageName != null) {
          promises.push(UserUtilities.checkPackageUpToDate(packageName));
        }
        return Promise.all(promises).then((function(_this) {
          return function(allData) {
            var atomCheck, issue, issues, packageCheck, packagePath, ref;
            issues = allData[0], atomCheck = allData[1], packageCheck = allData[2];
            if ((issues != null ? issues.open : void 0) || (issues != null ? issues.closed : void 0)) {
              issue = issues.open || issues.closed;
              issueButton.setAttribute('href', issue.html_url);
              issueButton.textContent = "View Issue";
              fatalNotification.innerHTML += " This issue has already been reported.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && !packageCheck.isCore) {
              issueButton.setAttribute('href', '#');
              issueButton.textContent = "Check for package updates";
              issueButton.addEventListener('click', function(e) {
                var command;
                e.preventDefault();
                command = 'settings-view:check-for-package-updates';
                return atom.commands.dispatch(atom.views.getView(atom.workspace), command);
              });
              fatalNotification.innerHTML += "<code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed;\n" + packageCheck.latestVersion + " latest.\nUpgrading to the latest version may fix this issue.";
            } else if ((packageCheck != null) && !packageCheck.upToDate && packageCheck.isCore) {
              issueButton.remove();
              fatalNotification.innerHTML += "<br><br>\nLocally installed core Atom package <code>" + packageName + "</code> is out of date: " + packageCheck.installedVersion + " installed locally;\n" + packageCheck.versionShippedWithAtom + " included with the version of Atom you're running.\nRemoving the locally installed version may fix this issue.";
              packagePath = (ref = atom.packages.getLoadedPackage(packageName)) != null ? ref.path : void 0;
              if (fs.isSymbolicLinkSync(packagePath)) {
                fatalNotification.innerHTML += "<br><br>\nUse: <code>apm unlink " + packagePath + "</code>";
              }
            } else if ((atomCheck != null) && !atomCheck.upToDate) {
              issueButton.remove();
              fatalNotification.innerHTML += "Atom is out of date: " + atomCheck.installedVersion + " installed;\n" + atomCheck.latestVersion + " latest.\nUpgrading to the <a href='https://github.com/atom/atom/releases/tag/v" + atomCheck.latestVersion + "'>latest version</a> may fix this issue.";
            } else {
              fatalNotification.innerHTML += " You can help by creating an issue. Please explain what actions triggered this error.";
              issueButton.addEventListener('click', function(e) {
                e.preventDefault();
                issueButton.classList.add('opening');
                return _this.issue.getIssueUrlForSystem().then(function(issueUrl) {
                  shell.openExternal(issueUrl);
                  return issueButton.classList.remove('opening');
                });
              });
            }
          };
        })(this));
      } else {
        return Promise.resolve();
      }
    };

    NotificationElement.prototype.removeNotification = function() {
      this.element.classList.add('remove');
      return this.removeNotificationAfterTimeout();
    };

    NotificationElement.prototype.handleRemoveNotificationClick = function() {
      return this.model.dismiss();
    };

    NotificationElement.prototype.handleRemoveAllNotificationsClick = function() {
      var i, len, notification, notifications;
      notifications = atom.notifications.getNotifications();
      for (i = 0, len = notifications.length; i < len; i++) {
        notification = notifications[i];
        if (notification.isDismissable() && !notification.isDismissed()) {
          notification.dismiss();
        }
      }
    };

    NotificationElement.prototype.handleStackTraceToggleClick = function(e, container) {
      if (typeof e.preventDefault === "function") {
        e.preventDefault();
      }
      if (container.style.display === 'none') {
        e.currentTarget.innerHTML = '<span class="icon icon-dash"></span>Hide Stack Trace';
        return container.style.display = 'block';
      } else {
        e.currentTarget.innerHTML = '<span class="icon icon-plus"></span>Show Stack Trace';
        return container.style.display = 'none';
      }
    };

    NotificationElement.prototype.autohide = function() {
      return setTimeout((function(_this) {
        return function() {
          _this.element.classList.add('remove');
          return _this.removeNotificationAfterTimeout();
        };
      })(this), this.visibilityDuration);
    };

    NotificationElement.prototype.removeNotificationAfterTimeout = function() {
      if (this.element === document.activeElement) {
        atom.workspace.getActivePane().activate();
      }
      return setTimeout((function(_this) {
        return function() {
          return _this.element.remove();
        };
      })(this), this.animationDuration);
    };

    NotificationElement.prototype.getButtonClass = function() {
      var type;
      type = "btn-" + (this.model.getType());
      if (type === 'btn-fatal') {
        return 'btn-error';
      } else {
        return type;
      }
    };

    return NotificationElement;

  })();

  addSplitLinesToContainer = function(container, content) {
    var div, i, len, line, ref;
    if (typeof content !== 'string') {
      content = content.toString();
    }
    ref = content.split('\n');
    for (i = 0, len = ref.length; i < len; i++) {
      line = ref[i];
      div = document.createElement('div');
      div.classList.add('line');
      div.textContent = line;
      container.appendChild(div);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
