Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var KeyBindingResolverView = (function () {
  function KeyBindingResolverView() {
    _classCallCheck(this, KeyBindingResolverView);

    this.keystrokes = null;
    this.usedKeyBinding = null;
    this.unusedKeyBindings = [];
    this.unmatchedKeyBindings = [];
    this.partiallyMatchedBindings = [];
    _etch2['default'].initialize(this);
  }

  _createClass(KeyBindingResolverView, [{
    key: 'serialize',
    value: function serialize() {
      return this.panel ? { attached: this.panel.isVisible() } : { attached: false };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.detach();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.detach();
      } else {
        this.attach();
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      var _this = this;

      this.disposables = new _atom.CompositeDisposable();
      this.panel = atom.workspace.addBottomPanel({ item: this });
      this.disposables.add(new _atom.Disposable(function () {
        _this.panel.destroy();
        _this.panel = null;
      }));

      this.disposables.add(atom.keymaps.onDidMatchBinding(function (_ref) {
        var keystrokes = _ref.keystrokes;
        var binding = _ref.binding;
        var keyboardEventTarget = _ref.keyboardEventTarget;
        var eventType = _ref.eventType;

        if (eventType === 'keyup' && binding == null) {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget }).filter(function (b) {
          return b !== binding;
        });

        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return b !== binding && !unusedKeyBindings.includes(b);
        });

        _this.update({ usedKeyBinding: binding, unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));

      this.disposables.add(atom.keymaps.onDidPartiallyMatchBindings(function (_ref2) {
        var keystrokes = _ref2.keystrokes;
        var partiallyMatchedBindings = _ref2.partiallyMatchedBindings;

        _this.update({ keystrokes: keystrokes, partiallyMatchedBindings: partiallyMatchedBindings });
      }));

      this.disposables.add(atom.keymaps.onDidFailToMatchBinding(function (_ref3) {
        var keystrokes = _ref3.keystrokes;
        var keyboardEventTarget = _ref3.keyboardEventTarget;
        var eventType = _ref3.eventType;

        if (eventType === 'keyup') {
          return;
        }

        var unusedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes, target: keyboardEventTarget });
        var unmatchedKeyBindings = atom.keymaps.findKeyBindings({ keystrokes: keystrokes }).filter(function (b) {
          return !unusedKeyBindings.includes(b);
        });

        _this.update({ unusedKeyBindings: unusedKeyBindings, unmatchedKeyBindings: unmatchedKeyBindings, keystrokes: keystrokes });
      }));
    }
  }, {
    key: 'detach',
    value: function detach() {
      if (this.disposables) {
        this.disposables.dispose();
      }
    }
  }, {
    key: 'update',
    value: function update(props) {
      this.keystrokes = props.keystrokes;
      this.usedKeyBinding = props.usedKeyBinding;
      this.unusedKeyBindings = props.unusedKeyBindings || [];
      this.unmatchedKeyBindings = props.unmatchedKeyBindings || [];
      this.partiallyMatchedBindings = props.partiallyMatchedBindings || [];
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'key-binding-resolver' },
        _etch2['default'].dom(
          'div',
          { className: 'panel-heading padded' },
          _etch2['default'].dom(
            'span',
            null,
            'Key Binding Resolver: '
          ),
          this.renderKeystrokes()
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panel-body padded' },
          this.renderKeyBindings()
        )
      );
    }
  }, {
    key: 'renderKeystrokes',
    value: function renderKeystrokes() {
      if (this.keystrokes) {
        if (this.partiallyMatchedBindings.length > 0) {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes,
            ' (partial)'
          );
        } else {
          return _etch2['default'].dom(
            'span',
            { className: 'keystroke' },
            this.keystrokes
          );
        }
      } else {
        return _etch2['default'].dom(
          'span',
          null,
          'Press any key: '
        );
      }
    }
  }, {
    key: 'renderKeyBindings',
    value: function renderKeyBindings() {
      var _this2 = this;

      if (this.partiallyMatchedBindings.length > 0) {
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            this.partiallyMatchedBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'keystrokes' },
                  binding.keystrokes
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      } else {
        var usedKeyBinding = '';
        if (this.usedKeyBinding) {
          usedKeyBinding = _etch2['default'].dom(
            'tr',
            { className: 'used' },
            _etch2['default'].dom(
              'td',
              { className: 'command' },
              this.usedKeyBinding.command
            ),
            _etch2['default'].dom(
              'td',
              { className: 'selector' },
              this.usedKeyBinding.selector
            ),
            _etch2['default'].dom(
              'td',
              { className: 'source', onclick: function () {
                  return _this2.openKeybindingFile(_this2.usedKeyBinding.source);
                } },
              this.usedKeyBinding.source
            )
          );
        }
        return _etch2['default'].dom(
          'table',
          { className: 'table-condensed' },
          _etch2['default'].dom(
            'tbody',
            null,
            usedKeyBinding,
            this.unusedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unused' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            }),
            this.unmatchedKeyBindings.map(function (binding) {
              return _etch2['default'].dom(
                'tr',
                { className: 'unmatched' },
                _etch2['default'].dom(
                  'td',
                  { className: 'command' },
                  binding.command
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'selector' },
                  binding.selector
                ),
                _etch2['default'].dom(
                  'td',
                  { className: 'source', onclick: function () {
                      return _this2.openKeybindingFile(binding.source);
                    } },
                  binding.source
                )
              );
            })
          )
        );
      }
    }
  }, {
    key: 'isInAsarArchive',
    value: function isInAsarArchive(pathToCheck) {
      var _atom$getLoadSettings = atom.getLoadSettings();

      var resourcePath = _atom$getLoadSettings.resourcePath;

      return pathToCheck.startsWith('' + resourcePath + _path2['default'].sep) && _path2['default'].extname(resourcePath) === '.asar';
    }
  }, {
    key: 'extractBundledKeymap',
    value: function extractBundledKeymap(bundledKeymapPath) {
      var metadata = require(_path2['default'].join(atom.getLoadSettings().resourcePath, 'package.json'));
      var bundledKeymaps = metadata ? metadata._atomKeymaps : {};
      var keymapName = _path2['default'].basename(bundledKeymapPath);
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(bundledKeymaps[keymapName] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'extractBundledPackageKeymap',
    value: function extractBundledPackageKeymap(keymapRelativePath) {
      var packageName = keymapRelativePath.split(_path2['default'].sep)[1];
      var keymapName = _path2['default'].basename(keymapRelativePath);
      var metadata = atom.packages.packagesCache[packageName] || {};
      var keymaps = metadata.keymaps || {};
      var extractedKeymapPath = _path2['default'].join(require('temp').mkdirSync('atom-bundled-keymap-'), keymapName);
      _fsPlus2['default'].writeFileSync(extractedKeymapPath, JSON.stringify(keymaps[keymapRelativePath] || {}, null, 2));
      return extractedKeymapPath;
    }
  }, {
    key: 'openKeybindingFile',
    value: function openKeybindingFile(keymapPath) {
      if (this.isInAsarArchive(keymapPath)) {
        keymapPath = this.extractBundledKeymap(keymapPath);
      } else if (keymapPath.startsWith('core:node_modules')) {
        keymapPath = this.extractBundledPackageKeymap(keymapPath.replace('core:', ''));
      } else if (keymapPath.startsWith('core:')) {
        keymapPath = this.extractBundledKeymap(keymapPath.replace('core:', ''));
      }

      atom.workspace.open(keymapPath);
    }
  }]);

  return KeyBindingResolverView;
})();

exports['default'] = KeyBindingResolverView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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