Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _imageEditorView = require('./image-editor-view');

var _imageEditorView2 = _interopRequireDefault(_imageEditorView);

// Editor model for an image file

var ImageEditor = (function () {
  _createClass(ImageEditor, null, [{
    key: 'deserialize',
    value: function deserialize(_ref) {
      var filePath = _ref.filePath;

      if (_fsPlus2['default'].isFileSync(filePath)) {
        return new ImageEditor(filePath);
      } else {
        console.warn('Could not deserialize image editor for path \'' + filePath + '\' because that file no longer exists');
      }
    }
  }]);

  function ImageEditor(filePath) {
    _classCallCheck(this, ImageEditor);

    this.file = new _atom.File(filePath);
    this.subscriptions = new _atom.CompositeDisposable();
    this.emitter = new _atom.Emitter();
  }

  _createClass(ImageEditor, [{
    key: 'serialize',
    value: function serialize() {
      return { filePath: this.getPath(), deserializer: this.constructor.name };
    }
  }, {
    key: 'terminatePendingState',
    value: function terminatePendingState() {
      if (this.isEqual(atom.workspace.getActivePane().getPendingItem())) {
        this.emitter.emit('did-terminate-pending-state');
      }
    }
  }, {
    key: 'onDidTerminatePendingState',
    value: function onDidTerminatePendingState(callback) {
      return this.emitter.on('did-terminate-pending-state', callback);
    }

    // Register a callback for when the image file changes
  }, {
    key: 'onDidChange',
    value: function onDidChange(callback) {
      var changeSubscription = this.file.onDidChange(callback);
      this.subscriptions.add(changeSubscription);
      return changeSubscription;
    }

    // Register a callback for whne the image's title changes
  }, {
    key: 'onDidChangeTitle',
    value: function onDidChangeTitle(callback) {
      var renameSubscription = this.file.onDidRename(callback);
      this.subscriptions.add(renameSubscription);
      return renameSubscription;
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      if (this.view) {
        this.view.destroy();
      }
    }

    // Retrieves the filename of the open file.
    //
    // This is `'untitled'` if the file is new and not saved to the disk.
    //
    // Returns a {String}.
  }, {
    key: 'getTitle',
    value: function getTitle() {
      var filePath = this.getPath();
      if (filePath) {
        return _path2['default'].basename(filePath);
      } else {
        return 'untitled';
      }
    }

    // Retrieves the absolute path to the image.
    //
    // Returns a {String} path.
  }, {
    key: 'getPath',
    value: function getPath() {
      return this.file.getPath();
    }

    // Retrieves the URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.getPath();
    }

    // Retrieves the encoded URI of the image.
    //
    // Returns a {String}.
  }, {
    key: 'getEncodedURI',
    value: function getEncodedURI() {
      return 'file://' + encodeURI(this.getPath().replace(/\\/g, '/')).replace(/#/g, '%23').replace(/\?/g, '%3F');
    }

    // Compares two {ImageEditor}s to determine equality.
    //
    // Equality is based on the condition that the two URIs are the same.
    //
    // Returns a {Boolean}.
  }, {
    key: 'isEqual',
    value: function isEqual(other) {
      return other instanceof ImageEditor && this.getURI() === other.getURI();
    }

    // Essential: Invoke the given callback when the editor is destroyed.
    //
    // * `callback` {Function} to be called when the editor is destroyed.
    //
    // Returns a {Disposable} on which `.dispose()` can be called to unsubscribe.
  }, {
    key: 'onDidDestroy',
    value: function onDidDestroy(callback) {
      return this.emitter.on('did-destroy', callback);
    }
  }, {
    key: 'element',
    get: function get() {
      return this.view.element;
    }
  }, {
    key: 'view',
    get: function get() {
      if (!this.editorView) {
        this.editorView = new _imageEditorView2['default'](this);
      }
      return this.editorView;
    }
  }]);

  return ImageEditor;
})();

exports['default'] = ImageEditor;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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