Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

// View that renders the image of an {ImageEditor}.

var ImageEditorView = (function () {
  function ImageEditorView(editor) {
    var _this = this;

    _classCallCheck(this, ImageEditorView);

    this.editor = editor;
    this.emitter = new _atom.Emitter();
    this.disposables = new _atom.CompositeDisposable();
    this.imageSize = _fsPlus2['default'].statSync(this.editor.getPath()).size;
    this.loaded = false;
    this.mode = 'reset-zoom';
    _etch2['default'].initialize(this);

    this.refs.image.style.display = 'none';
    this.updateImageURI();

    this.disposables.add(this.editor.onDidChange(function () {
      return _this.updateImageURI();
    }));
    this.disposables.add(atom.commands.add(this.element, {
      'image-view:reload': function imageViewReload() {
        return _this.updateImageURI();
      },
      'image-view:zoom-in': function imageViewZoomIn() {
        return _this.zoomIn();
      },
      'image-view:zoom-out': function imageViewZoomOut() {
        return _this.zoomOut();
      },
      'image-view:zoom-to-fit': function imageViewZoomToFit() {
        return _this.zoomToFit();
      },
      'image-view:reset-zoom': function imageViewResetZoom() {
        return _this.resetZoom();
      },
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    this.refs.image.onload = function () {
      _this.refs.image.onload = null;
      _this.originalHeight = _this.refs.image.naturalHeight;
      _this.originalWidth = _this.refs.image.naturalWidth;
      _this.loaded = true;
      _this.refs.image.style.display = '';
      _this.emitter.emit('did-load');
    };

    this.disposables.add(atom.tooltips.add(this.refs.whiteTransparentBackgroundButton, { title: 'Use white transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.blackTransparentBackgroundButton, { title: 'Use black transparent background' }));
    this.disposables.add(atom.tooltips.add(this.refs.transparentTransparentBackgroundButton, { title: 'Use transparent background' }));

    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      event.stopPropagation();
      _this.changeBackground(event.target.value);
    };

    this.refs.whiteTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.whiteTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.blackTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.blackTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));
    this.refs.transparentTransparentBackgroundButton.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.transparentTransparentBackgroundButton.removeEventListener('click', clickHandler);
    }));

    var zoomInClickHandler = function zoomInClickHandler() {
      _this.zoomIn();
    };
    this.refs.zoomInButton.addEventListener('click', zoomInClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomInButton.removeEventListener('click', zoomInClickHandler);
    }));

    var zoomOutClickHandler = function zoomOutClickHandler() {
      _this.zoomOut();
    };
    this.refs.zoomOutButton.addEventListener('click', zoomOutClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomOutButton.removeEventListener('click', zoomOutClickHandler);
    }));

    var resetZoomClickHandler = function resetZoomClickHandler() {
      _this.resetZoom();
    };
    this.refs.resetZoomButton.addEventListener('click', resetZoomClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.resetZoomButton.removeEventListener('click', resetZoomClickHandler);
    }));

    var zoomToFitClickHandler = function zoomToFitClickHandler() {
      _this.zoomToFit();
    };
    this.refs.zoomToFitButton.addEventListener('click', zoomToFitClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.zoomToFitButton.removeEventListener('click', zoomToFitClickHandler);
    }));
  }

  _createClass(ImageEditorView, [{
    key: 'onDidLoad',
    value: function onDidLoad(callback) {
      return this.emitter.on('did-load', callback);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.emitter.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'image-view', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'image-controls', ref: 'imageControls' },
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group' },
            _etch2['default'].dom(
              'a',
              { ref: 'whiteTransparentBackgroundButton', className: 'image-controls-color-white', value: 'white' },
              'white'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'blackTransparentBackgroundButton', className: 'image-controls-color-black', value: 'black' },
              'black'
            ),
            _etch2['default'].dom(
              'a',
              { ref: 'transparentTransparentBackgroundButton', className: 'image-controls-color-transparent', value: 'transparent' },
              'transparent'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomOutButton' },
              '-'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn reset-zoom-button', ref: 'resetZoomButton' },
              '100%'
            ),
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomInButton' },
              '+'
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'image-controls-group btn-group' },
            _etch2['default'].dom(
              'button',
              { className: 'btn', ref: 'zoomToFitButton' },
              'Zoom to fit'
            )
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'image-container', background: 'white', ref: 'imageContainer' },
          _etch2['default'].dom('img', { ref: 'image' })
        )
      );
    }
  }, {
    key: 'updateImageURI',
    value: function updateImageURI() {
      this.refs.image.src = this.editor.getEncodedURI() + '?time=' + Date.now();
    }

    // Zooms the image out by 25%.
  }, {
    key: 'zoomOut',
    value: function zoomOut() {
      this.adjustSize(0.75);
    }

    // Zooms the image in by 25%.
  }, {
    key: 'zoomIn',
    value: function zoomIn() {
      this.adjustSize(1.25);
    }

    // Zooms the image to its normal width and height.
  }, {
    key: 'resetZoom',
    value: function resetZoom() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'reset-zoom';
      this.refs.imageContainer.classList.remove('zoom-to-fit');
      this.refs.zoomToFitButton.classList.remove('selected');
      this.refs.image.style.width = this.originalWidth + 'px';
      this.refs.image.style.height = this.originalHeight + 'px';
      this.refs.resetZoomButton.textContent = '100%';
    }

    // Zooms to fit the image, doesn't scale beyond actual size
  }, {
    key: 'zoomToFit',
    value: function zoomToFit() {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      this.mode = 'zoom-to-fit';
      this.refs.imageContainer.classList.add('zoom-to-fit');
      this.refs.zoomToFitButton.classList.add('selected');
      this.refs.image.style.width = '';
      this.refs.image.style.height = '';
      this.refs.resetZoomButton.textContent = 'Auto';
    }

    // Adjust the size of the image by the given multiplying factor.
    //
    // factor - A {Number} to multiply against the current size.
  }, {
    key: 'adjustSize',
    value: function adjustSize(factor) {
      if (!this.loaded || this.element.offsetHeight === 0) {
        return;
      }

      if (this.mode === 'zoom-to-fit') {
        this.mode = 'zoom-manual';
        this.refs.imageContainer.classList.remove('zoom-to-fit');
        this.refs.zoomToFitButton.classList.remove('selected');
      } else if (this.mode === 'reset-zoom') {
        this.mode = 'zoom-manual';
      }

      var newWidth = this.refs.image.offsetWidth * factor;
      var newHeight = this.refs.image.offsetHeight * factor;
      var percent = Math.max(1, Math.round(newWidth / this.originalWidth * 100));

      // Switch to pixelated rendering when image is bigger than 200%
      if (newWidth > this.originalWidth * 2) {
        this.refs.image.style.imageRendering = 'pixelated';
      } else {
        this.refs.image.style.imageRendering = '';
      }

      this.refs.image.style.width = newWidth + 'px';
      this.refs.image.style.height = newHeight + 'px';
      this.refs.resetZoomButton.textContent = percent + '%';
    }

    // Changes the background color of the image view.
    //
    // color - A {String} that gets used as class name.
  }, {
    key: 'changeBackground',
    value: function changeBackground(color) {
      if (this.loaded && this.element.offsetHeight > 0 && color) {
        this.refs.imageContainer.setAttribute('background', color);
      }
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.refs.imageContainer.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.refs.imageContainer.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.refs.imageContainer.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.refs.imageContainer.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.refs.imageContainer.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.refs.imageContainer.scrollTop = this.refs.imageContainer.scrollHeight;
    }
  }]);

  return ImageEditorView;
})();

exports['default'] = ImageEditorView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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