(function() {
  var GrammarListView, GrammarStatusView, commandDisposable, createGrammarListView, grammarListView, grammarStatusView;

  GrammarListView = require('./grammar-list-view');

  GrammarStatusView = require('./grammar-status-view');

  commandDisposable = null;

  grammarListView = null;

  grammarStatusView = null;

  module.exports = {
    activate: function() {
      return commandDisposable = atom.commands.add('atom-text-editor', 'grammar-selector:show', createGrammarListView);
    },
    deactivate: function() {
      if (commandDisposable != null) {
        commandDisposable.dispose();
      }
      commandDisposable = null;
      if (grammarStatusView != null) {
        grammarStatusView.destroy();
      }
      grammarStatusView = null;
      if (grammarListView != null) {
        grammarListView.destroy();
      }
      return grammarListView = null;
    },
    consumeStatusBar: function(statusBar) {
      grammarStatusView = new GrammarStatusView(statusBar);
      return grammarStatusView.attach();
    }
  };

  createGrammarListView = function() {
    if (grammarListView == null) {
      grammarListView = new GrammarListView();
    }
    return grammarListView.toggle();
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
