Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var GrammarStatusView = (function () {
  function GrammarStatusView(statusBar) {
    var _this = this;

    _classCallCheck(this, GrammarStatusView);

    this.statusBar = statusBar;
    this.element = document.createElement('grammar-selector-status');
    this.element.classList.add('grammar-status', 'inline-block');
    this.grammarLink = document.createElement('a');
    this.grammarLink.classList.add('inline-block');
    this.element.appendChild(this.grammarLink);

    // TODO[v1.19]: Remove conditional once atom.workspace.observeActiveTextEditor ships in Atom v1.19
    if (atom.workspace.observeActiveTextEditor) {
      this.activeItemSubscription = atom.workspace.observeActiveTextEditor(this.subscribeToActiveTextEditor.bind(this));
    } else {
      this.activeItemSubscription = atom.workspace.observeActivePaneItem(this.subscribeToActiveTextEditor.bind(this));
    }

    this.configSubscription = atom.config.observe('grammar-selector.showOnRightSideOfStatusBar', this.attach.bind(this));
    var clickHandler = function clickHandler(event) {
      event.preventDefault();
      atom.commands.dispatch(atom.views.getView(atom.workspace.getActiveTextEditor()), 'grammar-selector:show');
    };
    this.element.addEventListener('click', clickHandler);
    this.clickSubscription = new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    });
  }

  _createClass(GrammarStatusView, [{
    key: 'attach',
    value: function attach() {
      if (this.statusBarTile) {
        this.statusBarTile.destroy();
      }

      this.statusBarTile = atom.config.get('grammar-selector.showOnRightSideOfStatusBar') ? this.statusBar.addRightTile({ item: this.element, priority: 10 }) : this.statusBar.addLeftTile({ item: this.element, priority: 10 });
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.activeItemSubscription) {
        this.activeItemSubscription.dispose();
      }

      if (this.grammarSubscription) {
        this.grammarSubscription.dispose();
      }

      if (this.clickSubscription) {
        this.clickSubscription.dispose();
      }

      if (this.configSubscription) {
        this.configSubscription.dispose();
      }

      if (this.statusBarTile) {
        this.statusBarTile.destroy();
      }
    }
  }, {
    key: 'subscribeToActiveTextEditor',
    value: function subscribeToActiveTextEditor() {
      if (this.grammarSubscription) {
        this.grammarSubscription.dispose();
        this.grammarSubscription = null;
      }

      var editor = atom.workspace.getActiveTextEditor();
      if (editor) {
        this.grammarSubscription = editor.onDidChangeGrammar(this.updateGrammarText.bind(this));
      }
      this.updateGrammarText();
    }
  }, {
    key: 'updateGrammarText',
    value: function updateGrammarText() {
      var _this2 = this;

      atom.views.updateDocument(function () {
        var editor = atom.workspace.getActiveTextEditor();
        var grammar = editor ? editor.getGrammar() : null;
        if (grammar) {
          var grammarName = null;
          if (grammar === atom.grammars.nullGrammar) {
            grammarName = 'Plain Text';
          } else {
            grammarName = grammar.name || grammar.scopeName;
          }

          _this2.grammarLink.textContent = grammarName;
          _this2.grammarLink.dataset.grammar = grammarName;
          _this2.element.style.display = '';
        } else {
          _this2.element.style.display = 'none';
        }
      });
    }
  }]);

  return GrammarStatusView;
})();

exports['default'] = GrammarStatusView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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