Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var GrammarListView = (function () {
  function GrammarListView() {
    var _this = this;

    _classCallCheck(this, GrammarListView);

    this.autoDetect = { name: 'Auto Detect' };
    this.selectListView = new _atomSelectList2['default']({
      itemsClassList: ['mark-active'],
      items: [],
      filterKeyForItem: function filterKeyForItem(grammar) {
        return grammar.name;
      },
      elementForItem: function elementForItem(grammar) {
        var grammarName = grammar.name || grammar.scopeName;
        var element = document.createElement('li');
        if (grammar === _this.currentGrammar) {
          element.classList.add('active');
        }
        element.textContent = grammarName;
        element.dataset.grammar = grammarName;
        return element;
      },
      didConfirmSelection: function didConfirmSelection(grammar) {
        _this.cancel();
        if (grammar === _this.autoDetect) {
          atom.textEditors.clearGrammarOverride(_this.editor);
        } else {
          atom.textEditors.setGrammarOverride(_this.editor, grammar.scopeName);
        }
      },
      didCancelSelection: function didCancelSelection() {
        _this.cancel();
      }
    });
    this.selectListView.element.classList.add('grammar-selector');
  }

  _createClass(GrammarListView, [{
    key: 'destroy',
    value: function destroy() {
      this.cancel();
      return this.selectListView.destroy();
    }
  }, {
    key: 'cancel',
    value: function cancel() {
      if (this.panel != null) {
        this.panel.destroy();
      }
      this.panel = null;
      this.currentGrammar = null;
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach() {
      this.previouslyFocusedElement = document.activeElement;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }
      this.selectListView.focus();
      this.selectListView.reset();
    }
  }, {
    key: 'toggle',
    value: _asyncToGenerator(function* () {
      if (this.panel != null) {
        this.cancel();
      } else if (atom.workspace.getActiveTextEditor()) {
        this.editor = atom.workspace.getActiveTextEditor();
        this.currentGrammar = this.editor.getGrammar();
        if (this.currentGrammar === atom.grammars.nullGrammar) {
          this.currentGrammar = this.autoDetect;
        }

        var grammars = atom.grammars.getGrammars().filter(function (grammar) {
          return grammar !== atom.grammars.nullGrammar;
        });
        grammars.sort(function (a, b) {
          if (a.scopeName === 'text.plain') {
            return -1;
          } else if (b.scopeName === 'text.plain') {
            return 1;
          } else if (a.name) {
            return a.name.localeCompare(b.name);
          } else if (a.scopeName) {
            return a.scopeName.localeCompare(b.scopeName);
          } else {
            return 1;
          }
        });
        grammars.unshift(this.autoDetect);
        yield this.selectListView.update({ items: grammars });
        this.attach();
      }
    })
  }]);

  return GrammarListView;
})();

exports['default'] = GrammarListView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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