'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _portal = require('./portal');

var _portal2 = _interopRequireDefault(_portal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

let Tooltip = (_temp = _class = class Tooltip extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.disposable = null;
  }

  componentWillReceiveProps(nextProps) {
    const propKeys = ['tooltips', 'title', 'html', 'className', 'placement', 'trigger', 'showDelay', 'hideDelay', 'keyBindingCommand', 'keyBindingTarget'];

    if (propKeys.some(key => this.props[key] !== nextProps[key])) {
      this.disposable && this.disposable.dispose();
      this.disposable = null;

      this.setupTooltip(nextProps);
    }
  }

  componentDidMount() {
    this.setupTooltip(this.props);
  }

  render() {
    if (this.props.children !== undefined) {
      return _react2.default.createElement(
        _portal2.default,
        { ref: c => {
            this.portal = c;
          } },
        this.props.children
      );
    } else {
      return null;
    }
  }

  componentWillUnmount() {
    this.disposable && this.disposable.dispose();
  }

  setupTooltip(props) {
    if (this.disposable) {
      return;
    }

    const options = {};
    ['title', 'html', 'placement', 'trigger', 'keyBindingCommand', 'keyBindingTarget'].forEach(key => {
      if (props[key] !== undefined) {
        options[key] = props[key];
      }
    });
    if (props.className !== undefined) {
      options.class = props.className;
    }
    if (props.showDelay !== undefined || props.hideDelay !== undefined) {
      const delayDefaults = (props.trigger === 'hover' || props.trigger === undefined) && { show: 1000, hide: 100 } || { show: 0, hide: 0 };

      options.delay = {
        show: props.showDelay !== undefined ? props.showDelay : delayDefaults.show,
        hide: props.hideDelay !== undefined ? props.hideDelay : delayDefaults.hide
      };
    }
    if (props.children !== undefined) {
      options.item = this.portal;
    }

    const target = this.getCurrentTarget(props);
    this.disposable = props.manager.add(target, options);
  }

  getCurrentTarget(props) {
    const target = props.target();
    if (target !== null && target.element !== undefined) {
      return target.element;
    } else {
      return target;
    }
  }
}, _class.propTypes = {
  manager: _propTypes2.default.object.isRequired,
  target: _propTypes2.default.func.isRequired,
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  html: _propTypes2.default.bool,
  className: _propTypes2.default.string,
  placement: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  trigger: _propTypes2.default.oneOf(['hover', 'click', 'focus', 'manual']),
  showDelay: _propTypes2.default.number,
  hideDelay: _propTypes2.default.number,
  keyBindingCommand: _propTypes2.default.string,
  keyBindingTarget: _propTypes2.default.element,
  children: _propTypes2.default.element
}, _temp);
exports.default = Tooltip;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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